/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.representations.CFG;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretedIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRMethod");
    private final IRScope method;
    private Arity arity;
    boolean displayedCFG = false;

    public InterpretedIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, CallConfiguration.FrameNoneScopeNone);
        this.method = method2;
        this.method.getStaticScope().determineModule();
        this.arity = this.calculateArity();
    }

    public InterpretedIRMethod(IRScope method2, RubyModule implementationClass) {
        this(method2, Visibility.PRIVATE, implementationClass);
    }

    public IRScope getIRMethod() {
        return this.method;
    }

    @Override
    public List<String[]> getParameterList() {
        return this.method instanceof IRMethod ? ((IRMethod)this.method).getArgDesc() : new ArrayList();
    }

    private Arity calculateArity() {
        StaticScope s2 = this.method.getStaticScope();
        if (s2.getOptionalArgs() > 0 || s2.getRestArg() >= 0) {
            return Arity.required(s2.getRequiredArgs());
        }
        return Arity.createArity(s2.getRequiredArgs());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        if (this.method.getInstrsForInterpretation() == null) {
            this.method.prepareForInterpretation();
        }
        if (Interpreter.isDebug()) {
            String realName = name2 == null || "".equals(name2) ? this.method.getName() : name2;
            LOG.info("Executing '" + realName + "'", new Object[0]);
            if (!this.displayedCFG) {
                CFG cfg = this.method.getCFG();
                LOG.info("Graph:\n" + cfg.toStringGraph(), new Object[0]);
                LOG.info("CFG:\n" + cfg.toStringInstrs(), new Object[0]);
                this.displayedCFG = true;
            }
        }
        if (this.method.hasExplicitCallProtocol()) {
            return Interpreter.INTERPRET_METHOD(context, this, self, name2, args2, block, null, false);
        }
        try {
            context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.method.getStaticScope());
            context.setCurrentVisibility(this.getVisibility());
            iRubyObject = Interpreter.INTERPRET_METHOD(context, this, self, name2, args2, block, null, false);
            Object var10_9 = null;
            context.popFrame();
            context.popRubyClass();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            context.popFrame();
            context.popRubyClass();
            context.popScope();
            throw throwable;
        }
        context.popScope();
        return iRubyObject;
    }

    @Override
    public DynamicMethod dup() {
        return new InterpretedIRMethod(this.method, this.visibility, this.implementationClass);
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }
}

