/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class FullFunctionCallbackMethod
extends DynamicMethod {
    private Callback callback;

    public FullFunctionCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeNone);
        this.callback = callback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject;
            block9: {
                this.callConfig.pre(context, self, clazz, name2, block, null);
                assert (args2 != null);
                Ruby runtime = context.runtime;
                boolean isTrace = runtime.hasEventHooks();
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                }
                try {
                    iRubyObject = this.callback.execute(self, args2, block);
                    Object var12_11 = null;
                    if (!isTrace) break block9;
                }
                catch (JumpException.ReturnJump rj) {
                    block10: {
                        IRubyObject iRubyObject2;
                        block11: {
                            try {
                                if (rj.getTarget() != context.getFrameJumpTarget()) break block10;
                                iRubyObject2 = (IRubyObject)rj.getValue();
                                Object var12_12 = null;
                                if (!isTrace) break block11;
                                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                if (!isTrace) throw throwable;
                                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
                                throw throwable;
                            }
                        }
                        Object var14_15 = null;
                        this.callConfig.post(context);
                        return iRubyObject2;
                    }
                    throw rj;
                }
                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name2, this.getImplementationClass());
            }
            Object var14_14 = null;
            this.callConfig.post(context);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.callConfig.post(context);
            throw throwable;
        }
    }

    public Callback getCallback() {
        return this.callback;
    }

    public Arity getArity() {
        return this.getCallback().getArity();
    }

    public DynamicMethod dup() {
        return new FullFunctionCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

