/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Attribute;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKCS10CertificationRequestExt;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class Request
extends RubyObject {
    private static final long serialVersionUID = -5551557929791764918L;
    private static ObjectAllocator REQUEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Request(runtime, klass);
        }
    };
    private IRubyObject version;
    private IRubyObject subject;
    private IRubyObject public_key;
    private boolean valid = false;
    private List<IRubyObject> attrs = new ArrayList<IRubyObject>();
    private PKCS10CertificationRequestExt req;

    public static void createRequest(Ruby runtime, RubyModule mX509) {
        RubyClass cRequest = mX509.defineClassUnder("Request", runtime.getObject(), REQUEST_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("RequestError", openSSLError, openSSLError.getAllocator());
        cRequest.defineAnnotatedMethods(Request.class);
    }

    public Request(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, frame=true, rest=true)
    public IRubyObject _initialize(IRubyObject[] args2, Block block) {
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1) == 0) {
            return this;
        }
        byte[] req_bytes = OpenSSLImpl.readX509PEM(args2[0]);
        this.req = new PKCS10CertificationRequestExt(req_bytes);
        this.version = this.getRuntime().newFixnum(this.req.getVersion());
        String algo = null;
        byte[] enc = null;
        try {
            PublicKey pkey = (PublicKey)OpenSSLReal.getWithBCProvider(new OpenSSLReal.Callable(){

                public Object call() throws GeneralSecurityException {
                    return Request.this.req.getPublicKey("BC");
                }
            });
            algo = pkey.getAlgorithm();
            enc = pkey.getEncoded();
        }
        catch (GeneralSecurityException gse) {
            throw Request.newX509ReqError(this.getRuntime(), gse.getMessage());
        }
        if ("RSA".equalsIgnoreCase(algo)) {
            this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::RSA", RubyString.newString(this.getRuntime(), enc));
        } else if ("DSA".equalsIgnoreCase(algo)) {
            this.public_key = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::PKey::DSA", RubyString.newString(this.getRuntime(), enc));
        } else {
            throw this.getRuntime().newLoadError("not implemented algo for public key: " + algo);
        }
        org.bouncycastle.asn1.x509.X509Name subName = this.req.getCertificationRequestInfo().getSubject();
        this.subject = Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Name");
        DERSequence subNameD = (DERSequence)subName.toASN1Object();
        for (int i2 = 0; i2 < subNameD.size(); ++i2) {
            DERSequence internal = (DERSequence)((DERSet)subNameD.getObjectAt(i2)).getObjectAt(0);
            DEREncodable oid2 = internal.getObjectAt(0);
            String v = null;
            if (internal.getObjectAt(1) instanceof DERString) {
                v = ((DERString)((Object)internal.getObjectAt(1))).getString();
            }
            RubyFixnum t = this.getRuntime().newFixnum(ASN1.idForClass(internal.getObjectAt(1).getClass()));
            ((X509Name)this.subject).addEntry(oid2, v, t);
        }
        ASN1Set in_attrs = this.req.getCertificationRequestInfo().getAttributes();
        Enumeration enm = in_attrs.getObjects();
        while (enm.hasMoreElements()) {
            DERSequence val = (DERSequence)enm.nextElement();
            DERObjectIdentifier v0 = (DERObjectIdentifier)val.getObjectAt(0);
            DERObject v1 = (DERObject)val.getObjectAt(1);
            RubyString a1 = this.getRuntime().newString(ASN1.getSymLookup(this.getRuntime()).get(v0));
            IRubyObject a2 = ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), RubyString.newString(this.getRuntime(), v1.getDEREncoded()));
            this.add_attribute(Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Attribute", new IRubyObject[]{a1, a2}));
        }
        this.valid = true;
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called: init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.version = this.getRuntime().getNil();
        this.subject = this.getRuntime().getNil();
        this.public_key = this.getRuntime().getNil();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        RubyString rubyString;
        StringWriter w = new StringWriter();
        try {
            try {
                PEMInputOutput.writeX509Request(w, this.req);
                rubyString = this.getRuntime().newString(w.toString());
                Object var4_4 = null;
            }
            catch (IOException ex) {
                throw this.getRuntime().newIOErrorFromException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                w.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return rubyString;
        }
        w.close();
        return rubyString;
    }

    @JRubyMethod
    public IRubyObject to_der() {
        return RubyString.newString(this.getRuntime(), this.req.getDEREncoded());
    }

    @JRubyMethod
    public IRubyObject to_text() {
        System.err.println("WARNING: unimplemented method called: to_text");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject val) {
        if (val != this.version) {
            this.valid = false;
        }
        this.version = val;
        if (!val.isNil() && this.req != null) {
            this.req.setVersion(RubyNumeric.fix2int(val));
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject subject() {
        return this.subject;
    }

    @JRubyMethod(name={"subject="})
    public IRubyObject set_subject(IRubyObject val) {
        if (val != this.subject) {
            this.valid = false;
        }
        this.subject = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        System.err.println("WARNING: unimplemented method called: signature_algorithm");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject public_key() {
        return this.public_key;
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(IRubyObject val) {
        if (val != this.public_key) {
            this.valid = false;
        }
        this.public_key = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject sign(final IRubyObject key2, IRubyObject digest2) {
        final String keyAlg = ((PKey)this.public_key).getAlgorithm();
        final String digAlg = ((Digest)digest2).getShortAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest2).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest2).name().toString())) {
            throw Request.newX509ReqError(this.getRuntime(), null);
        }
        final ASN1EncodableVector v1 = new ASN1EncodableVector();
        Iterator<IRubyObject> iter = this.attrs.iterator();
        while (iter.hasNext()) {
            v1.add(((Attribute)iter.next()).toASN1());
        }
        try {
            OpenSSLReal.doWithBCProvider(new OpenSSLReal.Runnable(){

                public void run() throws GeneralSecurityException {
                    Request.this.req = new PKCS10CertificationRequestExt(digAlg + "WITH" + keyAlg, ((X509Name)Request.this.subject).getRealName(), ((PKey)Request.this.public_key).getPublicKey(), (ASN1Set)new DERSet(v1), ((PKey)key2).getPrivateKey(), "BC");
                }
            });
        }
        catch (GeneralSecurityException gse) {
            throw Request.newX509ReqError(this.getRuntime(), gse.getMessage());
        }
        this.req.setVersion(RubyNumeric.fix2int(this.version));
        this.valid = true;
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject key2) {
        try {
            return this.valid && this.req.verify(((PKey)key2.callMethod(this.getRuntime().getCurrentContext(), "public_key")).getPublicKey()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        catch (Exception e) {
            return this.getRuntime().getFalse();
        }
    }

    @JRubyMethod
    public IRubyObject attributes() {
        return this.getRuntime().newArray(this.attrs);
    }

    @JRubyMethod(name={"attributes="})
    public IRubyObject set_attributes(IRubyObject val) {
        this.valid = false;
        this.attrs.clear();
        this.attrs.addAll(((RubyArray)val).getList());
        if (this.req != null) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            Iterator<IRubyObject> iter = this.attrs.iterator();
            while (iter.hasNext()) {
                v1.add(((Attribute)iter.next()).toASN1());
            }
            this.req.setAttributes(new DERSet(v1));
        }
        return val;
    }

    @JRubyMethod
    public IRubyObject add_attribute(IRubyObject val) {
        this.valid = false;
        this.attrs.add(val);
        if (this.req != null) {
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            Iterator<IRubyObject> iter = this.attrs.iterator();
            while (iter.hasNext()) {
                v1.add(((Attribute)iter.next()).toASN1());
            }
            this.req.setAttributes(new DERSet(v1));
        }
        return this.getRuntime().getNil();
    }

    private static RaiseException newX509ReqError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::RequestError", message2);
    }
}

