/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jnr.ffi.ObjectReferenceManager;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.InAccessibleMemoryIO;

public final class DefaultObjectReferenceManager
extends ObjectReferenceManager {
    private final Runtime runtime;
    private final ConcurrentMap<Pointer, Object> references = new ConcurrentHashMap<Pointer, Object>();

    public DefaultObjectReferenceManager(Runtime runtime) {
        this.runtime = runtime;
    }

    public Pointer newReference(Object obj) {
        ObjectReference ptr;
        if (obj == null) {
            throw new IllegalArgumentException("reference to null value not allowed");
        }
        int nextId = System.identityHashCode(obj);
        while (this.references.putIfAbsent(ptr = new ObjectReference(this.runtime, nextId), obj) != null) {
            ++nextId;
        }
        return ptr;
    }

    public void freeReference(Pointer reference2) {
        this.references.remove(reference2);
    }

    public Object getObject(Pointer reference2) {
        return this.references.get(reference2);
    }

    private static final class ObjectReference
    extends InAccessibleMemoryIO {
        private final long address;

        public ObjectReference(Runtime runtime, int address2) {
            super(runtime);
            this.address = (long)address2 & 0xFFFFFFFFL;
        }

        public boolean isDirect() {
            return true;
        }

        public long address() {
            return this.address;
        }

        public long size() {
            return 0L;
        }

        public int hashCode() {
            return (int)this.address;
        }

        public boolean equals(Object obj) {
            return obj instanceof Pointer && ((Pointer)obj).address() == this.address;
        }
    }
}

