/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.Counter;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpIndirectInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveOptArgBase;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgBase;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ruby19.ReceivePostReqdArgInstr;
import org.jruby.ir.interpreter.IRBreakJump;
import org.jruby.ir.interpreter.IRReturnJump;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.IRStaticScopeFactory;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private static final Logger LOG = LoggerFactory.getLogger("Interpreter");
    private static int inlineCount = 0;
    private static int interpInstrsCount = 0;
    private static int codeModificationsCount = 0;
    private static int numCyclesWithNoModifications = 0;
    private static int globalThreadPollCount = 0;
    private static HashMap<IRScope, Counter> scopeThreadPollCounts = new HashMap();

    public static boolean inProfileMode() {
        return RubyInstanceConfig.IR_PROFILE;
    }

    public static boolean isDebug() {
        return RubyInstanceConfig.IR_DEBUG;
    }

    private static IRScope getEvalContainerScope(Ruby runtime, StaticScope evalScope) {
        IRScope containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope()).getIRScope();
        if (containingIRScope == null) {
            containingIRScope = ((IRStaticScope)evalScope.getEnclosingScope().getEnclosingScope()).getIRScope();
        }
        return containingIRScope;
    }

    public static IRubyObject interpretCommonEval(Ruby runtime, String file2, int lineNumber, String backtraceName, RootNode rootNode, IRubyObject self, Block block) {
        boolean is_1_9 = runtime.is1_9();
        if (is_1_9) {
            IRBuilder.setRubyVersion("1.9");
        }
        StaticScope ss = rootNode.getStaticScope();
        IRScope containingIRScope = Interpreter.getEvalContainerScope(runtime, ss);
        IREvalScript evalScript = IRBuilder.createIRBuilder(runtime.getIRManager(), is_1_9).buildEvalRoot(ss, containingIRScope, file2, lineNumber, rootNode);
        evalScript.prepareForInterpretation();
        ThreadContext context = runtime.getCurrentContext();
        Interpreter.runBeginEndBlocks(evalScript.getBeginBlocks(), context, self, null);
        IRubyObject rv = evalScript.call(context, self, evalScript.getStaticScope().getModule(), rootNode.getScope(), block, backtraceName);
        Interpreter.runBeginEndBlocks(evalScript.getEndBlocks(), context, self, null);
        return rv;
    }

    public static IRubyObject interpretSimpleEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self, Block.NULL_BLOCK);
    }

    public static IRubyObject interpretBindingEval(Ruby runtime, String file2, int lineNumber, String backtraceName, Node node, IRubyObject self, Block block) {
        return Interpreter.interpretCommonEval(runtime, file2, lineNumber, backtraceName, (RootNode)node, self, block);
    }

    public static void runBeginEndBlocks(List<IRClosure> beBlocks, ThreadContext context, IRubyObject self, Object[] temp) {
        if (beBlocks == null) {
            return;
        }
        for (IRClosure b : beBlocks) {
            b.prepareForInterpretation();
            Block blk = (Block)new WrappedIRClosure(b).retrieve(context, self, context.getCurrentScope(), temp);
            blk.yield(context, null);
        }
    }

    public static IRubyObject interpret(Ruby runtime, Node rootNode, IRubyObject self) {
        IRScriptBody root;
        if (runtime.is1_9()) {
            IRBuilder.setRubyVersion("1.9");
        }
        if ((root = (IRScriptBody)IRBuilder.createIRBuilder(runtime.getIRManager(), runtime.is1_9()).buildRoot((RootNode)rootNode)).getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime.getObject());
        }
        RubyModule currModule = root.getStaticScope().getModule();
        IRStaticScopeFactory.newIRLocalScope(null).setModule(currModule);
        ThreadContext context = runtime.getCurrentContext();
        try {
            Interpreter.runBeginEndBlocks(root.getBeginBlocks(), context, self, null);
            InterpretedIRMethod method2 = new InterpretedIRMethod(root, currModule);
            IRubyObject rv = method2.call(context, self, currModule, "(root)", IRubyObject.NULL_ARRAY);
            Interpreter.runBeginEndBlocks(root.getEndBlocks(), context, self, null);
            if (Interpreter.isDebug() || Interpreter.inProfileMode()) {
                LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
            }
            return rv;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
    }

    private static void analyzeProfile() {
        numCyclesWithNoModifications = codeModificationsCount == 0 ? ++numCyclesWithNoModifications : 0;
        codeModificationsCount = 0;
        if (numCyclesWithNoModifications < 3) {
            return;
        }
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        Collections.sort(scopes, new Comparator<IRScope>(){

            @Override
            public int compare(IRScope a, IRScope b) {
                float aCount = ((Counter)scopeThreadPollCounts.get((Object)a)).count;
                float bCount = ((Counter)scopeThreadPollCounts.get((Object)b)).count;
                if (aCount == bCount) {
                    return 0;
                }
                return aCount < bCount ? 1 : -1;
            }
        });
        HashSet<IRScope> hotScopes = new HashSet<IRScope>();
        int i2 = 0;
        float f = 0.0f;
        for (IRScope s2 : scopes) {
            Instr[] instrs;
            long sCount = Interpreter.scopeThreadPollCounts.get((Object)s2).count;
            float sPerc = (float)(sCount * 1000L / (long)globalThreadPollCount) / 10.0f;
            if (sPerc < 1.0f && ((instrs = s2.getInstrsForInterpretation()) == null || (float)instrs.length > 5.0f + sPerc * 10.0f)) continue;
            hotScopes.add(s2);
            f += sPerc;
            if (++i2 != 50 && !((double)f >= 99.0)) continue;
            break;
        }
        boolean revisitScope = false;
        Iterator hsIter = hotScopes.iterator();
        IRScope hs = null;
        block1: while (hsIter.hasNext()) {
            if (!revisitScope) {
                hs = (IRScope)hsIter.next();
            }
            revisitScope = false;
            boolean skip2 = false;
            boolean isHotClosure = hs instanceof IRClosure;
            IRScope hc = isHotClosure ? hs : null;
            hs = isHotClosure ? hs.getLexicalParent() : hs;
            for (BasicBlock b : hs.getCFG().getBasicBlocks()) {
                for (Instr instr : b.getInstrs()) {
                    InterpretedIRMethod dynMeth;
                    IRScope tgtMethod;
                    Instr[] instrs;
                    CachingCallSite ccs;
                    CallBase call2;
                    CallSite cs;
                    if (!(instr instanceof CallBase) || ((CallBase)instr).inliningBlocked() || (cs = (call2 = (CallBase)instr).getCallSite()) == null || !(cs instanceof CachingCallSite) || !(ccs = (CachingCallSite)cs).isOptimizable()) continue;
                    CacheEntry ce = ccs.getCache();
                    DynamicMethod tgt = ce.method;
                    if (!(tgt instanceof InterpretedIRMethod) || (instrs = (tgtMethod = (dynMeth = (InterpretedIRMethod)tgt).getIRMethod()).getInstrsForInterpretation()) == null || instrs.length > 150) continue;
                    RubyModule implClass = dynMeth.getImplementationClass();
                    int classToken = implClass.getGeneration();
                    String n = tgtMethod.getName();
                    boolean inlineCall = false;
                    if (isHotClosure) {
                        Operand clArg = call2.getClosureArg(null);
                        inlineCall = clArg instanceof WrappedIRClosure && ((WrappedIRClosure)clArg).getClosure() == hc;
                    } else if (hotScopes.contains(tgtMethod)) {
                        inlineCall = true;
                    }
                    if (!inlineCall) continue;
                    System.out.println("Inlining " + tgtMethod + " in " + hs + " @ instr " + instr);
                    hs.inlineMethod(tgtMethod, implClass, classToken, b, call2);
                    scopeThreadPollCounts.remove(isHotClosure ? hc : hs);
                    scopeThreadPollCounts.remove(tgtMethod);
                    ++inlineCount;
                    skip2 = true;
                    revisitScope = true;
                    break;
                }
                if (!skip2) continue;
                continue block1;
            }
        }
    }

    private static void outputProfileStats() {
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        Collections.sort(scopes, new Comparator<IRScope>(){

            @Override
            public int compare(IRScope a, IRScope b) {
                float bCount;
                float aCount;
                int bden;
                int aden = a.getThreadPollInstrsCount();
                if (aden == 0) {
                    aden = 1;
                }
                if ((bden = b.getThreadPollInstrsCount()) == 0) {
                    bden = 1;
                }
                if ((aCount = (float)((Counter)scopeThreadPollCounts.get((Object)a)).count * (1.0f * (float)a.getInstrsForInterpretation().length / (float)aden)) == (bCount = (float)((Counter)scopeThreadPollCounts.get((Object)b)).count * (1.0f * (float)b.getInstrsForInterpretation().length / (float)bden))) {
                    return 0;
                }
                return aCount < bCount ? 1 : -1;
            }
        });
        LOG.info("------------------------", new Object[0]);
        LOG.info("Stats after " + globalThreadPollCount + " thread polls:", new Object[0]);
        LOG.info("------------------------", new Object[0]);
        LOG.info("# instructions: " + interpInstrsCount, new Object[0]);
        LOG.info("# code modifications in this period : " + codeModificationsCount, new Object[0]);
        LOG.info("------------------------", new Object[0]);
        int i2 = 0;
        float f1 = 0.0f;
        for (IRScope s2 : scopes) {
            long n = Interpreter.scopeThreadPollCounts.get((Object)s2).count;
            float p1 = (float)(n * 1000L / (long)globalThreadPollCount) / 10.0f;
            String msg = i2 + ". " + s2 + " [file:" + s2.getFileName() + ":" + s2.getLineNumber() + "] = " + n + "; (" + p1 + "%)";
            if (s2 instanceof IRClosure) {
                IRMethod m = s2.getNearestMethod();
                if (m != null) {
                    LOG.info(msg + " -- nearest enclosing method: " + m, new Object[0]);
                } else {
                    LOG.info(msg + " -- no enclosing method --", new Object[0]);
                }
            } else {
                LOG.info(msg, new Object[0]);
            }
            f1 += p1;
            if (++i2 != 20 && !((double)f1 >= 95.0)) continue;
            break;
        }
        codeModificationsCount = 0;
        if (globalThreadPollCount % 1000000 == 0) {
            System.out.println("---- resetting thread-poll counters ----");
            scopeThreadPollCounts = new HashMap();
            globalThreadPollCount = 0;
        }
    }

    private static IRubyObject interpret(ThreadContext context, IRubyObject self, IRScope scope, Visibility visibility, RubyModule implClass, IRubyObject[] args2, Block block, Block.Type blockType) {
        int temporaryVariablesSize;
        boolean debug = Interpreter.isDebug();
        boolean profile = Interpreter.inProfileMode();
        boolean inClosure = scope instanceof IRClosure;
        Instr[] instrs = scope.getInstrsForInterpretation();
        if (instrs == null) {
            instrs = scope.prepareForInterpretation();
        }
        Object[] temp = (temporaryVariablesSize = scope.getTemporaryVariableSize()) > 0 ? new Object[temporaryVariablesSize] : null;
        int n = instrs.length;
        int ipc = 0;
        Instr lastInstr = null;
        IRubyObject rv = null;
        Serializable exception2 = null;
        Ruby runtime = context.runtime;
        DynamicScope currDynScope = context.getCurrentScope();
        Counter tpCount = null;
        if (profile && (tpCount = scopeThreadPollCounts.get(scope)) == null) {
            tpCount = new Counter();
            scopeThreadPollCounts.put(scope, tpCount);
        }
        while (ipc < n) {
            lastInstr = instrs[ipc];
            Operation operation = lastInstr.getOperation();
            if (debug) {
                LOG.info("I: {}", lastInstr);
                ++interpInstrsCount;
            } else if (profile) {
                if (operation.modifiesCode()) {
                    ++codeModificationsCount;
                }
                ++interpInstrsCount;
            }
            try {
                Variable resultVar = null;
                Object result2 = null;
                try {
                    switch (operation) {
                        case PUSH_FRAME: {
                            context.preMethodFrameAndClass(implClass, scope.getName(), self, block, scope.getStaticScope());
                            context.setCurrentVisibility(visibility);
                            ++ipc;
                            break;
                        }
                        case PUSH_BINDING: {
                            currDynScope = DynamicScope.newDynamicScope(scope.getStaticScope());
                            context.pushScope(currDynScope);
                            ++ipc;
                            break;
                        }
                        case POP_FRAME: {
                            context.popFrame();
                            context.popRubyClass();
                            ++ipc;
                            break;
                        }
                        case POP_BINDING: {
                            context.popScope();
                            ++ipc;
                            break;
                        }
                        case JUMP: {
                            ipc = ((JumpInstr)lastInstr).getJumpTarget().getTargetPC();
                            break;
                        }
                        case JUMP_INDIRECT: {
                            ipc = ((Label)((JumpIndirectInstr)lastInstr).getJumpTarget().retrieve(context, self, currDynScope, temp)).getTargetPC();
                            break;
                        }
                        case B_TRUE: {
                            BranchInstr br = (BranchInstr)lastInstr;
                            Object value1 = br.getArg1().retrieve(context, self, currDynScope, temp);
                            ipc = ((IRubyObject)value1).isTrue() ? br.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case B_FALSE: {
                            BranchInstr br = (BranchInstr)lastInstr;
                            Object value1 = br.getArg1().retrieve(context, self, currDynScope, temp);
                            ipc = !((IRubyObject)value1).isTrue() ? br.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case B_NIL: {
                            BranchInstr br = (BranchInstr)lastInstr;
                            Object value1 = br.getArg1().retrieve(context, self, currDynScope, temp);
                            ipc = value1 == context.nil ? br.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case B_UNDEF: {
                            BranchInstr br = (BranchInstr)lastInstr;
                            Object value1 = br.getArg1().retrieve(context, self, currDynScope, temp);
                            ipc = value1 == UndefinedValue.UNDEFINED ? br.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case BEQ: {
                            BEQInstr beq = (BEQInstr)lastInstr;
                            Object value1 = beq.getArg1().retrieve(context, self, currDynScope, temp);
                            Object value2 = beq.getArg2().retrieve(context, self, currDynScope, temp);
                            boolean eql2 = ((IRubyObject)value1).op_equal(context, (IRubyObject)value2).isTrue();
                            ipc = eql2 ? beq.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case BNE: {
                            BNEInstr bne = (BNEInstr)lastInstr;
                            Operand arg1 = bne.getArg1();
                            Operand arg2 = bne.getArg2();
                            Object value1 = arg1.retrieve(context, self, currDynScope, temp);
                            Object value2 = arg2.retrieve(context, self, currDynScope, temp);
                            boolean eql3 = arg2 == scope.getManager().getNil() || arg2 == UndefinedValue.UNDEFINED ? value1 == value2 : ((IRubyObject)value1).op_equal(context, (IRubyObject)value2).isTrue();
                            ipc = !eql3 ? bne.getJumpTarget().getTargetPC() : ipc + 1;
                            break;
                        }
                        case MODULE_GUARD: {
                            ModuleVersionGuardInstr mvg = (ModuleVersionGuardInstr)lastInstr;
                            ipc = mvg.versionMatches(context, currDynScope, self, temp) ? ipc + 1 : mvg.getFailurePathLabel().getTargetPC();
                            break;
                        }
                        case RECV_PRE_REQD_ARG: {
                            ReceiveArgBase ra = (ReceivePreReqdArgInstr)lastInstr;
                            int argIndex = ra.getArgIndex();
                            result2 = argIndex < args2.length ? args2[argIndex] : context.nil;
                            resultVar = ra.getResult();
                            ++ipc;
                            break;
                        }
                        case RECV_POST_REQD_ARG: {
                            ReceiveArgBase ra = (ReceivePostReqdArgInstr)lastInstr;
                            result2 = ((ReceivePostReqdArgInstr)ra).receivePostReqdArg(args2);
                            if (result2 == null) {
                                result2 = context.nil;
                            }
                            resultVar = ra.getResult();
                            ++ipc;
                            break;
                        }
                        case RECV_OPT_ARG: {
                            ReceiveArgBase ra = (ReceiveOptArgBase)lastInstr;
                            result2 = ((ReceiveOptArgBase)ra).receiveOptArg(args2);
                            resultVar = ra.getResult();
                            ++ipc;
                            break;
                        }
                        case RECV_REST_ARG: {
                            ReceiveArgBase ra = (ReceiveRestArgBase)lastInstr;
                            result2 = ((ReceiveRestArgBase)ra).receiveRestArg(runtime, args2);
                            resultVar = ra.getResult();
                            ++ipc;
                            break;
                        }
                        case RECV_CLOSURE: {
                            result2 = block == Block.NULL_BLOCK ? context.nil : runtime.newProc(Block.Type.PROC, block);
                            resultVar = ((ResultInstr)((Object)lastInstr)).getResult();
                            ++ipc;
                            break;
                        }
                        case RECV_EXCEPTION: {
                            result2 = exception2;
                            resultVar = ((ResultInstr)((Object)lastInstr)).getResult();
                            ++ipc;
                            break;
                        }
                        case CLOSURE_RETURN: 
                        case RETURN: {
                            rv = (IRubyObject)((ReturnBase)lastInstr).getReturnValue().retrieve(context, self, currDynScope, temp);
                            ipc = n;
                            break;
                        }
                        case THREAD_POLL: {
                            if (profile) {
                                ++tpCount.count;
                                ++globalThreadPollCount;
                            }
                            context.callThreadPoll();
                            ++ipc;
                            break;
                        }
                        case LINE_NUM: {
                            context.setLine(((LineNumberInstr)lastInstr).lineNumber);
                            ++ipc;
                            break;
                        }
                        case COPY: {
                            CopyInstr c = (CopyInstr)lastInstr;
                            result2 = c.getSource().retrieve(context, self, currDynScope, temp);
                            resultVar = ((ResultInstr)((Object)lastInstr)).getResult();
                            ++ipc;
                            break;
                        }
                        case CHECK_ARITY: {
                            CheckArityInstr ca = (CheckArityInstr)lastInstr;
                            int numArgs = args2.length;
                            if (numArgs < ca.required || ca.rest == -1 && numArgs > ca.required + ca.opt) {
                                Arity.raiseArgumentError(runtime, numArgs, ca.required, ca.required + ca.opt);
                            }
                            ++ipc;
                            break;
                        }
                        default: {
                            result2 = lastInstr.interpret(context, currDynScope, self, temp, block);
                            if (lastInstr instanceof ResultInstr) {
                                resultVar = ((ResultInstr)((Object)lastInstr)).getResult();
                            }
                            ++ipc;
                        }
                    }
                    if (resultVar == null) continue;
                    if (resultVar instanceof TemporaryVariable) {
                        temp[((TemporaryVariable)resultVar).offset] = result2;
                        continue;
                    }
                    LocalVariable lv = (LocalVariable)resultVar;
                    currDynScope.setValue((IRubyObject)result2, lv.getLocation(), lv.getScopeDepth());
                }
                catch (IRReturnJump rj) {
                    ipc = scope.getEnsurerPC(lastInstr);
                    if (ipc == -1) {
                        return Interpreter.handleReturnJumpInClosure(scope, rj, blockType);
                    }
                    exception2 = rj;
                }
                catch (IRBreakJump bj) {
                    if (lastInstr instanceof BreakInstr || bj.breakInEval) {
                        Interpreter.handleBreakJump(context, scope, bj, self, blockType, inClosure);
                        continue;
                    }
                    if (Interpreter.inNonMethodBodyLambda(scope, blockType)) {
                        throw IRException.BREAK_LocalJumpError.getException(runtime);
                    }
                    if (bj.caughtByLambda || bj.scopeToReturnTo == scope) {
                        if (lastInstr instanceof ResultInstr) {
                            resultVar = ((ResultInstr)((Object)lastInstr)).getResult();
                            if (resultVar instanceof TemporaryVariable) {
                                temp[((TemporaryVariable)resultVar).offset] = bj.breakValue;
                            } else {
                                LocalVariable lv = (LocalVariable)resultVar;
                                currDynScope.setValue((IRubyObject)bj.breakValue, lv.getLocation(), lv.getScopeDepth());
                            }
                        }
                        ++ipc;
                        continue;
                    }
                    ipc = scope.getEnsurerPC(lastInstr);
                    if (ipc == -1) {
                        throw bj;
                    }
                    exception2 = bj;
                }
            }
            catch (RaiseException re) {
                if (debug) {
                    LOG.info("in scope: " + scope + ", caught raise exception: " + re.getException() + "; excepting instr: " + lastInstr, new Object[0]);
                }
                ipc = scope.getRescuerPC(lastInstr);
                if (debug) {
                    LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    throw re;
                }
                exception2 = re.getException();
            }
            catch (Throwable t) {
                if (t instanceof Unrescuable) {
                    ipc = scope.getEnsurerPC(lastInstr);
                } else {
                    if (debug) {
                        LOG.info("in scope: " + scope + ", caught Java throwable: " + t + "; excepting instr: " + lastInstr, new Object[0]);
                    }
                    ipc = scope.getRescuerPC(lastInstr);
                    if (debug) {
                        LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                    }
                }
                if (ipc == -1) {
                    UnsafeFactory.getUnsafe().throwException(t);
                }
                exception2 = t;
            }
        }
        if (lastInstr instanceof ReturnInstr && !Interpreter.inLambda(blockType)) {
            Interpreter.handleNonLocalReturn(context, scope, (ReturnInstr)lastInstr, rv, inClosure);
        }
        return rv;
    }

    private static void handleNonLocalReturn(ThreadContext context, IRScope scope, ReturnInstr returnInstr, IRubyObject returnValue, boolean inClosure) {
        IRMethod methodToReturnFrom = returnInstr.methodToReturnFrom;
        if (inClosure) {
            if (methodToReturnFrom == null) {
                if (context.getThread() == context.runtime.getThreadService().getMainThread()) {
                    throw IRException.RETURN_LocalJumpError.getException(context.runtime);
                }
                throw context.runtime.newThreadError("return can't jump across threads");
            }
            if (!context.scopeExistsOnCallStack(methodToReturnFrom.getStaticScope())) {
                if (Interpreter.isDebug()) {
                    LOG.info("in scope: " + scope + ", raising unexpected return local jump error", new Object[0]);
                }
                throw IRException.RETURN_LocalJumpError.getException(context.runtime);
            }
            throw IRReturnJump.create(methodToReturnFrom, returnValue);
        }
        if (methodToReturnFrom != null) {
            throw IRReturnJump.create(methodToReturnFrom, returnValue);
        }
    }

    private static IRubyObject handleReturnJumpInClosure(IRScope scope, IRReturnJump rj, Block.Type blockType) throws IRReturnJump {
        if (Interpreter.inNonMethodBodyLambda(scope, blockType) || rj.methodToReturnFrom == scope) {
            return (IRubyObject)rj.returnValue;
        }
        throw rj;
    }

    private static void handleBreakJump(ThreadContext context, IRScope scope, IRBreakJump bj, IRubyObject self, Block.Type blockType, boolean inClosure) throws RaiseException, IRBreakJump {
        bj.breakInEval = false;
        if (!inClosure) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        if (!Interpreter.inProc(blockType)) {
            if (Interpreter.inLambda(blockType)) {
                bj.caughtByLambda = true;
            } else if (scope instanceof IREvalScript) {
                bj.breakInEval = true;
            }
        }
        throw bj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self, IRScope scope, RubyModule clazz, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            iRubyObject = Interpreter.interpret(context, self, scope, null, clazz, args2, block, blockType);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, IRubyObject self, IRScope scope, IRubyObject[] args2, String name2, Block block, Block.Type blockType) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
            iRubyObject = Interpreter.interpret(context, self, scope, null, null, args2, block, blockType);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject INTERPRET_METHOD(ThreadContext context, InterpretedIRMethod irMethod, IRubyObject self, String name2, IRubyObject[] args2, Block block, Block.Type blockType, boolean isTraceable) {
        IRubyObject iRubyObject;
        boolean syntheticMethod;
        block8: {
            Ruby runtime = context.runtime;
            IRScope scope = irMethod.getIRMethod();
            RubyModule implClass = irMethod.getImplementationClass();
            Visibility viz = irMethod.getVisibility();
            syntheticMethod = name2 == null || name2.equals("");
            try {
                if (!syntheticMethod) {
                    ThreadContext.pushBacktrace(context, name2, scope.getFileName(), context.getLine());
                }
                if (isTraceable) {
                    Interpreter.methodPreTrace(runtime, context, name2, implClass);
                }
                iRubyObject = Interpreter.interpret(context, self, scope, viz, implClass, args2, block, blockType);
                Object var15_14 = null;
                if (!isTraceable) break block8;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (!isTraceable) {
                    if (syntheticMethod) throw throwable;
                    ThreadContext.popBacktrace(context);
                    throw throwable;
                }
                try {}
                catch (Throwable throwable2) {
                    Object var17_19 = null;
                    if (syntheticMethod) throw throwable2;
                    ThreadContext.popBacktrace(context);
                    throw throwable2;
                }
                Interpreter.methodPostTrace(runtime, context, name2, implClass);
                Object var17_18 = null;
                if (syntheticMethod) throw throwable;
                ThreadContext.popBacktrace(context);
                throw throwable;
            }
            try {
                Interpreter.methodPostTrace(runtime, context, name2, implClass);
                Object var17_16 = null;
                if (syntheticMethod) return iRubyObject;
                ThreadContext.popBacktrace(context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (syntheticMethod) throw throwable;
                ThreadContext.popBacktrace(context);
                throw throwable;
            }
        }
        if (syntheticMethod) return iRubyObject;
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    private static boolean inNonMethodBodyLambda(IRScope scope, Block.Type blockType) {
        return blockType == Block.Type.LAMBDA && !scope.getStaticScope().isArgumentScope();
    }

    private static boolean inLambda(Block.Type blockType) {
        return blockType == Block.Type.LAMBDA;
    }

    public static boolean inProc(Block.Type blockType) {
        return blockType == Block.Type.PROC;
    }

    private static void methodPreTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }
}

