/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.impl.MethodBodyCompiler;
import org.jruby.compiler.impl.RootScopedBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    public static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    public static final String RUBY = CodegenUtils.p(Ruby.class);
    public static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    public static final boolean VERIFY_CLASSFILES = false;
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_OFFSET = 0;
    public static final int DYNAMIC_SCOPE_OFFSET = 1;
    public static final int VARS_ARRAY_OFFSET = 2;
    public static final int EXCEPTION_OFFSET = 3;
    public static final int PREVIOUS_EXCEPTION_OFFSET = 4;
    public static final int FIRST_TEMP_OFFSET = 5;
    public static final int STARTING_DSTR_FACTOR = 10;
    private String classname;
    private String sourcename;
    private Integer javaVersion;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    private int methodIndex = 0;
    private int innerIndex = 0;
    private int rescueNumber = 1;
    private int ensureNumber = 1;
    StaticScope topLevelScope;
    private CacheCompiler cacheCompiler;
    private List<InvokerDescriptor> invokerDescriptors = new ArrayList<InvokerDescriptor>();
    private List<BlockCallbackDescriptor> blockCallbackDescriptors = new ArrayList<BlockCallbackDescriptor>();
    private List<BlockCallbackDescriptor> blockCallback19Descriptors = new ArrayList<BlockCallbackDescriptor>();
    private int constants = 0;

    public static Class[] getStaticMethodArgs(Class target, int args2) {
        switch (args2) {
            case 0: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, Block.class};
            }
            case 1: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 2: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 3: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 4: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static String getStaticMethodSignature(String classname, int args2) {
        switch (args2) {
            case 0: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, Block.class);
            }
            case 1: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 2: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 3: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 4: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static Class[] getStaticMethodParams(Class target, int args2) {
        switch (args2) {
            case 0: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, Block.class};
            }
            case 1: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 2: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 3: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 4: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static String getMethodSignature(int args2) {
        switch (args2) {
            case 0: {
                return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Block.class);
            }
            case 1: {
                return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 2: {
                return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 3: {
                return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 4: {
                return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static String getStaticClosureSignature(String classdesc) {
        return CodegenUtils.sig(IRubyObject.class, "L" + classdesc + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
    }

    public static String getStaticClosure19Signature(String classdesc) {
        return CodegenUtils.sig(IRubyObject.class, "L" + classdesc + ";", ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    }

    public static String getClosureSignature() {
        return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
    }

    public static String getClosure19Signature() {
        return CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    }

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public void setJavaVersion(Integer javaVersion) {
        this.javaVersion = javaVersion;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(CodegenUtils.c(this.getClassname()), this.classWriter.toByteArray());
        return classLoader.loadClass(CodegenUtils.c(this.getClassname()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpClass(PrintStream out) {
        PrintWriter pw = new PrintWriter(out);
        try {
            TraceClassVisitor tcv = new TraceClassVisitor(pw);
            new ClassReader(this.classWriter.toByteArray()).accept(tcv, 0);
            Object var5_4 = null;
            pw.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            pw.close();
            throw throwable;
        }
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.getClassname(), destination, this.classWriter);
    }

    public void writeInvokers(String destination) throws IOException {
        this.writeInvokers(new File(destination));
    }

    public void writeInvokers(File destination) throws IOException {
        byte[] callbackBytes;
        for (InvokerDescriptor invokerDescriptor : this.invokerDescriptors) {
            byte[] invokerBytes = RuntimeHelpers.defOffline(invokerDescriptor.getName(), invokerDescriptor.getClassname(), invokerDescriptor.getInvokerName(), invokerDescriptor.getArity(), invokerDescriptor.getScope(), invokerDescriptor.getCallConfig(), invokerDescriptor.getFile(), invokerDescriptor.getLine());
            this.writeClassFile(destination, invokerBytes, invokerDescriptor.getInvokerName());
        }
        for (BlockCallbackDescriptor blockCallbackDescriptor : this.blockCallbackDescriptors) {
            callbackBytes = RuntimeHelpers.createBlockCallbackOffline(blockCallbackDescriptor.getClassname(), blockCallbackDescriptor.getMethod(), blockCallbackDescriptor.getFile(), blockCallbackDescriptor.getLine());
            this.writeClassFile(destination, callbackBytes, blockCallbackDescriptor.getCallbackName());
        }
        for (BlockCallbackDescriptor blockCallbackDescriptor : this.blockCallback19Descriptors) {
            callbackBytes = RuntimeHelpers.createBlockCallback19Offline(blockCallbackDescriptor.getClassname(), blockCallbackDescriptor.getMethod(), blockCallbackDescriptor.getFile(), blockCallbackDescriptor.getLine());
            this.writeClassFile(destination, callbackBytes, blockCallbackDescriptor.getCallbackName());
        }
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        byte[] bytecode = writer.toByteArray();
        this.writeClassFile(destination, bytecode, classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassFile(File destination, byte[] bytecode, String classname) throws IOException {
        String fullname = classname + ".class";
        String filename2 = null;
        String path2 = null;
        if (fullname.lastIndexOf("/") == -1) {
            filename2 = fullname;
            path2 = "";
        } else {
            filename2 = fullname.substring(fullname.lastIndexOf("/") + 1);
            path2 = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path2);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename2));
        try {
            out.write(bytecode);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void addInvokerDescriptor(String newMethodName, int methodArity, StaticScope scope, CallConfiguration callConfig, String filename2, int line) {
        Arity arity2 = Arity.createArity(methodArity);
        InvokerDescriptor descriptor = new InvokerDescriptor(newMethodName, this.classname, arity2, scope, callConfig, filename2, line);
        this.invokerDescriptors.add(descriptor);
    }

    public void addBlockCallbackDescriptor(String method2, String file2, int line) {
        this.blockCallbackDescriptors.add(new BlockCallbackDescriptor(method2, this.classname, file2, line));
    }

    public void addBlockCallback19Descriptor(String method2, String file2, int line) {
        this.blockCallback19Descriptors.add(new BlockCallbackDescriptor(method2, this.classname, file2, line));
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope scope) {
        this.classWriter = new ClassWriter(3);
        this.classWriter.visit(this.javaVersion == null ? RubyInstanceConfig.JAVA_VERSION : this.javaVersion, 33, this.getClassname(), null, CodegenUtils.p(AbstractScript.class), null);
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(this.getClassVisitor(), 4106, "setPosition", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, Integer.TYPE)), null, null);
        method2.start();
        method2.aload(0);
        method2.ldc(this.sourcename);
        method2.iload(1);
        method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "setFileAndLine", CodegenUtils.sig(Void.TYPE, String.class, Integer.TYPE));
        method2.voidreturn();
        method2.end();
        this.topLevelScope = scope;
        this.beginInit();
        this.cacheCompiler = OptoFactory.newCacheCompiler(this);
        File sourceFile = new File(this.getSourcename());
        this.classWriter.visitSource(this.sourcename, sourceFile.getAbsolutePath());
    }

    @Override
    public void endScript(boolean generateLoad, boolean generateMain) {
        SkinnyMethodAdapter method2;
        String methodName = "__file__";
        String loadSig = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Boolean.TYPE);
        if (generateLoad || generateMain) {
            method2 = new SkinnyMethodAdapter(this.getClassVisitor(), 1, "load", loadSig, null, null);
            method2.start();
            Label tryBegin = new Label();
            Label tryFinally = new Label();
            method2.label(tryBegin);
            method2.aload(1);
            String scopeNames = RuntimeHelpers.encodeScope(this.topLevelScope);
            method2.ldc(scopeNames);
            method2.iload(3);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String.class, Boolean.TYPE));
            method2.aload(0);
            method2.aload(1);
            method2.aload(2);
            method2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            method2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            method2.invokestatic(this.getClassname(), methodName, StandardASMCompiler.getStaticMethodSignature(this.getClassname(), 4));
            method2.aload(1);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method2.areturn();
            method2.label(tryFinally);
            method2.aload(1);
            method2.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method2.athrow();
            method2.trycatch(tryBegin, tryFinally, tryFinally, null);
            method2.end();
        }
        if (generateMain) {
            method2 = new SkinnyMethodAdapter(this.getClassVisitor(), 9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null);
            method2.start();
            method2.newobj(this.getClassname());
            method2.dup();
            method2.invokespecial(this.getClassname(), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            method2.dup();
            method2.ldc(Type.getType("L" + this.getClassname() + ";"));
            method2.invokevirtual(CodegenUtils.p(Class.class), "getClassLoader", CodegenUtils.sig(ClassLoader.class, new Class[0]));
            method2.ldc(this.getClassname() + ".class");
            method2.invokevirtual(CodegenUtils.p(ClassLoader.class), "getResource", CodegenUtils.sig(URL.class, String.class));
            method2.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
            method2.astore(1);
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(AbstractScript.class), "setFilename", CodegenUtils.sig(Void.TYPE, String.class));
            method2.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            method2.dup();
            method2.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            method2.dup();
            method2.aload(0);
            method2.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            method2.dup();
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setScriptFileName", CodegenUtils.sig(Void.TYPE, String.class));
            method2.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            method2.dup();
            method2.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
            method2.swap();
            method2.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            method2.ldc(false);
            method2.invokevirtual(this.getClassname(), "load", loadSig);
            method2.voidreturn();
            method2.end();
        }
        this.getCacheCompiler().finish();
        this.endInit();
        this.endClassInit();
    }

    public static String buildStaticScopeNames(StaticScope scope) {
        return RuntimeHelpers.encodeScope(scope);
    }

    private void beginInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        this.initMethod.start();
        this.initMethod.aload(0);
        this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        this.initMethod.aload(0);
        this.initMethod.ldc(this.getSourcename());
        this.initMethod.putfield(this.getClassname(), "filename", CodegenUtils.ci(String.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(cv, 9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        this.clinitMethod.start();
    }

    private void endClassInit() {
        if (this.clinitMethod != null) {
            this.clinitMethod.voidreturn();
            this.clinitMethod.end();
        }
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        if (this.clinitMethod == null) {
            this.beginClassInit();
        }
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public BodyCompiler startMethod(String rubyName, String javaName, CompilerCallback args2, StaticScope scope, ASTInspector inspector) {
        MethodBodyCompiler methodCompiler = new MethodBodyCompiler(this, rubyName, javaName, inspector, scope);
        ((RootScopedBodyCompiler)methodCompiler).beginMethod(args2, scope);
        return methodCompiler;
    }

    @Override
    public BodyCompiler startFileMethod(CompilerCallback args2, StaticScope scope, ASTInspector inspector) {
        MethodBodyCompiler methodCompiler = new MethodBodyCompiler(this, "__file__", "__file__", inspector, scope);
        methodCompiler.beginMethod(args2, scope);
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(this.getClassVisitor(), 1, "__file__", StandardASMCompiler.getMethodSignature(4), null, null);
        method2.start();
        method2.aload(0);
        method2.aload(1);
        method2.aload(2);
        method2.aload(3);
        method2.aload(4);
        method2.invokestatic(this.getClassname(), "__file__", StandardASMCompiler.getStaticMethodSignature(this.getClassname(), 4));
        method2.areturn();
        method2.end();
        if (methodCompiler.isSpecificArity()) {
            method2 = new SkinnyMethodAdapter(this.getClassVisitor(), 1, "__file__", StandardASMCompiler.getMethodSignature(scope.getRequiredArgs()), null, null);
            method2.start();
            method2.aload(0);
            method2.aload(1);
            method2.aload(2);
            for (int i2 = 0; i2 < scope.getRequiredArgs(); ++i2) {
                method2.aload(3 + i2);
            }
            method2.aload(3 + scope.getRequiredArgs());
            method2.invokestatic(this.getClassname(), "__file__", StandardASMCompiler.getStaticMethodSignature(this.getClassname(), scope.getRequiredArgs()));
            method2.areturn();
            method2.end();
        }
        return methodCompiler;
    }

    @Override
    public BodyCompiler startRoot(String rubyName, String javaName, StaticScope scope, ASTInspector inspector) {
        MethodBodyCompiler methodCompiler = new MethodBodyCompiler(this, rubyName, javaName, inspector, scope);
        ((RootScopedBodyCompiler)methodCompiler).beginMethod(null, scope);
        return methodCompiler;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public int getAndIncrementMethodIndex() {
        return this.methodIndex++;
    }

    public int getInnerIndex() {
        return this.innerIndex;
    }

    public int getAndIncrementInnerIndex() {
        return this.innerIndex++;
    }

    public int getRescueNumber() {
        return this.rescueNumber;
    }

    public int getAndIncrementRescueNumber() {
        return this.rescueNumber++;
    }

    public int getEnsureNumber() {
        return this.ensureNumber;
    }

    public int getAndIncrementEnsureNumber() {
        return this.ensureNumber++;
    }

    public String getNewConstant(String type2, String name_prefix) {
        return this.getNewConstant(type2, name_prefix, null);
    }

    public synchronized String getNewConstantName() {
        return "_" + this.constants++;
    }

    public String getNewConstant(String type2, String name_prefix, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        String realName = this.getNewConstantName();
        cv.visitField(2, realName, type2, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.getClassname(), realName, type2);
        }
        return realName;
    }

    public String getNewField(String type2, String name2, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        cv.visitField(2, name2, type2, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.getClassname(), name2, type2);
        }
        return name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String type2, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "__" + this.constants++;
        }
        cv.visitField(26, realName, type2, null, null).visitEnd();
        return realName;
    }

    private static class BlockCallbackDescriptor {
        private final String method;
        private final String classname;
        private final String callbackName;
        private final String file;
        private final int line;

        public BlockCallbackDescriptor(String method2, String classname, String file2, int line) {
            this.method = method2;
            this.classname = classname;
            this.callbackName = InvocationMethodFactory.getBlockCallbackName(classname, method2);
            this.file = file2;
            this.line = line;
        }

        public String getClassname() {
            return this.classname;
        }

        public String getMethod() {
            return this.method;
        }

        public String getCallbackName() {
            return this.callbackName;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }
    }

    public static class InvokerDescriptor {
        private final String name;
        private final String classname;
        private final String invokerName;
        private final Arity arity;
        private final StaticScope scope;
        private final CallConfiguration callConfig;
        private final String file;
        private final int line;

        public InvokerDescriptor(String name2, String classname, Arity arity2, StaticScope scope, CallConfiguration callConfig, String file2, int line) {
            this.name = name2;
            this.classname = classname;
            this.invokerName = InvocationMethodFactory.getCompiledCallbackName(classname, name2);
            this.arity = arity2;
            this.scope = scope;
            this.callConfig = callConfig;
            this.file = file2;
            this.line = line;
        }

        public Arity getArity() {
            return this.arity;
        }

        public CallConfiguration getCallConfig() {
            return this.callConfig;
        }

        public String getClassname() {
            return this.classname;
        }

        public String getFile() {
            return this.file;
        }

        public String getInvokerName() {
            return this.invokerName;
        }

        public int getLine() {
            return this.line;
        }

        public String getName() {
            return this.name;
        }

        public StaticScope getScope() {
            return this.scope;
        }
    }
}

