/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class HeapBasedVariableCompiler
extends AbstractVariableCompiler {
    public HeapBasedVariableCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method2, scope, specificArity, argsIndex, firstTempIndex);
    }

    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            this.method.astore(this.methodCompiler.getDynamicScopeIndex());
            if (scope.getNumberOfVariables() > 4) {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
                this.method.astore(this.methodCompiler.getVarsArrayIndex());
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.methodCompiler.loadRuntime();
                this.methodCompiler.invokeUtilityMethod("fillNil", CodegenUtils.sig(Void.TYPE, IRubyObject[].class, Ruby.class));
            }
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    public void declareLocals(StaticScope scope, Label start2, Label end2) {
        this.method.visitLocalVariable("locals", CodegenUtils.ci(DynamicScope.class), null, start2, end2, this.methodCompiler.getDynamicScopeIndex());
    }

    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        assert (scope != null) : "compiling a class body with no scope";
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.dup();
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
        this.method.astore(this.methodCompiler.getVarsArrayIndex());
        bodyPrep.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (scope.getNumberOfVariables() > 4) {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.methodCompiler.getVarsArrayIndex());
        }
        if (scope.getNumberOfVariables() >= 1) {
            switch (scope.getNumberOfVariables()) {
                case 1: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, false);
                    break;
                }
                case 2: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, false);
                    break;
                }
                case 3: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, false);
                    break;
                }
                case 4: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, true);
                    this.assignLocalVariable(3, false);
                    break;
                }
                default: {
                    this.method.aload(this.methodCompiler.getVarsArrayIndex());
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, true);
                    this.assignLocalVariable(3, false);
                    this.methodCompiler.loadRuntime();
                    this.methodCompiler.invokeUtilityMethod("fillNil", CodegenUtils.sig(Void.TYPE, IRubyObject[].class, Ruby.class));
                }
            }
        }
    }

    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        assert (scope != null) : "compiling a closure body with no scope";
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (scope.getNumberOfVariables() > 4) {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.methodCompiler.getVarsArrayIndex());
        }
        if (scope.getNumberOfVariables() >= 1) {
            switch (scope.getNumberOfVariables()) {
                case 1: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, false);
                    break;
                }
                case 2: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, false);
                    break;
                }
                case 3: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, false);
                    break;
                }
                case 4: {
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, true);
                    this.assignLocalVariable(3, false);
                    break;
                }
                default: {
                    this.method.aload(this.methodCompiler.getVarsArrayIndex());
                    this.methodCompiler.loadNil();
                    this.assignLocalVariable(0, true);
                    this.assignLocalVariable(1, true);
                    this.assignLocalVariable(2, true);
                    this.assignLocalVariable(3, false);
                    this.methodCompiler.loadRuntime();
                    this.methodCompiler.invokeUtilityMethod("fillNil", CodegenUtils.sig(Void.TYPE, IRubyObject[].class, Ruby.class));
                }
            }
        }
        if (argsCallback != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.methodCompiler.getClosureIndex());
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
        }
    }

    public void beginFlatClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        if (scope.getNumberOfVariables() > 4) {
            this.method.aload(this.methodCompiler.getDynamicScopeIndex());
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            this.method.astore(this.methodCompiler.getVarsArrayIndex());
        }
        if (argsCallback != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.methodCompiler.getClosureIndex());
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
        }
    }

    public void assignLocalVariable(int index2, boolean expr) {
        switch (index2) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            default: {
                if (expr) {
                    this.method.dup();
                }
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.swap();
                this.method.pushInt(index2);
                this.method.swap();
                this.method.arraystore();
            }
        }
    }

    public void assignLocalVariable(int index2, CompilerCallback value2, boolean expr) {
        switch (index2) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value2.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value2.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value2.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                value2.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                if (expr) break;
                this.method.pop();
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.pushInt(index2);
                value2.call(this.methodCompiler);
                if (expr) {
                    this.method.dup_x2();
                }
                this.method.arraystore();
            }
        }
    }

    public void assignLocalVariable(int index2, int depth, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, expr);
            return;
        }
        this.assignHeapLocal(depth, index2, expr);
    }

    public void assignLocalVariable(int index2, int depth, CompilerCallback value2, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, value2, expr);
            return;
        }
        this.assignHeapLocal(value2, depth, index2, expr);
    }

    public void retrieveLocalVariable(int index2) {
        switch (index2) {
            case 0: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getVarsArrayIndex());
                this.method.pushInt(index2);
                this.method.arrayload();
            }
        }
    }

    public void retrieveLocalVariable(int index2, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index2);
            return;
        }
        this.retrieveHeapLocal(depth, index2);
    }

    public boolean isHeap() {
        return true;
    }
}

