/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    static final String SLASH = System.getProperty("file.separator");
    private final String name;
    private final String version;
    private final ClassLoader classLoader;
    private boolean loaded;

    public Library(String name2) {
        this(name2, null, null);
    }

    public Library(String name2, Class<?> clazz) {
        this(name2, Library.version(clazz), clazz.getClassLoader());
    }

    public Library(String name2, String version2) {
        this(name2, version2, null);
    }

    public Library(String name2, String version2, ClassLoader classLoader) {
        if (name2 == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name2;
        this.version = version2;
        this.classLoader = classLoader;
    }

    private static String version(Class<?> clazz) {
        try {
            return clazz.getPackage().getImplementationVersion();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getOperatingSystem() {
        String name2 = System.getProperty("os.name").toLowerCase().trim();
        if (name2.startsWith("linux")) {
            return "linux";
        }
        if (name2.startsWith("mac os x")) {
            return "osx";
        }
        if (name2.startsWith("win")) {
            return "windows";
        }
        return name2.replaceAll("\\W+", "_");
    }

    public static String getPlatform() {
        return Library.getOperatingSystem() + Library.getBitModel();
    }

    public static int getBitModel() {
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    public synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.doLoad();
        this.loaded = true;
    }

    private void doLoad() {
        String version2 = System.getProperty("library." + this.name + ".version");
        if (version2 == null) {
            version2 = this.version;
        }
        ArrayList<String> errors2 = new ArrayList<String>();
        String customPath = System.getProperty("library." + this.name + ".path");
        if (customPath != null) {
            if (version2 != null && this.load(errors2, this.file(customPath, this.map(this.name + "-" + version2)))) {
                return;
            }
            if (this.load(errors2, this.file(customPath, this.map(this.name)))) {
                return;
            }
        }
        if (version2 != null && this.load(errors2, this.name + Library.getBitModel() + "-" + version2)) {
            return;
        }
        if (version2 != null && this.load(errors2, this.name + "-" + version2)) {
            return;
        }
        if (this.load(errors2, this.name)) {
            return;
        }
        if (this.classLoader != null) {
            if (this.exractAndLoad(errors2, version2, customPath, this.getPlatformSpecifcResourcePath())) {
                return;
            }
            if (this.exractAndLoad(errors2, version2, customPath, this.getOperatingSystemSpecifcResourcePath())) {
                return;
            }
            if (this.exractAndLoad(errors2, version2, customPath, this.getResorucePath())) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load library. Reasons: " + errors2.toString());
    }

    public final String getOperatingSystemSpecifcResourcePath() {
        return this.getPlatformSpecifcResourcePath(Library.getOperatingSystem());
    }

    public final String getPlatformSpecifcResourcePath() {
        return this.getPlatformSpecifcResourcePath(Library.getPlatform());
    }

    public final String getPlatformSpecifcResourcePath(String platform) {
        return "META-INF/native/" + platform + "/" + this.map(this.name);
    }

    public final String getResorucePath() {
        return "META-INF/native/" + this.map(this.name);
    }

    public final String getLibraryFileName() {
        return this.map(this.name);
    }

    private boolean exractAndLoad(ArrayList<String> errors2, String version2, String customPath, String resourcePath) {
        URL resource2 = this.classLoader.getResource(resourcePath);
        if (resource2 != null) {
            File target;
            String libName = this.name + "-" + Library.getBitModel();
            if (version2 != null) {
                libName = libName + "-" + version2;
            }
            if (customPath != null && this.extract(errors2, resource2, target = this.file(customPath, this.map(libName))) && this.load(errors2, target)) {
                return true;
            }
            customPath = System.getProperty("java.io.tmpdir");
            target = this.file(customPath, this.map(libName));
            if (this.extract(errors2, resource2, target) && this.load(errors2, target)) {
                return true;
            }
        }
        return false;
    }

    private File file(String ... paths) {
        File rc = null;
        for (String path2 : paths) {
            rc = rc == null ? new File(path2) : new File(rc, path2);
        }
        return rc;
    }

    private String map(String libName) {
        String ext2;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext2 = ".dylib")) {
            libName = libName.substring(0, libName.length() - ext2.length()) + ".jnilib";
        }
        return libName;
    }

    private boolean extract(ArrayList<String> errors2, URL source2, File target) {
        FileOutputStream os = null;
        InputStream is = null;
        boolean extracting = false;
        try {
            if ((!target.exists() || this.isStale(source2, target)) && (is = source2.openStream()) != null) {
                int read2;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(target);
                extracting = true;
                while ((read2 = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read2);
                }
                os.close();
                is.close();
                this.chmod("755", target);
            }
        }
        catch (Throwable e) {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (extracting && target.exists()) {
                target.delete();
            }
            errors2.add(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isStale(URL source2, File target) {
        if (source2.getProtocol().equals("jar")) {
            try {
                String[] parts = source2.getFile().split(Pattern.quote("!"));
                source2 = new URL(parts[0]);
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        File sourceFile = null;
        if (source2.getProtocol().equals("file")) {
            sourceFile = new File(source2.getFile());
        }
        return sourceFile != null && sourceFile.exists() && sourceFile.lastModified() > target.lastModified();
    }

    private void chmod(String permision, File path2) {
        if (Library.getPlatform().startsWith("windows")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path2.getCanonicalPath()}).waitFor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean load(ArrayList<String> errors2, File lib) {
        try {
            System.load(lib.getPath());
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errors2.add(e.getMessage());
            return false;
        }
    }

    private boolean load(ArrayList<String> errors2, String lib) {
        try {
            System.loadLibrary(lib);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errors2.add(e.getMessage());
            return false;
        }
    }
}

