/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jruby.cext.GIL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Cleaner
extends WeakReference<Object> {
    private static ReferenceQueue<Object> queue = new ReferenceQueue();
    private static Cleaner list = null;
    private Cleaner prev;
    private Cleaner next;
    private static final Runnable reaper = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object var4_4;
                Reference ref;
                try {
                    ref = queue.remove();
                }
                catch (InterruptedException ex) {
                    break;
                }
                GIL.acquire();
                try {
                    do {
                        if (!(ref instanceof Cleaner)) continue;
                        Cleaner r = (Cleaner)ref;
                        if (r.next != null) {
                            r.next.prev = r.prev;
                        }
                        if (r.prev != null) {
                            r.prev.next = r.next;
                        }
                        if (r == list) {
                            if (list.next != null) {
                                list = list.next;
                            } else {
                                list = list.prev;
                            }
                        }
                        r.prev = (r.next = null);
                        r.dispose();
                        r.clear();
                    } while ((ref = queue.poll()) != null);
                    var4_4 = null;
                }
                catch (Throwable throwable) {
                    var4_4 = null;
                    GIL.releaseNoCleanup();
                    throw throwable;
                }
                GIL.releaseNoCleanup();
            }
        }
    };

    Cleaner(Object obj) {
        super(obj, queue);
    }

    static void register(Cleaner cleaner) {
        if (list != null) {
            cleaner.next = list;
            Cleaner.list.prev = cleaner;
        }
        list = cleaner;
    }

    abstract void dispose();

    static {
        Thread t = new Thread(reaper, "JRuby C extension cleanup thread");
        t.setPriority(10);
        t.setDaemon(true);
        t.start();
    }
}

