/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.util.TraceAbstractVisitor;

public class TraceAnnotationVisitor
extends TraceAbstractVisitor
implements AnnotationVisitor {
    protected AnnotationVisitor av;
    private int valueNumber = 0;

    public void visit(String string2, Object object) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.buf.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int j = 0; j < byArray.length; ++j) {
                    this.appendComa(j);
                    this.visitByte(byArray[j]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int j = 0; j < blArray.length; ++j) {
                    this.appendComa(j);
                    this.visitBoolean(blArray[j]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int j = 0; j < sArray.length; ++j) {
                    this.appendComa(j);
                    this.visitShort(sArray[j]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int j = 0; j < cArray.length; ++j) {
                    this.appendComa(j);
                    this.visitChar(cArray[j]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int j = 0; j < nArray.length; ++j) {
                    this.appendComa(j);
                    this.visitInt(nArray[j]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int j = 0; j < lArray.length; ++j) {
                    this.appendComa(j);
                    this.visitLong(lArray[j]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int j = 0; j < fArray.length; ++j) {
                    this.appendComa(j);
                    this.visitFloat(fArray[j]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int j = 0; j < dArray.length; ++j) {
                    this.appendComa(j);
                    this.visitDouble(dArray[j]);
                }
            }
            this.buf.append('}');
        }
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visit(string2, object);
        }
    }

    private void visitInt(int n) {
        this.buf.append(n);
    }

    private void visitLong(long l) {
        this.buf.append(l).append('L');
    }

    private void visitFloat(float f) {
        this.buf.append(f).append('F');
    }

    private void visitDouble(double d) {
        this.buf.append(d).append('D');
    }

    private void visitChar(char c) {
        this.buf.append("(char)").append((int)c);
    }

    private void visitShort(short s2) {
        this.buf.append("(short)").append(s2);
    }

    private void visitByte(byte by) {
        this.buf.append("(byte)").append(by);
    }

    private void visitBoolean(boolean bl) {
        this.buf.append(bl);
    }

    private void visitString(String string2) {
        TraceAnnotationVisitor.appendString(this.buf, string2);
    }

    private void visitType(Type type2) {
        this.buf.append(type2.getClassName()).append(".class");
    }

    public void visitEnum(String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.appendDescriptor(1, string3);
        this.buf.append('.').append(string4);
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visitEnum(string2, string3, string4);
        }
    }

    public AnnotationVisitor visitAnnotation(String string2, String string3) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, string3);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(")");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitAnnotation(string2, string3);
        }
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitArray(String string2) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("}");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitArray(string2);
        }
        return traceAnnotationVisitor;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void appendComa(int n) {
        if (n != 0) {
            this.buf.append(", ");
        }
    }
}

