/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepresenter {
    protected final Map<Class, Represent> representers = new HashMap<Class, Represent>();
    protected Represent nullRepresenter;
    protected final Map<Class, Represent> multiRepresenters = new LinkedHashMap<Class, Represent>();
    private Character defaultStyle;
    protected Boolean defaultFlowStyle;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>();
    protected final Map<Node, ?> withCheckedTag = new IdentityHashMap();
    protected Object objectToRepresent;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;

    public void represent(Serializer serializer, Object data) throws IOException {
        Node node = this.representData(data);
        serializer.serialize(node);
        this.representedObjects.clear();
        this.withCheckedTag.clear();
        this.objectToRepresent = null;
    }

    protected Node representData(Object data) {
        Node node;
        this.objectToRepresent = data;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            Node node2 = this.representedObjects.get(this.objectToRepresent);
            return node2;
        }
        if (data == null) {
            Node node3 = this.nullRepresenter.representData(data);
            return node3;
        }
        Class<?> clazz = data.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent representer = this.representers.get(clazz);
            node = representer.representData(data);
        } else {
            Represent representer;
            for (Class repr : this.multiRepresenters.keySet()) {
                if (!repr.isInstance(data)) continue;
                Represent representer2 = this.multiRepresenters.get(repr);
                Node node4 = representer2.representData(data);
                return node4;
            }
            if (clazz.isArray()) {
                throw new YAMLException("Arrays of primitives are not fully supported.");
            }
            if (this.multiRepresenters.containsKey(null)) {
                representer = this.multiRepresenters.get(null);
                node = representer.representData(data);
            } else {
                representer = this.representers.get(null);
                node = representer.representData(data);
            }
        }
        return node;
    }

    protected Node representScalar(Tag tag2, String value2, Character style) {
        if (style == null) {
            style = this.defaultStyle;
        }
        ScalarNode node = new ScalarNode(tag2, value2, null, null, style);
        return node;
    }

    protected Node representScalar(Tag tag2, String value2) {
        return this.representScalar(tag2, value2, null);
    }

    protected Node representSequence(Tag tag2, Iterable<? extends Object> sequence, Boolean flowStyle) {
        int size2 = 10;
        if (sequence instanceof List) {
            size2 = ((List)sequence).size();
        }
        ArrayList<Node> value2 = new ArrayList<Node>(size2);
        SequenceNode node = new SequenceNode(tag2, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Object object : sequence) {
            Node nodeItem = this.representData(object);
            if (!(nodeItem instanceof ScalarNode) || ((ScalarNode)nodeItem).getStyle() != null) {
                bestStyle = false;
            }
            value2.add(nodeItem);
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected Node representMapping(Tag tag2, Map<? extends Object, Object> mapping, Boolean flowStyle) {
        ArrayList<NodeTuple> value2 = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag2, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Object object : mapping.keySet()) {
            Object itemValue = mapping.get(object);
            Node nodeKey = this.representData(object);
            Node nodeValue = this.representData(itemValue);
            if (!(nodeKey instanceof ScalarNode) || ((ScalarNode)nodeKey).getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value2.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (flowStyle == null) {
            if (this.defaultFlowStyle != null) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    public void setDefaultScalarStyle(DumperOptions.ScalarStyle defaultStyle) {
        this.defaultStyle = defaultStyle.getChar();
    }

    public void setDefaultFlowStyle(DumperOptions.FlowStyle defaultFlowStyle) {
        this.defaultFlowStyle = defaultFlowStyle.getStyleBoolean();
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        this.explicitPropertyUtils = true;
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }
}

