/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ASTInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject INTERPRET_METHOD(Ruby runtime2, ThreadContext context, String file2, int line, RubyModule implClass, Node node, String name2, IRubyObject self, Block block, boolean isTraceable) {
        IRubyObject iRubyObject;
        block7: {
            try {
                String className = implClass.getName();
                ThreadContext.pushBacktrace(context, className, name2, file2, line);
                if (isTraceable) {
                    ASTInterpreter.methodPreTrace(runtime2, context, name2, implClass);
                }
                iRubyObject = node.interpret(runtime2, context, self, block);
                Object var13_12 = null;
                if (!isTraceable) break block7;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (isTraceable) {
                    try {
                        ASTInterpreter.methodPostTrace(runtime2, context, name2, implClass);
                        Object var15_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_17 = null;
                        ThreadContext.popBacktrace(context);
                        throw throwable2;
                    }
                    ThreadContext.popBacktrace(context);
                    {
                        throw throwable;
                    }
                }
                ThreadContext.popBacktrace(context);
                throw throwable;
            }
            try {
                ASTInterpreter.methodPostTrace(runtime2, context, name2, implClass);
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                ThreadContext.popBacktrace(context);
                throw throwable;
            }
            ThreadContext.popBacktrace(context);
            return iRubyObject;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime2, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, self.getMetaClass().getName(), name2, node.getPosition());
            iRubyObject = node.interpret(runtime2, context, self, block);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime2, ThreadContext context, String file2, int line, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, self.getMetaClass().getName(), name2, file2, line);
            iRubyObject = node.interpret(runtime2, context, self, block);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_CLASS(Ruby runtime2, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, self.getMetaClass().getName(), name2, node.getPosition());
            iRubyObject = node.interpret(runtime2, context, self, block);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(Ruby runtime2, ThreadContext context, String file2, int line, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, self.getMetaClass().getName(), name2, file2, line);
            iRubyObject = node.interpret(runtime2, context, self, block);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        try {
            ThreadContext.pushBacktrace(context, self.getMetaClass().getName(), "(root)", node.getPosition());
            iRubyObject = node.interpret(runtime2, context, self, block);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ThreadContext.popBacktrace(context);
            throw throwable;
        }
        ThreadContext.popBacktrace(context);
        return iRubyObject;
    }

    private static void methodPreTrace(Ruby runtime2, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime2.hasEventHooks()) {
            context.trace(RubyEvent.CALL, name2, implClass);
        }
    }

    private static void methodPostTrace(Ruby runtime2, ThreadContext context, String name2, RubyModule implClass) {
        if (runtime2.hasEventHooks()) {
            context.trace(RubyEvent.RETURN, name2, implClass);
        }
    }

    @Deprecated
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, Binding binding2) {
        return ASTInterpreter.evalWithBinding(context, binding2.getSelf(), src, binding2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self, IRubyObject src, Binding binding2) {
        Ruby runtime2 = src.getRuntime();
        DynamicScope evalScope = binding2.getDynamicScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject;
            try {
                RubyString source2 = src.convertToString();
                Node node = runtime2.parseEval(source2.getByteList(), binding2.getFile(), evalScope, binding2.getLine());
                iRubyObject = ASTInterpreter.INTERPRET_EVAL(runtime2, context, binding2.getFile(), binding2.getLine(), node, binding2.getMethod(), self, binding2.getFrame().getBlock());
                Object var11_13 = null;
            }
            catch (JumpException.BreakJump bj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            catch (JumpException.RedoJump rj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, (IRubyObject)rj.getValue(), "unexpected redo");
            }
            catch (StackOverflowError soe) {
                throw runtime2.newSystemStackError("stack level too deep", soe);
            }
            context.postEvalWithBinding(binding2, lastFrame);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            context.postEvalWithBinding(binding2, lastFrame);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file2, int lineNumber) {
        assert (file2 != null);
        Ruby runtime2 = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        RubyString source2 = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        try {
            IRubyObject iRubyObject;
            try {
                Node node = runtime2.parseEval(source2.getByteList(), file2, evalScope, lineNumber);
                iRubyObject = ASTInterpreter.INTERPRET_EVAL(runtime2, context, file2, lineNumber, node, "(eval)", self, Block.NULL_BLOCK);
                Object var13_14 = null;
            }
            catch (JumpException.BreakJump bj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            catch (StackOverflowError soe) {
                throw runtime2.newSystemStackError("stack level too deep", soe);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            context.setFile(savedFile);
            context.setLine(savedLine);
            throw throwable;
        }
    }

    public static void callTraceFunction(Ruby runtime2, ThreadContext context, RubyEvent event) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        runtime2.callEventHooks(context, event, context.getFile(), context.getLine(), name2, type2);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime2, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i2 = 0; i2 < node.size(); ++i2) {
            array[i2] = node.get(i2).interpret(runtime2, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime2, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime2, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime2, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type2, IRubyObject self, Block block) {
        block12: {
            IRubyObject iRubyObject;
            context.preClassEval(scope, type2);
            try {
                if (runtime2.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.CLASS);
                }
                if (bodyNode != null) break block12;
                iRubyObject = runtime2.getNil();
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (runtime2.hasEventHooks()) {
                        ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
                    }
                    Object var12_16 = null;
                    context.postClassEval();
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    context.postClassEval();
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                if (runtime2.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
                }
                Object var12_12 = null;
                context.postClassEval();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                context.postClassEval();
                throw throwable;
            }
            return iRubyObject;
        }
        String name2 = type2.getBaseName();
        if (name2 == null) {
            name2 = type2.isSingleton() ? "__singleton__" : (type2.isModule() ? "<anonymous module>" : "<anonymous class>");
        }
        IRubyObject iRubyObject = ASTInterpreter.INTERPRET_CLASS(runtime2, context, bodyNode, name2, type2, block);
        Object var10_10 = null;
        try {
            if (runtime2.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
            }
            Object var12_14 = null;
            context.postClassEval();
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            context.postClassEval();
            throw throwable;
        }
        return iRubyObject;
    }

    public static ByteList getArgumentDefinition(Ruby runtime2, ThreadContext context, Node node, ByteList type2, IRubyObject self, Block block) {
        if (node == null) {
            return type2;
        }
        if (node instanceof ArrayNode) {
            ArrayNode list2 = (ArrayNode)node;
            int size2 = list2.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                if (list2.get(i2).definition(runtime2, context, self, block) != null) continue;
                return null;
            }
        } else if (node.definition(runtime2, context, self, block) == null) {
            return null;
        }
        return type2;
    }

    public static Block getBlock(Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(blockNode, context, self);
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime2, context, self, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc2 = bodyNode == null ? runtime2.getNil() : bodyNode.interpret(runtime2, context, self, currentBlock);
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2, currentBlock);
    }

    private static Block getIterNodeBlock(Node blockNode, ThreadContext context, IRubyObject self) {
        IterNode iterNode = (IterNode)blockNode;
        StaticScope scope = iterNode.getScope();
        scope.determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime2) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        while (rubyClass.isSingleton() || rubyClass == runtime2.getDummy()) {
            if (scope == null) {
                return null;
            }
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime2.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method");
        }
        return rubyClass;
    }

    public static IRubyObject[] setupArgs(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size2 = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                argsArray[i2] = argsArrayNode.get(i2).interpret(runtime2, context, self, aBlock);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime2, context, self, aBlock));
    }
}

