/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.targets;

import com.kenai.constantine.Constant;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyObject;
import org.jruby.compiler.ir.CompilerTarget;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.instructions.BEQInstr;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.DefineClassMethodInstr;
import org.jruby.compiler.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.compiler.ir.instructions.GetFieldInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.JumpInstr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.instructions.PutFieldInstr;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.operands.FieldRef;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.GeneratorAdapter;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.util.CodegenUtils;

public class JVM
implements CompilerTarget {
    private static final boolean DEBUG = true;
    Stack<ClassData> clsStack = new Stack();
    List<ClassData> clsAccum = new ArrayList<ClassData>();
    IRScript script;

    public ClassVisitor cls() {
        return this.clsData().cls;
    }

    public ClassData clsData() {
        return this.clsStack.peek();
    }

    public void pushclass() {
        PrintWriter pw = new PrintWriter(System.out);
        this.clsStack.push(new ClassData(new TraceClassVisitor(new ClassWriter(3), pw)));
        pw.flush();
    }

    public void popclass() {
        this.clsStack.pop();
    }

    public GeneratorAdapter method() {
        return this.clsData().method();
    }

    public void pushmethod(String name2) {
        this.clsData().pushmethod(name2);
    }

    public void popmethod() {
        this.clsData().popmethod();
    }

    public void codegen(IRScope scope) {
        if (scope instanceof IRScript) {
            this.codegen((IRScript)scope);
        }
    }

    public void codegen(IRScript script) {
        this.script = script;
        this.emit(script.getRootClass());
    }

    public void emit(IRClass cls) {
        this.pushclass();
        this.cls().visit(RubyInstanceConfig.JAVA_VERSION, 33, cls.getName(), null, CodegenUtils.p(RubyObject.class), null);
        this.cls().visitSource(this.script.getFileName().toString(), null);
        this.pushmethod("__class__");
        for (Instr instr : cls.getInstrs()) {
            this.emit(instr);
        }
        this.popmethod();
        for (IRMethod method2 : cls.getMethods()) {
            this.emit(method2);
        }
        for (IRClass cls2 : cls.getClasses()) {
            this.emit(cls2);
        }
        this.cls().visitEnd();
        this.popclass();
    }

    public void emit(IRMethod method2) {
        this.pushmethod(method2.getName());
        for (Instr instr : method2.getInstrs()) {
            this.emit(instr);
        }
        this.popmethod();
    }

    public void emit(Instr instr) {
        switch (instr.operation) {
            case BEQ: {
                this.emitBEQ((BEQInstr)instr);
                break;
            }
            case CALL: {
                this.emitCALL((CallInstr)instr);
                break;
            }
            case COPY: {
                this.emitCOPY((CopyInstr)instr);
                break;
            }
            case DEF_INST_METH: {
                this.emitDEF_INST_METH((DefineInstanceMethodInstr)instr);
                break;
            }
            case JUMP: {
                this.emitJUMP((JumpInstr)instr);
                break;
            }
            case LABEL: {
                this.emitLABEL((LABEL_Instr)instr);
                break;
            }
            case PUT_FIELD: {
                this.emitPUT_FIELD((PutFieldInstr)instr);
                break;
            }
            case GET_FIELD: {
                this.emitGET_FIELD((GetFieldInstr)instr);
                break;
            }
            case RECV_ARG: {
                this.emitRECV_ARG((ReceiveArgumentInstruction)instr);
                break;
            }
            case RETURN: {
                this.emitRETURN((ReturnInstr)instr);
                break;
            }
            default: {
                System.err.println("unsupported: " + (Object)((Object)instr.operation));
            }
        }
    }

    public void emit(Constant constant) {
        if (constant instanceof Fixnum) {
            this.method().push(((Fixnum)((Object)constant)).value);
        }
    }

    public void emit(Operand operand) {
        if (operand.isConstant()) {
            this.emit((Constant)((Object)operand));
        } else if (operand instanceof Variable) {
            this.emit((Variable)operand);
        }
    }

    public void emit(Variable variable) {
        int index2 = this.getVariableIndex(variable);
        this.method().loadLocal(index2);
    }

    public void emitBEQ(BEQInstr beq) {
        Operand[] args2 = beq.getOperands();
        this.emit(args2[0]);
        this.emit(args2[1]);
        this.method().ifCmp(Type.getType(Object.class), 153, this.getLabel(beq.getJumpTarget()));
    }

    public void emitCOPY(CopyInstr copy) {
        int index2 = this.getVariableIndex(copy.result);
        this.emit(copy.getOperands()[0]);
        this.method().storeLocal(index2);
    }

    public void emitCALL(CallInstr call2) {
        this.emit(call2.getReceiver());
        for (Operand operand : call2.getCallArgs()) {
            this.emit(operand);
        }
        this.method().invokeVirtual(Type.getType(Object.class), Method.getMethod("Object " + call2.getMethodAddr() + " ()"));
    }

    public void emitDEF_INST_METH(DefineInstanceMethodInstr instr) {
        IRMethod irMethod = instr.method;
        GeneratorAdapter adapter = new GeneratorAdapter(1, Method.getMethod("void " + irMethod.getName() + " ()"), null, null, this.cls());
        adapter.loadThis();
        adapter.loadArgs();
        adapter.invokeStatic(Type.getType(Object.class), Method.getMethod("Object __ruby__" + irMethod.getName() + " (Object)"));
        adapter.returnValue();
        adapter.endMethod();
    }

    public void emitDEF_CLS_METH(DefineClassMethodInstr instr) {
        IRMethod irMethod = instr.method;
        GeneratorAdapter adapter = new GeneratorAdapter(9, Method.getMethod("void " + irMethod.getName() + " ()"), null, null, this.cls());
        adapter.returnValue();
        adapter.endMethod();
    }

    public void emitJUMP(JumpInstr jump) {
        this.method().goTo(this.getLabel(jump.target));
    }

    public void emitLABEL(LABEL_Instr lbl) {
        this.method().mark(this.getLabel(lbl._lbl));
    }

    public void emitPUT_FIELD(PutFieldInstr putField) {
        String field2 = ((FieldRef)putField.getOperands()[1]).getName();
        this.declareField(field2);
        this.emit(putField.getOperands()[0]);
        this.emit(putField.getOperands()[2]);
        this.method().putField(Type.getType(Object.class), field2, Type.getType(Object.class));
    }

    public void emitGET_FIELD(GetFieldInstr putField) {
        String field2 = ((FieldRef)putField.getOperands()[1]).getName();
        this.declareField(field2);
        this.emit(putField.getOperands()[0]);
        this.method().getField(Type.getType(Object.class), field2, Type.getType(Object.class));
    }

    public void emitRETURN(ReturnInstr ret) {
        this.emit(ret.getOperands()[0]);
        this.method().returnValue();
    }

    public void emitRECV_ARG(ReceiveArgumentInstruction recvArg) {
        int index2 = this.getVariableIndex(recvArg.result);
    }

    private int getVariableIndex(Variable variable) {
        Integer index2 = this.clsStack.peek().methodStack.peek().varMap.get(variable);
        if (index2 == null) {
            index2 = this.method().newLocal(Type.getType(Object.class));
            this.clsStack.peek().methodStack.peek().varMap.put(variable, index2);
        }
        return index2;
    }

    private org.jruby.org.objectweb.asm.Label getLabel(Label label) {
        org.jruby.org.objectweb.asm.Label asmLabel = this.clsData().methodData().labelMap.get(label);
        if (asmLabel == null) {
            asmLabel = this.method().newLabel();
            this.clsData().methodData().labelMap.put(label, asmLabel);
        }
        return asmLabel;
    }

    private void declareField(String field2) {
        if (!this.clsData().fieldSet.contains(field2)) {
            this.cls().visitField(4, field2, CodegenUtils.ci(Object.class), null, null);
            this.clsData().fieldSet.add(field2);
        }
    }

    private static class MethodData {
        public GeneratorAdapter method;
        public Map<Variable, Integer> varMap = new HashMap<Variable, Integer>();
        public Map<Label, org.jruby.org.objectweb.asm.Label> labelMap = new HashMap<Label, org.jruby.org.objectweb.asm.Label>();

        public MethodData(GeneratorAdapter method2) {
            this.method = method2;
        }
    }

    private static class ClassData {
        public ClassVisitor cls;
        Stack<MethodData> methodStack = new Stack();
        public Set<String> fieldSet = new HashSet<String>();

        public ClassData(ClassVisitor cls) {
            this.cls = cls;
        }

        public GeneratorAdapter method() {
            return this.methodData().method;
        }

        public MethodData methodData() {
            return this.methodStack.peek();
        }

        public void pushmethod(String name2) {
            this.methodStack.push(new MethodData(new GeneratorAdapter(9, Method.getMethod("org.jruby.runtime.builtin.IRubyObject " + name2 + " (org.jruby.runtime.ThreadContext, org.jruby.runtime.builtin.IRubyObject)"), null, null, this.cls)));
        }

        public void popmethod() {
            this.method().endMethod();
            this.methodStack.pop();
        }
    }
}

