/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.interpreter;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.compiler.ir.IRBuilder;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InlineMethodHint;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Interpreter {
    private static boolean debug = Boolean.parseBoolean(System.getProperty("jruby.ir.debug", "false"));
    private static int interpInstrsCount = 0;

    public static IRubyObject interpret(Ruby runtime2, Node rootNode, IRubyObject self) {
        IRScope scope = new IRBuilder().buildRoot((RootNode)rootNode);
        scope.prepareForInterpretation();
        return Interpreter.interpretTop(runtime2, scope, self);
    }

    public static IRubyObject interpretTop(Ruby runtime2, IRScope scope, IRubyObject self) {
        assert (scope instanceof IRScript) : "Must be an IRScript scope at Top!!!";
        IRScript root = (IRScript)scope;
        if (root.getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime2.getObject());
        }
        IRMethod rootMethod = root.getRootClass().getRootMethod();
        RubyClass metaclass = self.getMetaClass();
        InterpretedIRMethod method2 = new InterpretedIRMethod(rootMethod, metaclass);
        IRubyObject rv = method2.call(runtime2.getCurrentContext(), self, (RubyModule)metaclass, "", new IRubyObject[0]);
        if (debug) {
            System.out.println("-- Interpreted " + interpInstrsCount + " instructions");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject interpret(ThreadContext context, CFG cfg, InterpreterContext interp) {
        IRubyObject iRubyObject;
        boolean inClosure = cfg.getScope() instanceof IRClosure;
        try {
            interp.setMethodExitLabel(cfg.getExitBB().getLabel());
            IRubyObject self = (IRubyObject)interp.getSelf();
            Instr[] instrs = cfg.prepareForInterpretation();
            int n = instrs.length;
            int ipc = 0;
            Instr lastInstr = null;
            while (ipc < n) {
                Label jumpTarget;
                ++interpInstrsCount;
                lastInstr = instrs[ipc];
                if (debug) {
                    System.out.println("EXEC'ing: " + lastInstr);
                }
                ipc = (jumpTarget = lastInstr.interpret(interp, self)) == null ? ipc + 1 : jumpTarget.getTargetPC();
            }
            IRubyObject rv = (IRubyObject)interp.getReturnValue();
            if (lastInstr instanceof ReturnInstr) {
                if (inClosure) {
                    throw RuntimeHelpers.returnJump(rv, context);
                }
            } else if (lastInstr instanceof BREAK_Instr) {
                if (inClosure) {
                    RuntimeHelpers.breakJump(context, rv);
                } else {
                    throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.BREAK, rv, "unexpected break");
                }
            }
            iRubyObject = rv;
            Object var12_13 = null;
        }
        catch (JumpException.ReturnJump rj) {
            try {
                if (inClosure) {
                    throw rj;
                }
                IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                Object var12_14 = null;
                if (interp.getFrame() != null) {
                    context.popFrame();
                    interp.setFrame(null);
                }
                if (interp.hasAllocatedDynamicScope()) {
                    context.postMethodScopeOnly();
                }
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var12_15 = null;
                    if (interp.getFrame() != null) {
                        context.popFrame();
                        interp.setFrame(null);
                    }
                    if (!interp.hasAllocatedDynamicScope()) break block18;
                    context.postMethodScopeOnly();
                }
                throw throwable;
            }
        }
        if (interp.getFrame() != null) {
            context.popFrame();
            interp.setFrame(null);
        }
        if (interp.hasAllocatedDynamicScope()) {
            context.postMethodScopeOnly();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject interpret_with_inline(ThreadContext context, CFG cfg, InterpreterContext interp) {
        try {
            BasicBlock basicBlock = cfg.getEntryBB();
            Instr skipTillInstr = null;
            while (basicBlock != null) {
                Label jumpTarget = null;
                Instr prev = null;
                for (Instr instruction : basicBlock.getInstrs()) {
                    if (skipTillInstr != null && instruction != skipTillInstr) continue;
                    skipTillInstr = null;
                    if (debug) {
                        System.out.println("EXEC'ing: " + instruction);
                    }
                    ++interpInstrsCount;
                    try {
                        jumpTarget = instruction.interpret(interp, (IRubyObject)interp.getSelf());
                    }
                    catch (InlineMethodHint ih) {
                        if ("array_each".equals(ih.inlineableMethod.getName())) {
                            System.out.println("Got inline method hint for: " + ih.inlineableMethod.getFullyQualifiedName() + ". inlining!");
                            cfg.inlineMethod(ih.inlineableMethod, basicBlock, (CallInstr)instruction);
                            interp.updateRenamedVariablesCount(cfg.getScope().getRenamedVariableSize());
                            skipTillInstr = prev;
                            if (!debug) break;
                            System.out.println("--------------------");
                            System.out.println("\nGraph:\n" + cfg.getGraph().toString());
                            System.out.println("\nInstructions:\n" + cfg.toStringInstrs());
                            System.out.println("--------------------");
                            break;
                        }
                        jumpTarget = instruction.interpret(interp, (IRubyObject)interp.getSelf());
                    }
                    prev = instruction;
                }
                if (skipTillInstr != null) continue;
                basicBlock = jumpTarget == null ? cfg.getFallThroughBB(basicBlock) : cfg.getTargetBB(jumpTarget);
            }
            IRubyObject iRubyObject = (IRubyObject)interp.getReturnValue();
            Object var11_10 = null;
            if (interp.getFrame() != null) {
                context.popFrame();
                interp.setFrame(null);
            }
            if (interp.hasAllocatedDynamicScope()) {
                context.postMethodScopeOnly();
            }
            return iRubyObject;
        }
        catch (Throwable throwable) {
            block11: {
                Object var11_11 = null;
                if (interp.getFrame() != null) {
                    context.popFrame();
                    interp.setFrame(null);
                }
                if (!interp.hasAllocatedDynamicScope()) break block11;
                context.postMethodScopeOnly();
            }
            throw throwable;
        }
    }
}

