/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.interpreter.Interpreter;
import org.jruby.interpreter.NaiveInterpreterContext;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRMethod
extends DynamicMethod {
    public final IRMethod method;
    private final int temporaryVariableSize;

    public InterpretedIRMethod(IRMethod method2, RubyModule implementationClass) {
        super(implementationClass, Visibility.PRIVATE, CallConfiguration.FrameNoneScopeNone);
        this.temporaryVariableSize = method2.getTemporaryVariableSize();
        this.method = method2;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        NaiveInterpreterContext interp = new NaiveInterpreterContext(context, self, this.method.getLocalVariablesCount(), this.temporaryVariableSize, this.method.getRenamedVariableSize(), args2, block);
        CFG c = this.method.getCFG();
        if (c == null) {
            this.method.prepareForInterpretation();
            c = this.method.getCFG();
        }
        return Interpreter.interpret(context, c, interp);
    }

    public DynamicMethod dup() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

