/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.DNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class DRegexpNode
extends DNode
implements ILiteralNode {
    private final RegexpOptions options;
    private RubyRegexp onceRegexp;
    private boolean is19;

    public DRegexpNode(ISourcePosition position, RegexpOptions options2) {
        this(position, options2, false);
    }

    public DRegexpNode(ISourcePosition position, RegexpOptions options2, boolean is19) {
        super(position, (Encoding)null);
        this.options = options2;
        this.is19 = is19;
    }

    public NodeType getNodeType() {
        return NodeType.DREGEXPNODE;
    }

    protected RubyString allocateString(Ruby runtime2) {
        return runtime2.newString(new ByteList());
    }

    public boolean is19() {
        return this.is19;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.options.isOnce();
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.getOnce() && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string2 = (RubyString)super.interpret(runtime2, context, self, aBlock);
        RubyRegexp regexp2 = RubyRegexp.newDRegexp(runtime2, string2, this.options);
        if (this.getOnce() && this.onceRegexp == null) {
            this.onceRegexp = regexp2;
        }
        return regexp2;
    }
}

