/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveComparator {
    public static IRubyObject compare(ThreadContext context, String method2, IRubyObject a, IRubyObject b, Set<Pair> seen) {
        Ruby runtime2 = context.getRuntime();
        if (a == b) {
            return runtime2.getTrue();
        }
        if (a instanceof RubyHash && b instanceof RubyHash || a instanceof RubyArray && b instanceof RubyArray) {
            Pair pair = new Pair(a, b);
            if (seen == null) {
                seen = new HashSet<Pair>();
            } else if (seen.contains(pair)) {
                return runtime2.getTrue();
            }
            seen.add(pair);
        }
        if (a instanceof RubyHash) {
            RubyHash hash2 = (RubyHash)a;
            return hash2.compare(context, method2, b, seen);
        }
        if (a instanceof RubyArray) {
            RubyArray array = (RubyArray)a;
            return array.compare(context, method2, b, seen);
        }
        return a.callMethod(context, method2, b);
    }

    public static class Pair {
        private int a;
        private int b;

        public Pair(IRubyObject a, IRubyObject b) {
            this.a = System.identityHashCode(a);
            this.b = System.identityHashCode(b);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)other;
            return this.a == pair.a && this.b == pair.b;
        }

        public int hashCode() {
            int result = this.a;
            result = 31 * result + this.b;
            return result;
        }
    }
}

