/*
 * Decompiled with CFR 0.152.
 */
package org.yecht;

import java.io.IOException;
import org.yecht.BytecodeScanner;
import org.yecht.Data;
import org.yecht.DefaultYAMLParser;
import org.yecht.ErrorHandler;
import org.yecht.ImplicitScanner2;
import org.yecht.Level;
import org.yecht.LevelStatus;
import org.yecht.Node;
import org.yecht.Parser;
import org.yecht.Pointer;
import org.yecht.ScalarStyle;
import org.yecht.YAML;

public class TokenScanner
implements DefaultYAMLParser.yyInput {
    public static final int QUOTELEN = 1024;
    private Parser parser;
    private Object lval;
    private int currentToken = -1;
    public static final String[] tnames;
    private static final boolean[] YWORDC;
    private static final boolean[] DIGIT_OR_SIGN;

    public static void error(String msg, Parser parser) {
        if (parser.error_handler == null) {
            parser.error_handler = new ErrorHandler.Default();
        }
        parser.root = parser.root_on_error;
        parser.error_handler.handle(parser, msg);
    }

    public static DefaultYAMLParser.yyInput createScanner(Parser parser) {
        switch (parser.input_type) {
            case YAML_UTF8: {
                return new TokenScanner(parser);
            }
            case Bytecode_UTF8: {
                return new BytecodeScanner(parser);
            }
            case YAML_UTF16: {
                TokenScanner.error("UTF-16 is not currently supported in Yecht.\nPlease contribute code to help this happen!", parser);
                return null;
            }
            case YAML_UTF32: {
                TokenScanner.error("UTF-32 is not currently supported in Yecht.\nPlease contribute code to help this happen!", parser);
                return null;
            }
        }
        return null;
    }

    public TokenScanner(Parser parser) {
        this.parser = parser;
    }

    public Object value() {
        return this.lval;
    }

    public int token() {
        return this.currentToken;
    }

    public boolean advance() throws IOException {
        this.currentToken = this.real_yylex();
        return this.currentToken != 0;
    }

    private int isNewline(int ptr) {
        return this.newlineLen(ptr);
    }

    private int newlineLen(int ptr) {
        if (this.parser.buffer.buffer[ptr] == 10) {
            return 1;
        }
        if (this.parser.buffer.buffer[ptr] == 13 && this.parser.buffer.buffer[ptr + 1] == 10) {
            return 2;
        }
        return 0;
    }

    private int isNewline(byte[] buff, int ptr) {
        return this.newlineLen(buff, ptr);
    }

    private int newlineLen(byte[] buff, int ptr) {
        if (buff[ptr] == 10) {
            return 1;
        }
        if (buff[ptr] == 13 && buff[ptr + 1] == 10) {
            return 2;
        }
        return 0;
    }

    private void NEWLINE(int ptr) {
        this.parser.lineptr = ptr + this.newlineLen(ptr);
        if (this.parser.lineptr > this.parser.linectptr) {
            ++this.parser.linect;
            this.parser.linectptr = this.parser.lineptr;
        }
    }

    private void RETURN_YAML_BLOCK(QuotedString q, int blockType, int nlDoWhat) {
        Node n = Node.allocStr();
        n.type_id = this.parser.taguri_expansion ? Parser.taguri("yaml.org,2002", "str") : "str";
        Data.Str dd = (Data.Str)n.data;
        dd.ptr = Pointer.create(q.str, 0);
        dd.len = q.idx;
        dd.style = blockType == 20 ? ScalarStyle.Literal : ScalarStyle.Fold;
        if (q.idx > 0 && nlDoWhat != 50) {
            int fc = dd.len - 1;
            while (this.isNewline(dd.ptr.buffer, fc) > 0) {
                --fc;
            }
            if (nlDoWhat != 40 && fc < dd.len - 1) {
                ++fc;
            }
            dd.len = fc + 1;
        }
        this.lval = n;
    }

    private int GET_TRUE_YAML_INDENT() {
        Level lvl_deep = this.parser.currentLevel();
        int indt_len = lvl_deep.spaces;
        if (lvl_deep.status == LevelStatus.seq || indt_len == this.parser.cursor - this.parser.lineptr && lvl_deep.status != LevelStatus.map) {
            --this.parser.lvl_idx;
            Level lvl_over = this.parser.currentLevel();
            indt_len = lvl_over.spaces;
            ++this.parser.lvl_idx;
        }
        return indt_len;
    }

    private void YYPOS(int n) {
        this.parser.cursor = this.parser.token + n;
    }

    public void RETURN_IMPLICIT(QuotedString q) {
        Node n = Node.allocStr();
        this.parser.cursor = this.parser.token;
        Data.Str dd = (Data.Str)n.data;
        dd.ptr = Pointer.create(q.str, 0);
        dd.len = q.idx;
        dd.style = ScalarStyle.Plain;
        this.lval = n;
        if (this.parser.implicit_typing) {
            ImplicitScanner2.tryTagImplicit(n, this.parser.taguri_expansion);
        }
    }

    private int real_yylex() throws IOException {
        if (this.parser.cursor == -1) {
            this.parser.read();
        }
        if (this.parser.force_token != 0) {
            int t = this.parser.force_token;
            this.parser.force_token = 0;
            return t;
        }
        if (this.parser.lineptr != this.parser.cursor) {
            return this.document(0);
        }
        return this.header();
    }

    private int header() throws IOException {
        int doc_level = 0;
        block88: while (true) {
            this.parser.token = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            boolean yyaccept = false;
            while (true) {
                if (gotoPoint == -2) continue block88;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 5) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 7;
                                break;
                            }
                            case 9: 
                            case 32: {
                                gotoPoint = 12;
                                break;
                            }
                            case 10: {
                                gotoPoint = 9;
                                break;
                            }
                            case 13: {
                                gotoPoint = 11;
                                break;
                            }
                            case 35: {
                                gotoPoint = 5;
                                break;
                            }
                            case 45: {
                                gotoPoint = 2;
                                break;
                            }
                            case 46: {
                                gotoPoint = 4;
                                break;
                            }
                            default: {
                                gotoPoint = 14;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 45: {
                                gotoPoint = 28;
                                break;
                            }
                            default: {
                                gotoPoint = 3;
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        this.YYPOS(0);
                        return this.document(doc_level);
                    }
                    case 4: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 46: {
                                gotoPoint = 21;
                                break;
                            }
                            default: {
                                gotoPoint = 3;
                                break;
                            }
                        }
                        break;
                    }
                    case 5: {
                        ++this.parser.cursor;
                        this.eatComments();
                        break;
                    }
                    case 7: {
                        ++this.parser.cursor;
                        Level lvl = this.parser.currentLevel();
                        if (lvl.spaces > -1) {
                            this.parser.popLevel();
                            this.YYPOS(0);
                            return 268;
                        }
                        this.YYPOS(0);
                        return 0;
                    }
                    case 9: {
                        yyaccept = true;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 18;
                        break;
                    }
                    case 10: {
                        int indent = this.parser.token;
                        this.NEWLINE(indent);
                        while (indent < this.parser.cursor) {
                            if (this.isNewline(++indent) == 0) continue;
                            this.NEWLINE(indent);
                        }
                        doc_level = 0;
                        if (this.parser.buffer.buffer[this.parser.cursor] == 0) {
                            doc_level = -1;
                            this.parser.token = this.parser.cursor - 1;
                            break;
                        }
                        if (this.parser.buffer.buffer[this.parser.lineptr] != 32) break;
                        doc_level = this.parser.cursor - this.parser.lineptr;
                        break;
                    }
                    case 11: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 17;
                                break;
                            }
                            default: {
                                gotoPoint = 3;
                                break;
                            }
                        }
                        break;
                    }
                    case 12: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 16;
                        break;
                    }
                    case 13: {
                        doc_level = this.parser.cursor - this.parser.lineptr;
                        break;
                    }
                    case 14: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 3;
                        break;
                    }
                    case 15: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 16: {
                        switch (yych) {
                            case 9: 
                            case 32: {
                                gotoPoint = 15;
                                break;
                            }
                            default: {
                                gotoPoint = 13;
                                break;
                            }
                        }
                        break;
                    }
                    case 17: {
                        yyaccept = true;
                        this.parser.marker = ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 18: {
                        switch (yych) {
                            case 10: 
                            case 32: {
                                gotoPoint = 17;
                                break;
                            }
                            case 13: {
                                gotoPoint = 19;
                                break;
                            }
                            default: {
                                gotoPoint = 10;
                                break;
                            }
                        }
                        break;
                    }
                    case 19: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 17;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 20: {
                        this.parser.cursor = this.parser.marker;
                        if (!yyaccept) {
                            gotoPoint = 3;
                            break;
                        }
                        gotoPoint = 10;
                        break;
                    }
                    case 21: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 46: {
                                gotoPoint = 22;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 22: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 23;
                                break;
                            }
                            case 13: {
                                gotoPoint = 27;
                                break;
                            }
                            case 32: {
                                gotoPoint = 25;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 23: {
                        ++this.parser.cursor;
                    }
                    case 24: {
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status == LevelStatus.header) break;
                        if (lvl.spaces > -1) {
                            this.parser.popLevel();
                            this.YYPOS(0);
                            return 268;
                        }
                        this.YYPOS(0);
                        return 0;
                    }
                    case 25: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 32: {
                                gotoPoint = 25;
                                break;
                            }
                            default: {
                                gotoPoint = 24;
                                break;
                            }
                        }
                        break;
                    }
                    case 27: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 23;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 28: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 45: {
                                gotoPoint = 29;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 29: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 30;
                                break;
                            }
                            case 13: {
                                gotoPoint = 34;
                                break;
                            }
                            case 32: {
                                gotoPoint = 32;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                    case 30: {
                        ++this.parser.cursor;
                    }
                    case 31: {
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status == LevelStatus.header) {
                            this.YYPOS(3);
                            return this.directive();
                        }
                        if (lvl.spaces > -1) {
                            this.parser.popLevel();
                            this.YYPOS(0);
                            return 268;
                        }
                        this.YYPOS(0);
                        return 0;
                    }
                    case 32: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 32: {
                                gotoPoint = 32;
                                break;
                            }
                            default: {
                                gotoPoint = 31;
                                break;
                            }
                        }
                        break;
                    }
                    case 34: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 30;
                                break;
                            }
                            default: {
                                gotoPoint = 20;
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }

    private void spcOrLfStar() throws IOException {
        block4: while (true) {
            if (this.parser.cursor + 3 >= this.parser.limit) {
                this.parser.read();
            }
            byte ych = this.parser.buffer.buffer[this.parser.cursor];
            switch (ych) {
                case 10: 
                case 32: {
                    ++this.parser.cursor;
                    continue block4;
                }
                case 13: {
                    if (this.parser.buffer.buffer[this.parser.cursor + 1] == 10) {
                        this.parser.cursor += 2;
                        continue block4;
                    }
                    return;
                }
            }
            break;
        }
    }

    private boolean ywordc() throws IOException {
        if (!YWORDC[this.parser.buffer.buffer[this.parser.cursor] & 0xFF]) {
            return false;
        }
        ++this.parser.cursor;
        while (true) {
            if (this.parser.cursor == this.parser.limit) {
                this.parser.read();
            }
            if (!YWORDC[this.parser.buffer.buffer[this.parser.cursor] & 0xFF]) {
                return true;
            }
            ++this.parser.cursor;
        }
    }

    private boolean endspc() throws IOException {
        byte ych = this.parser.buffer.buffer[this.parser.cursor];
        switch (ych) {
            case 32: {
                ++this.parser.cursor;
                while (true) {
                    if (this.parser.cursor == this.parser.limit) {
                        this.parser.read();
                    }
                    if (this.parser.buffer.buffer[this.parser.cursor] != 32) {
                        return true;
                    }
                    ++this.parser.cursor;
                }
            }
            case 13: {
                if (this.parser.buffer.buffer[this.parser.cursor + 1] != 10) {
                    return false;
                }
                ++this.parser.cursor;
            }
            case 10: {
                ++this.parser.cursor;
                return true;
            }
        }
        return false;
    }

    private boolean yblock() throws IOException {
        int plus = 0;
        int ych = this.parser.buffer.buffer[this.parser.cursor + plus] & 0xFF;
        while (DIGIT_OR_SIGN[ych]) {
            if (this.parser.limit - this.parser.cursor < ++plus) {
                this.parser.read();
            }
            ych = this.parser.buffer.buffer[this.parser.cursor + plus] & 0xFF;
        }
        switch (ych) {
            case 32: {
                ++plus;
                while (true) {
                    if (this.parser.limit - this.parser.cursor < plus) {
                        this.parser.read();
                    }
                    if (this.parser.buffer.buffer[this.parser.cursor + plus] != 32) {
                        this.parser.cursor += plus;
                        return true;
                    }
                    ++plus;
                }
            }
            case 13: {
                if (this.parser.buffer.buffer[this.parser.cursor + plus + 1] != 10) {
                    return false;
                }
                ++plus;
            }
            case 10: {
                this.parser.cursor += ++plus;
                return true;
            }
        }
        return false;
    }

    private int document(int doc_level) throws IOException {
        boolean do_any = false;
        while (true) {
            Level lvl = this.parser.currentLevel();
            if (lvl.status == LevelStatus.header) {
                lvl.status = LevelStatus.doc;
            }
            this.parser.token = this.parser.cursor;
            if (this.parser.limit - this.parser.cursor < 3) {
                this.parser.read();
            }
            byte yych = this.parser.buffer.buffer[this.parser.cursor];
            switch (yych) {
                case 0: {
                    ++this.parser.cursor;
                    if (lvl.spaces > -1) {
                        this.parser.popLevel();
                        this.YYPOS(0);
                        return 268;
                    }
                    this.YYPOS(0);
                    return 0;
                }
                case 9: 
                case 32: {
                    ++this.parser.cursor;
                    while ((yych = this.parser.buffer.buffer[this.parser.cursor]) == 9 || yych == 32) {
                        ++this.parser.cursor;
                        if (this.parser.cursor != this.parser.limit) continue;
                        this.parser.read();
                    }
                    break;
                }
                case 13: {
                    if (this.parser.buffer.buffer[this.parser.cursor + 1] != 10) {
                        do_any = true;
                        break;
                    }
                    ++this.parser.cursor;
                }
                case 10: {
                    ++this.parser.cursor;
                    this.spcOrLfStar();
                    int indent = this.parser.token;
                    this.NEWLINE(indent);
                    while (indent < this.parser.cursor) {
                        if (this.isNewline(++indent) == 0) continue;
                        this.NEWLINE(indent);
                    }
                    int indt_len = 0;
                    if (this.parser.buffer.buffer[this.parser.cursor] == 0) {
                        indt_len = -1;
                        this.parser.token = this.parser.cursor - 1;
                    } else if (this.parser.buffer.buffer[this.parser.lineptr] == 32) {
                        indt_len = this.parser.cursor - this.parser.lineptr;
                    }
                    lvl = this.parser.currentLevel();
                    doc_level = 0;
                    if (this.parser.buffer.buffer[this.parser.cursor] == 35 || lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                    if (lvl.spaces > indt_len) {
                        this.parser.popLevel();
                        this.YYPOS(0);
                        return 268;
                    }
                    if (lvl.spaces < indt_len) {
                        if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                        this.parser.addLevel(indt_len, LevelStatus.doc);
                        return 266;
                    }
                    if (indt_len == -1) {
                        return 0;
                    }
                    return 267;
                }
                case 33: {
                    ++this.parser.cursor;
                    return this.transferMethod();
                }
                case 34: {
                    ++this.parser.cursor;
                    if (lvl.spaces < doc_level) {
                        if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                        this.parser.addLevel(doc_level, LevelStatus.doc);
                        this.YYPOS(0);
                        return 266;
                    }
                    return this.doubleQuote();
                }
                case 35: {
                    ++this.parser.cursor;
                    this.eatComments();
                    break;
                }
                case 38: {
                    ++this.parser.cursor;
                    if (this.ywordc()) {
                        this.lval = new String(this.parser.buffer.buffer, this.parser.token + 1, this.parser.cursor - (this.parser.token + 1), "ISO-8859-1");
                        this.parser.removeAnchor((String)this.lval);
                        return 257;
                    }
                    --this.parser.cursor;
                    do_any = true;
                    break;
                }
                case 39: {
                    ++this.parser.cursor;
                    if (lvl.spaces < doc_level) {
                        if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                        this.parser.addLevel(doc_level, LevelStatus.doc);
                        this.YYPOS(0);
                        return 266;
                    }
                    return this.singleQuote();
                }
                case 42: {
                    ++this.parser.cursor;
                    if (this.ywordc()) {
                        if (lvl.spaces < doc_level) {
                            if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                            this.parser.addLevel(doc_level, LevelStatus.doc);
                            this.YYPOS(0);
                            return 266;
                        }
                        this.lval = new String(this.parser.buffer.buffer, this.parser.token + 1, this.parser.cursor - (this.parser.token + 1), "ISO-8859-1");
                        return 258;
                    }
                    --this.parser.cursor;
                    do_any = true;
                    break;
                }
                case 44: 
                case 58: {
                    ++this.parser.cursor;
                    if (this.endspc()) {
                        if (this.parser.buffer.buffer[this.parser.token] == 58 && lvl.status != LevelStatus.imap && lvl.status != LevelStatus.iseq) {
                            lvl.status = LevelStatus.map;
                        }
                        this.YYPOS(1);
                        return this.parser.buffer.buffer[this.parser.token];
                    }
                    --this.parser.cursor;
                    do_any = true;
                    break;
                }
                case 45: 
                case 63: {
                    ++this.parser.cursor;
                    if (this.endspc()) {
                        if (lvl.spaces < this.parser.token - this.parser.lineptr) {
                            if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                            this.parser.addLevel(this.parser.token - this.parser.lineptr, LevelStatus.doc);
                            this.YYPOS(0);
                            return 266;
                        }
                        this.parser.force_token = 266;
                        if (this.parser.buffer.buffer[this.parser.cursor] == 35 || this.isNewline(this.parser.cursor) != 0 || this.isNewline(this.parser.cursor - 1) != 0) {
                            --this.parser.cursor;
                            this.parser.addLevel(this.parser.token + 1 - this.parser.lineptr, LevelStatus.seq);
                        } else {
                            this.parser.addLevel(this.parser.cursor - this.parser.lineptr, LevelStatus.seq);
                        }
                        return this.parser.buffer.buffer[this.parser.token];
                    }
                    --this.parser.cursor;
                    do_any = true;
                    break;
                }
                case 62: 
                case 124: {
                    ++this.parser.cursor;
                    if (this.yblock()) {
                        if (this.isNewline(this.parser.cursor - 1) != 0) {
                            --this.parser.cursor;
                        }
                        return this.scalarBlock();
                    }
                    --this.parser.cursor;
                    do_any = true;
                    break;
                }
                case 91: {
                    ++this.parser.cursor;
                    if (lvl.spaces < doc_level) {
                        if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                        this.parser.addLevel(doc_level, LevelStatus.doc);
                        this.YYPOS(0);
                        return 266;
                    }
                    lvl = this.parser.currentLevel();
                    this.parser.addLevel(lvl.spaces + 1, LevelStatus.iseq);
                    return this.parser.buffer.buffer[this.parser.token];
                }
                case 93: 
                case 125: {
                    ++this.parser.cursor;
                    this.parser.popLevel();
                    return this.parser.buffer.buffer[this.parser.token];
                }
                case 123: {
                    ++this.parser.cursor;
                    if (lvl.spaces < doc_level) {
                        if (lvl.status == LevelStatus.iseq || lvl.status == LevelStatus.imap) break;
                        this.parser.addLevel(doc_level, LevelStatus.doc);
                        this.YYPOS(0);
                        return 266;
                    }
                    lvl = this.parser.currentLevel();
                    this.parser.addLevel(lvl.spaces + 1, LevelStatus.imap);
                    return this.parser.buffer.buffer[this.parser.token];
                }
                default: {
                    do_any = true;
                }
            }
            if (!do_any) continue;
            if (lvl.spaces < doc_level) {
                if (lvl.status != LevelStatus.iseq && lvl.status != LevelStatus.imap) {
                    this.parser.addLevel(doc_level, LevelStatus.doc);
                    this.YYPOS(0);
                    return 266;
                }
            } else {
                return this.plain();
            }
            do_any = false;
        }
    }

    private int directive() throws IOException {
        block35: while (true) {
            this.parser.toktmp = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            while (true) {
                if (gotoPoint == -2) continue block35;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 2) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 37;
                                break;
                            }
                            case 9: 
                            case 32: {
                                gotoPoint = 40;
                                break;
                            }
                            case 37: {
                                gotoPoint = 38;
                                break;
                            }
                            default: {
                                gotoPoint = 42;
                                break;
                            }
                        }
                        break;
                    }
                    case 37: {
                        this.parser.cursor = this.parser.marker;
                        gotoPoint = 39;
                        break;
                    }
                    case 38: {
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                gotoPoint = 45;
                                break;
                            }
                            default: {
                                gotoPoint = 39;
                                break;
                            }
                        }
                        break;
                    }
                    case 39: {
                        this.parser.cursor = this.parser.toktmp;
                        return 265;
                    }
                    case 40: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 44;
                        break;
                    }
                    case 41: {
                        break;
                    }
                    case 42: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 39;
                        break;
                    }
                    case 43: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 44: {
                        switch (yych) {
                            case 9: 
                            case 32: {
                                gotoPoint = 43;
                                break;
                            }
                            default: {
                                gotoPoint = 41;
                                break;
                            }
                        }
                        break;
                    }
                    case 45: {
                        ++this.parser.cursor;
                        if (this.parser.limit - this.parser.cursor < 2) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                gotoPoint = 45;
                                break;
                            }
                            case 58: {
                                gotoPoint = 47;
                                break;
                            }
                            default: {
                                gotoPoint = 37;
                                break;
                            }
                        }
                        break;
                    }
                    case 47: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                gotoPoint = 48;
                                break;
                            }
                            default: {
                                gotoPoint = 37;
                                break;
                            }
                        }
                        break;
                    }
                    case 48: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 46: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: 
                            case 103: 
                            case 104: 
                            case 105: 
                            case 106: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: 
                            case 112: 
                            case 113: 
                            case 114: 
                            case 115: 
                            case 116: 
                            case 117: 
                            case 118: 
                            case 119: 
                            case 120: 
                            case 121: 
                            case 122: {
                                gotoPoint = 48;
                                break;
                            }
                            default: {
                                gotoPoint = 50;
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }

    private int getAndCheckIndentLength() {
        int indent = this.parser.token;
        this.NEWLINE(indent);
        while (indent < this.parser.cursor) {
            if (this.isNewline(++indent) == 0) continue;
            this.NEWLINE(indent);
        }
        int indt_len = 0;
        if (this.parser.buffer.buffer[this.parser.cursor] == 0) {
            indt_len = -1;
        } else if (this.parser.buffer.buffer[this.parser.lineptr] == 32) {
            indt_len = this.parser.cursor - this.parser.lineptr;
        }
        return indt_len;
    }

    private void countAndAddNewlines(QuotedString q) {
        int nl_count = 0;
        while (this.parser.token < this.parser.cursor) {
            int nl_len;
            if ((nl_len = this.newlineLen(this.parser.token++)) <= 0) continue;
            ++nl_count;
            this.parser.token += nl_len - 1;
        }
        if (nl_count <= 1) {
            q.cat(' ');
        } else {
            for (int i = 0; i < nl_count - 1; ++i) {
                q.cat('\n');
            }
        }
    }

    private int plain() throws IOException {
        QuotedString q = new QuotedString();
        this.parser.cursor = this.parser.token;
        Level plvl = this.parser.currentLevel();
        Level lvl_deep = this.parser.currentLevel();
        int parentIndent = lvl_deep.spaces;
        if (lvl_deep.status == LevelStatus.seq || parentIndent == this.parser.cursor - this.parser.lineptr && lvl_deep.status != LevelStatus.map) {
            --this.parser.lvl_idx;
            Level lvl_over = this.parser.currentLevel();
            parentIndent = lvl_over.spaces;
            ++this.parser.lvl_idx;
        }
        boolean plain3 = false;
        boolean do_any = false;
        while (true) {
            this.parser.token = this.parser.cursor;
            do {
                plain3 = false;
                if (this.parser.limit - this.parser.cursor < 3) {
                    this.parser.read();
                }
                byte yych = this.parser.buffer.buffer[this.parser.cursor];
                switch (yych) {
                    case 13: {
                        if (this.parser.buffer.buffer[this.parser.cursor + 1] != 10) {
                            do_any = true;
                            break;
                        }
                        ++this.parser.cursor;
                    }
                    case 10: {
                        ++this.parser.cursor;
                        this.spcOrLfStar();
                        int indt_len = this.getAndCheckIndentLength();
                        if (indt_len <= parentIndent) {
                            this.RETURN_IMPLICIT(q);
                            return 263;
                        }
                        this.countAndAddNewlines(q);
                        break;
                    }
                    case 0: {
                        ++this.parser.cursor;
                        this.RETURN_IMPLICIT(q);
                        return 263;
                    }
                    case 32: {
                        if (this.parser.buffer.buffer[this.parser.cursor + 1] == 35) {
                            this.parser.cursor += 2;
                            this.eatComments();
                            this.RETURN_IMPLICIT(q);
                            return 263;
                        }
                    }
                    case 9: {
                        ++this.parser.cursor;
                        if (q.idx == 0) break;
                        plain3 = true;
                        break;
                    }
                    case 125: {
                        ++this.parser.cursor;
                        if (plvl.status != LevelStatus.imap) {
                            if (this.parser.buffer.buffer[this.parser.cursor - 1] == 32 || this.isNewline(this.parser.cursor - 1) > 0) {
                                --this.parser.cursor;
                            }
                            q.cat(this.parser.buffer.buffer, this.parser.token, this.parser.cursor - this.parser.token);
                            break;
                        }
                        q.plain_is_inl();
                        this.RETURN_IMPLICIT(q);
                        return 263;
                    }
                    case 93: {
                        ++this.parser.cursor;
                        if (plvl.status != LevelStatus.iseq) {
                            if (this.parser.buffer.buffer[this.parser.cursor - 1] == 32 || this.isNewline(this.parser.cursor - 1) > 0) {
                                --this.parser.cursor;
                            }
                            q.cat(this.parser.buffer.buffer, this.parser.token, this.parser.cursor - this.parser.token);
                            break;
                        }
                        q.plain_is_inl();
                        this.RETURN_IMPLICIT(q);
                        return 263;
                    }
                    case 58: {
                        ++this.parser.cursor;
                        if (this.endspc()) {
                            this.RETURN_IMPLICIT(q);
                            return 263;
                        }
                        --this.parser.cursor;
                        do_any = true;
                        break;
                    }
                    case 44: {
                        ++this.parser.cursor;
                        if (this.endspc()) {
                            if (plvl.status != LevelStatus.iseq && plvl.status != LevelStatus.imap) {
                                if (this.parser.buffer.buffer[this.parser.cursor - 1] == 32 || this.isNewline(this.parser.cursor - 1) > 0) {
                                    --this.parser.cursor;
                                }
                                q.cat(this.parser.buffer.buffer, this.parser.token, this.parser.cursor - this.parser.token);
                                break;
                            }
                            q.plain_is_inl();
                            this.RETURN_IMPLICIT(q);
                            return 263;
                        }
                        --this.parser.cursor;
                        do_any = true;
                        break;
                    }
                    default: {
                        do_any = true;
                    }
                }
                if (!do_any) continue;
                ++this.parser.cursor;
                q.cat(this.parser.buffer.buffer, this.parser.token, this.parser.cursor - this.parser.token);
                do_any = false;
            } while (plain3);
        }
    }

    private int doubleQuote() throws IOException {
        boolean keep_nl = true;
        QuotedString q = new QuotedString();
        block61: while (true) {
            this.parser.token = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            boolean yyaccept = false;
            while (true) {
                if (gotoPoint == -2) continue block61;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 4) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 58;
                                break;
                            }
                            case 10: {
                                gotoPoint = 53;
                                break;
                            }
                            case 13: {
                                gotoPoint = 55;
                                break;
                            }
                            case 34: {
                                gotoPoint = 60;
                                break;
                            }
                            case 92: {
                                gotoPoint = 57;
                                break;
                            }
                            default: {
                                gotoPoint = 61;
                                break;
                            }
                        }
                        break;
                    }
                    case 53: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 75;
                        break;
                    }
                    case 54: {
                        int indent = this.parser.token;
                        this.NEWLINE(indent);
                        while (indent < this.parser.cursor) {
                            if (this.isNewline(++indent) == 0) continue;
                            this.NEWLINE(indent);
                        }
                        int indt_len = 0;
                        if (this.parser.buffer.buffer[this.parser.cursor] == 0) {
                            indt_len = -1;
                            this.parser.token = this.parser.cursor - 1;
                        } else if (this.parser.buffer.buffer[this.parser.lineptr] == 32) {
                            indt_len = this.parser.cursor - this.parser.lineptr;
                        }
                        boolean nl_count = false;
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status != LevelStatus.str) {
                            this.parser.addLevel(indt_len, LevelStatus.str);
                        } else if (indt_len < lvl.spaces) {
                            // empty if block
                        }
                        if (keep_nl) {
                            this.countAndAddNewlines(q);
                        }
                        keep_nl = true;
                        break;
                    }
                    case 55: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 74;
                                break;
                            }
                            default: {
                                gotoPoint = 56;
                                break;
                            }
                        }
                        break;
                    }
                    case 56: {
                        q.cat(this.parser.buffer.buffer[this.parser.cursor - 1]);
                        break;
                    }
                    case 57: {
                        yyaccept = true;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 65;
                                break;
                            }
                            case 13: {
                                gotoPoint = 67;
                                break;
                            }
                            case 32: {
                                gotoPoint = 62;
                                break;
                            }
                            case 34: 
                            case 48: 
                            case 92: 
                            case 97: 
                            case 98: 
                            case 101: 
                            case 102: 
                            case 110: 
                            case 114: 
                            case 116: 
                            case 118: {
                                gotoPoint = 69;
                                break;
                            }
                            case 120: {
                                gotoPoint = 68;
                                break;
                            }
                            default: {
                                gotoPoint = 56;
                                break;
                            }
                        }
                        break;
                    }
                    case 58: {
                        ++this.parser.cursor;
                    }
                    case 59: {
                        Node n = Node.allocStr();
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status == LevelStatus.str) {
                            this.parser.popLevel();
                        }
                        n.type_id = this.parser.taguri_expansion ? Parser.taguri("yaml.org,2002", "str") : "str";
                        Data.Str dd = (Data.Str)n.data;
                        dd.ptr = Pointer.create(q.str, 0);
                        dd.len = q.idx;
                        dd.style = ScalarStyle.TwoQuote;
                        this.lval = n;
                        return 263;
                    }
                    case 60: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 59;
                        break;
                    }
                    case 61: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 56;
                        break;
                    }
                    case 62: {
                        ++this.parser.cursor;
                        if (this.parser.limit - this.parser.cursor < 2) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 65;
                                break;
                            }
                            case 13: {
                                gotoPoint = 67;
                                break;
                            }
                            case 32: {
                                gotoPoint = 62;
                                break;
                            }
                            default: {
                                gotoPoint = 64;
                                break;
                            }
                        }
                        break;
                    }
                    case 64: {
                        this.parser.cursor = this.parser.marker;
                        if (!yyaccept) {
                            gotoPoint = 54;
                            break;
                        }
                        gotoPoint = 56;
                        break;
                    }
                    case 65: {
                        ++this.parser.cursor;
                        keep_nl = false;
                        --this.parser.cursor;
                        break;
                    }
                    case 67: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 65;
                                break;
                            }
                            default: {
                                gotoPoint = 64;
                                break;
                            }
                        }
                        break;
                    }
                    case 68: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                gotoPoint = 71;
                                break;
                            }
                            default: {
                                gotoPoint = 64;
                                break;
                            }
                        }
                        break;
                    }
                    case 69: {
                        ++this.parser.cursor;
                        byte ch = this.parser.buffer.buffer[this.parser.cursor - 1];
                        q.cat(this.escapeSeq(ch));
                        break;
                    }
                    case 71: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                gotoPoint = 72;
                                break;
                            }
                            default: {
                                gotoPoint = 64;
                                break;
                            }
                        }
                        break;
                    }
                    case 72: {
                        ++this.parser.cursor;
                        q.cat((byte)Integer.valueOf(new String(this.parser.buffer.buffer, this.parser.token + 2, 2, "ISO-8859-1"), 16).intValue());
                        break;
                    }
                    case 74: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 75: {
                        switch (yych) {
                            case 10: 
                            case 32: {
                                gotoPoint = 74;
                                break;
                            }
                            case 13: {
                                gotoPoint = 76;
                                break;
                            }
                            default: {
                                gotoPoint = 54;
                                break;
                            }
                        }
                        break;
                    }
                    case 76: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 74;
                                break;
                            }
                            default: {
                                gotoPoint = 64;
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }

    private int singleQuote() throws IOException {
        QuotedString q = new QuotedString();
        block35: while (true) {
            this.parser.token = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            while (true) {
                if (gotoPoint == -2) continue block35;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 2) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 85;
                                break;
                            }
                            case 10: {
                                gotoPoint = 79;
                                break;
                            }
                            case 13: {
                                gotoPoint = 81;
                                break;
                            }
                            case 39: {
                                gotoPoint = 83;
                                break;
                            }
                            default: {
                                gotoPoint = 86;
                                break;
                            }
                        }
                        break;
                    }
                    case 79: {
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 90;
                        break;
                    }
                    case 80: {
                        int indent = this.parser.token;
                        this.NEWLINE(indent);
                        while (indent < this.parser.cursor) {
                            if (this.isNewline(++indent) == 0) continue;
                            this.NEWLINE(indent);
                        }
                        int indt_len = 0;
                        if (this.parser.buffer.buffer[this.parser.cursor] == 0) {
                            indt_len = -1;
                            this.parser.token = this.parser.cursor - 1;
                        } else if (this.parser.buffer.buffer[this.parser.lineptr] == 32) {
                            indt_len = this.parser.cursor - this.parser.lineptr;
                        }
                        int nl_count = 0;
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status != LevelStatus.str) {
                            this.parser.addLevel(indt_len, LevelStatus.str);
                        } else if (indt_len < lvl.spaces) {
                            // empty if block
                        }
                        while (this.parser.token < this.parser.cursor) {
                            int nl_len;
                            if ((nl_len = this.newlineLen(this.parser.token++)) <= 0) continue;
                            ++nl_count;
                            this.parser.token += nl_len - 1;
                        }
                        if (nl_count <= 1) {
                            q.cat(' ');
                            break;
                        }
                        for (int i = 0; i < nl_count - 1; ++i) {
                            q.cat('\n');
                        }
                        break;
                    }
                    case 81: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 89;
                                break;
                            }
                            default: {
                                gotoPoint = 82;
                                break;
                            }
                        }
                        break;
                    }
                    case 82: {
                        q.cat(this.parser.buffer.buffer[this.parser.cursor - 1]);
                        break;
                    }
                    case 83: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 39: {
                                gotoPoint = 87;
                                break;
                            }
                            default: {
                                gotoPoint = 84;
                                break;
                            }
                        }
                        break;
                    }
                    case 84: {
                        Node n = Node.allocStr();
                        Level lvl = this.parser.currentLevel();
                        if (lvl.status == LevelStatus.str) {
                            this.parser.popLevel();
                        }
                        n.type_id = this.parser.taguri_expansion ? Parser.taguri("yaml.org,2002", "str") : "str";
                        Data.Str dd = (Data.Str)n.data;
                        dd.ptr = Pointer.create(q.str, 0);
                        dd.len = q.idx;
                        dd.style = ScalarStyle.OneQuote;
                        this.lval = n;
                        return 263;
                    }
                    case 85: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 84;
                        break;
                    }
                    case 86: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 82;
                        break;
                    }
                    case 87: {
                        ++this.parser.cursor;
                        q.cat('\'');
                        break;
                    }
                    case 89: {
                        this.parser.marker = ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 90: {
                        switch (yych) {
                            case 10: 
                            case 32: {
                                gotoPoint = 89;
                                break;
                            }
                            case 13: {
                                gotoPoint = 91;
                                break;
                            }
                            default: {
                                gotoPoint = 80;
                                break;
                            }
                        }
                        break;
                    }
                    case 91: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 89;
                                break;
                            }
                            default: {
                                gotoPoint = 92;
                                break;
                            }
                        }
                        break;
                    }
                    case 92: {
                        this.parser.cursor = this.parser.marker;
                        gotoPoint = 80;
                        break;
                    }
                }
            }
            break;
        }
    }

    private int transferMethod() throws IOException {
        QuotedString q = new QuotedString();
        block41: while (true) {
            this.parser.toktmp = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            while (true) {
                if (gotoPoint == -2) continue block41;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 4) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 95;
                                break;
                            }
                            case 10: {
                                gotoPoint = 97;
                                break;
                            }
                            case 13: {
                                gotoPoint = 99;
                                break;
                            }
                            case 32: {
                                gotoPoint = 98;
                                break;
                            }
                            case 92: {
                                gotoPoint = 101;
                                break;
                            }
                            default: {
                                gotoPoint = 102;
                                break;
                            }
                        }
                        break;
                    }
                    case 95: {
                        ++this.parser.cursor;
                    }
                    case 96: {
                        this.parser.cursor = this.parser.toktmp;
                        if (this.parser.cursor == this.parser.token + 1) {
                            return 261;
                        }
                        Level lvl = this.parser.currentLevel();
                        if (q.str[0] == 94) {
                            this.lval = lvl.domain + new String(q.str, 1, q.idx - 1, "ISO-8859-1");
                        } else {
                            int carat = 0;
                            int qend = q.idx;
                            while (++carat < qend && q.str[carat] != 94) {
                            }
                            if (carat < qend) {
                                lvl.domain = new String(q.str, 0, carat, "ISO-8859-1");
                                this.lval = lvl.domain + new String(q.str, carat + 1, qend - carat - 1, "ISO-8859-1");
                            } else {
                                this.lval = new String(q.str, 0, qend, "ISO-8859-1");
                            }
                        }
                        return 259;
                    }
                    case 97: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 96;
                        break;
                    }
                    case 98: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 111;
                        break;
                    }
                    case 99: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 95;
                                break;
                            }
                            default: {
                                gotoPoint = 100;
                                break;
                            }
                        }
                        break;
                    }
                    case 100: {
                        q.cat(this.parser.buffer.buffer[this.parser.cursor - 1]);
                        break;
                    }
                    case 101: {
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 34: 
                            case 48: 
                            case 92: 
                            case 97: 
                            case 98: 
                            case 101: 
                            case 102: 
                            case 110: 
                            case 114: 
                            case 116: 
                            case 118: {
                                gotoPoint = 105;
                                break;
                            }
                            case 120: {
                                gotoPoint = 103;
                                break;
                            }
                            default: {
                                gotoPoint = 100;
                                break;
                            }
                        }
                        break;
                    }
                    case 102: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 100;
                        break;
                    }
                    case 103: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                gotoPoint = 107;
                                break;
                            }
                            default: {
                                gotoPoint = 104;
                                break;
                            }
                        }
                        break;
                    }
                    case 104: {
                        this.parser.cursor = this.parser.marker;
                        gotoPoint = 100;
                        break;
                    }
                    case 105: {
                        ++this.parser.cursor;
                        byte ch = this.parser.buffer.buffer[this.parser.cursor - 1];
                        q.cat(this.escapeSeq(ch));
                        break;
                    }
                    case 107: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                gotoPoint = 108;
                                break;
                            }
                            default: {
                                gotoPoint = 104;
                                break;
                            }
                        }
                        break;
                    }
                    case 108: {
                        ++this.parser.cursor;
                        q.cat((byte)Integer.valueOf(new String(this.parser.buffer.buffer, this.parser.toktmp + 2, 2, "ISO-8859-1"), 16).intValue());
                        break;
                    }
                    case 110: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 111: {
                        switch (yych) {
                            case 32: {
                                gotoPoint = 110;
                                break;
                            }
                            default: {
                                gotoPoint = 96;
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }

    private int scalarBlock() throws IOException {
        QuotedString q = new QuotedString();
        q.str[0] = 0;
        int lastIndent = 0;
        int parentIndent = -1;
        int blockType = 0;
        int nlDoWhat = 0;
        int forceIndent = -1;
        int yyt = this.parser.token;
        Level lvl = this.parser.currentLevel();
        switch (this.parser.buffer.buffer[yyt]) {
            case 124: {
                blockType = 20;
                break;
            }
            case 62: {
                blockType = 10;
            }
        }
        while (++yyt <= this.parser.cursor) {
            if (this.parser.buffer.buffer[yyt] == 45) {
                nlDoWhat = 40;
                continue;
            }
            if (this.parser.buffer.buffer[yyt] == 43) {
                nlDoWhat = 50;
                continue;
            }
            if (!Character.isDigit((char)this.parser.buffer.buffer[yyt])) continue;
            forceIndent = (char)this.parser.buffer.buffer[yyt] - 48;
        }
        block60: while (true) {
            this.parser.token = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            boolean yyaccept = false;
            while (true) {
                if (gotoPoint == -2) continue block60;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 5) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 120;
                                break;
                            }
                            case 10: {
                                gotoPoint = 114;
                                break;
                            }
                            case 13: {
                                gotoPoint = 116;
                                break;
                            }
                            case 35: {
                                gotoPoint = 118;
                                break;
                            }
                            case 45: {
                                gotoPoint = 122;
                                break;
                            }
                            default: {
                                gotoPoint = 123;
                                break;
                            }
                        }
                        break;
                    }
                    case 114: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 133;
                        break;
                    }
                    case 115: {
                        int tok = this.parser.token;
                        int nl_count = 0;
                        boolean fold_nl = false;
                        boolean nl_begin = false;
                        int indt_len = this.getAndCheckIndentLength();
                        lvl = this.parser.currentLevel();
                        if (lvl.status != LevelStatus.block) {
                            parentIndent = this.GET_TRUE_YAML_INDENT();
                            if (forceIndent > 0) {
                                forceIndent += parentIndent;
                            }
                            if (indt_len > parentIndent) {
                                int new_spaces = forceIndent > 0 ? forceIndent : indt_len;
                                this.parser.addLevel(new_spaces, LevelStatus.block);
                                lastIndent = indt_len - new_spaces;
                                nl_begin = true;
                                lvl = this.parser.currentLevel();
                            } else {
                                this.parser.cursor = this.parser.token;
                                this.RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                                return 264;
                            }
                        }
                        if (blockType == 10 && lastIndent == 0 && indt_len - lvl.spaces == 0) {
                            fold_nl = true;
                        }
                        int pacer = this.parser.token;
                        while (pacer < this.parser.cursor) {
                            int nl_len;
                            if ((nl_len = this.newlineLen(pacer++)) <= 0) continue;
                            ++nl_count;
                            pacer += nl_len - 1;
                        }
                        if (fold_nl || nl_begin) {
                            --nl_count;
                        }
                        if (nl_count < 1 && !nl_begin) {
                            q.cat(' ');
                        } else {
                            for (int i = 0; i < nl_count; ++i) {
                                q.cat('\n');
                            }
                        }
                        lastIndent = indt_len - lvl.spaces;
                        this.parser.cursor -= lastIndent;
                        if (indt_len >= lvl.spaces) break;
                        this.parser.popLevel();
                        this.parser.cursor = this.parser.token;
                        this.RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                        return 264;
                    }
                    case 116: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 132;
                                break;
                            }
                            default: {
                                gotoPoint = 117;
                                break;
                            }
                        }
                        break;
                    }
                    case 117: {
                        q.cat(this.parser.buffer.buffer[this.parser.token]);
                        break;
                    }
                    case 118: {
                        ++this.parser.cursor;
                        lvl = this.parser.currentLevel();
                        if (lvl.status != LevelStatus.block) {
                            this.eatComments();
                            this.parser.token = this.parser.cursor;
                            break;
                        }
                        q.cat(this.parser.buffer.buffer[this.parser.token]);
                        break;
                    }
                    case 120: {
                        ++this.parser.cursor;
                        --this.parser.cursor;
                        this.parser.popLevel();
                        this.RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                        return 264;
                    }
                    case 122: {
                        yyaccept = true;
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 45: {
                                gotoPoint = 124;
                                break;
                            }
                            default: {
                                gotoPoint = 117;
                                break;
                            }
                        }
                        break;
                    }
                    case 123: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 117;
                        break;
                    }
                    case 124: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 45: {
                                gotoPoint = 126;
                                break;
                            }
                            default: {
                                gotoPoint = 125;
                                break;
                            }
                        }
                        break;
                    }
                    case 125: {
                        this.parser.cursor = this.parser.marker;
                        if (!yyaccept) {
                            gotoPoint = 115;
                            break;
                        }
                        gotoPoint = 117;
                        break;
                    }
                    case 126: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 127;
                                break;
                            }
                            case 13: {
                                gotoPoint = 131;
                                break;
                            }
                            case 32: {
                                gotoPoint = 129;
                                break;
                            }
                            default: {
                                gotoPoint = 125;
                                break;
                            }
                        }
                        break;
                    }
                    case 127: {
                        ++this.parser.cursor;
                    }
                    case 128: {
                        if (this.parser.token == this.parser.lineptr) {
                            if (blockType == 10 && q.idx > 0) {
                                --q.idx;
                            }
                            q.cat('\n');
                            this.parser.popLevel();
                            this.parser.cursor = this.parser.token;
                            this.RETURN_YAML_BLOCK(q, blockType, nlDoWhat);
                            return 264;
                        }
                        q.cat(this.parser.buffer.buffer[this.parser.token]);
                        this.parser.cursor = this.parser.token + 1;
                        break;
                    }
                    case 129: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 32: {
                                gotoPoint = 129;
                                break;
                            }
                            default: {
                                gotoPoint = 128;
                                break;
                            }
                        }
                        break;
                    }
                    case 131: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 127;
                                break;
                            }
                            default: {
                                gotoPoint = 125;
                                break;
                            }
                        }
                        break;
                    }
                    case 132: {
                        yyaccept = false;
                        this.parser.marker = ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 133: {
                        switch (yych) {
                            case 10: 
                            case 32: {
                                gotoPoint = 132;
                                break;
                            }
                            case 13: {
                                gotoPoint = 134;
                                break;
                            }
                            default: {
                                gotoPoint = 115;
                                break;
                            }
                        }
                        break;
                    }
                    case 134: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 132;
                                break;
                            }
                            default: {
                                gotoPoint = 125;
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
    }

    private byte escapeSeq(byte ch) {
        switch (ch) {
            case 48: {
                return 0;
            }
            case 97: {
                return 7;
            }
            case 98: {
                return 8;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
        }
        return ch;
    }

    private void eatComments() throws IOException {
        block28: while (true) {
            this.parser.token = this.parser.cursor;
            int gotoPoint = -1;
            int yych = 0;
            while (true) {
                if (gotoPoint == -2) continue block28;
                int currentGoto = gotoPoint;
                gotoPoint = -2;
                switch (currentGoto) {
                    case -1: {
                        if (this.parser.limit - this.parser.cursor < 2) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 0: {
                                gotoPoint = 137;
                                break;
                            }
                            case 10: {
                                gotoPoint = 139;
                                break;
                            }
                            case 13: {
                                gotoPoint = 140;
                                break;
                            }
                            default: {
                                gotoPoint = 142;
                                break;
                            }
                        }
                        break;
                    }
                    case 137: {
                        ++this.parser.cursor;
                    }
                    case 138: {
                        this.parser.cursor = this.parser.token;
                        return;
                    }
                    case 139: {
                        this.parser.marker = ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        gotoPoint = 144;
                        break;
                    }
                    case 140: {
                        ++this.parser.cursor;
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 143;
                                break;
                            }
                            default: {
                                gotoPoint = 141;
                                break;
                            }
                        }
                        break;
                    }
                    case 141: {
                        break;
                    }
                    case 142: {
                        yych = this.parser.buffer.buffer[++this.parser.cursor];
                        gotoPoint = 141;
                        break;
                    }
                    case 143: {
                        this.parser.marker = ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                    }
                    case 144: {
                        switch (yych) {
                            case 10: {
                                gotoPoint = 143;
                                break;
                            }
                            case 13: {
                                gotoPoint = 145;
                                break;
                            }
                            default: {
                                gotoPoint = 138;
                                break;
                            }
                        }
                        break;
                    }
                    case 145: {
                        ++this.parser.cursor;
                        if (this.parser.limit <= this.parser.cursor) {
                            this.parser.read();
                        }
                        yych = this.parser.buffer.buffer[this.parser.cursor];
                        switch (yych) {
                            case 10: {
                                gotoPoint = 143;
                                break;
                            }
                            default: {
                                gotoPoint = 146;
                                break;
                            }
                        }
                        break;
                    }
                    case 146: {
                        this.parser.cursor = this.parser.marker;
                        gotoPoint = 138;
                        break;
                    }
                }
            }
            break;
        }
    }

    static {
        int c;
        tnames = new String[269];
        TokenScanner.tnames[0] = "ENDINPUT";
        TokenScanner.tnames[256] = "error";
        TokenScanner.tnames[44] = "COMMA";
        TokenScanner.tnames[45] = "DASH";
        TokenScanner.tnames[58] = "COLON";
        TokenScanner.tnames[63] = "QUESTION";
        TokenScanner.tnames[91] = "SQUAREO";
        TokenScanner.tnames[93] = "SQUAREC";
        TokenScanner.tnames[123] = "CURLYO";
        TokenScanner.tnames[125] = "CURLYC";
        TokenScanner.tnames[257] = "ANCHOR";
        TokenScanner.tnames[258] = "ALIAS";
        TokenScanner.tnames[264] = "BLOCK";
        TokenScanner.tnames[265] = "DOCSEP";
        TokenScanner.tnames[268] = "IEND";
        TokenScanner.tnames[267] = "INDENT";
        TokenScanner.tnames[266] = "IOPEN";
        TokenScanner.tnames[261] = "ITRANSFER";
        TokenScanner.tnames[263] = "PLAIN";
        TokenScanner.tnames[260] = "TAGURI";
        TokenScanner.tnames[259] = "TRANSFER";
        TokenScanner.tnames[262] = "WORD";
        YWORDC = new boolean[256];
        DIGIT_OR_SIGN = new boolean[256];
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            TokenScanner.YWORDC[c] = true;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            TokenScanner.YWORDC[c] = true;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            TokenScanner.YWORDC[c] = true;
            TokenScanner.DIGIT_OR_SIGN[c] = true;
        }
        TokenScanner.YWORDC[95] = true;
        TokenScanner.YWORDC[45] = true;
        TokenScanner.DIGIT_OR_SIGN[45] = true;
        TokenScanner.DIGIT_OR_SIGN[43] = true;
    }

    private static class QuotedString {
        public int idx = 0;
        public int capa = 100;
        public byte[] str = new byte[100];

        public void cat(char l) {
            this.cat((byte)l);
        }

        public void cat(byte l) {
            if (this.idx + 1 >= this.capa) {
                this.capa += 1024;
                this.str = YAML.realloc(this.str, this.capa);
            }
            this.str[this.idx++] = l;
            this.str[this.idx] = 0;
        }

        public void cat(byte[] l, int cs, int cl) {
            while (this.idx + cl >= this.capa) {
                this.capa += 1024;
                this.str = YAML.realloc(this.str, this.capa);
            }
            System.arraycopy(l, cs, this.str, this.idx, cl);
            this.idx += cl;
            this.str[this.idx] = 0;
        }

        public void plain_is_inl() {
            for (int walker = this.idx - 1; walker > 0 && (this.str[walker] == 10 || this.str[walker] == 32 || this.str[walker] == 9); --walker) {
                --this.idx;
                this.str[walker] = 0;
            }
        }
    }
}

