/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.Node;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.SValue19Node;
import org.jruby.ast.SValueNode;
import org.jruby.ast.Splat19Node;
import org.jruby.ast.SplatNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.StaticScope;

public class ParserSupport19
extends ParserSupport {
    public AssignableNode assignable(Token lhs, Node value2) {
        this.checkExpression(value2);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "Can't assign to __ENCODING__", "__ENCODING__");
            }
            case 306: {
                return this.currentScope.assign(lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value2));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), this.lexer.getCurrentLine(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value2);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 311: {
                return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value2);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), this.lexer.getCurrentLine(), "identifier " + (String)lhs.getValue() + " is not valid to set", lhs.getValue());
    }

    public DStrNode createDStrNode(ISourcePosition position) {
        return new DStrNode(position, this.lexer.getEncoding());
    }

    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, "identifier " + identifier + " is not valid to get", identifier, new Object[0]);
    }

    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new Splat19Node(position, this.makeNullNil(node));
    }

    public SValueNode newSValueNode(ISourcePosition position, Node node) {
        return new SValue19Node(position, node);
    }

    private int[] allocateNamedLocals(RegexpNode regexpNode) {
        String[] names2 = regexpNode.loadPattern(this.configuration.getRuntime()).getNames();
        int length2 = names2.length;
        int[] locals = new int[length2];
        StaticScope scope = this.getCurrentScope();
        for (int i = 0; i < length2; ++i) {
            int slot = scope.isDefined(names2[i]);
            locals[i] = slot >= 0 ? slot : this.getCurrentScope().addVariableThisScope(names2[i]);
        }
        return locals;
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpNode) {
            int[] locals = this.allocateNamedLocals((RegexpNode)firstNode);
            if (locals.length > 0) {
                return new Match2CaptureNode(firstNode.getPosition(), firstNode, secondNode, locals);
            }
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }
}

