/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby runtime2, boolean wrap2) {
        RubyClass ioClass = runtime2.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext context, IRubyObject obj) {
        RubyIO io2 = (RubyIO)obj;
        try {
            OpenFile openFile = io2.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStream().getDescriptor();
            if (!descriptor.isOpen() || !openFile.getMainStream().getModes().isReadable() || openFile.getMainStream().feof()) {
                return context.getRuntime().getFalse();
            }
            int avail = openFile.getMainStream().ready();
            if (avail > 0) {
                return context.getRuntime().newFixnum(avail);
            }
        }
        catch (Exception anyEx) {
            return context.getRuntime().getFalse();
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject io_wait(ThreadContext context, IRubyObject obj) {
        RubyIO io2 = (RubyIO)obj;
        try {
            OpenFile openFile = io2.getOpenFile();
            if (openFile.getMainStream().feof()) {
                return context.getRuntime().getNil();
            }
            openFile.getMainStream().waitUntilReady();
        }
        catch (Exception anyEx) {
            return context.getRuntime().getNil();
        }
        return obj;
    }
}

