/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaCallable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyToJavaInvoker
extends JavaMethod {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final JavaCallable javaCallable;
    protected final JavaCallable[][] javaCallables;
    protected final JavaCallable[] javaVarargsCallables;
    protected final int minVarargsArity;
    protected final Map cache;
    private Member[] members;

    RubyToJavaInvoker(RubyModule host, Member[] members2) {
        super(host, Visibility.PUBLIC);
        this.members = members2;
        this.setArity(Arity.OPTIONAL);
        Ruby runtime2 = host.getRuntime();
        JavaCallable callable = null;
        JavaCallable[][] callables = null;
        JavaCallable[] varargsCallables = null;
        int varargsArity = Integer.MAX_VALUE;
        if (members2.length == 1) {
            callable = this.createCallable(runtime2, members2[0]);
            if (callable.isVarArgs()) {
                varargsCallables = this.createCallableArray(callable);
            }
        } else {
            HashMap methodsMap = new HashMap();
            ArrayList<JavaCallable> varargsMethods = new ArrayList<JavaCallable>();
            int maxArity = 0;
            for (Member method2 : members2) {
                int currentArity = this.getMemberParameterTypes(method2).length;
                maxArity = Math.max(currentArity, maxArity);
                ArrayList<JavaCallable> methodsForArity = (ArrayList<JavaCallable>)methodsMap.get(currentArity);
                if (methodsForArity == null) {
                    methodsForArity = new ArrayList<JavaCallable>();
                    methodsMap.put(currentArity, methodsForArity);
                }
                JavaCallable javaMethod = this.createCallable(runtime2, method2);
                methodsForArity.add(javaMethod);
                if (!this.isMemberVarArgs(method2)) continue;
                varargsArity = Math.min(currentArity - 1, varargsArity);
                varargsMethods.add(javaMethod);
            }
            callables = this.createCallableArrayArray(maxArity + 1);
            for (Map.Entry entry : methodsMap.entrySet()) {
                List methodsForArity = (List)entry.getValue();
                JavaCallable[] methodsArray = methodsForArity.toArray(this.createCallableArray(methodsForArity.size()));
                callables[((Integer)entry.getKey()).intValue()] = methodsArray;
            }
            if (varargsMethods.size() > 0) {
                varargsCallables = this.createCallableArray(varargsMethods.size());
                varargsMethods.toArray(varargsCallables);
            }
        }
        members2 = null;
        this.cache = new ConcurrentHashMap(0, 0.75f, 1);
        this.javaCallable = callable;
        this.javaCallables = callables;
        this.javaVarargsCallables = varargsCallables;
        this.minVarargsArity = varargsArity;
    }

    protected Member[] getMembers() {
        return this.members;
    }

    protected AccessibleObject[] getAccessibleObjects() {
        return (AccessibleObject[])this.getMembers();
    }

    protected abstract JavaCallable createCallable(Ruby var1, Member var2);

    protected abstract JavaCallable[] createCallableArray(JavaCallable var1);

    protected abstract JavaCallable[] createCallableArray(int var1);

    protected abstract JavaCallable[][] createCallableArrayArray(int var1);

    protected abstract Class[] getMemberParameterTypes(Member var1);

    protected abstract boolean isMemberVarArgs(Member var1);

    static Object convertArg(IRubyObject arg2, JavaCallable method2, int index2) {
        return arg2.toJava(method2.getParameterTypes()[index2]);
    }

    static Object convertVarargs(IRubyObject[] args2, JavaCallable method2) {
        Object varargs;
        Class<?>[] types = method2.getParameterTypes();
        Class<?> varargArrayType = types[types.length - 1];
        Class<?> varargType = varargArrayType.getComponentType();
        int varargsStart = types.length - 1;
        int varargsCount = args2.length - varargsStart;
        if (varargsCount == 1 && args2[varargsStart] instanceof ArrayJavaProxy) {
            varargs = args2[varargsStart].toJava(varargArrayType);
        } else {
            varargs = Array.newInstance(varargType, varargsCount);
            for (int i = 0; i < varargsCount; ++i) {
                Array.set(varargs, i, args2[varargsStart + i].toJava(varargType));
            }
        }
        return varargs;
    }

    static JavaProxy castJavaProxy(IRubyObject self) {
        assert (self instanceof JavaProxy) : "Java methods can only be invoked on Java objects";
        return (JavaProxy)self;
    }

    static void trySetAccessible(AccessibleObject[] accObjs) {
        if (!Ruby.isSecurityRestricted()) {
            try {
                AccessibleObject.setAccessible(accObjs, true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    void raiseNoMatchingCallableError(String name2, IRubyObject proxy2, Object ... args2) {
        int len = args2.length;
        Object[] argTypes = new Class[args2.length];
        for (int i = 0; i < len; ++i) {
            argTypes[i] = args2[i].getClass();
        }
        throw proxy2.getRuntime().newArgumentError("no " + name2 + " with arguments matching " + Arrays.toString(argTypes) + " on object " + proxy2.getMetaClass());
    }

    protected JavaCallable findCallable(IRubyObject self, String name2, IRubyObject[] args2, int arity2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            Object[] callablesForArity = null;
            if (arity2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[arity2]) == null) {
                if (this.javaVarargsCallables != null) {
                    callable = CallableSelector.matchingCallableArityN(this.cache, this.javaVarargsCallables, args2, arity2);
                    if (callable == null) {
                        throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, this.javaVarargsCallables, args2);
                    }
                    return callable;
                }
                throw self.getRuntime().newArgumentError(args2.length, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityN(this.cache, (JavaCallable[])callablesForArity, args2, arity2);
            if (callable == null && this.javaVarargsCallables != null) {
                callable = CallableSelector.matchingCallableArityN(this.cache, this.javaVarargsCallables, args2, arity2);
                if (callable == null) {
                    throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, this.javaVarargsCallables, args2);
                }
                return callable;
            }
            if (callable == null) {
                throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, callablesForArity, args2);
            }
        } else if (!callable.isVarArgs() && callable.getParameterTypes().length != args2.length) {
            throw self.getRuntime().newArgumentError(args2.length, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityZero(IRubyObject self, String name2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                this.raiseNoMatchingCallableError(name2, self, EMPTY_OBJECT_ARRAY);
            }
            callable = callablesForArity[0];
        } else if (callable.getParameterTypes().length != 0) {
            throw self.getRuntime().newArgumentError(0, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityOne(IRubyObject self, String name2, IRubyObject arg0) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            Object[] callablesForArity = null;
            if (this.javaCallables.length <= 1 || (callablesForArity = this.javaCallables[1]) == null) {
                throw self.getRuntime().newArgumentError(1, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityOne(this.cache, (JavaCallable[])callablesForArity, arg0);
            if (callable == null) {
                throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, callablesForArity, arg0);
            }
        } else if (callable.getParameterTypes().length != 1) {
            throw self.getRuntime().newArgumentError(1, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityTwo(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            Object[] callablesForArity = null;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                throw self.getRuntime().newArgumentError(2, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityTwo(this.cache, (JavaCallable[])callablesForArity, arg0, arg1);
            if (callable == null) {
                throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, callablesForArity, arg0, arg1);
            }
        } else if (callable.getParameterTypes().length != 2) {
            throw self.getRuntime().newArgumentError(2, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityThree(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            Object[] callablesForArity = null;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                throw self.getRuntime().newArgumentError(3, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityThree(this.cache, (JavaCallable[])callablesForArity, arg0, arg1, arg2);
            if (callable == null) {
                throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, callablesForArity, arg0, arg1, arg2);
            }
        } else if (callable.getParameterTypes().length != 3) {
            throw self.getRuntime().newArgumentError(3, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityFour(IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            Object[] callablesForArity = null;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                throw self.getRuntime().newArgumentError(4, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityFour(this.cache, (JavaCallable[])callablesForArity, arg0, arg1, arg2, arg3);
            if (callable == null) {
                throw CallableSelector.argTypesDoNotMatch(self.getRuntime(), self, callablesForArity, arg0, arg1, arg2, arg3);
            }
        } else if (callable.getParameterTypes().length != 4) {
            throw self.getRuntime().newArgumentError(4, callable.getParameterTypes().length);
        }
        return callable;
    }
}

