/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.interpreter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.compiler.ir.IRBuilder;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.compiler_pass.AddBindingInstructions;
import org.jruby.compiler.ir.compiler_pass.CFG_Builder;
import org.jruby.compiler.ir.compiler_pass.IR_Printer;
import org.jruby.compiler.ir.compiler_pass.LiveVariableAnalysis;
import org.jruby.compiler.ir.compiler_pass.opts.DeadCodeElimination;
import org.jruby.compiler.ir.compiler_pass.opts.LocalOptimizationPass;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InlineMethodHint;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Interpreter {
    private static int interpInstrsCount = 0;

    public static IRubyObject interpret(Ruby runtime2, Node rootNode, IRubyObject self) {
        IRScope scope = new IRBuilder().buildRoot((RootNode)rootNode);
        scope.runCompilerPass(new LocalOptimizationPass());
        scope.runCompilerPass(new CFG_Builder());
        scope.runCompilerPass(new LiveVariableAnalysis());
        scope.runCompilerPass(new DeadCodeElimination());
        scope.runCompilerPass(new AddBindingInstructions());
        return Interpreter.interpretTop(runtime2, scope, self);
    }

    public static void main(String[] args2) {
        Ruby runtime2 = Ruby.getGlobalRuntime();
        boolean isDebug = args2.length > 0 && args2[0].equals("-debug");
        int i = isDebug ? 1 : 0;
        boolean isCommandLineScript = args2.length > i && args2[i].equals("-e");
        i += isCommandLineScript ? 1 : 0;
        while (i < args2.length) {
            long t1 = new Date().getTime();
            Node ast = Interpreter.buildAST(runtime2, isCommandLineScript, args2[i]);
            long t2 = new Date().getTime();
            IRScope scope = new IRBuilder().buildRoot((RootNode)ast);
            long t3 = new Date().getTime();
            if (isDebug) {
                System.out.println("## Before local optimization pass");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new LocalOptimizationPass());
            long t4 = new Date().getTime();
            if (isDebug) {
                System.out.println("## After local optimization");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new CFG_Builder());
            long t5 = new Date().getTime();
            if (isDebug) {
                System.out.println("## After dead code elimination");
            }
            scope.runCompilerPass(new LiveVariableAnalysis());
            long t7 = new Date().getTime();
            scope.runCompilerPass(new DeadCodeElimination());
            long t8 = new Date().getTime();
            scope.runCompilerPass(new AddBindingInstructions());
            long t9 = new Date().getTime();
            if (isDebug) {
                scope.runCompilerPass(new IR_Printer());
            }
            Interpreter.interpretTop(runtime2, scope, runtime2.getTopSelf());
            long t10 = new Date().getTime();
            System.out.println("Time to build AST         : " + (t2 - t1));
            System.out.println("Time to build IR          : " + (t3 - t2));
            System.out.println("Time to run local opts    : " + (t4 - t3));
            System.out.println("Time to run build cfg     : " + (t5 - t4));
            System.out.println("Time to run lva           : " + (t7 - t5));
            System.out.println("Time to run dead code elim: " + (t8 - t7));
            System.out.println("Time to add frame instrs  : " + (t9 - t8));
            System.out.println("Time to interpret         : " + (t10 - t9));
            ++i;
        }
    }

    public static Node buildAST(Ruby runtime2, boolean isCommandLineScript, String arg2) {
        if (isCommandLineScript) {
            return runtime2.parse(ByteList.create(arg2), "-e", null, 0, false);
        }
        try {
            System.out.println("-- processing " + arg2 + " --");
            return runtime2.parseFile(new FileInputStream(new File(arg2)), arg2, null, 0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static IRubyObject interpretTop(Ruby runtime2, IRScope scope, IRubyObject self) {
        assert (scope instanceof IRScript) : "Must be an IRScript scope at Top!!!";
        IRScript root = (IRScript)scope;
        if (root.getStaticScope().getModule() == null) {
            root.getStaticScope().setModule(runtime2.getObject());
        }
        IRMethod rootMethod = root.getRootClass().getRootMethod();
        RubyClass metaclass = self.getMetaClass();
        InterpretedIRMethod method2 = new InterpretedIRMethod(rootMethod, metaclass);
        IRubyObject rv = method2.call(runtime2.getCurrentContext(), self, (RubyModule)metaclass, "", new IRubyObject[0]);
        System.out.println("-- Interpreted " + interpInstrsCount + " instructions");
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject interpret(ThreadContext context, CFG cfg, InterpreterContext interp) {
        IRubyObject iRubyObject;
        boolean inClosure = cfg.getScope() instanceof IRClosure;
        try {
            interp.setMethodExitLabel(cfg.getExitBB().getLabel());
            IRubyObject self = (IRubyObject)interp.getSelf();
            Instr[] instrs = cfg.prepareForInterpretation();
            int n = instrs.length;
            int ipc = 0;
            Instr lastInstr = null;
            while (ipc < n) {
                ++interpInstrsCount;
                lastInstr = instrs[ipc];
                Label jumpTarget = lastInstr.interpret(interp, self);
                ipc = jumpTarget == null ? ipc + 1 : jumpTarget.getTargetPC();
            }
            IRubyObject rv = (IRubyObject)interp.getReturnValue();
            if (inClosure && lastInstr instanceof ReturnInstr) {
                throw context.returnJump(rv);
            }
            iRubyObject = rv;
            Object var12_13 = null;
        }
        catch (JumpException.ReturnJump rj) {
            try {
                if (inClosure) {
                    throw rj;
                }
                IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                Object var12_14 = null;
                if (interp.getFrame() != null) {
                    context.popFrame();
                    interp.setFrame(null);
                }
                if (interp.hasAllocatedDynamicScope()) {
                    context.postMethodScopeOnly();
                }
                return iRubyObject2;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var12_15 = null;
                    if (interp.getFrame() != null) {
                        context.popFrame();
                        interp.setFrame(null);
                    }
                    if (!interp.hasAllocatedDynamicScope()) break block12;
                    context.postMethodScopeOnly();
                }
                throw throwable;
            }
        }
        if (interp.getFrame() != null) {
            context.popFrame();
            interp.setFrame(null);
        }
        if (interp.hasAllocatedDynamicScope()) {
            context.postMethodScopeOnly();
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject interpret_with_inline(ThreadContext context, CFG cfg, InterpreterContext interp) {
        try {
            BasicBlock basicBlock = cfg.getEntryBB();
            Instr skipTillInstr = null;
            while (basicBlock != null) {
                Label jumpTarget = null;
                Instr prev = null;
                for (Instr instruction : basicBlock.getInstrs()) {
                    if (skipTillInstr != null && instruction != skipTillInstr) continue;
                    skipTillInstr = null;
                    ++interpInstrsCount;
                    try {
                        jumpTarget = instruction.interpret(interp, (IRubyObject)interp.getSelf());
                    }
                    catch (InlineMethodHint ih) {
                        if (ih.inlineableMethod.getName() == "array_each") {
                            System.out.println("Got inline method hint for: " + ih.inlineableMethod.getFullyQualifiedName() + ". inlining!");
                            cfg.inlineMethod(ih.inlineableMethod, basicBlock, (CallInstr)instruction);
                            interp.updateRenamedVariablesCount(cfg.getScope().getRenamedVariableSize());
                            skipTillInstr = prev;
                            break;
                        }
                        jumpTarget = instruction.interpret(interp, (IRubyObject)interp.getSelf());
                    }
                    prev = instruction;
                }
                if (skipTillInstr != null) continue;
                basicBlock = jumpTarget == null ? cfg.getFallThroughBB(basicBlock) : cfg.getTargetBB(jumpTarget);
            }
            IRubyObject iRubyObject = (IRubyObject)interp.getReturnValue();
            Object var11_10 = null;
            if (interp.getFrame() != null) {
                context.popFrame();
                interp.setFrame(null);
            }
            if (interp.hasAllocatedDynamicScope()) {
                context.postMethodScopeOnly();
            }
            return iRubyObject;
        }
        catch (Throwable throwable) {
            block10: {
                Object var11_11 = null;
                if (interp.getFrame() != null) {
                    context.popFrame();
                    interp.setFrame(null);
                }
                if (!interp.hasAllocatedDynamicScope()) break block10;
                context.postMethodScopeOnly();
            }
            throw throwable;
        }
    }
}

