/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jruby.compiler.ir.instructions.ClosureReturnInstr;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.ReceiveClosureArgInstr;
import org.jruby.compiler.ir.instructions.YieldInstr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.CFG;
import org.jruby.compiler.ir.representations.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBlock {
    int _id;
    CFG _cfg;
    Label _label;
    List<Instr> _instrs = new ArrayList<Instr>();
    boolean _isLive;
    private Instr[] _instrsArray = null;

    public BasicBlock(CFG c, Label l) {
        this._label = l;
        this._isLive = true;
        this._cfg = c;
        this._id = c.getNextBBID();
    }

    public void updateCFG(CFG c) {
        this._cfg = c;
        this._id = c.getNextBBID();
    }

    public int getID() {
        return this._id;
    }

    public Label getLabel() {
        return this._label;
    }

    public void addInstr(Instr i) {
        this._instrs.add(i);
    }

    public void insertInstr(Instr i) {
        this._instrs.add(0, i);
    }

    public List<Instr> getInstrs() {
        return this._instrs;
    }

    public Instr[] getInstrsArray() {
        if (this._instrsArray == null) {
            this._instrsArray = this._instrs.toArray(new Instr[this._instrs.size()]);
        }
        return this._instrsArray;
    }

    public Instr getLastInstr() {
        int n = this._instrs.size();
        return n == 0 ? null : this._instrs.get(n - 1);
    }

    public boolean removeInstr(Instr i) {
        if (i == null) {
            return false;
        }
        return this._instrs.remove(i);
    }

    public boolean isEmpty() {
        return this._instrs.isEmpty();
    }

    public BasicBlock splitAtInstruction(Instr splitPoint, Label newLabel, boolean includeSplitPointInstr) {
        BasicBlock newBB = new BasicBlock(this._cfg, newLabel);
        int idx = 0;
        int numInstrs = this._instrs.size();
        boolean found = false;
        for (Instr i : this._instrs) {
            if (i == splitPoint) {
                found = true;
            }
            if (found) {
                if (!includeSplitPointInstr && i == splitPoint) continue;
                newBB.addInstr(i);
                continue;
            }
            ++idx;
        }
        for (int j = 0; j < numInstrs - idx; ++j) {
            this._instrs.remove(idx);
        }
        return newBB;
    }

    public void swallowBB(BasicBlock foodBB) {
        this._instrs.addAll(foodBB._instrs);
    }

    public BasicBlock cloneForInlining(InlinerInfo ii) {
        BasicBlock clonedBB = ii.getOrCreateRenamedBB(this);
        for (Instr i : this.getInstrs()) {
            Instr clonedInstr = i.cloneForInlining(ii);
            clonedBB.addInstr(clonedInstr);
            if (!(clonedInstr instanceof YieldInstr)) continue;
            ii.recordYieldSite(clonedBB, (YieldInstr)clonedInstr);
        }
        return clonedBB;
    }

    public void processClosureArgAndReturnInstrs(InlinerInfo ii, YieldInstr yi) {
        Variable yieldResult = ii.getRenamedVariable(yi.result);
        Operand[] yieldArgs = yi.getOperands();
        ListIterator<CopyInstr> it = ((ArrayList)this._instrs).listIterator();
        while (it.hasNext()) {
            Operand closureArg;
            Instr i = (Instr)it.next();
            if (i instanceof ClosureReturnInstr) {
                it.set(new CopyInstr(yieldResult, ((ClosureReturnInstr)i).getArg()));
                continue;
            }
            if (!(i instanceof ReceiveClosureArgInstr)) continue;
            ReceiveClosureArgInstr rcai = (ReceiveClosureArgInstr)i;
            int argIndex = rcai.argIndex;
            boolean restOfArgs = rcai.restOfArgArray;
            if (argIndex < yieldArgs.length) {
                closureArg = yieldArgs[argIndex].cloneForInlining(ii);
            } else if (argIndex >= yieldArgs.length) {
                closureArg = new Array();
            } else {
                Operand[] tmp = new Operand[yieldArgs.length - argIndex];
                for (int j = argIndex; j < yieldArgs.length; ++j) {
                    tmp[j - argIndex] = yieldArgs[j].cloneForInlining(ii);
                }
                closureArg = new Array(tmp);
            }
            it.set(new CopyInstr(rcai.result, closureArg));
        }
    }

    public String toString() {
        return "BB [" + this._id + ":" + this._label + "]";
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder(this.toString() + "\n");
        for (Instr instr : this.getInstrs()) {
            if (instr.isDead()) continue;
            buf.append('\t').append(instr).append('\n');
        }
        return buf.toString();
    }
}

