/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.PutInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StoreToBindingInstr
extends PutInstr {
    private int bindingSlot;

    public StoreToBindingInstr(IRExecutionScope scope, String slotName, Operand value2) {
        super(Operation.BINDING_STORE, MetaObject.create(scope.getClosestMethodAncestor()), slotName, value2);
        MetaObject mo = (MetaObject)this.getTarget();
        IRMethod m = (IRMethod)mo.scope;
        this.bindingSlot = m.assignBindingSlot(slotName);
    }

    public String toString() {
        return "\tBINDING(" + this.operands[1] + ")." + this.ref + " = " + this.operands[0];
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new StoreToBindingInstr((IRExecutionScope)((MetaObject)this.operands[1]).scope, this.ref, this.operands[0].cloneForInlining(ii));
    }

    private IRScope getIRScope(Operand scopeHolder) {
        assert (scopeHolder instanceof MetaObject) : "Target should be a MetaObject";
        return ((MetaObject)scopeHolder).getScope();
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        LocalVariable v = (LocalVariable)this.getValue();
        IRMethod m = (IRMethod)this.getIRScope(this.getTarget());
        if (this.bindingSlot == -1) {
            this.bindingSlot = m.getBindingSlot(v.getName());
        }
        interp.setSharedBindingVariable(this.bindingSlot, interp.getLocalVariable(v.getLocation()));
        return null;
    }
}

