/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.DataFlowVar;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVariableNode
extends FlowGraphNode {
    private BitSet _in;
    private BitSet _out;
    private BitSet _tmp;
    private int _setSize;

    public LiveVariableNode(DataFlowProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this._setSize = this._prob.getDFVarsCount();
        this._in = new BitSet(this._setSize);
    }

    private void addDFVar(Variable v) {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        if (v != null && lvp.getDFVar(v) == null) {
            lvp.addDFVar(v);
        }
    }

    @Override
    public void buildDataFlowVars(Instr i) {
        this.addDFVar(i.getResult());
        for (Variable x : i.getUsedVariables()) {
            this.addDFVar(x);
        }
    }

    @Override
    public void initSolnForNode() {
        Collection<Variable> lv;
        LiveVariablesProblem p2 = (LiveVariablesProblem)this._prob;
        this._tmp = new BitSet(this._setSize);
        if (this._bb == p2.getCFG().getExitBB() && (lv = p2.getVarsLiveOnExit()) != null && !lv.isEmpty()) {
            for (Variable v : lv) {
                this._tmp.set(p2.getDFVar((Variable)v)._id);
            }
        }
    }

    @Override
    public void compute_MEET(CFG.CFG_Edge edge, FlowGraphNode pred2) {
        this._tmp.or(((LiveVariableNode)pred2)._in);
    }

    private LiveVariablesProblem processClosure(IRClosure cl, Collection<Variable> liveOnEntry) {
        CFG c = cl.getCFG();
        LiveVariablesProblem lvp = new LiveVariablesProblem();
        lvp.initVarsLiveOnExit(liveOnEntry);
        lvp.setup(c);
        lvp.compute_MOP_Solution();
        c.setDataFlowSolution(lvp.getName(), lvp);
        return lvp;
    }

    @Override
    public boolean applyTransferFunction() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        this._out = (BitSet)this._tmp.clone();
        List<Instr> instrs = this._bb.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i = it.previous();
            Variable v = i.getResult();
            if (v != null) {
                DataFlowVar dv = lvp.getDFVar(v);
                this._tmp.clear(dv._id);
            }
            if (i instanceof CallInstr) {
                CallInstr c = (CallInstr)i;
                Operand o = c.getClosureArg();
                if (o != null && o instanceof MetaObject) {
                    IRClosure cl = (IRClosure)((MetaObject)o).scope;
                    if (c.isLVADataflowBarrier()) {
                        this.processClosure(cl, lvp.getAllVars());
                        for (int j = 0; j < this._setSize; ++j) {
                            this._tmp.set(j);
                        }
                    } else {
                        ArrayList<Variable> liveVars = new ArrayList<Variable>();
                        for (int j = 0; j < this._tmp.size(); ++j) {
                            if (!this._tmp.get(j)) continue;
                            liveVars.add(lvp.getVariable(j));
                        }
                        LiveVariablesProblem xlvp = this.processClosure(cl, liveVars);
                        for (Variable y : xlvp.getVarsLiveOnEntry()) {
                            DataFlowVar dv = lvp.getDFVar(y);
                            if (dv == null) continue;
                            this._tmp.set(dv._id);
                        }
                    }
                } else if (c.isLVADataflowBarrier()) {
                    for (int j = 0; j < this._setSize; ++j) {
                        this._tmp.set(j);
                    }
                }
            }
            for (Variable x : i.getUsedVariables()) {
                DataFlowVar dv = lvp.getDFVar(x);
                if (dv == null) continue;
                this._tmp.set(dv._id);
            }
        }
        if (this._tmp.equals(this._in)) {
            return false;
        }
        this._in = this._tmp;
        return true;
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("\tVars Live on Entry: ");
        int count2 = 0;
        for (i = 0; i < this._in.size(); ++i) {
            if (!this._in.get(i)) continue;
            buf.append(' ').append(i);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        buf.append("\n\tVars Live on Exit: ");
        count2 = 0;
        for (i = 0; i < this._out.size(); ++i) {
            if (!this._out.get(i)) continue;
            buf.append(' ').append(i);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    void markDeadInstructions() {
        LiveVariablesProblem lvp = (LiveVariablesProblem)this._prob;
        if (this._out == null) {
            for (Instr i : this._bb.getInstrs()) {
                i.markDead();
            }
            return;
        }
        this._tmp = (BitSet)this._out.clone();
        List<Instr> instrs = this._bb.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i = it.previous();
            Variable v = i.getResult();
            if (v != null) {
                DataFlowVar dv = lvp.getDFVar(v);
                if (!this._tmp.get(dv._id) && !i.hasSideEffects()) {
                    i.markDead();
                    it.remove();
                } else if (this._tmp.get(dv._id)) {
                    this._tmp.clear(dv._id);
                }
            }
            if (i instanceof CallInstr) {
                CallInstr c = (CallInstr)i;
                if (c.isLVADataflowBarrier()) {
                    for (int j = 0; j < this._setSize; ++j) {
                        this._tmp.set(j);
                    }
                } else {
                    Operand o = c.getClosureArg();
                    if (o != null && o instanceof MetaObject) {
                        IRClosure cl = (IRClosure)((MetaObject)o).scope;
                        CFG x = cl.getCFG();
                        LiveVariablesProblem xlvp = (LiveVariablesProblem)x.getDataFlowSolution(lvp.getName());
                        for (Variable y : xlvp.getVarsLiveOnEntry()) {
                            DataFlowVar dv = lvp.getDFVar(y);
                            if (dv == null) continue;
                            this._tmp.set(dv._id);
                        }
                    }
                }
            }
            if (i.isDead()) continue;
            for (Variable x : i.getUsedVariables()) {
                DataFlowVar dv = lvp.getDFVar(x);
                if (dv == null) continue;
                this._tmp.set(dv._id);
            }
        }
    }

    BitSet getLiveInBitSet() {
        return this._in;
    }

    BitSet getLiveOutBitSet() {
        return this._out;
    }
}

