/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import jruby.objectweb.asm.ClassReader;
import jruby.objectweb.asm.util.TraceClassVisitor;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassCache;
import org.jruby.util.JavaNameMangler;

public class JITCompiler
implements JITCompilerMBean {
    public static final boolean USE_CACHE = true;
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    private final JITCounts counts = new JITCounts();

    public JITCompiler(Ruby ruby2) {
        ruby2.getBeanManager().register(this);
    }

    public DynamicMethod tryJIT(DefaultMethod method2, ThreadContext context, String name2) {
        if (context.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            return this.jitIsEnabled(method2, context, name2);
        }
        return null;
    }

    private DynamicMethod jitIsEnabled(DefaultMethod method2, ThreadContext context, String name2) {
        RubyInstanceConfig instanceConfig = context.getRuntime().getInstanceConfig();
        if (method2.incrementCallCount() >= instanceConfig.getJitThreshold()) {
            return this.jitThresholdReached(method2, instanceConfig, context, name2);
        }
        return null;
    }

    private DynamicMethod jitThresholdReached(DefaultMethod method2, RubyInstanceConfig instanceConfig, ThreadContext context, String name2) {
        try {
            int methodCount;
            ClassCache classCache = instanceConfig.getClassCache();
            if (classCache.isFull()) {
                this.counts.abandonCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            String moduleName = method2.getImplementationClass().getName();
            if (instanceConfig.getExcludedMethods().size() > 0) {
                IRubyObject possibleRealClass;
                String excludeModuleName = moduleName;
                if (method2.getImplementationClass().isSingleton() && (possibleRealClass = ((MetaClass)method2.getImplementationClass()).getAttached()) instanceof RubyModule) {
                    excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                }
                if (instanceConfig.getExcludedMethods().contains(excludeModuleName) || instanceConfig.getExcludedMethods().contains(excludeModuleName + "#" + name2) || instanceConfig.getExcludedMethods().contains(name2)) {
                    method2.setCallCount(-1);
                    return null;
                }
            }
            String key2 = SexpMaker.create(name2, method2.getArgsNode(), method2.getBodyNode());
            JITClassGenerator generator = new JITClassGenerator(name2, key2, context.getRuntime(), method2, context, this.counts);
            Class sourceClass = instanceConfig.getClassCache().cacheClassByKey(key2, generator);
            if (sourceClass == null) {
                this.counts.failCount.incrementAndGet();
                method2.setCallCount(-1);
                return null;
            }
            this.counts.successCount.incrementAndGet();
            Script jitCompiledScript = (Script)sourceClass.newInstance();
            Set<Script> jittedMethods = context.getRuntime().getJittedMethods();
            jittedMethods.add(jitCompiledScript);
            if (instanceConfig.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % instanceConfig.getJitLogEvery() == 0) {
                JITCompiler.log(method2, name2, "live compiled methods: " + methodCount, new String[0]);
            }
            if (instanceConfig.isJitLogging()) {
                JITCompiler.log(method2, name2, "done jitting", new String[0]);
            }
            method2.switchToJitted(jitCompiledScript, generator.callConfig());
            return null;
        }
        catch (Throwable t) {
            if (context.getRuntime().getDebug().isTrue()) {
                t.printStackTrace();
            }
            if (instanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(method2, name2, "could not compile", t.getMessage());
            }
            this.counts.failCount.incrementAndGet();
            method2.setCallCount(-1);
            return null;
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            byte[] digest2 = sha1.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < digest2.length; ++i) {
                builder.append(Integer.toString((digest2[i] & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveToCodeCache(Ruby ruby2, byte[] bytecode, String packageName, File cachedClassFile) {
        block16: {
            FileOutputStream fos;
            String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
            File codeCacheDir = new File(codeCache);
            if (!codeCacheDir.exists()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " does not exist");
            } else if (!codeCacheDir.isDirectory()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not a directory");
            } else if (!codeCacheDir.canWrite()) {
                ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not writable");
            } else {
                boolean createdDirs;
                if (!new File(codeCache, packageName).isDirectory() && !(createdDirs = new File(codeCache, packageName).mkdirs())) {
                    ruby2.getWarnings().warn("could not create JIT cache dir: " + new File(codeCache, packageName));
                }
                fos = null;
                if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                    System.err.println("writing jitted code to to " + cachedClassFile);
                }
                fos = new FileOutputStream(cachedClassFile);
                fos.write(bytecode);
                Object var9_8 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {}
            }
            break block16;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_9 = null;
                    try {
                        fos.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    fos.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method2, String name2, String message2, String ... reason2) {
        String className = method2.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        System.err.print(message2 + ":" + className + "." + name2 + " at " + method2.getPosition());
        if (reason2.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < reason2.length; ++i) {
                System.err.print(reason2[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    public long getFailCount() {
        return this.counts.failCount.get();
    }

    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    public long getAverageCodeSize() {
        return this.counts.averageCodeSize.get();
    }

    public long getAverageCompileTime() {
        return this.counts.averageCompileTime.get() / 1000L;
    }

    public long getLargestCodeSize() {
        return this.counts.largestCodeSize.get();
    }

    public static class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private final StandardASMCompiler asmCompiler;
        private final StaticScope staticScope;
        private final Node bodyNode;
        private final ArgsNode argsNode;
        private final Ruby ruby;
        private final String packageName;
        private final String className;
        private final String filename;
        private final String methodName;
        private final JITCounts counts;
        private final String digestString;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String name2, String key2, Ruby ruby2, DefaultMethod method2, ThreadContext context, JITCounts counts) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = JITCompiler.getHashForString(key2);
            this.className = this.packageName + "/" + JavaNameMangler.mangleMethodName(name2) + "_" + this.digestString;
            this.name = this.className.replaceAll("/", ".");
            this.bodyNode = method2.getBodyNode();
            this.argsNode = method2.getArgsNode();
            this.methodName = name2;
            this.filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method2.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(this.className, this.filename);
            this.ruby = ruby2;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void compile() {
            block23: {
                if (this.bytecode != null) {
                    return;
                }
                codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
                cachedClassFile = new File(codeCache + "/" + this.className + ".class");
                if (codeCache != null && cachedClassFile.exists()) {
                    fis = null;
                    try {
                        try {
                            if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                                System.err.println("loading cached code from: " + cachedClassFile);
                            }
                            fis = new FileInputStream(cachedClassFile);
                            this.bytecode = new byte[(int)fis.getChannel().size()];
                            fis.read(this.bytecode);
                            this.name = new ClassReader(this.bytecode).getClassName();
                            var6_4 = null;
                        }
                        catch (Exception e) {
                            var6_5 = null;
                            try {
                                fis.close();
                            }
                            catch (Exception e) {}
                            break block23;
                        }
                    }
                    catch (Throwable var5_11) {
                        var6_6 = null;
                        ** try [egrp 2[TRYBLOCK] [4 : 167->174)] { 
lbl31:
                        // 1 sources

                        fis.close();
                        throw var5_11;
lbl33:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var5_11;
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 167->174)] { 
lbl38:
                    // 1 sources

                    fis.close();
                    return;
lbl40:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
            }
            start = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            compiler = this.ruby.getInstanceConfig().newCompiler();
            args = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context, true);
                }
            };
            inspector = new ASTInspector();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                inspector = new ASTInspector(this.className, true);
            }
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startFileMethod(args, this.staticScope, inspector);
                compiler.compileBody(this.bodyNode, methodCompiler, true);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startFileMethod(args, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startFileMethod(null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.FrameNoneScopeNone;
            }
            methodCompiler.endBody();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.getCallConfig();
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                tcv = new TraceClassVisitor(new PrintWriter(System.out));
                new ClassReader(this.bytecode).accept(tcv, 0);
            }
            if (this.bytecode.length > this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + this.ruby.getInstanceConfig().getJitMaxSize());
            }
            if (codeCache != null) {
                JITCompiler.saveToCodeCache(this.ruby, this.bytecode, this.packageName, cachedClassFile);
            }
            JITCounts.access$500(this.counts).incrementAndGet();
            JITCounts.access$600(this.counts).addAndGet(System.nanoTime() - start);
            JITCounts.access$700(this.counts).addAndGet(this.bytecode.length);
            JITCounts.access$800(this.counts).set(JITCounts.access$600(this.counts).get() / JITCounts.access$500(this.counts).get());
            JITCounts.access$900(this.counts).set(JITCounts.access$700(this.counts).get() / JITCounts.access$500(this.counts).get());
            var11_15 = this.counts;
            synchronized (var11_15) {
                if (JITCounts.access$1000(this.counts).get() >= (long)this.bytecode.length) return;
                JITCounts.access$1000(this.counts).set(this.bytecode.length);
                return;
            }
        }

        public void generate() {
            this.compile();
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }

        public String toString() {
            return this.methodName + "() at " + this.bodyNode.getPosition().getFile() + ":" + this.bodyNode.getPosition().getLine();
        }
    }

    public static class JITCounts {
        private final AtomicLong compiledCount = new AtomicLong(0L);
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failCount = new AtomicLong(0L);
        private final AtomicLong abandonCount = new AtomicLong(0L);
        private final AtomicLong compileTime = new AtomicLong(0L);
        private final AtomicLong averageCompileTime = new AtomicLong(0L);
        private final AtomicLong codeSize = new AtomicLong(0L);
        private final AtomicLong averageCodeSize = new AtomicLong(0L);
        private final AtomicLong largestCodeSize = new AtomicLong(0L);
    }
}

