/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public abstract class DNode
extends ListNode {
    protected Encoding encoding;

    public DNode(ISourcePosition position) {
        this(position, (Encoding)null);
    }

    public DNode(ISourcePosition position, Encoding encoding2) {
        super(position);
        this.encoding = encoding2;
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.buildDynamicString(runtime2, context, self, aBlock);
    }

    public boolean is19() {
        return this.encoding != null;
    }

    public boolean isSameEncoding(StrNode strNode) {
        return strNode.getValue().getEncoding() == this.encoding;
    }

    protected RubyString allocateString(Ruby runtime2) {
        ByteList empty2 = new ByteList();
        if (this.is19()) {
            empty2.setEncoding(this.encoding);
        }
        return runtime2.newString(empty2);
    }

    public void appendToString(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock, RubyString string2, Node node) {
        if (node instanceof StrNode && (!this.is19() || this.isSameEncoding((StrNode)node))) {
            string2.getByteList().append(((StrNode)node).getValue());
        } else if (this.is19()) {
            string2.append19(node.interpret(runtime2, context, self, aBlock));
        } else {
            string2.append(node.interpret(runtime2, context, self, aBlock));
        }
    }

    public RubyString buildDynamicString(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyString string2 = this.allocateString(runtime2);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            this.appendToString(runtime2, context, self, aBlock, string2, this.get(i));
        }
        return string2;
    }

    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String definition = super.definition(runtime2, context, self, aBlock);
        return this.is19() && definition == null ? "expression" : definition;
    }
}

