/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    private IRubyObject[] values;
    private static ObjectAllocator STRUCT_INSTANCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyStruct instance = new RubyStruct(runtime2, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public RubyStruct(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
        int size2 = RubyNumeric.fix2int(RubyStruct.getInternalVariable(rubyClass, "__size__"));
        this.values = new IRubyObject[size2];
        for (int i = 0; i < size2; ++i) {
            this.values[i] = this.getRuntime().getNil();
        }
    }

    public static RubyClass createStructClass(Ruby runtime2) {
        RubyClass structClass = runtime2.defineClass("Struct", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setStructClass(structClass);
        structClass.index = 15;
        structClass.includeModule(runtime2.getEnumerable());
        structClass.defineAnnotatedMethods(RubyStruct.class);
        return structClass;
    }

    public int getNativeTypeIndex() {
        return 15;
    }

    private static IRubyObject getInternalVariable(RubyClass type2, String internedName) {
        RubyClass structClass = type2.getRuntime().getStructClass();
        while (type2 != null && type2 != structClass) {
            IRubyObject variable = (IRubyObject)type2.fastGetInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type2 = type2.getSuperClass();
        }
        return type2.getRuntime().getNil();
    }

    private RubyClass classOf() {
        return this.getMetaClass() instanceof MetaClass ? this.getMetaClass().getSuperClass() : this.getMetaClass();
    }

    private void modify() {
        this.testFrozen();
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify struct");
        }
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = this.getRuntime();
        int h = this.getMetaClass().getRealClass().hashCode();
        for (int i = 0; i < this.values.length; ++i) {
            h = h << 1 | (h < 0 ? 1 : 0);
            h = (int)((long)h ^ RubyNumeric.num2long(this.values[i].callMethod(context, "hash")));
        }
        return runtime2.newFixnum(h);
    }

    private IRubyObject setByName(String name2, IRubyObject value2) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        this.modify();
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asJavaString().equals(name2)) continue;
            this.values[i] = value2;
            return this.values[i];
        }
        throw this.notStructMemberError(name2);
    }

    private IRubyObject getByName(String name2) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (!member.eltInternal(i).asJavaString().equals(name2)) continue;
            return this.values[i];
        }
        throw this.notStructMemberError(name2);
    }

    @JRubyMethod(name={"new"}, required=1, rest=true, meta=true)
    public static RubyClass newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        int i;
        RubyClass newStruct2;
        int i2;
        String name2 = null;
        boolean nilName = false;
        Ruby runtime2 = recv2.getRuntime();
        if (args2.length > 0) {
            IRubyObject firstArgAsString = args2[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                name2 = ((RubyString)firstArgAsString).getByteList().toString();
            } else if (args2[0].isNil()) {
                nilName = true;
            }
        }
        RubyArray member = runtime2.newArray();
        int n = i2 = name2 == null && !nilName ? 0 : 1;
        while (i2 < args2.length) {
            member.append(runtime2.newSymbol(args2[i2].asJavaString()));
            ++i2;
        }
        RubyClass superClass = (RubyClass)recv2;
        if (name2 == null || nilName) {
            newStruct2 = RubyClass.newClass(runtime2, superClass);
            newStruct2.setAllocator(STRUCT_INSTANCE_ALLOCATOR);
            newStruct2.makeMetaClass(superClass.getMetaClass());
            newStruct2.inherit(superClass);
        } else {
            if (!IdUtil.isConstant(name2)) {
                throw runtime2.newNameError("identifier " + name2 + " needs to be constant", name2);
            }
            IRubyObject type2 = superClass.getConstantAt(name2);
            if (type2 != null) {
                ThreadContext context = runtime2.getCurrentContext();
                runtime2.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, context.getFile(), context.getLine(), "redefining constant Struct::" + name2, name2);
                superClass.remove_const(context, runtime2.newString(name2));
            }
            newStruct2 = superClass.defineClassUnder(name2, superClass, STRUCT_INSTANCE_ALLOCATOR);
        }
        newStruct2.setReifiedClass(RubyStruct.class);
        newStruct2.index = 15;
        newStruct2.fastSetInternalVariable("__size__", member.length());
        newStruct2.fastSetInternalVariable("__member__", member);
        newStruct2.getSingletonClass().defineAnnotatedMethods(StructMethods.class);
        int n2 = i = name2 == null && !nilName ? 0 : 1;
        while (i < args2.length) {
            String memberName = args2[i].asJavaString();
            final int index2 = name2 == null && !nilName ? i : i - 1;
            newStruct2.addMethod(memberName, new DynamicMethod((RubyModule)newStruct2, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    Arity.checkArgumentCount(self.getRuntime(), args2, 0, 0);
                    return ((RubyStruct)self).get(index2);
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                    return ((RubyStruct)self).get(index2);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            newStruct2.addMethod(memberName + "=", new DynamicMethod((RubyModule)newStruct2, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    Arity.checkArgumentCount(self.getRuntime(), args2, 1, 1);
                    return ((RubyStruct)self).set(args2[0], index2);
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                    return ((RubyStruct)self).set(arg2, index2);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
            ++i;
        }
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(runtime2.getCurrentContext(), null, newStruct2, newStruct2);
        }
        return newStruct2;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(args2, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, block);
        return struct;
    }

    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyStruct struct = new RubyStruct(recv2.getRuntime(), (RubyClass)recv2);
        struct.callInit(arg0, arg1, arg2, block);
        return struct;
    }

    private void checkSize(int length2) {
        if (length2 > this.values.length) {
            throw this.getRuntime().newArgumentError("struct size differs (" + length2 + " for " + this.values.length + ")");
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.modify();
        this.checkSize(args2.length);
        System.arraycopy(args2, 0, this.values, 0, args2.length);
        RuntimeHelpers.fillNil(this.values, args2.length, this.values.length, context.runtime);
        return context.nil;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 0, nil, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 1, arg0, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.initializeInternal(context, 2, arg0, arg1, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.initializeInternal(context, 3, arg0, arg1, arg2);
    }

    public IRubyObject initializeInternal(ThreadContext context, int provided, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modify();
        this.checkSize(provided);
        switch (provided) {
            case 3: {
                this.values[2] = arg2;
            }
            case 2: {
                this.values[1] = arg1;
            }
            case 1: {
                this.values[0] = arg0;
            }
        }
        if (provided < this.values.length) {
            RuntimeHelpers.fillNil(this.values, provided, this.values.length, context.runtime);
        }
        return this.getRuntime().getNil();
    }

    public static RubyArray members(IRubyObject recv2, Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable((RubyClass)recv2, "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        RubyArray result = recv2.getRuntime().newArray(member.getLength());
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            result.append(recv2.getRuntime().newString(member.eltInternal(i).asJavaString()));
        }
        return result;
    }

    @JRubyMethod
    public RubyArray members() {
        return RubyStruct.members(this.classOf(), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public RubyArray select(ThreadContext context, Block block) {
        RubyArray array = RubyArray.newArray(context.getRuntime());
        for (int i = 0; i < this.values.length; ++i) {
            if (!block.yield(context, this.values[i]).isTrue()) continue;
            array.append(this.values[i]);
        }
        return array;
    }

    public IRubyObject set(IRubyObject value2, int index2) {
        this.modify();
        this.values[index2] = value2;
        return this.values[index2];
    }

    private RaiseException notStructMemberError(String name2) {
        return this.getRuntime().newNameError(name2 + " is not struct member", name2);
    }

    public IRubyObject get(int index2) {
        return this.values[index2];
    }

    public void copySpecialInstanceVariables(IRubyObject clone) {
        RubyStruct struct = (RubyStruct)clone;
        struct.values = new IRubyObject[this.values.length];
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass().getRealClass() != other.getMetaClass().getRealClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime2 = this.getRuntime();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.equalInternal(context, this.values[i], otherStruct.values[i])) continue;
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.getRuntime().getFalse();
        }
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime2 = this.getRuntime();
        RubyStruct otherStruct = (RubyStruct)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (RubyStruct.eqlInternal(context, this.values[i], otherStruct.values[i])) continue;
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    private IRubyObject inspectStruct(ThreadContext context) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        ByteList buffer = new ByteList("#<struct ".getBytes());
        buffer.append(this.getMetaClass().getRealClass().getRealClass().getName().getBytes());
        buffer.append(32);
        int k = member.getLength();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                buffer.append(44).append(32);
            }
            buffer.append(RubyString.objAsString(context, member.eltInternal(i)).getByteList());
            buffer.append(61);
            buffer.append(RubyStruct.inspect(context, this.values[i]).getByteList());
        }
        buffer.append(62);
        return this.getRuntime().newString(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("#<struct " + this.getMetaClass().getRealClass().getName() + ":...>");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectStruct(context);
            Object var4_3 = null;
            this.getRuntime().unregisterInspecting(this);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getRuntime().unregisterInspecting(this);
            throw throwable;
        }
    }

    @JRubyMethod(name={"to_a", "values"})
    public RubyArray to_a() {
        return this.getRuntime().newArray(this.values);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size() {
        return this.getRuntime().newFixnum(this.values.length);
    }

    public IRubyObject eachInternal(ThreadContext context, Block block) {
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.values[i]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    public IRubyObject each_pairInternal(ThreadContext context, Block block) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(this.classOf(), "__member__");
        assert (!member.isNil()) : "uninitialized struct";
        for (int i = 0; i < this.values.length; ++i) {
            block.yield(context, this.getRuntime().newArrayNoCopy(member.eltInternal(i), this.values[i]));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairInternal(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_pair");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject key2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            return this.getByName(key2.asJavaString());
        }
        int idx = RubyNumeric.fix2int(key2);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            return this.setByName(key2.asJavaString(), value2);
        }
        int idx = RubyNumeric.fix2int(key2);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw this.getRuntime().newIndexError("offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value2;
        return this.values[idx];
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        int olen = this.values.length;
        RubyArray result = this.getRuntime().newArray(args2.length);
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyFixnum) {
                result.append(this.aref(args2[i]));
                continue;
            }
            if (args2[i] instanceof RubyRange) {
                int len;
                int[] beglen = ((RubyRange)args2[i]).begLenInt(olen, 0);
                if (beglen == null) continue;
                int beg = beglen[0];
                int end2 = len = beglen[1];
                for (int j = 0; j < end2; ++j) {
                    result.append(this.aref(this.getRuntime().newFixnum(j + beg)));
                }
                continue;
            }
            result.append(this.aref(this.getRuntime().newFixnum(RubyNumeric.num2long(args2[i]))));
        }
        return result;
    }

    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader('S', struct.getMetaClass());
        RubyArray array = (RubyArray)RubyStruct.getInternalVariable(struct.classOf(), "__member__");
        output.writeInt(array.size());
        for (int i = 0; i < array.size(); ++i) {
            RubySymbol name2 = (RubySymbol)array.eltInternal(i);
            output.dumpObject(name2);
            output.dumpObject(struct.values[i]);
        }
    }

    public static RubyStruct unmarshalFrom(UnmarshalStream input) throws IOException {
        IRubyObject[] values;
        RubySymbol className;
        Ruby runtime2 = input.getRuntime();
        RubyClass rbClass = RubyStruct.pathToClass(runtime2, (className = (RubySymbol)input.unmarshalObject(false)).asJavaString());
        if (rbClass == null) {
            throw runtime2.newNameError("uninitialized constant " + className, className.asJavaString());
        }
        RubyArray mem = RubyStruct.members(rbClass, Block.NULL_BLOCK);
        int len = input.unmarshalInt();
        if (len == 0) {
            values = IRubyObject.NULL_ARRAY;
        } else {
            values = new IRubyObject[len];
            RuntimeHelpers.fillNil(values, runtime2);
        }
        RubyStruct result = RubyStruct.newStruct((IRubyObject)rbClass, values, Block.NULL_BLOCK);
        input.registerLinkTarget(result);
        for (int i = 0; i < len; ++i) {
            IRubyObject slot = input.unmarshalObject(false);
            if (!mem.eltInternal(i).toString().equals(slot.toString())) {
                throw runtime2.newTypeError("struct " + rbClass.getName() + " not compatible (:" + slot + " for :" + mem.eltInternal(i) + ")");
            }
            result.aset(runtime2.newFixnum(i), input.unmarshalObject());
        }
        return result;
    }

    private static RubyClass pathToClass(Ruby runtime2, String path2) {
        return (RubyClass)runtime2.getClassFromPath(path2);
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        if (this == arg2) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg2;
        this.values = new IRubyObject[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    public static class StructMethods {
        @JRubyMethod(name={"new", "[]"}, rest=true)
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
            return RubyStruct.newStruct(recv2, args2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, Block block) {
            return RubyStruct.newStruct(recv2, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
            return RubyStruct.newStruct(recv2, arg0, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, block);
        }

        @JRubyMethod(name={"new", "[]"})
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return RubyStruct.newStruct(recv2, arg0, arg1, arg2, block);
        }

        @JRubyMethod
        public static IRubyObject members(IRubyObject recv2, Block block) {
            return RubyStruct.members(recv2, block);
        }
    }
}

