/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.util.HashMap;
import java.util.Map;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.MethodData;
import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileData
implements IProfileData {
    private Invocation currentInvocation;
    private Invocation topInvocation;
    private int[] methodRecursion;
    private ThreadContext threadContext;

    public ProfileData(ThreadContext tc) {
        this.topInvocation = this.currentInvocation = new Invocation(0);
        this.methodRecursion = new int[1000];
        this.threadContext = tc;
    }

    @Override
    public int profileEnter(int calledMethod) {
        Invocation parentInvocation = this.currentInvocation;
        int recursiveDepth = this.incRecursionFor(calledMethod);
        Invocation childInvocation = parentInvocation.childInvocationFor(calledMethod, recursiveDepth);
        childInvocation.incrementCount();
        this.currentInvocation = childInvocation;
        return parentInvocation.getMethodSerialNumber();
    }

    @Override
    public int profileExit(int callingMethod, long startTime) {
        long now = System.nanoTime();
        long duration = now - startTime;
        Invocation current2 = this.currentInvocation;
        current2.addDuration(duration);
        int previousMethod = current2.getMethodSerialNumber();
        this.decRecursionFor(previousMethod);
        this.currentInvocation = current2.getParent();
        return previousMethod;
    }

    public void decRecursionFor(int serial) {
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = mr[serial] - 1;
    }

    public int incRecursionFor(int serial) {
        int inc;
        this.ensureRecursionSize(serial);
        int[] mr = this.methodRecursion;
        mr[serial] = inc = mr[serial] + 1;
        return inc;
    }

    private void ensureRecursionSize(int index2) {
        int[] mr = this.methodRecursion;
        int length2 = mr.length;
        if (length2 <= index2) {
            int[] newRecursion = new int[(int)((double)index2 * 1.5 + 1.0)];
            System.arraycopy(mr, 0, newRecursion, 0, length2);
            this.methodRecursion = newRecursion;
        }
    }

    public long totalTime() {
        return this.topInvocation.childTime();
    }

    public Map<Integer, MethodData> methodData() {
        HashMap<Integer, MethodData> methods2 = new HashMap<Integer, MethodData>();
        MethodData data = new MethodData(0);
        methods2.put(0, data);
        data.invocations.add(this.topInvocation);
        ProfileData.methodData1(methods2, this.topInvocation);
        return methods2;
    }

    private static void methodData1(Map<Integer, MethodData> methods2, Invocation inv) {
        for (IntHashMap.Entry entry : inv.getChildren().entrySet()) {
            Invocation child = (Invocation)entry.getValue();
            int serial = child.getMethodSerialNumber();
            MethodData data = methods2.get(serial);
            if (data == null) {
                data = new MethodData(serial);
                methods2.put(serial, data);
            }
            data.invocations.add(child);
            ProfileData.methodData1(methods2, child);
        }
    }

    public Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }
}

