/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.MemoryIO;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.NativeParam;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.FastIntMethodOneArg;
import org.jruby.ext.ffi.jffi.FastIntMethodThreeArg;
import org.jruby.ext.ffi.jffi.FastIntMethodTwoArg;
import org.jruby.ext.ffi.jffi.FastIntMethodZeroArg;
import org.jruby.ext.ffi.jffi.IntParameterConverter;
import org.jruby.ext.ffi.jffi.IntResultConverter;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FastIntMethodFactory
extends MethodFactory {
    private FastIntMethodFactory() {
    }

    public static final FastIntMethodFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean isFastIntMethod(Type returnType, Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.isFastIntParam(parameterTypes[i])) continue;
            return false;
        }
        if (parameterTypes.length > 3) return false;
        if (!this.isFastIntResult(returnType)) return false;
        if (Platform.getPlatform().getCPU() == Platform.CPU.I386) return true;
        if (Platform.getPlatform().getCPU() != Platform.CPU.X86_64) return false;
        return true;
    }

    final boolean isFastIntResult(Type type2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: 
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case BOOL: {
                    return true;
                }
                case POINTER: 
                case STRING: {
                    return Platform.getPlatform().addressSize() == 32;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        } else if (type2 instanceof MappedType) {
            return this.isFastIntResult(((MappedType)type2).getRealType());
        }
        return false;
    }

    final boolean isFastIntParam(Type paramType) {
        if (paramType instanceof Type.Builtin) {
            switch (paramType.getNativeType()) {
                case CHAR: 
                case UCHAR: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: 
                case BOOL: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        } else if (paramType instanceof MappedType) {
            MappedType mt = (MappedType)paramType;
            return this.isFastIntParam(mt.getRealType()) && !mt.isReferenceRequired() && !mt.isPostInvokeRequired();
        }
        return false;
    }

    DynamicMethod createMethod(RubyModule module, Function function, Type returnType, Type[] parameterTypes, IRubyObject enums) {
        IntParameterConverter[] parameterConverters = new IntParameterConverter[parameterTypes.length];
        IntResultConverter resultConverter = this.getIntResultConverter(returnType);
        for (int i = 0; i < parameterConverters.length; ++i) {
            parameterConverters[i] = this.getIntParameterConverter(parameterTypes[i], enums);
        }
        switch (parameterTypes.length) {
            case 0: {
                return new FastIntMethodZeroArg(module, function, resultConverter, parameterConverters);
            }
            case 1: {
                return new FastIntMethodOneArg(module, function, resultConverter, parameterConverters);
            }
            case 2: {
                return new FastIntMethodTwoArg(module, function, resultConverter, parameterConverters);
            }
            case 3: {
                return new FastIntMethodThreeArg(module, function, resultConverter, parameterConverters);
            }
        }
        throw module.getRuntime().newRuntimeError("Arity " + parameterTypes.length + " not implemented");
    }

    final IntParameterConverter getIntParameterConverter(Type type2, IRubyObject enums) {
        if (type2 instanceof Type.Builtin) {
            return this.getIntParameterConverter(type2.getNativeType(), enums);
        }
        if (type2 instanceof MappedType) {
            MappedType ctype = (MappedType)type2;
            return new MappedParameterConverter(this.getIntParameterConverter(ctype.getRealType(), enums), ctype);
        }
        return null;
    }

    final IntParameterConverter getIntParameterConverter(NativeParam type2, IRubyObject enums) {
        switch ((NativeType)type2) {
            case BOOL: {
                return BooleanParameterConverter.INSTANCE;
            }
            case CHAR: {
                return Signed8ParameterConverter.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8ParameterConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ParameterConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ParameterConverter.INSTANCE;
            }
            case INT: {
                return enums instanceof RubyHash ? new IntOrEnumParameterConverter((RubyHash)enums) : Signed32ParameterConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case FLOAT: {
                return Float32ParameterConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Signed32ParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Unsigned32ParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Long is too big for int parameter");
            }
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return PointerParameterConverter.INSTANCE;
                }
                throw new IllegalArgumentException("Pointer is too big for int parameter");
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    final IntResultConverter getIntResultConverter(Type type2) {
        if (type2 instanceof Type.Builtin) {
            return this.getIntResultConverter(type2.getNativeType());
        }
        if (type2 instanceof MappedType) {
            MappedType ctype = (MappedType)type2;
            return new MappedResultConverter(this.getIntResultConverter(ctype.getRealType()), ctype);
        }
        return null;
    }

    final IntResultConverter getIntResultConverter(NativeType type2) {
        switch (type2) {
            case VOID: {
                return VoidResultConverter.INSTANCE;
            }
            case BOOL: {
                return BooleanResultConverter.INSTANCE;
            }
            case CHAR: {
                return Signed8ResultConverter.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8ResultConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ResultConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ResultConverter.INSTANCE;
            }
            case INT: {
                return Signed32ResultConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ResultConverter.INSTANCE;
            }
            case FLOAT: {
                return Float32ResultConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Signed32ResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException(":long is too big for int result");
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    return Unsigned32ResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException(":ulong is too big for int result");
            }
            case POINTER: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return PointerResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException(":pointer is too big for int result");
            }
            case STRING: {
                if (Platform.getPlatform().addressSize() == 32) {
                    return StringResultConverter.INSTANCE;
                }
                throw new IllegalArgumentException(":string is too big for int result");
            }
        }
        throw new IllegalArgumentException("Unknown type " + type2);
    }

    private static final int getAddress(Pointer ptr) {
        return (int)((DirectMemoryIO)ptr.getMemoryIO()).getAddress();
    }

    static final class MappedParameterConverter
    extends BaseParameterConverter {
        private final IntParameterConverter nativeConverter;
        private final MappedType mappedType;

        public MappedParameterConverter(IntParameterConverter nativeConverter, MappedType mappedType) {
            this.nativeConverter = nativeConverter;
            this.mappedType = mappedType;
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return this.nativeConverter.intValue(context, this.mappedType.toNative(context, obj));
        }
    }

    static final class IntOrEnumParameterConverter
    extends BaseParameterConverter {
        private final RubyHash enums;

        public IntOrEnumParameterConverter(RubyHash enums) {
            this.enums = enums;
        }

        public final int intValue(ThreadContext context, IRubyObject parameter) {
            return Util.intValue(parameter, this.enums);
        }
    }

    static final class PointerParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new PointerParameterConverter();

        PointerParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject parameter) {
            if (parameter instanceof Pointer) {
                return FastIntMethodFactory.getAddress((Pointer)parameter);
            }
            if (parameter instanceof Struct) {
                AbstractMemory memory = ((Struct)parameter).getMemory();
                if (memory instanceof Pointer) {
                    return FastIntMethodFactory.getAddress((Pointer)memory);
                }
                if (memory == null || memory.isNil()) {
                    return 0;
                }
            } else if (parameter.isNil()) {
                return 0;
            }
            throw context.getRuntime().newArgumentError("Cannot convert pointer to 32bit integer");
        }

        public boolean isConvertible(ThreadContext context, IRubyObject parameter) {
            return parameter instanceof Pointer || parameter instanceof Struct && ((Struct)parameter).getMemory() instanceof Pointer || parameter.isNil();
        }
    }

    static final class Float32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Float32ParameterConverter();

        Float32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Float.floatToRawIntBits((float)RubyNumeric.num2dbl(obj));
        }
    }

    static final class Unsigned32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned32ParameterConverter();

        Unsigned32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return (int)Util.uint32Value(obj);
        }
    }

    static final class Signed32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed32ParameterConverter();

        Signed32ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int32Value(obj);
        }
    }

    static final class Unsigned16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned16ParameterConverter();

        Unsigned16ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.uint16Value(obj);
        }
    }

    static final class Signed16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed16ParameterConverter();

        Signed16ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int16Value(obj);
        }
    }

    static final class Unsigned8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned8ParameterConverter();

        Unsigned8ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.uint8Value(obj);
        }
    }

    static final class Signed8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed8ParameterConverter();

        Signed8ParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            return Util.int8Value(obj);
        }
    }

    static final class BooleanParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new BooleanParameterConverter();

        BooleanParameterConverter() {
        }

        public final int intValue(ThreadContext context, IRubyObject obj) {
            if (!(obj instanceof RubyBoolean)) {
                throw context.getRuntime().newTypeError("wrong argument type.  Expected true or false");
            }
            return obj.isTrue() ? 1 : 0;
        }
    }

    static abstract class BaseParameterConverter
    implements IntParameterConverter {
        static final MemoryIO IO = MemoryIO.getInstance();

        BaseParameterConverter() {
        }

        public boolean isConvertible(ThreadContext context, IRubyObject value2) {
            return true;
        }
    }

    static final class StringResultConverter
    implements IntResultConverter {
        private static final MemoryIO IO = MemoryIO.getInstance();
        public static final IntResultConverter INSTANCE = new StringResultConverter();

        StringResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            long address2 = (long)value2 & PointerResultConverter.ADDRESS_MASK;
            return FFIUtil.getString(context.getRuntime(), address2);
        }
    }

    static final class MappedResultConverter
    implements IntResultConverter {
        private final IntResultConverter nativeConverter;
        private final MappedType mappedType;

        public MappedResultConverter(IntResultConverter nativeConverter, MappedType mappedType) {
            this.nativeConverter = nativeConverter;
            this.mappedType = mappedType;
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return this.mappedType.fromNative(context, this.nativeConverter.fromNative(context, value2));
        }
    }

    static final class PointerResultConverter
    implements IntResultConverter {
        static final long ADDRESS_MASK = Platform.getPlatform().addressSize() == 32 ? 0xFFFFFFFFL : -1L;
        public static final IntResultConverter INSTANCE = new PointerResultConverter();

        PointerResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            long address2 = (long)value2 & ADDRESS_MASK;
            return new Pointer(context.getRuntime(), NativeMemoryIO.wrap(context.getRuntime(), address2));
        }
    }

    static final class Float32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Float32ResultConverter();

        Float32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return context.getRuntime().newFloat(Float.intBitsToFloat(value2));
        }
    }

    static final class Unsigned32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned32ResultConverter();

        Unsigned32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned32(context.getRuntime(), value2);
        }
    }

    static final class Signed32ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed32ResultConverter();

        Signed32ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned32(context.getRuntime(), value2);
        }
    }

    static final class Unsigned16ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned16ResultConverter();

        Unsigned16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned16(context.getRuntime(), (short)value2);
        }
    }

    static final class Signed16ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed16ResultConverter();

        Signed16ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned16(context.getRuntime(), (short)value2);
        }
    }

    static final class Unsigned8ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned8ResultConverter();

        Unsigned8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newUnsigned8(context.getRuntime(), (byte)value2);
        }
    }

    static final class Signed8ResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new Signed8ResultConverter();

        Signed8ResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return Util.newSigned8(context.getRuntime(), (byte)value2);
        }
    }

    static final class BooleanResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new BooleanResultConverter();

        BooleanResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return context.getRuntime().newBoolean((value2 & 0xFF) != 0);
        }
    }

    static final class VoidResultConverter
    implements IntResultConverter {
        public static final IntResultConverter INSTANCE = new VoidResultConverter();

        VoidResultConverter() {
        }

        public final IRubyObject fromNative(ThreadContext context, int value2) {
            return context.getRuntime().getNil();
        }
    }

    private static final class SingletonHolder {
        private static final FastIntMethodFactory INSTANCE = new FastIntMethodFactory();

        private SingletonHolder() {
        }
    }
}

