/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.CursorBuffer;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Readline"})
public class Readline {
    public static final char ESC_KEY_CODE = '\u001b';
    private static final boolean DEBUG = false;
    private static IRubyObject COMPLETION_CASE_FOLD = null;

    public static void createReadline(Ruby runtime2) throws IOException {
        ConsoleHolder holder = new ConsoleHolder();
        holder.history = new ReadlineHistory();
        holder.currentCompletor = null;
        COMPLETION_CASE_FOLD = runtime2.getNil();
        RubyModule mReadline = runtime2.defineModule("Readline");
        mReadline.dataWrapStruct(holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        IRubyObject hist = runtime2.getObject().callMethod(runtime2.getCurrentContext(), "new");
        mReadline.fastSetConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule(runtime2.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.fastSetConstant("VERSION", runtime2.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime2, final ConsoleHolder holder) {
        try {
            holder.readline = new ConsoleReader();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        holder.readline.setUseHistory(false);
        holder.readline.setUsePagination(true);
        holder.readline.setBellEnabled(true);
        ((CandidateListCompletionHandler)holder.readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        holder.readline.addCompletor(holder.currentCompletor);
        holder.readline.setHistory(holder.history);
        holder.readline.addTriggeredAction('\u001b', new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    holder.readline.beep();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime2) {
        return (ConsoleHolder)runtime2.fastGetModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder holder, Completor completor) {
        if (holder.readline != null) {
            holder.readline.removeCompletor(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompletor(holder.currentCompletor);
        }
    }

    public static Completor getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) {
        return Readline.s_readline(recv2.getRuntime().getCurrentContext(), recv2, prompt, add_to_hist);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(ThreadContext context, IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) {
        Ruby runtime2 = context.getRuntime();
        ConsoleHolder holder = Readline.getHolder(runtime2);
        if (holder.readline == null) {
            Readline.initReadline(runtime2, holder);
        }
        IRubyObject line = runtime2.getNil();
        String v = null;
        try {
            while (true) {
                Object var11_8;
                try {
                    holder.readline.getTerminal().disableEcho();
                    v = holder.readline.readLine(prompt.toString());
                    var11_8 = null;
                    holder.readline.getTerminal().enableEcho();
                }
                catch (IOException ioe) {
                    if (RubyIO.restartSystemCall(ioe)) {
                        try {
                            holder.readline.getTerminal().initializeTerminal();
                        }
                        catch (Exception e) {
                        }
                        var11_8 = null;
                        holder.readline.getTerminal().enableEcho();
                        continue;
                    }
                    throw runtime2.newIOErrorFromException(ioe);
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            holder.readline.getTerminal().enableEcho();
            throw throwable;
        }
        if (null != v) {
            if (add_to_hist.isTrue()) {
                holder.readline.getHistory().addToHistory(v);
            }
            line = RubyString.newUnicodeString(recv2.getRuntime(), v);
        }
        return line;
    }

    @JRubyMethod(name={"input="}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setInput(ThreadContext context, IRubyObject recv2, IRubyObject input) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"output="}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject setOutput(ThreadContext context, IRubyObject recv2, IRubyObject output) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt) {
        return Readline.s_readline(recv2, prompt, recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2) {
        return Readline.s_readline(recv2, RubyString.newEmptyString(recv2.getRuntime()), recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"basic_word_break_characters="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_basic_word_break_character(IRubyObject recv2, IRubyObject achar) {
        Ruby runtime2 = recv2.getRuntime();
        if (!achar.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + achar.getMetaClass() + " into String");
        }
        ProcCompletor.setDelimiter(achar.convertToString().toString());
        return achar;
    }

    @JRubyMethod(name={"basic_word_break_characters"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_basic_word_break_character(IRubyObject recv2) {
        return recv2.getRuntime().newString(ProcCompletor.getDelimiter());
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject recv2, IRubyObject achar) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv2, IRubyObject proc2) {
        if (!proc2.respondsTo("call")) {
            throw recv2.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv2.getRuntime()), new ProcCompletor(proc2));
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"basic_quote_characters", "basic_quote_characters=", "completer_quote_characters", "completer_quote_characters=", "completer_word_break_characters", "completer_word_break_characters=", "completion_append_character", "completion_proc", "emacs_editing_mode", "filename_quote_characters", "filename_quote_characters=", "vi_editing_mode"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject unimplemented(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        String err = context.getFrameName() + "() function is unimplemented on this machine";
        throw runtime2.newNotImplementedError(err);
    }

    @JRubyMethod(name={"basic_quote_characters", "basic_quote_characters=", "completer_quote_characters", "completer_quote_characters=", "completer_word_break_characters", "completer_word_break_characters=", "completion_append_character", "completion_proc", "emacs_editing_mode", "emacs_editing_mode?", "filename_quote_characters", "filename_quote_characters=", "vi_editing_mode", "vi_editing_mode?", "set_screen_size"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject unimplemented19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        String err = context.getFrameName() + "() function is unimplemented on this machine";
        throw runtime2.newNotImplementedError(err);
    }

    @JRubyMethod(name={"completion_case_fold"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_completion_case_fold(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"completion_case_fold="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_case_fold(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        COMPLETION_CASE_FOLD = other;
        return COMPLETION_CASE_FOLD;
    }

    @JRubyMethod(name={"get_screen_size"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_screen_size(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        ConsoleHolder holder = Readline.getHolder(runtime2);
        IRubyObject[] ary = new IRubyObject[]{runtime2.newFixnum(holder.readline.getTermheight()), runtime2.newFixnum(holder.readline.getTermwidth())};
        return RubyArray.newArray(runtime2, ary);
    }

    @JRubyMethod(name={"line_buffer"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_line_buffer(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        ConsoleHolder holder = Readline.getHolder(runtime2);
        if (holder.readline == null) {
            Readline.initReadline(runtime2, holder);
        }
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime2.newString(cb.toString()).taint(context);
    }

    @JRubyMethod(name={"point"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_get_point(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        ConsoleHolder holder = Readline.getHolder(runtime2);
        if (holder.readline == null) {
            Readline.initReadline(runtime2, holder);
        }
        CursorBuffer cb = holder.readline.getCursorBuffer();
        return runtime2.newFixnum(cb.cursor);
    }

    @JRubyMethod(name={"refresh_line"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject s_refresh_line(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        runtime2.secure(4);
        ConsoleHolder holder = Readline.getHolder(runtime2);
        try {
            holder.readline.redrawLine();
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
        return runtime2.getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String buffer, int cursor, List candidates) {
            int index2 = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            return index2 + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;
        private static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompletor(IRubyObject procCompletor) {
            this.procCompletor = procCompletor;
        }

        public static String getDelimiter() {
            StringBuilder result = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                result.append(delimiter);
            }
            return result.toString();
        }

        public static void setDelimiter(String delimiter) {
            ArrayList<String> l = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                l.add(String.valueOf(buf.get()));
            }
            delimiters = l.toArray(new String[l.size()]);
        }

        private int wordIndexOf(String buffer) {
            int index2 = 0;
            for (String c : delimiters) {
                index2 = buffer.lastIndexOf(c);
                if (index2 == -1) continue;
                return index2;
            }
            return index2;
        }

        public int complete(String buffer, int cursor, List candidates) {
            Ruby runtime2;
            ThreadContext context;
            IRubyObject result;
            IRubyObject comps;
            int index2 = this.wordIndexOf(buffer = buffer.substring(0, cursor));
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            if ((comps = (result = this.procCompletor.callMethod(context = (runtime2 = this.procCompletor.getRuntime()).getCurrentContext(), "call", runtime2.newString(buffer))).callMethod(context, "to_a")) instanceof List) {
                for (Object obj : (List)((Object)comps)) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv2, IRubyObject[] lines2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            for (int i = 0; i < lines2.length; ++i) {
                RubyString line = lines2[i].convertToString();
                holder.history.addToHistory(line.getUnicodeValue());
            }
            return recv2.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            if (holder.history.size() == 0) {
                return runtime2.getNil();
            }
            return runtime2.newString(holder.history.pop()).taint(runtime2.getCurrentContext());
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            RubyArray histList = runtime2.newArray();
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                histList.append(runtime2.newString((String)i.next()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv2) {
            return recv2.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = (int)index2.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                ThreadContext context = runtime2.getCurrentContext();
                return runtime2.newString((String)holder.history.getHistoryList().get(i)).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv2, IRubyObject index2, IRubyObject val) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = (int)index2.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                holder.history.set(i, val.asJavaString());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
            return runtime2.getNil();
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            if (holder.history.size() == 0) {
                return runtime2.getNil();
            }
            try {
                return runtime2.newString(holder.history.remove(0)).taint(runtime2.getCurrentContext());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("history shift error");
            }
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newBoolean(holder.history.size() == 0);
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime2 = recv2.getRuntime();
            ThreadContext context = runtime2.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = RubyNumeric.num2int(index2);
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                return runtime2.newString(holder.history.remove(i)).taint(context);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject recv2, Block block) {
            Ruby runtime2 = recv2.getRuntime();
            ThreadContext context = runtime2.getCurrentContext();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                block.yield(context, runtime2.newString((String)i.next()).taint(context));
            }
            return recv2;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completor currentCompletor;
        public ReadlineHistory history;
    }

    public static class ReadlineHistory
    extends History {
        ArrayList historyList = null;
        Field index = null;
        private boolean securityRestricted = false;

        public ReadlineHistory() {
            try {
                Field list2 = History.class.getDeclaredField("history");
                list2.setAccessible(true);
                this.historyList = (ArrayList)list2.get(this);
                this.index = History.class.getDeclaredField("currentIndex");
                this.index.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                this.securityRestricted = true;
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        public void setCurrentIndex(int i) {
            if (this.securityRestricted) {
                return;
            }
            try {
                this.index.setInt(this, i);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        public void set(int i, String s) {
            if (this.securityRestricted) {
                return;
            }
            this.historyList.set(i, s);
        }

        public String pop() {
            if (this.securityRestricted) {
                List histList = this.getHistoryList();
                return (String)histList.get(histList.size() - 1);
            }
            return this.remove(this.historyList.size() - 1);
        }

        public String remove(int i) {
            if (this.securityRestricted) {
                return "";
            }
            this.setCurrentIndex(this.historyList.size() - 2);
            return (String)this.historyList.remove(i);
        }
    }
}

