/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class InstanceVariable
extends AbstractVariable {
    private static String pattern = "@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new InstanceVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private InstanceVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, false, javaObject);
    }

    public InstanceVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        InstanceVariable.updateInstanceVar(receiver2, vars);
        InstanceVariable.updateInstanceVar((RubyObject)receiver2.getRuntime().getTopSelf(), vars);
    }

    static void updateInstanceVar(RubyObject receiver2, BiVariableMap vars) {
        InstanceVariables ivars = receiver2.getInstanceVariables();
        List<String> keys2 = ivars.getInstanceVariableNameList();
        for (String key2 : keys2) {
            IRubyObject value2 = ivars.fastGetInstanceVariable(key2);
            BiVariable var = vars.getVariable(receiver2, key2);
            if (var != null) {
                var.setRubyObject(value2);
                continue;
            }
            var = new InstanceVariable((IRubyObject)receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        InstanceVariables ivars = receiver2.getInstanceVariables();
        if (!ivars.getInstanceVariableNameList().contains(key2)) {
            return;
        }
        IRubyObject value2 = ivars.fastGetInstanceVariable(key2);
        BiVariable var = vars.getVariable(receiver2, key2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new InstanceVariable((IRubyObject)receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.InstanceVariable;
    }

    public static boolean isValidName(Object name2) {
        return InstanceVariable.isValidName(pattern, name2);
    }

    public void inject() {
        ((RubyObject)this.receiver).fastSetInstanceVariable(this.name.intern(), this.getRubyObject());
    }

    public void remove(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject self = context.getFrameSelf();
        self.getInstanceVariables().removeInstanceVariable(this.name);
    }
}

