/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.RubyInstanceConfig;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.Hash19Node;
import org.jruby.ast.HashNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.SValue19Node;
import org.jruby.ast.StarNode;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;

public class ASTCompiler19
extends ASTCompiler {
    public void compile(Node node, BodyCompiler context, boolean expr) {
        if (node == null) {
            if (expr) {
                context.loadNil();
            }
            return;
        }
        switch (node.getNodeType()) {
            case ENCODINGNODE: {
                this.compileEncoding(node, context, expr);
                break;
            }
            case LAMBDANODE: {
                this.compileLambda(node, context, expr);
                break;
            }
            case MULTIPLEASGN19NODE: {
                this.compileMultipleAsgn19(node, context, expr);
                break;
            }
            default: {
                super.compile(node, context, expr);
            }
        }
    }

    public void compileArgs(Node node, BodyCompiler context, boolean expr) {
        ArgsNode argsNode = (ArgsNode)node;
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        context.getVariableCompiler().checkMethodArity(required, opt, rest2);
        this.compileMethodArgs(node, context, expr);
    }

    public void compileAssignment(Node node, BodyCompiler context, boolean expr) {
        switch (node.getNodeType()) {
            case MULTIPLEASGN19NODE: {
                this.compileMultipleAsgn19Assignment(node, context, expr);
                break;
            }
            default: {
                super.compileAssignment(node, context, expr);
            }
        }
    }

    public void compileDefined(Node node, BodyCompiler context, boolean expr) {
        throw new NotCompilableException("1.9 mode does not compile defined? properly yet: " + node.getPosition());
    }

    public void compileMethodArgs(Node node, BodyCompiler context, boolean expr) {
        final ArgsNode argsNode = (ArgsNode)node;
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        ArrayCallback requiredAssignment = null;
        ArrayCallback optionalGiven = null;
        ArrayCallback optionalNotGiven = null;
        CompilerCallback restAssignment = null;
        CompilerCallback blockAssignment = null;
        if (required > 0) {
            requiredAssignment = new ArrayCallback(){

                public void nextValue(BodyCompiler context, Object object, int index2) {
                    ArrayNode arguments = (ArrayNode)object;
                    Node argNode = arguments.get(index2);
                    switch (argNode.getNodeType()) {
                        case ARGUMENTNODE: {
                            int varIndex = ((ArgumentNode)argNode).getIndex();
                            context.getVariableCompiler().assignLocalVariable(varIndex, false);
                            break;
                        }
                        case MULTIPLEASGN19NODE: {
                            ASTCompiler19.this.compileMultipleAsgn19Assignment(argNode, context, false);
                            break;
                        }
                        default: {
                            throw new NotCompilableException("unknown argument type: " + argNode);
                        }
                    }
                }
            };
        }
        if (opt > 0) {
            optionalGiven = new ArrayCallback(){

                public void nextValue(BodyCompiler context, Object object, int index2) {
                    OptArgNode optArg = (OptArgNode)((ListNode)object).get(index2);
                    ASTCompiler19.this.compileAssignment(optArg.getValue(), context, false);
                }
            };
            optionalNotGiven = new ArrayCallback(){

                public void nextValue(BodyCompiler context, Object object, int index2) {
                    OptArgNode optArg = (OptArgNode)((ListNode)object).get(index2);
                    ASTCompiler19.this.compile(optArg.getValue(), context, false);
                }
            };
        }
        if (rest2 > -1) {
            restAssignment = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getRestArg(), false);
                }
            };
        }
        if (argsNode.getBlock() != null) {
            blockAssignment = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    context.getVariableCompiler().assignLocalVariable(argsNode.getBlock().getCount(), false);
                }
            };
        }
        context.getVariableCompiler().assignMethodArguments19(argsNode.getPre(), argsNode.getPreCount(), argsNode.getPost(), argsNode.getPostCount(), argsNode.getPostIndex(), argsNode.getOptArgs(), argsNode.getOptionalArgsCount(), requiredAssignment, optionalGiven, optionalNotGiven, restAssignment, blockAssignment);
        if (!expr) {
            context.consumeCurrentValue();
        }
    }

    public void compileArgsPush(Node node, BodyCompiler context, boolean expr) {
        ArgsPushNode argsPush = (ArgsPushNode)node;
        this.compile(argsPush.getFirstNode(), context, true);
        this.compile(argsPush.getSecondNode(), context, true);
        context.argsPush();
        if (!expr) {
            context.consumeCurrentValue();
        }
    }

    public void compileEncoding(Node node, BodyCompiler context, boolean expr) {
        boolean popit;
        EncodingNode encodingNode = (EncodingNode)node;
        boolean doit = expr || !RubyInstanceConfig.PEEPHOLE_OPTZ;
        boolean bl = popit = !RubyInstanceConfig.PEEPHOLE_OPTZ && !expr;
        if (doit) {
            context.loadEncoding(encodingNode.getEncoding());
        }
        if (popit) {
            context.consumeCurrentValue();
        }
    }

    public void compileIter(Node node, BodyCompiler context) {
        final IterNode iterNode = (IterNode)node;
        final ArgsNode argsNode = (ArgsNode)iterNode.getVarNode();
        CompilerCallback closureBody = new CompilerCallback(){

            public void call(BodyCompiler context) {
                if (iterNode.getBodyNode() != null) {
                    ASTCompiler19.this.compile(iterNode.getBodyNode(), context, true);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback closureArgs = new CompilerCallback(){

            public void call(BodyCompiler context) {
                context.consumeCurrentValue();
                context.consumeCurrentValue();
                if (iterNode.getVarNode() != null) {
                    if (iterNode instanceof LambdaNode) {
                        int required = argsNode.getRequiredArgsCount();
                        int opt = argsNode.getOptionalArgsCount();
                        int rest2 = argsNode.getRestArg();
                        context.getVariableCompiler().checkMethodArity(required, opt, rest2);
                        ASTCompiler19.this.compileMethodArgs(argsNode, context, true);
                    } else {
                        ASTCompiler19.this.compileMethodArgs(argsNode, context, true);
                    }
                }
            }
        };
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(iterNode.getBodyNode());
        inspector.inspect(iterNode.getVarNode());
        if (argsNodeId == null) {
            context.createNewClosure19(iterNode.getPosition().getFile(), iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, null, hasMultipleArgsHead, argsNodeId, RuntimeHelpers.encodeParameterList(argsNode), inspector);
        } else {
            context.createNewClosure19(iterNode.getPosition().getFile(), iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()).getValue(), closureBody, closureArgs, hasMultipleArgsHead, argsNodeId, RuntimeHelpers.encodeParameterList(argsNode), inspector);
        }
    }

    public void compileLambda(Node node, BodyCompiler context, boolean expr) {
        boolean popit;
        final LambdaNode lambdaNode = (LambdaNode)node;
        boolean doit = expr || !RubyInstanceConfig.PEEPHOLE_OPTZ;
        boolean bl = popit = !RubyInstanceConfig.PEEPHOLE_OPTZ && !expr;
        if (doit) {
            context.createNewLambda(new CompilerCallback(){

                public void call(BodyCompiler context) {
                    ASTCompiler19.this.compileIter(lambdaNode, context);
                }
            });
        }
        if (popit) {
            context.consumeCurrentValue();
        }
    }

    public void compileMultipleAsgn19(Node node, BodyCompiler context, boolean expr) {
        MultipleAsgn19Node multipleAsgn19Node = (MultipleAsgn19Node)node;
        if (expr) {
            this.compileUnoptimizedMultipleAsgn19(multipleAsgn19Node, context, expr);
        } else {
            this.compileOptimizedMultipleAsgn19(multipleAsgn19Node, context, expr);
        }
    }

    private void compileOptimizedMultipleAsgn19(MultipleAsgn19Node multipleAsgn19Node, BodyCompiler context, boolean expr) {
        if (multipleAsgn19Node.getValueNode() instanceof ArrayNode && multipleAsgn19Node.getPreCount() > 0 && multipleAsgn19Node.getPostCount() == 0 && multipleAsgn19Node.getRest() == null && multipleAsgn19Node.getPreCount() == ((ArrayNode)multipleAsgn19Node.getValueNode()).size()) {
            int size2;
            boolean normalAssigns = true;
            for (Node asgn : multipleAsgn19Node.getPre().childNodes()) {
                if (!(asgn instanceof ListNode)) continue;
                normalAssigns = false;
                break;
            }
            if (normalAssigns && (size2 = multipleAsgn19Node.getPreCount()) >= 2 && size2 <= 10) {
                ArrayNode values = (ArrayNode)multipleAsgn19Node.getValueNode();
                for (Node value2 : values.childNodes()) {
                    this.compile(value2, context, true);
                }
                context.reverseValues(size2);
                for (Node asgn : multipleAsgn19Node.getPre().childNodes()) {
                    this.compileAssignment(asgn, context, false);
                }
                return;
            }
        }
        this.compileUnoptimizedMultipleAsgn19(multipleAsgn19Node, context, expr);
    }

    private void compileUnoptimizedMultipleAsgn19(MultipleAsgn19Node multipleAsgn19Node, BodyCompiler context, boolean expr) {
        this.compile(multipleAsgn19Node.getValueNode(), context, true);
        this.compileMultipleAsgn19Assignment(multipleAsgn19Node, context, expr);
    }

    public void compileMultipleAsgn19Assignment(Node node, BodyCompiler context, boolean expr) {
        final MultipleAsgn19Node multipleAsgn19Node = (MultipleAsgn19Node)node;
        ArrayCallback prePostAssignCallback = new ArrayCallback(){

            public void nextValue(BodyCompiler context, Object sourceArray, int index2) {
                ListNode nodes = (ListNode)sourceArray;
                Node assignNode = nodes.get(index2);
                ASTCompiler19.this.compileAssignment(assignNode, context, false);
            }
        };
        CompilerCallback restCallback = new CompilerCallback(){

            public void call(BodyCompiler context) {
                Node argsNode = multipleAsgn19Node.getRest();
                if (argsNode instanceof StarNode) {
                    context.consumeCurrentValue();
                } else {
                    ASTCompiler19.this.compileAssignment(argsNode, context, false);
                }
            }
        };
        if (multipleAsgn19Node.getPreCount() == 0 && multipleAsgn19Node.getPostCount() == 0) {
            if (multipleAsgn19Node.getRest() == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgn19Node.getPosition());
            }
            if (!(multipleAsgn19Node.getRest() instanceof StarNode)) {
                context.ensureMultipleAssignableRubyArray(multipleAsgn19Node.getPreCount() != 0 || multipleAsgn19Node.getPostCount() != 0);
                context.forEachInValueArray(0, 0, null, null, restCallback);
            }
        } else {
            context.ensureMultipleAssignableRubyArray(multipleAsgn19Node.getPreCount() != 0 || multipleAsgn19Node.getPostCount() != 0);
            if (multipleAsgn19Node.getRest() == null) {
                context.forEachInValueArray(0, multipleAsgn19Node.getPreCount(), multipleAsgn19Node.getPre(), multipleAsgn19Node.getPostCount(), multipleAsgn19Node.getPost(), prePostAssignCallback, null);
            } else {
                context.forEachInValueArray(0, multipleAsgn19Node.getPreCount(), multipleAsgn19Node.getPre(), multipleAsgn19Node.getPostCount(), multipleAsgn19Node.getPost(), prePostAssignCallback, restCallback);
            }
        }
        if (!expr) {
            context.consumeCurrentValue();
        }
    }

    public void compileHash(Node node, BodyCompiler context, boolean expr) {
        this.compileHashCommon((Hash19Node)node, context, expr);
    }

    protected void createNewHash(BodyCompiler context, HashNode hashNode, ArrayCallback hashCallback) {
        context.createNewHash19(hashNode.getListNode(), hashCallback, hashNode.getListNode().size() / 2);
    }

    public void compileMatch2(Node node, BodyCompiler context, boolean expr) {
        if (!(node instanceof Match2CaptureNode)) {
            super.compileMatch2(node, context, expr);
            return;
        }
        final Match2CaptureNode matchNode = (Match2CaptureNode)node;
        this.compile(matchNode.getReceiverNode(), context, true);
        CompilerCallback value2 = new CompilerCallback(){

            public void call(BodyCompiler context) {
                ASTCompiler19.this.compile(matchNode.getValueNode(), context, true);
            }
        };
        context.match2Capture(value2, matchNode.getScopeOffsets());
        if (!expr) {
            context.consumeCurrentValue();
        }
    }

    public void compileSValue(Node node, BodyCompiler context, boolean expr) {
        SValue19Node svalueNode = (SValue19Node)node;
        this.compile(svalueNode.getValue(), context, true);
        context.singlifySplattedValue19();
        if (!expr) {
            context.consumeCurrentValue();
        }
    }

    protected void splatCurrentValue(BodyCompiler context) {
        context.splatCurrentValue("splatValue19");
    }
}

