/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jruby.objectweb.asm.ClassReader;
import jruby.objectweb.asm.util.TraceClassVisitor;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.types.INameNode;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.libraries.FiberLibrary;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"JRuby"})
public class RubyJRuby {
    public static RubyModule createJRuby(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        runtime2.getKernel().callMethod(context, "require", (IRubyObject)runtime2.newString("java"));
        RubyModule jrubyModule = runtime2.defineModule("JRuby");
        jrubyModule.defineAnnotatedMethods(RubyJRuby.class);
        jrubyModule.defineAnnotatedMethods(JRubyUtilLibrary.class);
        RubyClass compiledScriptClass = jrubyModule.defineClassUnder("CompiledScript", runtime2.getObject(), runtime2.getObject().getAllocator());
        for (String name2 : new String[]{"name", "class_name", "original_script", "code"}) {
            compiledScriptClass.addReadWriteAttribute(context, name2);
        }
        compiledScriptClass.defineAnnotatedMethods(JRubyCompiledScript.class);
        RubyClass threadLocalClass = jrubyModule.defineClassUnder("ThreadLocal", runtime2.getObject(), JRubyThreadLocal.ALLOCATOR);
        threadLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        RubyClass fiberLocalClass = jrubyModule.defineClassUnder("FiberLocal", runtime2.getObject(), JRubyFiberLocal.ALLOCATOR);
        fiberLocalClass.defineAnnotatedMethods(JRubyExecutionContextLocal.class);
        return jrubyModule;
    }

    public static RubyModule createJRubyExt(Ruby runtime2) {
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", (IRubyObject)runtime2.newString("java"));
        RubyModule mJRubyExt = runtime2.getOrCreateModule("JRuby").defineModuleUnder("Extensions");
        mJRubyExt.defineAnnotatedMethods(JRubyExtensions.class);
        runtime2.getObject().includeModule(mJRubyExt);
        return mJRubyExt;
    }

    public static void createJRubyCoreExt(Ruby runtime2) {
        runtime2.getClassClass().defineAnnotatedMethods(JRubyClassExtensions.class);
        runtime2.getThread().defineAnnotatedMethods(JRubyThreadExtensions.class);
        runtime2.getString().defineAnnotatedMethods(JRubyStringExtensions.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject runtime(IRubyObject recv2, Block unusedBlock) {
        return JavaUtil.convertJavaToUsableRubyObject(recv2.getRuntime(), recv2.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject with_current_runtime_as_global(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby currentRuntime = context.getRuntime();
        Ruby globalRuntime = Ruby.getGlobalRuntime();
        try {
            if (globalRuntime != currentRuntime) {
                currentRuntime.useAsGlobalRuntime();
            }
            block.yieldSpecific(context);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (Ruby.getGlobalRuntime() != globalRuntime) {
                globalRuntime.useAsGlobalRuntime();
            }
            throw throwable;
        }
        if (Ruby.getGlobalRuntime() != globalRuntime) {
            globalRuntime.useAsGlobalRuntime();
        }
        return currentRuntime.getNil();
    }

    @JRubyMethod(name={"parse", "ast_for"}, optional=3, module=true)
    public static IRubyObject parse(IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 0, 0);
            return JavaUtil.convertJavaToUsableRubyObject(recv2.getRuntime(), ((InterpretedBlock)block.getBody()).getBodyNode());
        }
        Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 3);
        String filename2 = "-";
        boolean extraPositionInformation = false;
        RubyString content = args2[0].convertToString();
        if (args2.length > 1) {
            filename2 = args2[1].convertToString().toString();
            if (args2.length > 2) {
                extraPositionInformation = args2[2].isTrue();
            }
        }
        return JavaUtil.convertJavaToUsableRubyObject(recv2.getRuntime(), recv2.getRuntime().parse(content.getByteList(), filename2, null, 0, extraPositionInformation));
    }

    @JRubyMethod(name={"compile"}, optional=3, module=true)
    public static IRubyObject compile(IRubyObject recv2, IRubyObject[] args2, Block block) {
        String filename2;
        Node node;
        RubyString content;
        if (block.isGiven()) {
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 0, 0);
            if (block.getBody() instanceof CompiledBlock) {
                throw new RuntimeException("Cannot compile an already compiled block. Use -J-Djruby.jit.enabled=false to avoid this problem.");
            }
            content = RubyString.newEmptyString(recv2.getRuntime());
            Node bnode = ((InterpretedBlock)block.getBody()).getBodyNode();
            node = new RootNode(bnode.getPosition(), block.getBinding().getDynamicScope(), bnode);
            filename2 = "__block_" + node.getPosition().getFile();
        } else {
            Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 3);
            filename2 = "-";
            boolean extraPositionInformation = false;
            content = args2[0].convertToString();
            if (args2.length > 1) {
                filename2 = args2[1].convertToString().toString();
                if (args2.length > 2) {
                    extraPositionInformation = args2[2].isTrue();
                }
            }
            node = recv2.getRuntime().parse(content.getByteList(), filename2, null, 0, extraPositionInformation);
        }
        String classname = filename2.equals("-e") ? "__dash_e__" : filename2.replace('\\', '/').replaceAll(".rb", "").replaceAll("-", "_dash_");
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(node);
        StandardASMCompiler asmCompiler = new StandardASMCompiler(classname, filename2);
        ASTCompiler compiler = recv2.getRuntime().getInstanceConfig().newCompiler();
        compiler.compileRoot(node, asmCompiler, inspector);
        byte[] bts = asmCompiler.getClassByteArray();
        IRubyObject compiledScript = ((RubyModule)recv2).fastGetConstant("CompiledScript").callMethod(recv2.getRuntime().getCurrentContext(), "new");
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "name=", recv2.getRuntime().newString(filename2));
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "class_name=", recv2.getRuntime().newString(classname));
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "original_script=", content);
        compiledScript.callMethod(recv2.getRuntime().getCurrentContext(), "code=", JavaUtil.convertJavaToUsableRubyObject(recv2.getRuntime(), bts));
        return compiledScript;
    }

    @JRubyMethod(name={"reference"}, required=1, module=true)
    public static IRubyObject reference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        return Java.getInstance(runtime2, obj);
    }

    @JRubyMethod(name={"dereference"}, required=1, module=true)
    public static IRubyObject dereference(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        Object unwrapped;
        if (obj instanceof JavaProxy) {
            unwrapped = ((JavaProxy)obj).getObject();
        } else if (obj.dataGetStruct() instanceof JavaObject) {
            unwrapped = JavaUtil.unwrapJavaObject(obj);
        } else {
            throw context.getRuntime().newTypeError("got " + obj + ", expected wrapped Java object");
        }
        if (!(unwrapped instanceof IRubyObject)) {
            throw context.getRuntime().newTypeError("got " + obj + ", expected Java-wrapped Ruby object");
        }
        return (IRubyObject)unwrapped;
    }

    private static IRubyObject getNameFrom(Ruby runtime2, INameNode node) {
        return node == null ? runtime2.getNil() : RubySymbol.newSymbol(runtime2, node.getName());
    }

    public static class MethodExtensions {
        @JRubyMethod(name={"args"})
        public static IRubyObject methodArgs(IRubyObject recv2) {
            Ruby runtime2 = recv2.getRuntime();
            RubyMethod rubyMethod = (RubyMethod)recv2;
            RubyArray argsArray = RubyArray.newArray(runtime2);
            DynamicMethod method2 = rubyMethod.method;
            RubySymbol req = runtime2.newSymbol("req");
            RubySymbol opt = runtime2.newSymbol("opt");
            RubySymbol rest2 = runtime2.newSymbol("rest");
            RubySymbol block = runtime2.newSymbol("block");
            if (method2 instanceof MethodArgs2) {
                return RuntimeHelpers.parameterListToParameters(runtime2, ((MethodArgs2)((Object)method2)).getParameterList(), true);
            }
            if (method2 instanceof MethodArgs) {
                MethodArgs interpMethod = (MethodArgs)((Object)method2);
                ArgsNode args2 = interpMethod.getArgsNode();
                ListNode requiredArgs = args2.getPre();
                for (int i = 0; requiredArgs != null && i < requiredArgs.size(); ++i) {
                    Node argNode = requiredArgs.get(i);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.append(RubyArray.newArray(runtime2, req));
                        continue;
                    }
                    argsArray.append(RubyArray.newArray(runtime2, req, RubyJRuby.getNameFrom(runtime2, (INameNode)((Object)argNode))));
                }
                ListNode optArgs = args2.getOptArgs();
                for (int i = 0; optArgs != null && i < optArgs.size(); ++i) {
                    argsArray.append(RubyArray.newArray(runtime2, opt, RubyJRuby.getNameFrom(runtime2, (INameNode)((Object)optArgs.get(i)))));
                }
                if (args2.getRestArg() >= 0) {
                    argsArray.append(RubyArray.newArray(runtime2, rest2, RubyJRuby.getNameFrom(runtime2, args2.getRestArgNode())));
                }
                ListNode requiredArgsPost = args2.getPost();
                for (int i = 0; requiredArgsPost != null && i < requiredArgsPost.size(); ++i) {
                    Node argNode = requiredArgsPost.get(i);
                    if (argNode instanceof MultipleAsgn19Node) {
                        argsArray.append(RubyArray.newArray(runtime2, req));
                        continue;
                    }
                    argsArray.append(RubyArray.newArray(runtime2, req, RubyJRuby.getNameFrom(runtime2, (INameNode)((Object)requiredArgsPost.get(i)))));
                }
                if (args2.getBlock() != null) {
                    argsArray.append(RubyArray.newArray(runtime2, block, RubyJRuby.getNameFrom(runtime2, args2.getBlock())));
                }
            } else if (method2.getArity() == Arity.OPTIONAL) {
                argsArray.append(RubyArray.newArray(runtime2, rest2));
            }
            return argsArray;
        }
    }

    public static class JRubyStringExtensions {
        @JRubyMethod(name={"alloc"}, meta=true)
        public static IRubyObject alloc(ThreadContext context, IRubyObject recv2, IRubyObject size2) {
            return RubyString.newStringLight(context.getRuntime(), (int)size2.convertToInteger().getLongValue());
        }
    }

    public static class JRubyThreadExtensions {
        private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

        @JRubyMethod(name={"times"}, module=true)
        public static IRubyObject times(IRubyObject recv2, Block unusedBlock) {
            Ruby runtime2 = recv2.getRuntime();
            long cpu = threadBean.getCurrentThreadCpuTime();
            long user = threadBean.getCurrentThreadUserTime();
            if (cpu == -1L) {
                cpu = 0L;
            }
            if (user == -1L) {
                user = 0L;
            }
            double system_d = (double)(cpu - user) / 1.0E9;
            double user_d = (double)user / 1.0E9;
            RubyFloat zero = runtime2.newFloat(0.0);
            return RubyStruct.newStruct(runtime2.getTmsStruct(), new IRubyObject[]{RubyFloat.newFloat(runtime2, user_d), RubyFloat.newFloat(runtime2, system_d), zero, zero}, Block.NULL_BLOCK);
        }
    }

    public static class JRubyClassExtensions {
        @JRubyMethod(name={"subclasses"}, optional=1)
        public static IRubyObject subclasses(ThreadContext context, IRubyObject maybeClass, IRubyObject[] args2) {
            if (!(maybeClass instanceof RubyClass)) {
                throw context.getRuntime().newTypeError(maybeClass, context.getRuntime().getClassClass());
            }
            RubyClass clazz = (RubyClass)maybeClass;
            return clazz.__subclasses__(context, args2);
        }

        @JRubyMethod(name={"become_java!"}, optional=1)
        public static IRubyObject become_java_bang(ThreadContext context, IRubyObject maybeClass, IRubyObject[] args2) {
            if (!(maybeClass instanceof RubyClass)) {
                throw context.getRuntime().newTypeError(maybeClass, context.getRuntime().getClassClass());
            }
            RubyClass clazz = (RubyClass)maybeClass;
            if (args2.length > 0) {
                clazz.reify(args2[0].convertToString().asJavaString());
            } else {
                clazz.reify();
            }
            return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), clazz.getReifiedClass());
        }

        @JRubyMethod
        public static IRubyObject java_class(ThreadContext context, IRubyObject maybeClass) {
            if (!(maybeClass instanceof RubyClass)) {
                throw context.getRuntime().newTypeError(maybeClass, context.getRuntime().getClassClass());
            }
            RubyClass clazz = (RubyClass)maybeClass;
            for (RubyClass current2 = clazz; current2 != null; current2 = current2.getSuperClass()) {
                if (current2.getReifiedClass() == null) continue;
                clazz = current2;
                break;
            }
            return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), clazz.getReifiedClass());
        }

        @JRubyMethod
        public static IRubyObject add_method_annotation(ThreadContext context, IRubyObject maybeClass, IRubyObject methodName, IRubyObject annoMap) {
            RubyClass clazz = JRubyClassExtensions.getRubyClass(maybeClass, context);
            String method2 = methodName.convertToString().asJavaString();
            Map annos = (Map)((Object)annoMap);
            for (Map.Entry entry : annos.entrySet()) {
                Map value2 = (Map)entry.getValue();
                if (value2 == null) {
                    value2 = Collections.EMPTY_MAP;
                }
                clazz.addMethodAnnotation(method2, JRubyClassExtensions.getAnnoClass(context, entry.getKey()), value2);
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod
        public static IRubyObject add_parameter_annotations(ThreadContext context, IRubyObject maybeClass, IRubyObject methodName, IRubyObject paramAnnoMaps) {
            RubyClass clazz = JRubyClassExtensions.getRubyClass(maybeClass, context);
            String method2 = methodName.convertToString().asJavaString();
            List annos = (List)((Object)paramAnnoMaps);
            for (int i = annos.size() - 1; i >= 0; --i) {
                Map paramAnnos = (Map)annos.get(i);
                for (Map.Entry entry : paramAnnos.entrySet()) {
                    Map value2 = (Map)entry.getValue();
                    if (value2 == null) {
                        value2 = Collections.EMPTY_MAP;
                    }
                    clazz.addParameterAnnotation(method2, i, JRubyClassExtensions.getAnnoClass(context, entry.getKey()), value2);
                }
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod
        public static IRubyObject add_class_annotation(ThreadContext context, IRubyObject maybeClass, IRubyObject annoMap) {
            RubyClass clazz = JRubyClassExtensions.getRubyClass(maybeClass, context);
            Map annos = (Map)((Object)annoMap);
            for (Map.Entry entry : annos.entrySet()) {
                Map value2 = (Map)entry.getValue();
                if (value2 == null) {
                    value2 = Collections.EMPTY_MAP;
                }
                clazz.addClassAnnotation(JRubyClassExtensions.getAnnoClass(context, entry.getKey()), value2);
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod
        public static IRubyObject add_method_signature(ThreadContext context, IRubyObject maybeClass, IRubyObject methodName, IRubyObject clsList) {
            RubyClass clazz = JRubyClassExtensions.getRubyClass(maybeClass, context);
            ArrayList<Class> types = new ArrayList<Class>();
            Iterator i = ((List)((Object)clsList)).iterator();
            while (i.hasNext()) {
                types.add(JRubyClassExtensions.getAnnoClass(context, i.next()));
            }
            clazz.addMethodSignature(methodName.convertToString().asJavaString(), types.toArray(new Class[types.size()]));
            return context.getRuntime().getNil();
        }

        private static Class getAnnoClass(ThreadContext context, Object annoClass) {
            IRubyObject annoMod;
            if (annoClass instanceof Class) {
                return (Class)annoClass;
            }
            if (annoClass instanceof IRubyObject && (annoMod = (IRubyObject)annoClass).respondsTo("java_class")) {
                return (Class)annoMod.callMethod(context, "java_class").toJava(Object.class);
            }
            throw context.getRuntime().newArgumentError("must supply java class argument instead of " + annoClass.toString());
        }

        private static RubyClass getRubyClass(IRubyObject maybeClass, ThreadContext context) throws RaiseException {
            if (!(maybeClass instanceof RubyClass)) {
                throw context.getRuntime().newTypeError(maybeClass, context.getRuntime().getClassClass());
            }
            RubyClass clazz = (RubyClass)maybeClass;
            return clazz;
        }
    }

    @JRubyModule(name={"JRubyExtensions"})
    public static class JRubyExtensions {
        @JRubyMethod(name={"steal_method"}, required=2, module=true)
        public static IRubyObject steal_method(IRubyObject recv2, IRubyObject type2, IRubyObject methodName) {
            RubyModule to_add = null;
            to_add = recv2 instanceof RubyModule ? (RubyModule)recv2 : recv2.getSingletonClass();
            String name2 = methodName.toString();
            if (!(type2 instanceof RubyModule)) {
                throw recv2.getRuntime().newArgumentError("First argument must be a module/class");
            }
            DynamicMethod method2 = ((RubyModule)type2).searchMethod(name2);
            if (method2 == null || method2.isUndefined()) {
                throw recv2.getRuntime().newArgumentError("No such method " + name2 + " on " + type2);
            }
            to_add.addMethod(name2, method2);
            return recv2.getRuntime().getNil();
        }

        @JRubyMethod(name={"steal_methods"}, required=1, rest=true, module=true)
        public static IRubyObject steal_methods(IRubyObject recv2, IRubyObject[] args2) {
            IRubyObject type2 = args2[0];
            for (int i = 1; i < args2.length; ++i) {
                JRubyExtensions.steal_method(recv2, type2, args2[i]);
            }
            return recv2.getRuntime().getNil();
        }
    }

    @JRubyClass(name={"JRuby::FiberLocal"})
    public static final class JRubyFiberLocal
    extends JRubyExecutionContextLocal {
        public static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass type2) {
                return new JRubyFiberLocal(runtime2, type2);
            }
        };

        public JRubyFiberLocal(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"with_value"}, required=1)
        public IRubyObject withValue(ThreadContext context, IRubyObject value2, Block block) {
            IRubyObject iRubyObject;
            Map<Object, IRubyObject> contextVariables = this.getContextVariables(context);
            IRubyObject old_value = contextVariables.get(this);
            contextVariables.put(this, value2);
            try {
                iRubyObject = block.yieldSpecific(context);
                Object var8_7 = null;
                contextVariables.put(this, old_value);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                contextVariables.put(this, old_value);
                throw throwable;
            }
            return iRubyObject;
        }

        protected final ExecutionContext getExecutionContext(ThreadContext context) {
            FiberLibrary.Fiber fiber = context.getFiber();
            if (fiber != null) {
                return fiber;
            }
            return context.getThread();
        }
    }

    @JRubyClass(name={"JRuby::ThreadLocal"})
    public static final class JRubyThreadLocal
    extends JRubyExecutionContextLocal {
        public static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass type2) {
                return new JRubyThreadLocal(runtime2, type2);
            }
        };

        public JRubyThreadLocal(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        protected final ExecutionContext getExecutionContext(ThreadContext context) {
            return context.getThread();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class JRubyExecutionContextLocal
    extends RubyObject {
        private IRubyObject default_value;
        private RubyProc default_proc;
        private static final IRubyObject[] EMPTY_ARGS = new IRubyObject[0];

        public JRubyExecutionContextLocal(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            this.default_value = runtime2.getNil();
            this.default_proc = null;
        }

        @JRubyMethod(name={"initialize"}, required=0, optional=1)
        public IRubyObject rubyInitialize(ThreadContext context, IRubyObject[] args2, Block block) {
            if (block.isGiven()) {
                if (args2.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments");
                }
                this.default_proc = block.getProcObject();
                if (this.default_proc == null) {
                    this.default_proc = RubyProc.newProc(context.getRuntime(), block, block.type);
                }
            } else if (args2.length == 1) {
                this.default_value = args2[0];
            } else if (args2.length != 0) {
                throw context.getRuntime().newArgumentError("wrong number of arguments");
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"default"}, required=0)
        public IRubyObject getDefault(ThreadContext context) {
            return this.default_value;
        }

        @JRubyMethod(name={"default_proc"}, required=0)
        public IRubyObject getDefaultProc(ThreadContext context) {
            if (this.default_proc != null) {
                return this.default_proc;
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(name={"value"}, required=0)
        public IRubyObject getValue(ThreadContext context) {
            Map<Object, IRubyObject> contextVariables = this.getContextVariables(context);
            IRubyObject value2 = contextVariables.get(this);
            if (value2 != null) {
                return value2;
            }
            if (this.default_proc != null) {
                contextVariables.put(this, context.getRuntime().getNil());
                IRubyObject new_value = this.default_proc.call(context, EMPTY_ARGS, null, Block.NULL_BLOCK);
                contextVariables.put(this, new_value);
                return new_value;
            }
            return this.default_value;
        }

        @JRubyMethod(name={"value="}, required=1)
        public IRubyObject setValue(ThreadContext context, IRubyObject value2) {
            this.getContextVariables(context).put(this, value2);
            return value2;
        }

        protected final Map<Object, IRubyObject> getContextVariables(ThreadContext context) {
            return this.getExecutionContext(context).getContextVariables();
        }

        protected abstract ExecutionContext getExecutionContext(ThreadContext var1);
    }

    @JRubyClass(name={"JRuby::CompiledScript"})
    public static class JRubyCompiledScript {
        @JRubyMethod(name={"to_s"})
        public static IRubyObject compiled_script_to_s(IRubyObject recv2) {
            return recv2.getInstanceVariables().fastGetInstanceVariable("@original_script");
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject compiled_script_inspect(IRubyObject recv2) {
            return recv2.getRuntime().newString("#<JRuby::CompiledScript " + recv2.getInstanceVariables().fastGetInstanceVariable("@name") + ">");
        }

        @JRubyMethod(name={"inspect_bytecode"})
        public static IRubyObject compiled_script_inspect_bytecode(IRubyObject recv2) {
            StringWriter sw = new StringWriter();
            ClassReader cr = new ClassReader((byte[])recv2.getInstanceVariables().fastGetInstanceVariable("@code").toJava(byte[].class));
            TraceClassVisitor cv = new TraceClassVisitor(new PrintWriter(sw));
            cr.accept(cv, 2);
            return recv2.getRuntime().newString(sw.toString());
        }
    }

    public static class JRubySynchronizedMeta {
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject append_features(IRubyObject self, IRubyObject target) {
            if (target instanceof RubyClass && self instanceof RubyModule) {
                RubyClass targetModule = (RubyClass)target;
                targetModule.becomeSynchronized();
                return ((RubyModule)self).append_features(target);
            }
            throw target.getRuntime().newTypeError(self + " can only be included into classes");
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject extend_object(IRubyObject self, IRubyObject obj) {
            if (self instanceof RubyModule) {
                RubyClass singletonClass = obj.getSingletonClass();
                singletonClass.becomeSynchronized();
                return ((RubyModule)self).extend_object(obj);
            }
            throw self.getRuntime().newTypeError("JRuby::Singleton.extend_object called against " + self);
        }
    }
}

