/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby runtime2) {
        RubyModule enumModule = runtime2.defineModule("Enumerable");
        runtime2.setEnumerable(enumModule);
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(Ruby runtime2, ThreadContext context, IRubyObject self, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock.newCallClosure(self, runtime2.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime2, ThreadContext context, IRubyObject self, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock19.newCallClosure(self, runtime2.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject[] args2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime2.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime2, ThreadContext context, IRubyObject self, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock.newCallClosure(self, runtime2.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime2, ThreadContext context, IRubyObject self, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", CallBlock19.newCallClosure(self, runtime2.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject[] args2, Arity arity2, BlockCallback callback) {
        return RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime2.getEnumerable(), arity2, callback, context));
    }

    private static void checkContext(ThreadContext firstContext, ThreadContext secondContext, String name2) {
        if (firstContext != secondContext) {
            throw secondContext.getRuntime().newThreadError("Enumerable#" + name2 + " cannot be parallelized");
        }
    }

    public static IRubyObject checkArgs(Ruby runtime2, IRubyObject[] largs) {
        return largs.length == 0 ? runtime2.getNil() : largs[0];
    }

    @JRubyMethod
    public static IRubyObject count(ThreadContext context, IRubyObject self, final Block block) {
        int[] result;
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            result = new int[]{0};
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(localContext, ctx, "count");
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        result[0] = result[0] + 1;
                    }
                    return runtime2.getNil();
                }
            });
        } else {
            if (self.respondsTo("size")) {
                return self.callMethod(context, "size");
            }
            result = new int[]{0};
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(localContext, ctx, "count");
                    result[0] = result[0] + 1;
                    return runtime2.getNil();
                }
            });
        }
        return RubyFixnum.newFixnum(runtime2, result[0]);
    }

    @JRubyMethod
    public static IRubyObject count(ThreadContext context, IRubyObject self, final IRubyObject arg2, Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        final int[] result = new int[]{0};
        if (block.isGiven()) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block block) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyEnumerable.checkContext(localContext, ctx, "count");
                if (larg.equals(arg2)) {
                    result[0] = result[0] + 1;
                }
                return runtime2.getNil();
            }
        });
        return RubyFixnum.newFixnum(runtime2, result[0]);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), self, "cycle");
        }
        return RubyEnumerable.cycleCommon(context, self, -1L, block);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return RubyEnumerable.cycle(context, self, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), self, "cycle", arg2);
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.getRuntime().getNil();
        }
        return RubyEnumerable.cycleCommon(context, self, times2, block);
    }

    private static IRubyObject cycleCommon(ThreadContext context, IRubyObject self, long nv, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyArray rubyArray = result;
                synchronized (rubyArray) {
                    result.append(larg);
                }
                block.yield(ctx, larg);
                return runtime2.getNil();
            }
        });
        int len = result.size();
        if (len == 0) {
            return runtime2.getNil();
        }
        while (nv < 0L || 0L < --nv) {
            for (int i = 0; i < len; ++i) {
                block.yield(context, result.eltInternal(i));
            }
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"take"})
    public static IRubyObject take(ThreadContext context, IRubyObject self, IRubyObject n, Block block) {
        final Ruby runtime2 = context.getRuntime();
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime2.newArgumentError("attempt to take negative size");
        }
        if (len == 0L) {
            return runtime2.newEmptyArray();
        }
        final RubyArray result = runtime2.newArray();
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
                long i;
                {
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(larg);
                        if (--this.i == 0L) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod
    public static IRubyObject take_while(ThreadContext context, IRubyObject self, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), self, "take_while");
        }
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (!block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(larg);
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod(name={"drop"})
    public static IRubyObject drop(ThreadContext context, IRubyObject self, IRubyObject n, Block block) {
        final Ruby runtime2 = context.getRuntime();
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime2.newArgumentError("attempt to drop negative size");
        }
        final RubyArray result = runtime2.newArray();
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
                long i;
                {
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        if (this.i == 0L) {
                            result.append(larg);
                        } else {
                            --this.i;
                        }
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod
    public static IRubyObject drop_while(ThreadContext context, IRubyObject self, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), self, "drop_while");
        }
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
                boolean memo = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (!this.memo && !block.yield(ctx, larg).isTrue()) {
                        this.memo = true;
                    }
                    if (this.memo) {
                        RubyArray rubyArray = result;
                        synchronized (rubyArray) {
                            result.append(larg);
                        }
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        final IRubyObject[] holder = new IRubyObject[]{runtime2.getNil()};
        try {
            RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "first");
                    holder[0] = larg;
                    throw JumpException.SPECIAL_JUMP;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return holder[0];
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self, final IRubyObject num) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        final ThreadContext localContext = context;
        int firstCount = RubyNumeric.fix2int(num);
        if (firstCount < 0) {
            throw runtime2.newArgumentError("negative index");
        }
        if (firstCount == 0) {
            return result;
        }
        try {
            RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){
                private int iter;
                {
                    this.iter = RubyNumeric.fix2int(num);
                }

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "first");
                    result.append(larg);
                    if (this.iter-- == 1) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            // empty catch block
        }
        return result;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime2, result));
        return result;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = runtime2.newArray();
        RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime2.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(runtime2, result), context));
        return result;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime2, result));
        result.infectBy(self);
        return result;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = runtime2.newArray();
        RuntimeHelpers.invoke(context, self, "each", args2, CallBlock.newCallClosure(self, runtime2.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(runtime2, result), context));
        result.infectBy(self);
        return result;
    }

    @JRubyMethod
    public static IRubyObject sort(ThreadContext context, IRubyObject self, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime2, result));
        result.sort_bang(context, block);
        return result;
    }

    public static IRubyObject sort_byCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        if (self instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self;
            final IRubyObject[][] valuesAndCriteria = new IRubyObject[selfArray.size()][2];
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
                AtomicInteger i = new AtomicInteger(0);

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject[] myVandC = valuesAndCriteria[this.i.getAndIncrement()];
                    myVandC[0] = larg;
                    myVandC[1] = block.yield(ctx, larg);
                    return runtime2.getNil();
                }
            });
            Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

                @Override
                public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                    return RubyFixnum.fix2int(o1[1].callMethod(localContext, "<=>", o2[1]));
                }
            });
            IRubyObject[] dstArray = new IRubyObject[selfArray.size()];
            for (int i = 0; i < dstArray.length; ++i) {
                dstArray[i] = valuesAndCriteria[i][0];
            }
            return runtime2.newArrayNoCopy(dstArray);
        }
        final ArrayList valuesAndCriteria = new ArrayList();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                IRubyObject[] myVandC = new IRubyObject[]{larg, block.yield(ctx, larg)};
                valuesAndCriteria.add(myVandC);
                return runtime2.getNil();
            }
        });
        Collections.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                return RubyFixnum.fix2int(o1[1].callMethod(localContext, "<=>", o2[1]));
            }
        });
        IRubyObject[] dstArray = new IRubyObject[valuesAndCriteria.size()];
        for (int i = 0; i < dstArray.length; ++i) {
            dstArray[i] = ((IRubyObject[])valuesAndCriteria.get(i))[0];
        }
        return runtime2.newArrayNoCopy(dstArray);
    }

    @JRubyMethod
    public static IRubyObject sort_by(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.sort_byCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "sort_by");
    }

    @JRubyMethod
    public static IRubyObject grep(ThreadContext context, IRubyObject self, final IRubyObject pattern, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    ctx.setRubyFrameDelta(ctx.getRubyFrameDelta() + 2);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        IRubyObject value2 = block.yield(ctx, larg);
                        RubyArray rubyArray = result;
                        synchronized (rubyArray) {
                            result.append(value2);
                        }
                    }
                    ctx.setRubyFrameDelta(ctx.getRubyFrameDelta() - 2);
                    return runtime2.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        RubyArray rubyArray = result;
                        synchronized (rubyArray) {
                            result.append(larg);
                        }
                    }
                    return runtime2.getNil();
                }
            });
        }
        return result;
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.detectCommon(context, self, null, block);
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self, IRubyObject ifnone, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final IRubyObject[] result = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "detect/find");
                    if (block.yield(ctx, larg).isTrue()) {
                        result[0] = larg;
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return result[0];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : runtime2.getNil();
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, null, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "detect");
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, ifnone, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self, ifnone, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "detect", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, null, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "find");
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find(context, ifnone, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self, ifnone, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "find", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find_index(ThreadContext context, IRubyObject self, Block block) {
        boolean blockGiven = block.isGiven();
        if (self instanceof RubyArray && blockGiven) {
            return ((RubyArray)self).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "find_index");
    }

    @JRubyMethod
    public static IRubyObject find_index(ThreadContext context, IRubyObject self, IRubyObject cond, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (block.isGiven()) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        if (self instanceof RubyArray) {
            return ((RubyArray)self).find_index(context, cond);
        }
        return RubyEnumerable.find_indexCommon(context, self, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final long[] result = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result[0] = result[0] + 1L;
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime2, result[0]);
        }
        return runtime2.getNil();
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self, final IRubyObject cond) {
        final Ruby runtime2 = context.getRuntime();
        final long[] result = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    if (larg.equals(cond)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result[0] = result[0] + 1L;
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime2, result[0]);
        }
        return runtime2.getNil();
    }

    public static IRubyObject selectCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(larg);
                    }
                }
                return runtime2.getNil();
            }
        });
        return result;
    }

    @JRubyMethod
    public static IRubyObject select(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "select");
    }

    @JRubyMethod
    public static IRubyObject find_all(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "find_all");
    }

    public static IRubyObject rejectCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(larg);
                    }
                }
                return runtime2.getNil();
            }
        });
        return result;
    }

    @JRubyMethod
    public static IRubyObject reject(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.rejectCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "reject");
    }

    @JRubyMethod(name={"collect", "map"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject collect(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray result = runtime2.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject value2 = block.yield(ctx, larg);
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(value2);
                    }
                    return runtime2.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(runtime2, result));
        }
        return result;
    }

    @JRubyMethod(name={"collect"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.collectCommon19(context, self, block, "collect");
    }

    @JRubyMethod(name={"map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject map19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.collectCommon19(context, self, block, "map");
    }

    private static IRubyObject collectCommon19(ThreadContext context, IRubyObject self, final Block block, String methodName) {
        final Ruby runtime2 = context.getRuntime();
        if (block.isGiven()) {
            final RubyArray result = runtime2.newArray();
            RubyEnumerable.callEach19(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject value2 = block.yield(ctx, larg);
                    RubyArray rubyArray = result;
                    synchronized (rubyArray) {
                        result.append(value2);
                    }
                    return runtime2.getNil();
                }
            });
            return result;
        }
        return RubyEnumerator.enumeratorize(runtime2, self, methodName);
    }

    public static IRubyObject collectCommon(ThreadContext context, Ruby runtime2, IRubyObject self, RubyArray result, Block block, BlockCallback blockCallback) {
        RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, blockCallback);
        return result;
    }

    @JRubyMethod(name={"flat_map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject flat_map19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self, block, "flat_map");
    }

    @JRubyMethod(name={"collect_concat"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect_concat19(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self, block, "collect_concat");
    }

    private static IRubyObject flatMapCommon19(ThreadContext context, IRubyObject self, final Block block, String methodName) {
        final Ruby runtime2 = context.getRuntime();
        if (block.isGiven()) {
            final RubyArray ary = runtime2.newArray();
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject i = block.yield(ctx, larg);
                    IRubyObject tmp = i.checkArrayType();
                    RubyArray rubyArray = ary;
                    synchronized (rubyArray) {
                        if (tmp.isNil()) {
                            ary.append(i);
                        } else {
                            ary.concat(tmp);
                        }
                    }
                    return runtime2.getNil();
                }
            });
            return ary;
        }
        return RubyEnumerator.enumeratorize(runtime2, self, methodName);
    }

    public static IRubyObject injectCommon(ThreadContext context, IRubyObject self, IRubyObject init, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final IRubyObject[] result = new IRubyObject[]{init};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyEnumerable.checkContext(localContext, ctx, "inject");
                result[0] = result[0] == null ? larg : block.yieldArray(ctx, runtime2.newArray(result[0], larg), null, null);
                return runtime2.getNil();
            }
        });
        return result[0] == null ? runtime2.getNil() : result[0];
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.injectCommon(context, self, null, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.injectCommon(context, self, arg2, block) : RubyEnumerable.inject(context, self, null, arg2, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self, IRubyObject init, IRubyObject method2, Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (block.isGiven()) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        final String methodId = method2.asJavaString();
        final IRubyObject[] result = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                result[0] = result[0] == null ? larg : result[0].callMethod(ctx, methodId, larg);
                return runtime2.getNil();
            }
        });
        return result[0] == null ? runtime2.getNil() : result[0];
    }

    public static IRubyObject partitionCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final RubyArray arr_true = runtime2.newArray();
        final RubyArray arr_false = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = arr_true;
                    synchronized (rubyArray) {
                        arr_true.append(larg);
                    }
                }
                RubyArray rubyArray = arr_false;
                synchronized (rubyArray) {
                    arr_false.append(larg);
                }
                return runtime2.getNil();
            }
        });
        return runtime2.newArray((IRubyObject)arr_true, (IRubyObject)arr_false);
    }

    @JRubyMethod(name={"partition"})
    public static IRubyObject partition(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.partitionCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "partition");
    }

    public static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self, Block block) {
        RubyEnumerable.callEach(context.getRuntime(), context, self, Arity.TWO_ARGUMENTS, (BlockCallback)new EachWithIndex(context, block));
        return self;
    }

    public static IRubyObject each_with_indexCommon19(ThreadContext context, IRubyObject self, Block block, IRubyObject[] args2) {
        RubyEnumerable.callEach(context.getRuntime(), context, self, args2, Arity.TWO_ARGUMENTS, new EachWithIndex(context, block));
        return self;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_with_index");
    }

    @JRubyMethod(name={"each_with_index"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_with_index19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon19(context, self, block, args2) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_with_index", args2);
    }

    @JRubyMethod
    public static IRubyObject enum_with_index(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "enum_with_index");
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_entry(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, self, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "each_entry", args2);
    }

    private static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self, IRubyObject[] args2, final Block block) {
        RubyEnumerable.callEach(context.getRuntime(), context, self, args2, block.arity(), new BlockCallback(){

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yieldSpecific(ctx, RubyEnumerable.checkArgs(ctx.getRuntime(), largs));
            }
        });
        return self;
    }

    @JRubyMethod
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self, RubyEnumerable.to_a(context, self), block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "reverse_each");
    }

    @JRubyMethod(rest=true)
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self, RubyEnumerable.to_a(context, self, args2), block) : RubyEnumerator.enumeratorize(context.getRuntime(), self, "reverse_each", args2);
    }

    private static IRubyObject reverse_eachInternal(ThreadContext context, IRubyObject self, IRubyObject obj, Block block) {
        ((RubyArray)obj).reverse_each(context, block);
        return self;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1)
    public static IRubyObject include_p(ThreadContext context, IRubyObject self, final IRubyObject arg2) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        try {
            RubyEnumerable.callEach(runtime2, context, self, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "include?/member?");
                    if (RubyObject.equalInternal(ctx, larg, arg2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime2.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final IRubyObject[] result = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "max{}");
                    if (result[0] == null || RubyComparable.cmpint(ctx, block.yieldArray(ctx, runtime2.newArray(larg, result[0]), null, null), larg, result[0]) > 0) {
                        result[0] = larg;
                    }
                    return runtime2.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject[] iRubyObjectArray = result;
                    synchronized (result) {
                        if (result[0] == null || RubyComparable.cmpint(ctx, larg.callMethod(ctx, "<=>", result[0]), larg, result[0]) > 0) {
                            result[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime2.getNil();
                    }
                }
            });
        }
        return result[0] == null ? runtime2.getNil() : result[0];
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, self, "max_by");
        }
        final IRubyObject[] result = new IRubyObject[]{runtime2.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
            IRubyObject memo = null;

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyEnumerable.checkContext(localContext, ctx, "max_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, v.callMethod(ctx, "<=>", this.memo), v, this.memo) > 0) {
                    this.memo = v;
                    result[0] = larg;
                }
                return runtime2.getNil();
            }
        });
        return result[0];
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final IRubyObject[] result = new IRubyObject[]{null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyEnumerable.checkContext(localContext, ctx, "min{}");
                    if (result[0] == null || RubyComparable.cmpint(ctx, block.yield(ctx, runtime2.newArray(larg, result[0])), larg, result[0]) < 0) {
                        result[0] = larg;
                    }
                    return runtime2.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject[] iRubyObjectArray = result;
                    synchronized (result) {
                        if (result[0] == null || RubyComparable.cmpint(ctx, larg.callMethod(ctx, "<=>", result[0]), larg, result[0]) < 0) {
                            result[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime2.getNil();
                    }
                }
            });
        }
        return result[0] == null ? runtime2.getNil() : result[0];
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, self, "min_by");
        }
        final IRubyObject[] result = new IRubyObject[]{runtime2.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
            IRubyObject memo = null;

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyEnumerable.checkContext(localContext, ctx, "min_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, v.callMethod(ctx, "<=>", this.memo), v, this.memo) < 0) {
                    this.memo = v;
                    result[0] = larg;
                }
                return runtime2.getNil();
            }
        });
        return result[0];
    }

    @JRubyMethod
    public static IRubyObject minmax(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final IRubyObject[] result = new IRubyObject[]{null, null};
        final ThreadContext localContext = context;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(localContext, ctx, "minmax");
                    IRubyObject arg2 = RubyEnumerable.checkArgs(runtime2, largs);
                    if (result[0] == null) {
                        result[0] = result[1] = arg2;
                    } else {
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime2.newArray(arg2, result[0])), arg2, result[0]) < 0) {
                            result[0] = arg2;
                        }
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime2.newArray(arg2, result[1])), arg2, result[1]) > 0) {
                            result[1] = arg2;
                        }
                    }
                    return runtime2.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject arg2 = RubyEnumerable.checkArgs(runtime2, largs);
                    IRubyObject[] iRubyObjectArray = result;
                    synchronized (result) {
                        if (result[0] == null) {
                            result[0] = result[1] = arg2;
                        } else {
                            if (RubyComparable.cmpint(ctx, arg2.callMethod(ctx, "<=>", result[0]), arg2, result[0]) < 0) {
                                result[0] = arg2;
                            }
                            if (RubyComparable.cmpint(ctx, arg2.callMethod(ctx, "<=>", result[1]), arg2, result[1]) > 0) {
                                result[1] = arg2;
                            }
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return runtime2.getNil();
                    }
                }
            });
        }
        if (result[0] == null) {
            result[0] = result[1] = runtime2.getNil();
        }
        return runtime2.newArrayNoCopy(result);
    }

    @JRubyMethod
    public static IRubyObject minmax_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, self, "minmax_by");
        }
        final IRubyObject[] result = new IRubyObject[]{runtime2.getNil(), runtime2.getNil()};
        final ThreadContext localContext = context;
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
            IRubyObject minMemo = null;
            IRubyObject maxMemo = null;

            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyEnumerable.checkContext(localContext, ctx, "minmax_by");
                IRubyObject arg2 = RubyEnumerable.checkArgs(runtime2, largs);
                IRubyObject v = block.yield(ctx, arg2);
                if (this.minMemo == null) {
                    this.minMemo = this.maxMemo = v;
                    result[0] = result[1] = arg2;
                } else {
                    if (RubyComparable.cmpint(ctx, v.callMethod(ctx, "<=>", this.minMemo), v, this.minMemo) < 0) {
                        this.minMemo = v;
                        result[0] = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, v.callMethod(ctx, "<=>", this.maxMemo), v, this.maxMemo) > 0) {
                        this.maxMemo = v;
                        result[1] = arg2;
                    }
                }
                return runtime2.getNil();
            }
        });
        return runtime2.newArrayNoCopy(result);
    }

    @JRubyMethod(name={"none?"})
    public static IRubyObject none_p(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"one?"})
    public static IRubyObject one_p(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        final boolean[] result = new boolean[]{false};
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            if (result[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result[0] = true;
                        }
                        return runtime2.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (larg.isTrue()) {
                            if (result[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result[0] = true;
                        }
                        return runtime2.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime2.getFalse();
        }
        return result[0] ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"all?"})
    public static IRubyObject all_p(ThreadContext context, IRubyObject self, Block block) {
        if (self instanceof RubyArray) {
            return ((RubyArray)self).all_p(context, block);
        }
        return RubyEnumerable.all_pCommon(context, self, block);
    }

    public static IRubyObject all_pCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (!block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"any?"})
    public static IRubyObject any_p(ThreadContext context, IRubyObject self, Block block) {
        if (self instanceof RubyArray) {
            return ((RubyArray)self).any_p(context, block);
        }
        return RubyEnumerable.any_pCommon(context, self, block);
    }

    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        final ThreadContext localContext = context;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "any?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, ctx, "any?");
                        IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime2.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject zip(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self, args2, block, "to_a");
    }

    @JRubyMethod(name={"zip"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject zip19(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self, args2, block, "to_ary");
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime2, IRubyObject[] args2, String methodConverter) {
        RubyClass array = runtime2.getArray();
        for (int i = 0; i < args2.length; ++i) {
            args2[i] = TypeConverter.convertToType(args2[i], array, methodConverter);
        }
        return args2;
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self, IRubyObject[] aArgs, final Block block, String methodConverter) {
        final Ruby runtime2 = context.getRuntime();
        final int aLen = aArgs.length + 1;
        final IRubyObject[] args2 = RubyEnumerable.zipCommonConvert(runtime2, aArgs, methodConverter);
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                    RubyArray array = runtime2.newArray(aLen);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i = 0; i < j; ++i) {
                        array.append(((RubyArray)args2[i]).entry(myIx));
                    }
                    block.yield(ctx, array);
                    return runtime2.getNil();
                }
            });
            return runtime2.getNil();
        }
        final RubyArray zip2 = runtime2.newArray();
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                RubyArray array = runtime2.newArray(aLen);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i = 0; i < j; ++i) {
                    array.append(((RubyArray)args2[i]).entry(myIx));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime2.getNil();
            }
        });
        return zip2;
    }

    @JRubyMethod
    public static IRubyObject group_by(ThreadContext context, IRubyObject self, final Block block) {
        final Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, self, "group_by");
        }
        final RubyHash result = new RubyHash(runtime2);
        RubyEnumerable.callEach(runtime2, context, self, block.arity(), new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.checkArgs(runtime2, largs);
                IRubyObject key2 = block.yield(ctx, larg);
                RubyHash rubyHash = result;
                synchronized (rubyHash) {
                    RubyArray curr = (RubyArray)result.fastARef(key2);
                    if (curr == null) {
                        curr = runtime2.newArray();
                        result.fastASet(key2, curr);
                    }
                    curr.append(larg);
                }
                return runtime2.getNil();
            }
        });
        return result;
    }

    @Deprecated
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        switch (Arity.checkArgumentCount(context.runtime, args2, 0, 1)) {
            case 0: {
                return RubyEnumerable.chunk(context, self, block);
            }
            case 1: {
                return RubyEnumerable.chunk(context, self, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, Block block) {
        return RubyEnumerable.chunk(context, self, context.nil, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self, IRubyObject initialState, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError("no block given");
        }
        IRubyObject enumerator = context.getRuntime().getEnumerator().allocate();
        enumerator.getInternalVariables().setInternalVariable("chunk_enumerable", self);
        enumerator.getInternalVariables().setInternalVariable("chunk_categorize", RubyProc.newProc(context.getRuntime(), block, block.type));
        enumerator.getInternalVariables().setInternalVariable("chunk_initial_state", initialState);
        RuntimeHelpers.invoke(context, enumerator, "initialize", CallBlock.newCallClosure(self, context.getRuntime().getEnumerable(), Arity.noArguments(), new ChunkedBlockCallback(context.getRuntime(), enumerator), context));
        return enumerator;
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject join(ThreadContext context, IRubyObject self) {
        return RubyEnumerable.join(context, self, context.getRuntime().getGlobalVariables().get("$,"));
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject join(ThreadContext context, IRubyObject self, IRubyObject sep) {
        return ((RubyArray)RubyEnumerable.to_a19(context, self)).join19(context, sep);
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyArray result;

        public AppendBlockCallback(Ruby runtime2, RubyArray result) {
            this.runtime = runtime2;
            this.result = result;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            this.result.append(RubyEnumerable.checkArgs(this.runtime, largs));
            return this.runtime.getNil();
        }
    }

    public static final class ChunkedBlockCallback
    implements BlockCallback {
        private final Ruby runtime;
        private final IRubyObject enumerator;

        public ChunkedBlockCallback(Ruby runtime2, IRubyObject enumerator) {
            this.runtime = runtime2;
            this.enumerator = enumerator;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            IRubyObject args2 = RubyEnumerable.checkArgs(this.runtime, largs);
            final ChunkArg arg2 = new ChunkArg();
            IRubyObject enumerable = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_enumerable");
            arg2.categorize = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_categorize");
            arg2.state = (IRubyObject)this.enumerator.getInternalVariables().getInternalVariable("chunk_initial_state");
            arg2.prev_value = this.runtime.getNil();
            arg2.prev_elts = this.runtime.getNil();
            arg2.yielder = args2;
            if (!arg2.state.isNil()) {
                arg2.state = arg2.state.dup();
            }
            final RubySymbol alone = this.runtime.newSymbol("_alone");
            final RubySymbol separator = this.runtime.newSymbol("_separator");
            RubyEnumerable.callEach(this.runtime, context, enumerable, Arity.ONE_ARGUMENT, new BlockCallback(){

                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject i = RubyEnumerable.checkArgs(ChunkedBlockCallback.this.runtime, largs);
                    IRubyObject v = arg2.state.isNil() ? arg2.categorize.callMethod(ctx, "call", i) : arg2.categorize.callMethod(ctx, "call", new IRubyObject[]{i, arg2.state});
                    if (v == alone) {
                        if (!arg2.prev_value.isNil()) {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ChunkedBlockCallback.this.runtime.getNil();
                        }
                        arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(v, (IRubyObject)ChunkedBlockCallback.this.runtime.newArray(i)));
                    } else if (v.isNil() || v == separator) {
                        if (!arg2.prev_value.isNil()) {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ChunkedBlockCallback.this.runtime.getNil();
                        }
                    } else {
                        if (v instanceof RubySymbol && v.toString().charAt(0) == '_') {
                            throw ChunkedBlockCallback.this.runtime.newRuntimeError("symbol begins with an underscore is reserved");
                        }
                        if (arg2.prev_value.isNil()) {
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(i);
                        } else if (arg2.prev_value.equals(v)) {
                            ((RubyArray)arg2.prev_elts).append(i);
                        } else {
                            arg2.yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(i);
                        }
                    }
                    return ChunkedBlockCallback.this.runtime.getNil();
                }
            });
            if (!arg2.prev_elts.isNil()) {
                arg2.yielder.callMethod(context, "<<", this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
            }
            return this.runtime.getNil();
        }
    }

    static class ChunkArg {
        public IRubyObject categorize;
        public IRubyObject state;
        public IRubyObject prev_value;
        public IRubyObject prev_elts;
        public IRubyObject yielder;

        ChunkArg() {
        }
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext ctx, Block block) {
            this.block = block;
            this.runtime = ctx.getRuntime();
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            switch (iargs.length) {
                case 0: 
                case 1: {
                    this.block.call(context, RubyEnumerable.checkArgs(this.runtime, iargs), this.runtime.newFixnum(this.index++));
                    break;
                }
                case 2: {
                    this.block.call(context, (IRubyObject)this.runtime.newArrayNoCopy(iargs), this.runtime.newFixnum(this.index++));
                }
            }
            return this.runtime.getNil();
        }
    }
}

