/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.util.ModifiableInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixExporter<V, E> {
    private String delimiter = " ";
    private String prefix = "";
    private String suffix = "";

    private void println(PrintWriter printWriter, String string2, String string3, String string4) {
        printWriter.println(this.prefix + string2 + this.suffix + this.delimiter + this.prefix + string3 + this.suffix + this.delimiter + this.prefix + string4 + this.suffix);
    }

    public void exportAdjacencyMatrix(Writer writer, UndirectedGraph<V, E> undirectedGraph) {
        PrintWriter printWriter = new PrintWriter(writer);
        IntegerNameProvider integerNameProvider = new IntegerNameProvider();
        for (Object v : undirectedGraph.vertexSet()) {
            integerNameProvider.getVertexName(v);
        }
        for (Object v : undirectedGraph.vertexSet()) {
            this.exportAdjacencyMatrixVertex(printWriter, integerNameProvider, v, Graphs.neighborListOf(undirectedGraph, v));
        }
        printWriter.flush();
    }

    public void exportAdjacencyMatrix(Writer writer, DirectedGraph<V, E> directedGraph) {
        PrintWriter printWriter = new PrintWriter(writer);
        IntegerNameProvider integerNameProvider = new IntegerNameProvider();
        for (Object v : directedGraph.vertexSet()) {
            integerNameProvider.getVertexName(v);
        }
        for (Object v : directedGraph.vertexSet()) {
            this.exportAdjacencyMatrixVertex(printWriter, integerNameProvider, v, Graphs.successorListOf(directedGraph, v));
        }
        printWriter.flush();
    }

    private void exportAdjacencyMatrixVertex(PrintWriter printWriter, VertexNameProvider<V> vertexNameProvider, V v, List<V> list2) {
        ModifiableInteger modifiableInteger;
        String string2;
        String string3 = vertexNameProvider.getVertexName(v);
        LinkedHashMap<String, ModifiableInteger> linkedHashMap = new LinkedHashMap<String, ModifiableInteger>();
        for (V object : list2) {
            string2 = vertexNameProvider.getVertexName(object);
            modifiableInteger = (ModifiableInteger)linkedHashMap.get(string2);
            if (modifiableInteger == null) {
                modifiableInteger = new ModifiableInteger(0);
                linkedHashMap.put(string2, modifiableInteger);
            }
            modifiableInteger.increment();
            if (!v.equals(object)) continue;
            modifiableInteger.increment();
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            string2 = (String)entry.getKey();
            modifiableInteger = (ModifiableInteger)entry.getValue();
            this.println(printWriter, string3, string2, modifiableInteger.toString());
        }
    }

    public void exportLaplacianMatrix(Writer writer, UndirectedGraph<V, E> undirectedGraph) {
        PrintWriter printWriter = new PrintWriter(writer);
        IntegerNameProvider<V> integerNameProvider = new IntegerNameProvider<V>();
        for (Object v : undirectedGraph.vertexSet()) {
            integerNameProvider.getVertexName(v);
        }
        for (Object v : undirectedGraph.vertexSet()) {
            String string2 = integerNameProvider.getVertexName(v);
            List<V> list2 = Graphs.neighborListOf(undirectedGraph, v);
            this.println(printWriter, string2, string2, Integer.toString(list2.size()));
            for (V v2 : list2) {
                String string3 = integerNameProvider.getVertexName(v2);
                this.println(printWriter, string2, string3, "-1");
            }
        }
        printWriter.flush();
    }

    public void exportNormalizedLaplacianMatrix(Writer writer, UndirectedGraph<V, E> undirectedGraph) {
        PrintWriter printWriter = new PrintWriter(writer);
        IntegerNameProvider<Object> integerNameProvider = new IntegerNameProvider<Object>();
        for (Object v : undirectedGraph.vertexSet()) {
            integerNameProvider.getVertexName(v);
        }
        for (Object v : undirectedGraph.vertexSet()) {
            String string2 = integerNameProvider.getVertexName(v);
            LinkedHashSet<V> linkedHashSet = new LinkedHashSet<V>(Graphs.neighborListOf(undirectedGraph, v));
            if (linkedHashSet.isEmpty()) {
                this.println(printWriter, string2, string2, "0");
                continue;
            }
            this.println(printWriter, string2, string2, "1");
            for (Object e : linkedHashSet) {
                String string3 = integerNameProvider.getVertexName(e);
                double d = -1.0 / Math.sqrt(undirectedGraph.degreeOf(v) * undirectedGraph.degreeOf(e));
                this.println(printWriter, string2, string3, Double.toString(d));
            }
        }
        printWriter.flush();
    }
}

