/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGraphModelAdapter<V, E>
extends DefaultGraphModel {
    private static final long serialVersionUID = 3256722883706302515L;
    final Set<GraphCell> jCellsBeingAdded = new HashSet<GraphCell>();
    final Set<GraphCell> jCellsBeingRemoved = new HashSet<GraphCell>();
    final Set<Object> jtElementsBeingAdded = new HashSet<Object>();
    final Set<Object> jtElementsBeingRemoved = new HashSet<Object>();
    private final CellFactory<V, E> cellFactory;
    private final Map<Edge, E> cellToEdge = new HashMap<Edge, E>();
    private final Map<GraphCell, V> cellToVertex = new HashMap<GraphCell, V>();
    private AttributeMap defaultEdgeAttributes;
    private AttributeMap defaultVertexAttributes;
    private final Map<E, Edge> edgeToCell = new HashMap<E, Edge>();
    private final Map<V, GraphCell> vertexToCell = new HashMap<V, GraphCell>();
    private final ShieldedGraph jtGraph;

    public JGraphModelAdapter(Graph<V, E> graph) {
        this(graph, JGraphModelAdapter.createDefaultVertexAttributes(), JGraphModelAdapter.createDefaultEdgeAttributes(graph));
    }

    public JGraphModelAdapter(Graph<V, E> graph, AttributeMap attributeMap, AttributeMap attributeMap2) {
        this(graph, attributeMap, attributeMap2, new DefaultCellFactory());
    }

    public JGraphModelAdapter(Graph<V, E> graph, AttributeMap attributeMap, AttributeMap attributeMap2, CellFactory<V, E> cellFactory) {
        Iterator<E> iterator;
        if (graph == null || attributeMap == null || attributeMap2 == null || cellFactory == null) {
            throw new IllegalArgumentException("null is NOT permitted");
        }
        this.jtGraph = new ShieldedGraph(graph);
        this.setDefaultVertexAttributes(attributeMap);
        this.setDefaultEdgeAttributes(attributeMap2);
        this.cellFactory = cellFactory;
        if (graph instanceof ListenableGraph) {
            iterator = (ListenableGraph)graph;
            iterator.addGraphListener(new JGraphTListener());
        }
        iterator = graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            this.handleJGraphTAddedVertex(iterator.next());
        }
        iterator = graph.edgeSet().iterator();
        while (iterator.hasNext()) {
            this.handleJGraphTAddedEdge(iterator.next());
        }
        this.addGraphModelListener(new JGraphListener());
    }

    public static <V, E> AttributeMap createDefaultEdgeAttributes(Graph<V, E> graph) {
        AttributeMap attributeMap = new AttributeMap();
        if (graph instanceof DirectedGraph) {
            GraphConstants.setLineEnd((Map)attributeMap, (int)2);
            GraphConstants.setEndFill((Map)attributeMap, (boolean)true);
            GraphConstants.setEndSize((Map)attributeMap, (int)10);
        }
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.decode("#25507C"));
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setLineColor((Map)attributeMap, (Color)Color.decode("#7AA1E6"));
        return attributeMap;
    }

    public static AttributeMap createDefaultVertexAttributes() {
        AttributeMap attributeMap = new AttributeMap();
        Color color = Color.decode("#FF9900");
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)new Rectangle2D.Double(50.0, 50.0, 90.0, 30.0));
        GraphConstants.setBorder((Map)attributeMap, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground((Map)attributeMap, (Color)color);
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.white);
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque((Map)attributeMap, (boolean)true);
        return attributeMap;
    }

    public CellFactory<V, E> getCellFactory() {
        return this.cellFactory;
    }

    public void setDefaultEdgeAttributes(AttributeMap attributeMap) {
        this.defaultEdgeAttributes = attributeMap;
    }

    public AttributeMap getDefaultEdgeAttributes() {
        return this.defaultEdgeAttributes;
    }

    public void setDefaultVertexAttributes(AttributeMap attributeMap) {
        this.defaultVertexAttributes = attributeMap;
    }

    public AttributeMap getDefaultVertexAttributes() {
        return this.defaultVertexAttributes;
    }

    public DefaultEdge getEdgeCell(E e) {
        return (DefaultEdge)this.edgeToCell.get(e);
    }

    public DefaultGraphCell getVertexCell(Object object) {
        return (DefaultGraphCell)this.vertexToCell.get(object);
    }

    public DefaultPort getVertexPort(Object object) {
        DefaultGraphCell defaultGraphCell = this.getVertexCell(object);
        if (defaultGraphCell == null) {
            return null;
        }
        return (DefaultPort)defaultGraphCell.getChildAt(0);
    }

    void handleJGraphChangedEdge(Edge edge) {
        if (this.isDangling(edge)) {
            if (this.cellToEdge.containsKey(edge)) {
                this.handleJGraphRemovedEdge(edge);
            }
        } else if (this.cellToEdge.containsKey(edge)) {
            E e = this.cellToEdge.get(edge);
            Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
            Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
            V v = this.cellToVertex.get(object);
            V v2 = this.cellToVertex.get(object2);
            if (this.jtGraph.getEdgeSource(e) != v || this.jtGraph.getEdgeTarget(e) != v2) {
                this.handleJGraphRemovedEdge(edge);
                this.handleJGraphInsertedEdge(edge);
            }
        } else {
            this.handleJGraphInsertedEdge(edge);
        }
    }

    void handleJGraphInsertedEdge(Edge edge) {
        if (!this.isDangling(edge)) {
            V v;
            Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
            Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
            V v2 = this.cellToVertex.get(object);
            Object e = this.jtGraph.addEdge(v2, v = this.cellToVertex.get(object2));
            if (e != null) {
                this.cellToEdge.put(edge, e);
                this.edgeToCell.put(e, edge);
            } else {
                this.internalRemoveCell((GraphCell)edge);
                System.err.println("Warning: an edge was deleted because the underlying JGraphT graph refused to create it. This situation can happen when a constraint of the underlying graph is violated, e.g., an attempt to add a parallel edge or a self-loop to a graph that forbids them. To avoid this message, make sure to use a suitable underlying JGraphT graph.");
            }
        }
    }

    void handleJGraphInsertedVertex(GraphCell graphCell) {
        Object object = graphCell instanceof DefaultGraphCell ? ((DefaultGraphCell)graphCell).getUserObject() : graphCell.toString();
        if (this.vertexToCell.containsKey(object)) {
            System.err.println("Warning: detected two JGraph vertices with the same JGraphT vertex as user object. It is an indication for a faulty situation that should NOT happen.Removing vertex: " + graphCell);
            this.internalRemoveCell(graphCell);
        } else {
            this.jtGraph.addVertex(object);
            this.cellToVertex.put(graphCell, object);
            this.vertexToCell.put((GraphCell)object, graphCell);
        }
    }

    void handleJGraphRemovedEdge(Edge edge) {
        if (this.cellToEdge.containsKey(edge)) {
            E e = this.cellToEdge.get(edge);
            this.jtGraph.removeEdge(e);
            this.cellToEdge.remove(edge);
            this.edgeToCell.remove(e);
        }
    }

    void handleJGraphRemovedVertex(GraphCell graphCell) {
        if (this.cellToVertex.containsKey(graphCell)) {
            V v = this.cellToVertex.get(graphCell);
            Set set = this.jtGraph.edgesOf(v);
            if (!set.isEmpty()) {
                this.jtGraph.removeAllEdges(new ArrayList(set));
            }
            this.jtGraph.removeVertex(v);
            this.cellToVertex.remove(graphCell);
            this.vertexToCell.remove(v);
        }
    }

    void handleJGraphTAddedEdge(E e) {
        DefaultEdge defaultEdge = this.cellFactory.createEdgeCell(e);
        this.edgeToCell.put(e, (Edge)defaultEdge);
        this.cellToEdge.put((Edge)defaultEdge, e);
        ConnectionSet connectionSet = new ConnectionSet();
        connectionSet.connect((Object)defaultEdge, (Object)this.getVertexPort(this.jtGraph.getEdgeSource(e)), (Object)this.getVertexPort(this.jtGraph.getEdgeTarget(e)));
        this.internalInsertCell((GraphCell)defaultEdge, this.createEdgeAttributeMap(defaultEdge), connectionSet);
    }

    void handleJGraphTAddedVertex(V v) {
        DefaultGraphCell defaultGraphCell = this.cellFactory.createVertexCell(v);
        defaultGraphCell.add((MutableTreeNode)new DefaultPort());
        this.vertexToCell.put((GraphCell)v, (GraphCell)defaultGraphCell);
        this.cellToVertex.put((GraphCell)defaultGraphCell, v);
        this.internalInsertCell((GraphCell)defaultGraphCell, this.createVertexAttributeMap((GraphCell)defaultGraphCell), null);
    }

    void handleJGraphTRemoveVertex(Object object) {
        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.vertexToCell.remove(object);
        this.cellToVertex.remove(defaultGraphCell);
        ArrayList arrayList = new ArrayList();
        for (Object e : defaultGraphCell.getChildren()) {
            if (!this.isPort(e)) continue;
            arrayList.add(e);
        }
        this.remove(arrayList.toArray());
        this.internalRemoveCell((GraphCell)defaultGraphCell);
    }

    void handleJGraphTRemovedEdge(E e) {
        DefaultEdge defaultEdge = (DefaultEdge)this.edgeToCell.remove(e);
        this.cellToEdge.remove(defaultEdge);
        this.internalRemoveCell((GraphCell)defaultEdge);
    }

    private boolean isDangling(Edge edge) {
        Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
        Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
        return !this.cellToVertex.containsKey(object) || !this.cellToVertex.containsKey(object2);
    }

    private AttributeMap createEdgeAttributeMap(DefaultEdge defaultEdge) {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)defaultEdge, this.getDefaultEdgeAttributes().clone());
        return attributeMap;
    }

    private AttributeMap createVertexAttributeMap(GraphCell graphCell) {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)graphCell, this.getDefaultVertexAttributes().clone());
        return attributeMap;
    }

    private void internalInsertCell(GraphCell graphCell, AttributeMap attributeMap, ConnectionSet connectionSet) {
        this.jCellsBeingAdded.add(graphCell);
        this.insert(new Object[]{graphCell}, (Map)attributeMap, connectionSet, null, null);
        this.jCellsBeingAdded.remove(graphCell);
    }

    private void internalRemoveCell(GraphCell graphCell) {
        this.jCellsBeingRemoved.add(graphCell);
        this.remove(new Object[]{graphCell});
        this.jCellsBeingRemoved.remove(graphCell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShieldedGraph {
        private final Graph<V, E> graph;

        ShieldedGraph(Graph<V, E> graph) {
            this.graph = graph;
        }

        EdgeFactory<V, E> getEdgeFactory() {
            return this.graph.getEdgeFactory();
        }

        E addEdge(V v, V v2) {
            Object e = this.graph.getEdgeFactory().createEdge(v, v2);
            JGraphModelAdapter.this.jtElementsBeingAdded.add(e);
            boolean bl = this.graph.addEdge(v, v2, e);
            JGraphModelAdapter.this.jtElementsBeingAdded.remove(e);
            return bl ? e : null;
        }

        V getEdgeSource(E e) {
            return this.graph.getEdgeSource(e);
        }

        V getEdgeTarget(E e) {
            return this.graph.getEdgeTarget(e);
        }

        void addVertex(V v) {
            JGraphModelAdapter.this.jtElementsBeingAdded.add(v);
            this.graph.addVertex(v);
            JGraphModelAdapter.this.jtElementsBeingAdded.remove(v);
        }

        Set<E> edgesOf(V v) {
            return this.graph.edgesOf(v);
        }

        boolean removeAllEdges(Collection<E> collection) {
            return this.graph.removeAllEdges(collection);
        }

        void removeEdge(E e) {
            JGraphModelAdapter.this.jtElementsBeingRemoved.add(e);
            this.graph.removeEdge(e);
            JGraphModelAdapter.this.jtElementsBeingRemoved.remove(e);
        }

        void removeVertex(V v) {
            JGraphModelAdapter.this.jtElementsBeingRemoved.add(v);
            this.graph.removeVertex(v);
            JGraphModelAdapter.this.jtElementsBeingRemoved.remove(v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JGraphTListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 3616724963609360440L;

        private JGraphTListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            Object e = graphEdgeChangeEvent.getEdge();
            if (!JGraphModelAdapter.this.jtElementsBeingAdded.remove(e)) {
                JGraphModelAdapter.this.handleJGraphTAddedEdge(e);
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            Object e = graphEdgeChangeEvent.getEdge();
            if (!JGraphModelAdapter.this.jtElementsBeingRemoved.remove(e)) {
                JGraphModelAdapter.this.handleJGraphTRemovedEdge(e);
            }
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
            Object v = graphVertexChangeEvent.getVertex();
            if (!JGraphModelAdapter.this.jtElementsBeingAdded.remove(v)) {
                JGraphModelAdapter.this.handleJGraphTAddedVertex(v);
            }
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
            Object v = graphVertexChangeEvent.getVertex();
            if (!JGraphModelAdapter.this.jtElementsBeingRemoved.remove(v)) {
                JGraphModelAdapter.this.handleJGraphTRemoveVertex(v);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JGraphListener
    implements GraphModelListener,
    Serializable {
        private static final long serialVersionUID = 3544673988098865209L;

        private JGraphListener() {
        }

        public void graphChanged(GraphModelEvent graphModelEvent) {
            Object[] objectArray;
            Object[] objectArray2;
            GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
            Object[] objectArray3 = graphModelChange.getRemoved();
            if (objectArray3 != null) {
                this.handleRemovedEdges(this.filterEdges(objectArray3));
                this.handleRemovedVertices(this.filterVertices(objectArray3));
            }
            if ((objectArray2 = graphModelChange.getInserted()) != null) {
                this.handleInsertedVertices(this.filterVertices(objectArray2));
                this.handleInsertedEdges(this.filterEdges(objectArray2));
            }
            if ((objectArray = graphModelChange.getChanged()) != null) {
                this.handleChangedEdges(this.filterEdges(objectArray));
            }
        }

        private List<Object> filterEdges(Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Edge)) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList;
        }

        private List<Object> filterVertices(Object[] objectArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof Edge || object instanceof Port) continue;
                if (object instanceof DefaultGraphCell) {
                    DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                    if (!defaultGraphCell.isLeaf() && !(defaultGraphCell.getFirstChild() instanceof Port)) continue;
                    arrayList.add(object);
                    continue;
                }
                if (!(object instanceof GraphCell)) continue;
                arrayList.add(object);
            }
            return arrayList;
        }

        private void handleChangedEdges(List<Object> list2) {
            for (Edge edge : list2) {
                JGraphModelAdapter.this.handleJGraphChangedEdge(edge);
            }
        }

        private void handleInsertedEdges(List<Object> list2) {
            for (Edge edge : list2) {
                if (JGraphModelAdapter.this.jCellsBeingAdded.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedEdge(edge);
            }
        }

        private void handleInsertedVertices(List<Object> list2) {
            for (GraphCell graphCell : list2) {
                if (JGraphModelAdapter.this.jCellsBeingAdded.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedVertex(graphCell);
            }
        }

        private void handleRemovedEdges(List<Object> list2) {
            for (Edge edge : list2) {
                if (JGraphModelAdapter.this.jCellsBeingRemoved.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedEdge(edge);
            }
        }

        private void handleRemovedVertices(List<Object> list2) {
            for (GraphCell graphCell : list2) {
                if (JGraphModelAdapter.this.jCellsBeingRemoved.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedVertex(graphCell);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultCellFactory<VV, EE>
    implements CellFactory<VV, EE>,
    Serializable {
        private static final long serialVersionUID = 3690194343461861173L;

        @Override
        public DefaultEdge createEdgeCell(EE EE) {
            return new DefaultEdge(EE);
        }

        @Override
        public DefaultGraphCell createVertexCell(VV VV) {
            return new DefaultGraphCell(VV);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CellFactory<VV, EE> {
        public DefaultEdge createEdgeCell(EE var1);

        public DefaultGraphCell createVertexCell(VV var1);
    }
}

