/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.tree.analysis;

import java.util.List;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.tree.analysis.AnalyzerException;
import jruby.objectweb.asm.tree.analysis.BasicValue;
import jruby.objectweb.asm.tree.analysis.BasicVerifier;
import jruby.objectweb.asm.tree.analysis.Value;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();
    static /* synthetic */ Class class$java$lang$Object;

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type2, Type type3, boolean bl) {
        this(type2, type3, null, bl);
    }

    public SimpleVerifier(Type type2, Type type3, List list2, boolean bl) {
        this.currentClass = type2;
        this.currentSuperClass = type3;
        this.currentClassInterfaces = list2;
        this.isInterface = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Value newValue(Type type2) {
        Value value2;
        boolean bl;
        if (type2 == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean bl2 = bl = type2.getSort() == 9;
        if (bl) {
            switch (type2.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type2);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(value2 = super.newValue(type2))) {
            if (bl) {
                value2 = this.newValue(type2.getElementType());
                String string2 = ((BasicValue)value2).getType().getDescriptor();
                for (int i = 0; i < type2.getDimensions(); ++i) {
                    string2 = '[' + string2;
                }
                value2 = new BasicValue(Type.getType(string2));
            } else {
                value2 = new BasicValue(type2);
            }
        }
        return value2;
    }

    protected boolean isArrayValue(Value value2) {
        Type type2 = ((BasicValue)value2).getType();
        return type2 != null && ("Lnull;".equals(type2.getDescriptor()) || type2.getSort() == 9);
    }

    protected Value getElementValue(Value value2) throws AnalyzerException {
        Type type2 = ((BasicValue)value2).getType();
        if (type2 != null) {
            if (type2.getSort() == 9) {
                return this.newValue(Type.getType(type2.getDescriptor().substring(1)));
            }
            if ("Lnull;".equals(type2.getDescriptor())) {
                return value2;
            }
        }
        throw new Error("Internal error");
    }

    protected boolean isSubTypeOf(Value value2, Value value3) {
        Type type2 = ((BasicValue)value3).getType();
        Type type3 = ((BasicValue)value2).getType();
        switch (type2.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type3.equals(type2);
            }
            case 9: 
            case 10: {
                if ("Lnull;".equals(type3.getDescriptor())) {
                    return true;
                }
                if (type3.getSort() == 10 || type3.getSort() == 9) {
                    return this.isAssignableFrom(type2, type3);
                }
                return false;
            }
        }
        throw new Error("Internal error");
    }

    public Value merge(Value value2, Value value3) {
        if (!value2.equals(value3)) {
            Type type2 = ((BasicValue)value2).getType();
            Type type3 = ((BasicValue)value3).getType();
            if (!(type2 == null || type2.getSort() != 10 && type2.getSort() != 9 || type3 == null || type3.getSort() != 10 && type3.getSort() != 9)) {
                if ("Lnull;".equals(type2.getDescriptor())) {
                    return value3;
                }
                if ("Lnull;".equals(type3.getDescriptor())) {
                    return value2;
                }
                if (this.isAssignableFrom(type2, type3)) {
                    return value2;
                }
                if (this.isAssignableFrom(type3, type2)) {
                    return value3;
                }
                do {
                    if (type2 != null && !this.isInterface(type2)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(type2 = this.getSuperClass(type2), type3));
                return this.newValue(type2);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return value2;
    }

    protected boolean isInterface(Type type2) {
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type2).isInterface();
    }

    protected Type getSuperClass(Type type2) {
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class clazz = this.getClass(type2).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    protected boolean isAssignableFrom(Type type2, Type type3) {
        if (type2.equals(type3)) {
            return true;
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            if (this.getSuperClass(type3) == null) {
                return false;
            }
            if (this.isInterface) {
                return type3.getSort() == 10 || type3.getSort() == 9;
            }
            return this.isAssignableFrom(type2, this.getSuperClass(type3));
        }
        if (this.currentClass != null && type3.equals(this.currentClass)) {
            if (this.isAssignableFrom(type2, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type type4 = (Type)this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(type2, type4)) continue;
                    return true;
                }
            }
            return false;
        }
        Class clazz = this.getClass(type2);
        if (clazz.isInterface()) {
            clazz = class$java$lang$Object == null ? (class$java$lang$Object = SimpleVerifier.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return clazz.isAssignableFrom(this.getClass(type3));
    }

    protected Class getClass(Type type2) {
        try {
            if (type2.getSort() == 9) {
                return Class.forName(type2.getDescriptor().replace('/', '.'), false, this.loader);
            }
            return Class.forName(type2.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

