/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jnr.netdb.NetDBEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NetDBIterator
implements Iterator<NetDBEntry> {
    private final BufferedReader reader;
    private NetDBEntry next = null;

    public NetDBIterator(Reader r) {
        this.reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
    }

    NetDBEntry readNextEntry() throws IOException {
        String s = null;
        while ((s = this.reader.readLine()) != null) {
            List<String> aliases2;
            String[] fields2;
            String[] line = s.split("#", 2);
            if (line.length < 1 || line[0].length() == 0 || (fields2 = line[0].trim().split("\\s+")).length < 2 || fields2[0] == null || fields2[1] == null) continue;
            String serviceName = fields2[0];
            String data = fields2[1];
            if (fields2.length > 2) {
                aliases2 = new ArrayList(fields2.length - 2);
                for (int i = 2; i < fields2.length; ++i) {
                    if (fields2[i] == null) continue;
                    aliases2.add(fields2[i]);
                }
            } else {
                aliases2 = Collections.emptyList();
            }
            return new NetDBEntry(serviceName, data, aliases2);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next != null || (this.next = this.readNextEntry()) != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public NetDBEntry next() {
        try {
            NetDBEntry s;
            NetDBEntry netDBEntry = s = this.next != null ? this.next : this.readNextEntry();
            if (s == null) {
                throw new NoSuchElementException("not found");
            }
            this.next = null;
            return s;
        }
        catch (IOException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

