/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.libraries.FiberLibrary;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 10;
    private static final int CALL_POLL_COUNT = 4095;
    private static final String UNKNOWN_NAME = "(unknown)";
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private static final RubyContinuation.Continuation[] EMPTY_CATCHTARGET_STACK = new RubyContinuation.Continuation[0];
    private RubyContinuation.Continuation[] catchStack = EMPTY_CATCHTARGET_STACK;
    private int catchIndex = -1;
    private String file = "";
    private int line = 0;
    private final ProfileData profileData = new ProfileData();
    private int rubyFrameDelta = 0;
    private boolean eventHooksEnabled = true;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    public int callNumber = 0;
    public static final Map<String, FrameType> INTERPRETED_FRAMES = new HashMap<String, FrameType>();

    public static ThreadContext newContext(Ruby runtime2) {
        ThreadContext context = new ThreadContext(runtime2);
        return context;
    }

    private ThreadContext(Ruby runtime2) {
        this.runtime = runtime2;
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        Frame[] stack = this.frameStack;
        int length2 = stack.length;
        for (int i = 0; i < length2; ++i) {
            stack[i] = new Frame();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.thread.getErrorInfo();
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.thread.setErrorInfo(errorInfo);
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value2) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value2);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < newSize; ++i) {
            newFrameStack[i] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        int index2 = ++this.scopeIndex;
        DynamicScope[] stack = this.scopeStack;
        stack[index2] = scope;
        if (index2 + 1 == stack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
        if (thread != null) {
            thread.setContext(this);
        }
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        if (newSize == 0) {
            newSize = 1;
        }
        RubyContinuation.Continuation[] newCatchStack = new RubyContinuation.Continuation[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyContinuation.Continuation catchTarget) {
        int index2;
        if ((index2 = ++this.catchIndex) == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
        this.catchStack[index2] = catchTarget;
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyContinuation.Continuation getActiveCatch(String tag) {
        for (int i = this.catchIndex; i >= 0; --i) {
            RubyContinuation.Continuation c = this.catchStack[i];
            if (c.tag != tag) continue;
            return c;
        }
        return null;
    }

    private void pushFrameCopy() {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        Frame currentFrame = stack[index2 - 1];
        stack[index2].updateFrame(currentFrame);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2] = frame;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name2, IRubyObject self, Block block) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(clazz, self, name2, block, this.file, this.line, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject self) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrameForEval(self, this.file, this.line, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String name2) {
        this.pushFrame(name2);
    }

    private void pushFrame(String name2) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(name2, this.file, this.line);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame() {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(this.file, this.line);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        this.setFileAndLine(frame);
        frame.clear();
    }

    private void popFrameReal(Frame oldFrame) {
        int index2 = this.frameIndex;
        Frame frame = this.frameStack[index2];
        this.frameStack[index2] = oldFrame;
        this.frameIndex = index2 - 1;
        this.setFileAndLine(frame);
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int newDelta) {
        this.rubyFrameDelta = newDelta;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        int index2 = this.frameIndex;
        Frame[] stack = this.frameStack;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return stack[index2 + 1];
    }

    public Frame getPreviousFrame() {
        int index2 = this.frameIndex;
        return index2 < 1 ? null : this.frameStack[index2 - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public Frame[] getFrames(int delta) {
        int top = this.frameIndex + delta;
        Frame[] frames = new Frame[top + 1];
        for (int i = 0; i <= top; ++i) {
            frames[i] = this.frameStack[i].duplicateForBacktrace();
        }
        return frames;
    }

    public boolean isJumpTargetAlive(int target, int skipFrames) {
        for (int i = this.frameIndex - skipFrames; i >= 0; --i) {
            if (this.frameStack[i].getJumpTarget() != target) continue;
            return true;
        }
        return false;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public int getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String file2) {
        this.file = file2;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setFileAndLine(String file2, int line) {
        this.file = file2;
        this.line = line;
    }

    public void setFileAndLine(Frame frame) {
        this.file = frame.getFile();
        this.line = frame.getLine();
    }

    public void setFileAndLine(ISourcePosition position) {
        this.file = position.getFile();
        this.line = position.getStartLine();
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.thread.pollThreadEvents(this);
    }

    public int getCurrentTarget() {
        return this.callNumber;
    }

    public void callThreadPoll() {
        if ((this.callNumber++ & 0xFFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public static void callThreadPoll(ThreadContext context) {
        if ((context.callNumber++ & 0xFFF) == 0) {
            context.pollThreadEvents();
        }
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass) {
        this.trace(event, name2, implClass, this.file, this.line);
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass, String file2, int line) {
        this.runtime.callEventHooks(this, event, file2, line, name2, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        int index2 = ++this.parentIndex;
        RubyModule[] stack = this.parentStack;
        stack[index2] = currentModule;
        if (index2 + 1 == stack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int index2 = this.parentIndex;
        RubyModule[] stack = this.parentStack;
        RubyModule ret = stack[index2];
        stack[index2] = null;
        this.parentIndex = index2 - 1;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getPreviousRubyClass() {
        assert (this.parentIndex != 0) : "Trying to get RubyClass from too-shallow stack";
        RubyModule parentModule = this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String internedName) {
        IRubyObject value2 = this.getConstant(internedName);
        return value2 != null;
    }

    public IRubyObject getConstant(String internedName) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, internedName, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result);
            return result;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.fastSetConstant(internedName, result);
        return result;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result) {
        this.runtime.getObject().fastSetConstant(internedName, result);
        return result;
    }

    @Deprecated
    private static void addBackTraceElement(RubyArray backtrace2, RubyStackTraceElement frame, RubyStackTraceElement previousFrame) {
        ThreadContext.addBackTraceElement(backtrace2.getRuntime(), backtrace2, frame, previousFrame);
    }

    private static void addBackTraceElement(Ruby runtime2, RubyArray backtrace2, Frame frame, Frame previousFrame) {
        if (frame != previousFrame && frame.getLine() == previousFrame.getLine() && frame.getName() != null && frame.getName().equals(previousFrame.getName()) && frame.getFile().equals(previousFrame.getFile())) {
            return;
        }
        RubyString traceLine = previousFrame.getName() != null ? RubyString.newString(runtime2, frame.getFile() + ':' + (frame.getLine() + 1) + ":in `" + previousFrame.getName() + '\'') : (runtime2.is1_9() ? RubyString.newString(runtime2, frame.getFile() + ':' + (frame.getLine() + 1) + ":in `<main>'") : RubyString.newString(runtime2, frame.getFile() + ':' + (frame.getLine() + 1)));
        backtrace2.append(traceLine);
    }

    private static void addBackTraceElement(Ruby runtime2, RubyArray backtrace2, RubyStackTraceElement frame, RubyStackTraceElement previousFrame) {
        if (frame != previousFrame && frame.getLineNumber() == previousFrame.getLineNumber() && frame.getMethodName() != null && frame.getMethodName().equals(previousFrame.getMethodName()) && frame.getFileName() != null && frame.getFileName().equals(previousFrame.getFileName())) {
            return;
        }
        String fileName = frame.getFileName();
        if (fileName == null) {
            fileName = "";
        }
        RubyString traceLine = previousFrame.getMethodName() == UNKNOWN_NAME ? RubyString.newString(runtime2, fileName + ':' + frame.getLineNumber()) : RubyString.newString(runtime2, fileName + ':' + frame.getLineNumber() + ":in `" + previousFrame.getMethodName() + '\'');
        backtrace2.append(traceLine);
    }

    private static void addBackTraceElement(RubyArray backtrace2, RubyStackTraceElement frame, RubyStackTraceElement previousFrame, FrameType frameType) {
        if (frame != previousFrame && frame.getMethodName() != null && frame.getMethodName().equals(previousFrame.getMethodName()) && frame.getFileName().equals(previousFrame.getFileName()) && frame.getLineNumber() == previousFrame.getLineNumber()) {
            return;
        }
        StringBuilder buf = new StringBuilder(60);
        buf.append(frame.getFileName()).append(':').append(frame.getLineNumber());
        if (previousFrame.getMethodName() != null) {
            switch (frameType) {
                case METHOD: {
                    buf.append(":in `");
                    buf.append(previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case BLOCK: {
                    buf.append(":in `");
                    buf.append("block in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case EVAL: {
                    buf.append(":in `");
                    buf.append("eval in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case CLASS: {
                    buf.append(":in `");
                    buf.append("class in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case ROOT: {
                    buf.append(":in `<toplevel>'");
                }
            }
        }
        backtrace2.append(backtrace2.getRuntime().newString(buf.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime2, RubyStackTraceElement[] backtraceFrames) {
        return ThreadContext.createBacktraceFromFrames(runtime2, backtraceFrames, true);
    }

    public IRubyObject createCallerBacktrace(Ruby runtime2, int level2) {
        int traceSize = this.frameIndex - level2 + 1;
        RubyArray backtrace2 = runtime2.newArray(traceSize);
        for (int i = traceSize - 1; i > 0; --i) {
            ThreadContext.addBackTraceElement(runtime2, backtrace2, this.frameStack[i], this.frameStack[i - 1]);
        }
        return backtrace2;
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime2, RubyStackTraceElement[] backtraceFrames, boolean cropAtEval) {
        RubyArray backtrace2 = runtime2.newArray();
        if (backtraceFrames == null || backtraceFrames.length <= 0) {
            return backtrace2;
        }
        int traceSize = backtraceFrames.length;
        for (int i = 0; i < traceSize - 1; ++i) {
            RubyStackTraceElement frame = backtraceFrames[i];
            if (cropAtEval && frame.isBinding()) break;
            ThreadContext.addBackTraceElement(runtime2, backtrace2, frame, backtraceFrames[i + 1]);
        }
        return backtrace2;
    }

    public Frame[] createBacktrace(int level2, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level2 + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public boolean isEventHooksEnabled() {
        return this.eventHooksEnabled;
    }

    public void setEventHooksEnabled(boolean flag) {
        this.eventHooksEnabled = flag;
    }

    public RubyStackTraceElement[] createBacktrace2(int level2, boolean nativeException) {
        int traceSize = this.frameIndex - level2 + 1;
        if (traceSize <= 0) {
            return null;
        }
        int totalSize = traceSize;
        if (nativeException) {
            totalSize = traceSize + 1;
        }
        RubyStackTraceElement[] newTrace = new RubyStackTraceElement[totalSize];
        return this.buildTrace(newTrace);
    }

    private RubyStackTraceElement[] buildTrace(RubyStackTraceElement[] newTrace) {
        for (int i = 0; i < newTrace.length; ++i) {
            Frame current2 = this.frameStack[i];
            String klazzName = this.getClassNameFromFrame(current2);
            String methodName = this.getMethodNameFromFrame(current2);
            newTrace[newTrace.length - 1 - i] = new RubyStackTraceElement(klazzName, methodName, current2.getFile(), current2.getLine() + 1, current2.isBindingFrame());
        }
        return newTrace;
    }

    private String getClassNameFromFrame(Frame current2) {
        String klazzName = current2.getKlazz() == null ? UNKNOWN_NAME : current2.getKlazz().getName();
        return klazzName;
    }

    private String getMethodNameFromFrame(Frame current2) {
        String methodName = current2.getName();
        if (current2.getName() == null) {
            methodName = UNKNOWN_NAME;
        }
        return methodName;
    }

    private static String createRubyBacktraceString(StackTraceElement element) {
        return element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
    }

    public static String createRawBacktraceStringFromThrowable(Throwable t) {
        StackTraceElement[] javaStackTrace = t.getStackTrace();
        StringBuffer buffer = new StringBuffer();
        if (javaStackTrace != null && javaStackTrace.length > 0) {
            StackTraceElement element = javaStackTrace[0];
            buffer.append(ThreadContext.createRubyBacktraceString(element)).append(": ").append(t.toString()).append("\n");
            for (int i = 1; i < javaStackTrace.length; ++i) {
                element = javaStackTrace[i];
                buffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(element));
                if (i + 1 >= javaStackTrace.length) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static IRubyObject createRawBacktrace(Ruby runtime2, StackTraceElement[] stackTrace, boolean filter) {
        RubyArray traceArray = RubyArray.newArray(runtime2);
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (filter && (element.getClassName().startsWith("org.jruby") || element.getLineNumber() < 0)) continue;
            RubyString str = RubyString.newString(runtime2, ThreadContext.createRubyBacktraceString(element));
            traceArray.append(str);
        }
        return traceArray;
    }

    public static IRubyObject createRubyCompiledBacktrace(Ruby runtime2, StackTraceElement[] stackTrace) {
        RubyArray traceArray = RubyArray.newArray(runtime2);
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            int index2 = element.getMethodName().indexOf("$RUBY$");
            if (index2 < 0) continue;
            String unmangledMethod = element.getMethodName().substring(index2 + 6);
            RubyString str = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + unmangledMethod + "'");
            traceArray.append(str);
        }
        return traceArray;
    }

    private Frame pushFrameForBlock(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setFileAndLine(this.file, this.line);
        this.setFileAndLine(binding2.getFile(), binding2.getLine());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    private Frame pushFrameForEval(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        this.setFileAndLine(binding2.getFile(), binding2.getLine());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    public static IRubyObject createRubyHybridBacktrace(Ruby runtime2, RubyStackTraceElement[] backtraceFrames, RubyStackTraceElement[] stackTrace, boolean debug) {
        RubyArray traceArray = RubyArray.newArray(runtime2);
        ThreadContext context = runtime2.getCurrentContext();
        int rubyFrameIndex = backtraceFrames.length - 1;
        for (int i = 0; i < stackTrace.length; ++i) {
            RubyString str;
            String unmangledMethod;
            RubyStackTraceElement element = stackTrace[i];
            int index2 = element.getMethodName().indexOf("$RUBY$");
            if (index2 >= 0) {
                unmangledMethod = element.getMethodName().substring(index2 + 6);
                RubyString str2 = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + unmangledMethod + "'");
                traceArray.append(str2);
                if (element.getMethodName().contains("__rescue__") || element.getMethodName().contains("__ensure__")) continue;
                --rubyFrameIndex;
                continue;
            }
            if (element.getMethodName().equals("__file__")) {
                RubyString str3 = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ": `<toplevel>'");
                traceArray.append(str3);
                --rubyFrameIndex;
                continue;
            }
            index2 = element.getClassName().indexOf("$RUBYINVOKER$");
            if (index2 >= 0) {
                unmangledMethod = element.getClassName().substring(index2 + 13);
                Frame current2 = context.frameStack[rubyFrameIndex];
                str = RubyString.newString(runtime2, current2.getFile() + ":" + (current2.getLine() + 1) + ":in `" + unmangledMethod + "'");
                traceArray.append(str);
                continue;
            }
            index2 = element.getClassName().indexOf("$RUBYFRAMEDINVOKER$");
            if (index2 >= 0) {
                ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex - 1], FrameType.METHOD);
                --rubyFrameIndex;
                continue;
            }
            String classMethod = element.getClassName() + "." + element.getMethodName();
            FrameType frameType = INTERPRETED_FRAMES.get(classMethod);
            if (frameType != null) {
                if (rubyFrameIndex == 0) {
                    ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex], frameType);
                    continue;
                }
                ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex - 1], frameType);
                --rubyFrameIndex;
                continue;
            }
            if (!debug) continue;
            str = RubyString.newString(runtime2, ThreadContext.createRubyBacktraceString(element.getElement()));
            traceArray.append(str);
        }
        return traceArray;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
    }

    public void preCompiledClassDummyScope(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(staticScope.getDummyScope());
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type2) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names2) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names2);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void preMethodFrameAndDummyScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void preMethodNoFrameAndDummyScope(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name2, IRubyObject self, Block block) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name2, self, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name2, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
        this.pushBacktraceFrame(name2);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
        this.popFrame();
    }

    public void preMethodBacktraceOnly(String name2) {
        this.pushBacktraceFrame(name2);
    }

    public void preMethodBacktraceDummyScope(RubyModule clazz, String name2, StaticScope staticScope) {
        this.pushBacktraceFrame(name2);
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodBacktraceOnly() {
        this.popFrame();
    }

    public void postMethodBacktraceDummyScope() {
        this.popFrame();
        this.popRubyClass();
        this.popScope();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self, String name2) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame[] currentFrames) {
        for (Frame frame : currentFrames) {
            this.pushFrame(frame);
        }
        this.setFileAndLine(this.getCurrentFrame());
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding2, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(binding2.getDynamicScope());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding2, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(DynamicScope.newDynamicScope(scope, binding2.getDynamicScope()));
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding2, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(emptyScope);
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding2, RubyModule klass) {
        this.pushRubyClass(klass != null ? klass : binding2.getKlass());
        return this.pushFrameForBlock(binding2);
    }

    public void preEvalScriptlet(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postEvalScriptlet() {
        this.popScope();
    }

    public Frame preEvalWithBinding(Binding binding2) {
        binding2.getFrame().setIsBindingFrame(true);
        Frame lastFrame = this.pushFrameForEval(binding2);
        this.pushRubyClass(binding2.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding2, Frame lastFrame) {
        binding2.getFrame().setIsBindingFrame(false);
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }

    public Binding currentBinding() {
        Frame frame = this.getCurrentFrame();
        return new Binding(frame, this.getRubyClass(), this.getCurrentScope(), this.file, this.line);
    }

    public Binding currentBinding(IRubyObject self) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), this.getCurrentScope(), this.file, this.line);
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), this.getCurrentScope(), this.file, this.line);
    }

    public Binding currentBinding(IRubyObject self, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), scope, this.file, this.line);
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), scope, this.file, this.line);
    }

    public Binding previousBinding() {
        Frame frame = this.getPreviousFrame();
        Frame current2 = this.getCurrentFrame();
        return new Binding(frame, this.getPreviousRubyClass(), this.getCurrentScope(), current2.getFile(), current2.getLine());
    }

    public Binding previousBinding(IRubyObject self) {
        Frame frame = this.getPreviousFrame();
        Frame current2 = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getPreviousRubyClass(), this.getCurrentScope(), current2.getFile(), current2.getLine());
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    public int profileEnter(int nextMethod) {
        return this.profileData.profileEnter(nextMethod);
    }

    public int profileExit(int nextMethod) {
        return this.profileData.profileExit(nextMethod);
    }

    static {
        INTERPRETED_FRAMES.put(DefaultMethod.class.getName() + ".interpretedCall", FrameType.METHOD);
        INTERPRETED_FRAMES.put(InterpretedBlock.class.getName() + ".evalBlockBody", FrameType.BLOCK);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalWithBinding", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalSimple", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalClassDefinitionBody", FrameType.CLASS);
        INTERPRETED_FRAMES.put(Ruby.class.getName() + ".runInterpreter", FrameType.ROOT);
    }

    public static class ProfileData {
        private static final int SERIAL_OFFSET = 0;
        private static final int SELFTIME_OFFSET = 1;
        private static final int COUNT_OFFSET = 2;
        private static final int AGGREGATETIME_OFFSET = 3;
        private long[] profileSelfTimes = new long[0];
        private long[] profileAggregateTimes = new long[0];
        private long[] profileAggregateStarts = new long[0];
        private int[] profileCounts = new int[0];
        private int[] profileRecursions = new int[0];
        private int current;
        private long lastTime = 0L;

        public int profileEnter(int nextMethod) {
            this.ensureProfileSize(Math.max(this.current, nextMethod));
            int n = nextMethod;
            this.profileCounts[n] = this.profileCounts[n] + 1;
            return this.aggregateProfileTime(nextMethod, true);
        }

        public int profileExit(int nextMethod) {
            this.ensureProfileSize(Math.max(this.current, nextMethod));
            return this.aggregateProfileTime(nextMethod, false);
        }

        private int aggregateProfileTime(int newMethod, boolean entry) {
            long now = System.nanoTime();
            if (entry) {
                int n = newMethod;
                this.profileRecursions[n] = this.profileRecursions[n] + 1;
                if (this.profileRecursions[newMethod] == 1) {
                    this.profileAggregateStarts[newMethod] = now;
                }
            } else {
                int n = this.current;
                this.profileRecursions[n] = this.profileRecursions[n] - 1;
                if (this.profileRecursions[this.current] == 0) {
                    int n2 = this.current;
                    this.profileAggregateTimes[n2] = this.profileAggregateTimes[n2] + (now - this.profileAggregateStarts[this.current]);
                }
            }
            if (this.current != 0) {
                int n = this.current;
                this.profileSelfTimes[n] = this.profileSelfTimes[n] + (now - this.lastTime);
            }
            this.lastTime = now;
            int oldCurrent = this.current;
            this.current = newMethod;
            return oldCurrent;
        }

        private void ensureProfileSize(int method2) {
            if (this.profileSelfTimes.length <= method2) {
                long[] newProfileSelfTimes = new long[method2 * 2 + 1];
                System.arraycopy(this.profileSelfTimes, 0, newProfileSelfTimes, 0, this.profileSelfTimes.length);
                this.profileSelfTimes = newProfileSelfTimes;
                long[] newProfileAggregateTimes = new long[method2 * 2 + 1];
                System.arraycopy(this.profileAggregateTimes, 0, newProfileAggregateTimes, 0, this.profileAggregateTimes.length);
                this.profileAggregateTimes = newProfileAggregateTimes;
                long[] newProfileAggregateStarts = new long[method2 * 2 + 1];
                System.arraycopy(this.profileAggregateStarts, 0, newProfileAggregateStarts, 0, this.profileAggregateStarts.length);
                this.profileAggregateStarts = newProfileAggregateStarts;
                int[] newProfileCounts = new int[method2 * 2 + 1];
                System.arraycopy(this.profileCounts, 0, newProfileCounts, 0, this.profileCounts.length);
                this.profileCounts = newProfileCounts;
                int[] newProfileRecursions = new int[method2 * 2 + 1];
                System.arraycopy(this.profileRecursions, 0, newProfileRecursions, 0, this.profileRecursions.length);
                this.profileRecursions = newProfileRecursions;
            }
        }

        public void printProfile(ThreadContext context, String[] profiledNames, DynamicMethod[] profiledMethods, PrintStream out) {
            long[][] tuples = new long[this.profileSelfTimes.length][];
            for (int i = 0; i < this.profileSelfTimes.length; ++i) {
                tuples[i] = new long[]{i, this.profileSelfTimes[i], this.profileCounts[i], this.profileAggregateTimes[i]};
            }
            Arrays.sort(tuples, new Comparator<long[]>(){

                @Override
                public int compare(long[] o1, long[] o2) {
                    return Long.valueOf(o2[1]).compareTo(o1[1]);
                }
            });
            int longestName = 0;
            for (int i = 0; i < profiledNames.length; ++i) {
                String name2 = profiledNames[i];
                if (name2 == null) continue;
                DynamicMethod method2 = profiledMethods[i];
                String displayName = this.moduleHashMethod(method2.getImplementationClass(), name2);
                longestName = Math.max(longestName, displayName.length());
            }
            out.println("    #            calls             self        aggregate  method");
            out.println("----------------------------------------------------------------");
            int lines2 = 0;
            for (long[] tuple : tuples) {
                if (tuple[1] == 0L) break;
                int index2 = (int)tuple[0];
                String name3 = profiledNames[index2];
                DynamicMethod method3 = profiledMethods[index2];
                String displayName = this.moduleHashMethod(method3.getImplementationClass(), name3);
                this.pad(out, 5, Integer.toString(++lines2));
                out.print("  ");
                this.pad(out, 15, Long.toString(tuple[2]));
                out.print("  ");
                this.pad(out, 15, this.nanoString(tuple[1]));
                out.print("  ");
                this.pad(out, 15, this.nanoString(tuple[3]));
                out.print("  ");
                out.println(displayName);
                if (lines2 == 50) break;
            }
        }

        private void pad(PrintStream out, int size2, String body) {
            this.pad(out, size2, body, true);
        }

        private void pad(PrintStream out, int size2, String body, boolean front) {
            int i;
            if (front) {
                for (i = 0; i < size2 - body.length(); ++i) {
                    out.print(' ');
                }
            }
            out.print(body);
            if (!front) {
                for (i = 0; i < size2 - body.length(); ++i) {
                    out.print(' ');
                }
            }
        }

        private String nanoString(long nanoTime) {
            return Double.toString((double)nanoTime / 1.0E9) + 's';
        }

        private String moduleHashMethod(RubyModule module, String name2) {
            if (module.isSingleton()) {
                return ((RubyClass)module).getRealClass().getName() + "(singleton)#" + name2;
            }
            return module.getName() + "#" + name2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameType {
        METHOD,
        BLOCK,
        EVAL,
        CLASS,
        ROOT;

    }

    public static class RubyStackTraceElement {
        private StackTraceElement element;
        private boolean binding;

        public RubyStackTraceElement(String cls, String method2, String file2, int line, boolean binding2) {
            this.element = new StackTraceElement(cls, method2, file2, line);
            this.binding = binding2;
        }

        public StackTraceElement getElement() {
            return this.element;
        }

        public boolean isBinding() {
            return this.binding;
        }

        public String getClassName() {
            return this.element.getClassName();
        }

        public String getFileName() {
            return this.element.getFileName();
        }

        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        public String getMethodName() {
            return this.element.getMethodName();
        }
    }
}

