/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaObject"})
public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();
    private final RubyClass.VariableAccessor objectAccessor;
    private static final ObjectAllocator JAVA_OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new JavaObject(runtime2, klazz, null);
        }
    };

    protected JavaObject(Ruby runtime2, RubyClass rubyClass, Object value2) {
        super(runtime2, rubyClass);
        this.objectAccessor = rubyClass.getVariableAccessorForWrite("__wrap_struct__");
        this.dataWrapStruct(value2);
    }

    @Override
    public Object dataGetStruct() {
        return this.objectAccessor.get(this);
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.objectAccessor.set(this, object);
    }

    protected JavaObject(Ruby runtime2, Object value2) {
        this(runtime2, runtime2.getJavaSupport().getJavaObjectClass(), value2);
    }

    public static JavaObject wrap(Ruby runtime2, Object value2) {
        if (value2 != null) {
            if (value2 instanceof Class) {
                return JavaClass.get(runtime2, (Class)value2);
            }
            if (value2.getClass().isArray()) {
                return new JavaArray(runtime2, value2);
            }
        }
        return new JavaObject(runtime2, value2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext context, IRubyObject self, IRubyObject object) {
        Ruby runtime2 = context.getRuntime();
        Object obj = JavaObject.getWrappedObject(object, NEVER);
        if (obj == NEVER) {
            return runtime2.getNil();
        }
        return JavaObject.wrap(runtime2, obj);
    }

    @Override
    public Class<?> getJavaClass() {
        Object dataStruct = this.dataGetStruct();
        return dataStruct != null ? dataStruct.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.dataGetStruct();
    }

    public static RubyClass createJavaObjectClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaObject", runtime2.getObject(), JAVA_OBJECT_ALLOCATOR);
        JavaObject.registerRubyMethods(runtime2, result);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    protected static void registerRubyMethods(Ruby runtime2, RubyClass result) {
        result.defineAnnotatedMethods(JavaObject.class);
    }

    @Override
    public boolean equals(Object other) {
        Ruby runtime2 = this.getRuntime();
        Object myValue = this.getValue();
        Object otherValue = other;
        if (other instanceof IRubyObject) {
            otherValue = JavaObject.getWrappedObject((IRubyObject)other, NEVER);
        }
        if (otherValue == NEVER) {
            return false;
        }
        return myValue == otherValue;
    }

    @Override
    public int hashCode() {
        Object dataStruct = this.dataGetStruct();
        if (dataStruct != null) {
            return dataStruct.hashCode();
        }
        return 0;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        return JavaObject.to_s(this.getRuntime(), this.dataGetStruct());
    }

    public static IRubyObject to_s(Ruby runtime2, Object dataStruct) {
        if (dataStruct != null) {
            String stringValue = dataStruct.toString();
            if (stringValue != null) {
                return RubyString.newUnicodeString(runtime2, dataStruct.toString());
            }
            return runtime2.getNil();
        }
        return RubyString.newEmptyString(runtime2);
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(IRubyObject other) {
        Object myValue = this.getValue();
        return JavaObject.opEqualShared(myValue, other);
    }

    public static IRubyObject op_equal(JavaProxy self, IRubyObject other) {
        Object myValue = self.getObject();
        return JavaObject.opEqualShared(myValue, other);
    }

    private static IRubyObject opEqualShared(Object myValue, IRubyObject other) {
        Ruby runtime2 = other.getRuntime();
        Object otherValue = JavaObject.getWrappedObject(other, NEVER);
        if (other == NEVER) {
            return runtime2.getFalse();
        }
        if (myValue == null && otherValue == null) {
            return runtime2.getTrue();
        }
        return runtime2.newBoolean(myValue.equals(otherValue));
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject same(IRubyObject other) {
        Ruby runtime2 = this.getRuntime();
        Object myValue = this.getValue();
        Object otherValue = JavaObject.getWrappedObject(other, NEVER);
        if (other == NEVER) {
            return runtime2.getFalse();
        }
        if (myValue == null && otherValue == null) {
            return this.getRuntime().getTrue();
        }
        boolean isSame = this.getValue() == ((JavaObject)other).getValue();
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private static Object getWrappedObject(IRubyObject other, Object def) {
        if (other instanceof JavaObject) {
            return ((JavaObject)other).getValue();
        }
        if (other instanceof JavaProxy) {
            return ((JavaProxy)other).getObject();
        }
        return def;
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject aref(IRubyObject index2) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject aset(IRubyObject index2, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"fill"}, required=3)
    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public IRubyObject ruby_synchronized(ThreadContext context, Block block) {
        Object lock2 = this.getValue();
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject ruby_synchronized(ThreadContext context, Object lock2, Block block) {
        Object object = lock2 != null ? lock2 : NULL_LOCK;
        synchronized (object) {
            return block.yield(context, null);
        }
    }

    @JRubyMethod(frame=true)
    public IRubyObject marshal_dump() {
        if (Serializable.class.isAssignableFrom(this.getJavaClass())) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.getValue());
                return this.getRuntime().newString(new ByteList(baos.toByteArray()));
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        throw this.getRuntime().newTypeError("no marshal_dump is defined for class " + this.getJavaClass());
    }

    @JRubyMethod(frame=true)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            JRubyObjectInputStream ois = new JRubyObjectInputStream(context.getRuntime(), bais);
            this.dataWrapStruct(ois.readObject());
            return this;
        }
        catch (IOException ioe) {
            throw context.getRuntime().newIOErrorFromException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw context.getRuntime().newTypeError("Class not found unmarshaling Java type: " + cnfe.getLocalizedMessage());
        }
    }

    @Override
    public Object toJava(Class cls) {
        if (this.getValue() == null) {
            return this.getValue();
        }
        if (cls.isAssignableFrom(this.getValue().getClass())) {
            return this.getValue();
        }
        return super.toJava(cls);
    }
}

