/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PropertyName;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertyCatcher {
    public static LocalContextScope getScope(LocalContextScope defaultScope) {
        LocalContextScope scope = defaultScope;
        String s = System.getProperty(PropertyName.LOCALCONTEXT_SCOPE.toString());
        if (s == null) {
            return scope;
        }
        if ("singlethread".equalsIgnoreCase(s)) {
            return LocalContextScope.SINGLETHREAD;
        }
        if ("singleton".equalsIgnoreCase(s)) {
            return LocalContextScope.SINGLETON;
        }
        if ("threadsafe".equalsIgnoreCase(s)) {
            return LocalContextScope.THREADSAFE;
        }
        return scope;
    }

    public static LocalVariableBehavior getBehavior(LocalVariableBehavior defaultBehavior) {
        LocalVariableBehavior behavior = defaultBehavior;
        String s = System.getProperty(PropertyName.LOCALVARIABLE_BEHAVIOR.toString());
        if (s == null) {
            return behavior;
        }
        if ("global".equalsIgnoreCase(s)) {
            return LocalVariableBehavior.GLOBAL;
        }
        if ("persistent".equalsIgnoreCase(s)) {
            return LocalVariableBehavior.PERSISTENT;
        }
        if ("transient".equalsIgnoreCase(s)) {
            return LocalVariableBehavior.TRANSIENT;
        }
        if ("bsf".equalsIgnoreCase(s)) {
            return LocalVariableBehavior.BSF;
        }
        return behavior;
    }

    public static void setConfiguration(ScriptingContainer container) {
        LocalContextProvider provider = container.getProvider();
        RubyInstanceConfig config = provider.getRubyInstanceConfig();
        String s = System.getProperty(PropertyName.COMPILEMODE.toString());
        if (s != null) {
            if ("jit".equalsIgnoreCase(s)) {
                config.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
            } else if ("force".equalsIgnoreCase(s)) {
                config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
            } else {
                config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
            }
        }
        if ((s = System.getProperty(PropertyName.COMPATVERSION.toString())) != null && SystemPropertyCatcher.isRuby19(s)) {
            config.setCompatVersion(CompatVersion.RUBY1_9);
        }
    }

    @Deprecated
    public static void setJRubyHome(ScriptingContainer container) throws URISyntaxException {
        String jrubyhome = SystemPropertyCatcher.findJRubyHome(container);
        if (jrubyhome != null) {
            container.getProvider().getRubyInstanceConfig().setJRubyHome(jrubyhome);
        }
    }

    public static String findJRubyHome(Object instance) throws URISyntaxException {
        String jrubyhome = System.getenv("JRUBY_HOME");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        jrubyhome = System.getProperty("jruby.home");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        jrubyhome = SystemPropertyCatcher.findFromJar(instance);
        if (jrubyhome != null) {
            return jrubyhome;
        }
        return null;
    }

    private static String findFromJar(Object instance) throws URISyntaxException {
        URL resource2 = instance.getClass().getResource("/META-INF/jruby.home");
        if (resource2 == null) {
            return null;
        }
        String location = null;
        location = resource2.getProtocol().equals("jar") ? resource2.getPath() : "classpath:/META-INF/jruby.home";
        return location;
    }

    public static List<String> findLoadPaths() {
        String paths = System.getProperty(PropertyName.CLASSPATH.toString());
        ArrayList<String> loadPaths = new ArrayList<String>();
        if (paths == null) {
            paths = System.getProperty("java.class.path");
        }
        if (paths == null) {
            return loadPaths;
        }
        String[] possiblePaths = paths.split(File.pathSeparator);
        String[] prefixes = new String[]{"file", "url"};
        for (int i = 0; i < possiblePaths.length; ++i) {
            int startIndex = i;
            for (int j = 0; j < prefixes.length; ++j) {
                if (!prefixes[j].equals(possiblePaths[i]) || i >= possiblePaths.length - 1) continue;
                loadPaths.add(possiblePaths[i] + ":" + possiblePaths[++i]);
                break;
            }
            if (startIndex != i) continue;
            loadPaths.add(possiblePaths[i]);
        }
        return loadPaths;
    }

    public static boolean isRuby19(String name2) {
        Pattern p2 = Pattern.compile("[jJ]?(r|R)(u|U)(b|B)(y|Y)1[\\._]?9");
        Matcher m = p2.matcher(name2);
        return m.matches();
    }

    public static String getBaseDir() {
        String baseDir = System.getenv("PWD");
        if (baseDir == null || "/".equals(baseDir)) {
            baseDir = System.getProperty("user.dir");
        }
        return baseDir;
    }
}

