/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedNode
extends Node {
    private final Node expressionNode;

    public DefinedNode(ISourcePosition position, Node expressionNode) {
        super(position);
        assert (expressionNode != null) : "expressionNode is not null";
        this.expressionNode = expressionNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.DEFINEDNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefinedNode(this);
    }

    public Node getExpressionNode() {
        return this.expressionNode;
    }

    @Override
    public List<Node> childNodes() {
        return DefinedNode.createList(this.expressionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String definition = this.expressionNode.definition(runtime2, context, self, aBlock);
            IRubyObject iRubyObject = definition != null ? runtime2.newString(definition) : runtime2.getNil();
            Object var8_7 = null;
            context.setWithinDefined(false);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.setWithinDefined(false);
            throw throwable;
        }
    }
}

