/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyCompiledScript;
import org.jruby.embed.jsr223.JRubyContext;
import org.jruby.embed.jsr223.JRubyEngineFactory;
import org.jruby.embed.jsr223.Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyEngine
implements Compilable,
Invocable,
ScriptEngine {
    private final ScriptingContainer container;
    private JRubyEngineFactory factory;
    private JRubyContext context;

    JRubyEngine(ScriptingContainer container, JRubyEngineFactory factory) {
        this.container = container;
        this.factory = factory;
        this.context = new JRubyContext(container);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        return new JRubyCompiledScript(this.container, this, script);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        return new JRubyCompiledScript(this.container, this, reader);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (script == null || context == null) {
            throw new NullPointerException("either script or context is null");
        }
        return this.evaluate(context, script);
    }

    private Object evaluate(ScriptContext context, String script) throws ScriptException {
        if (this.context != context) {
            this.setContext(context);
        }
        this.injectGlobalBindings(context);
        this.container.setScriptFilename(Utils.getFilename(this));
        try {
            EmbedEvalUnit unit = this.container.parse(script, Utils.getLineNumber(this));
            IRubyObject ret = unit.run();
            Object object = JavaEmbedUtils.rubyToJava(ret);
            Object var7_7 = null;
            if (this.isTerminationOn()) {
                this.container.terminate();
            }
            return object;
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_8 = null;
                    if (!this.isTerminationOn()) break block6;
                    this.container.terminate();
                }
                throw throwable;
            }
        }
    }

    private void injectGlobalBindings(ScriptContext context) {
        Bindings globalMap = context.getBindings(200);
        if (globalMap == null) {
            return;
        }
        Set engineKeys = context.getBindings(100).keySet();
        Set globalKeys = globalMap.keySet();
        for (String key2 : globalKeys) {
            Object value2;
            if (engineKeys.contains(key2) || (value2 = context.getBindings(200).get(key2)) == null) continue;
            this.container.put(key2, value2);
        }
    }

    private ScriptException wrapException(Exception e) {
        if (e.getCause() instanceof Exception) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    return new ScriptException(ex);
                }
            }
            return new ScriptException((Exception)e.getCause());
        }
        return new ScriptException(e);
    }

    private boolean isTerminationOn() {
        boolean termination = false;
        Object obj = this.container.getAttribute(AttributeName.TERMINATION.toString());
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            termination = true;
        }
        return termination;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        if (reader == null || context == null) {
            throw new NullPointerException("either reader or context is null");
        }
        return this.evaluate(context, reader);
    }

    private Object evaluate(ScriptContext context, Reader reader) throws ScriptException {
        if (this.context != context) {
            this.setContext(context);
        }
        this.injectGlobalBindings(context);
        String filename2 = Utils.getFilename(this);
        try {
            EmbedEvalUnit unit = this.container.parse(reader, filename2, Utils.getLineNumber(this));
            IRubyObject ret = unit.run();
            Object object = JavaEmbedUtils.rubyToJava(ret);
            Object var8_8 = null;
            if (this.isTerminationOn()) {
                this.container.terminate();
            }
            return object;
        }
        catch (Exception e) {
            try {
                throw this.wrapException(e);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_9 = null;
                    if (!this.isTerminationOn()) break block6;
                    this.container.terminate();
                }
                throw throwable;
            }
        }
    }

    @Override
    public Object eval(String script) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("script is null");
        }
        return this.evaluate((ScriptContext)this.context, script);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        return this.evaluate((ScriptContext)this.context, reader);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        if (script == null || bindings == null) {
            throw new NullPointerException("either script or bindings is null");
        }
        this.getContext().setBindings(bindings, 100);
        return this.evaluate((ScriptContext)this.context, script);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        if (reader == null || bindings == null) {
            throw new NullPointerException("either reader or bindings is null");
        }
        this.getContext().setBindings(bindings, 100);
        return this.evaluate((ScriptContext)this.context, reader);
    }

    @Override
    public Object get(String key2) {
        return this.getBindings(100).get(key2);
    }

    @Override
    public void put(String key2, Object value2) {
        this.getBindings(100).put(key2, value2);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("context is null");
        }
        if (ctx instanceof JRubyContext) {
            this.context = (JRubyContext)ctx;
        } else {
            this.context = new JRubyContext(this.container);
            this.context.setWriter(ctx.getWriter());
            this.context.setErrorWriter(ctx.getErrorWriter());
            this.context.setBindings(ctx.getBindings(100), 100);
            if (ctx.getBindings(200) != null) {
                this.context.setBindings(ctx.getBindings(200), 200);
            }
            ctx = this.context;
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object receiver2, String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        if (method2 == null) {
            throw new NullPointerException("method is null");
        }
        if (receiver2 == null) {
            throw new NullPointerException("receiver is null");
        }
        try {
            if (args2 == null || args2.length == 0) {
                return this.container.callMethod(receiver2, method2, Object.class);
            }
            return this.container.callMethod(receiver2, method2, args2, Object.class);
        }
        catch (Exception e) {
            if (e.getCause().getMessage().contains("undefined method")) {
                throw this.wrapMethodException(e);
            }
            throw this.wrapException(e);
        }
    }

    private NoSuchMethodException wrapMethodException(Exception e) {
        Writer w = this.container.getErrorWriter();
        if (w instanceof PrintWriter) {
            e.printStackTrace((PrintWriter)w);
        } else {
            try {
                w.write(e.getMessage());
            }
            catch (IOException ex) {
                return new NoSuchMethodException(ex.getMessage());
            }
        }
        return new NoSuchMethodException(e.getCause().getMessage());
    }

    @Override
    public Object invokeFunction(String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        if (method2 == null) {
            throw new NullPointerException("method is null");
        }
        try {
            if (args2 == null || args2.length == 0) {
                return this.container.callMethod(null, method2, Object.class);
            }
            return this.container.callMethod((Object)null, method2, args2, Object.class);
        }
        catch (Exception e) {
            if (e.getCause().getMessage().contains("undefined method")) {
                throw this.wrapMethodException(e);
            }
            throw this.wrapException(e);
        }
    }

    @Override
    public <T> T getInterface(Class<T> returnType) {
        return this.getInterface(null, returnType);
    }

    @Override
    public <T> T getInterface(Object receiver2, Class<T> returnType) {
        return this.container.getInstance(receiver2, returnType);
    }
}

