/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.DataFlowVar;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.LiveVariableNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveVariablesProblem
extends DataFlowProblem {
    private HashMap<Variable, DataFlowVar> _dfVarMap = new HashMap();
    private HashMap<Integer, Variable> _varDfVarMap = new HashMap();
    private Collection<Variable> _varsLiveOnExit;
    private Set<Variable> _udVars = new HashSet<Variable>();

    @Override
    public String getName() {
        return "Live Variables Analysis";
    }

    public LiveVariablesProblem() {
        super(DataFlowProblem.DF_Direction.BACKWARD);
    }

    public DataFlowVar getDFVar(Variable v) {
        return this._dfVarMap.get(v);
    }

    public Variable getVariable(int id2) {
        return this._varDfVarMap.get(id2);
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new LiveVariableNode(this, bb);
    }

    private void addDFVar(Variable v, boolean recordVar) {
        DataFlowVar dfv = new DataFlowVar(this);
        this._dfVarMap.put(v, dfv);
        this._varDfVarMap.put(dfv._id, v);
        if (recordVar) {
            this._udVars.add(v);
        }
    }

    public void addDFVar(Variable v) {
        this.addDFVar(v, true);
    }

    public void initVarsLiveOnExit(Collection<Variable> vars) {
        this._varsLiveOnExit = vars;
    }

    public List<Variable> getVarsLiveOnEntry() {
        ArrayList<Variable> liveVars = new ArrayList<Variable>();
        BitSet liveIn = ((LiveVariableNode)this.getFlowGraphNode(this._cfg.getEntryBB())).getLiveInBitSet();
        for (int i = 0; i < liveIn.size(); ++i) {
            if (!liveIn.get(i)) continue;
            Variable v = this.getVariable(i);
            liveVars.add(v);
        }
        return liveVars;
    }

    @Override
    public void setup(CFG c) {
        super.setup(c);
        if (this._varsLiveOnExit != null && !this._varsLiveOnExit.isEmpty()) {
            for (Variable v : this._varsLiveOnExit) {
                if (this.getDFVar(v) != null) continue;
                this.addDFVar(v, false);
            }
        }
    }

    @Override
    public String getDataFlowVarsForOutput() {
        StringBuffer buf = new StringBuffer();
        for (Variable v : this._dfVarMap.keySet()) {
            buf.append("DF Var ").append(this._dfVarMap.get((Object)v)._id).append(" = ").append(v).append("\n");
        }
        return buf.toString();
    }

    public void markDeadInstructions() {
        for (FlowGraphNode n : this._fgNodes) {
            ((LiveVariableNode)n).markDeadInstructions();
        }
    }

    public Collection<Variable> getVarsLiveOnExit() {
        return this._varsLiveOnExit;
    }

    public boolean isDefinedOrUsed(Variable v) {
        return this._udVars.contains(v);
    }

    public Set<Variable> allDefinedOrUsedVariables() {
        return this._udVars;
    }

    public Set<Variable> getAllVars() {
        return this._dfVarMap.keySet();
    }
}

