/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.kenai.constantine.Constant;
import com.kenai.constantine.ConstantSet;
import com.kenai.constantine.platform.Errno;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jcodings.Encoding;
import org.joda.time.DateTimeZone;
import org.jruby.CompatVersion;
import org.jruby.Finalizable;
import org.jruby.NativeException;
import org.jruby.Profile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyContinuation;
import org.jruby.RubyConverter;
import org.jruby.RubyDir;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.TopSelfFactory;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.executable.Script;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.JRubyPOSIXHandler;
import org.jruby.ext.LateLoadingLibrary;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.JavaSupport;
import org.jruby.management.BeanManager;
import org.jruby.management.BeanManagerFactory;
import org.jruby.management.ClassCache;
import org.jruby.management.Config;
import org.jruby.management.ParserStats;
import org.jruby.parser.EvalStaticScope;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.BuiltinScript;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SimpleSampler;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.func.Function1;
import org.jruby.util.io.ChannelDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ruby {
    private static Ruby globalRuntime;
    public static final int NIL_PREFILLED_ARRAY_SIZE = 128;
    private final IRubyObject[] nilPrefilledArray = new IRubyObject[128];
    private Map<Integer, RubyClass> errnos = new HashMap<Integer, RubyClass>();
    private RubyHash charsetMap;
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook();
    private ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();
    private ThreadLocal<Map<String, RubyHash>> recursive = new ThreadLocal();
    private RubySymbol recursiveKey;
    private volatile int constantGeneration = 1;
    private final ThreadService threadService;
    private POSIX posix;
    private int stackTraces = 0;
    private final ObjectSpace objectSpace = new ObjectSpace();
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private Map<Integer, WeakDescriptorReference> descriptors = new ConcurrentHashMap<Integer, WeakDescriptorReference>();
    private ReferenceQueue<ChannelDescriptor> descriptorQueue = new ReferenceQueue();
    private Map<Integer, ChannelDescriptor> retainedDescriptors = new ConcurrentHashMap<Integer, ChannelDescriptor>();
    private long randomSeed = 0L;
    private long randomSeedSequence = 0L;
    private Random random = new Random();
    private final List<EventHook> eventHooks = new Vector<EventHook>();
    private boolean hasEventHooks;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private volatile boolean objectSpaceEnabled;
    private final Set<Script> jittedMethods = Collections.synchronizedSet(new WeakHashSet());
    private long globalState = 1L;
    private int safeLevel = -1;
    private IRubyObject topSelf;
    private RubyNil nilObject;
    private IRubyObject[] singleNilArray;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    private boolean verbose;
    private boolean warningsEnabled;
    private boolean debug;
    private IRubyObject verboseValue;
    private RubyThreadGroup defaultThreadGroup;
    private RubyClass basicObjectClass;
    private RubyClass objectClass;
    private RubyClass moduleClass;
    private RubyClass classClass;
    private RubyClass nilClass;
    private RubyClass trueClass;
    private RubyClass falseClass;
    private RubyClass numericClass;
    private RubyClass floatClass;
    private RubyClass integerClass;
    private RubyClass fixnumClass;
    private RubyClass complexClass;
    private RubyClass rationalClass;
    private RubyClass enumeratorClass;
    private RubyClass yielderClass;
    private RubyClass arrayClass;
    private RubyClass hashClass;
    private RubyClass rangeClass;
    private RubyClass stringClass;
    private RubyClass encodingClass;
    private RubyClass converterClass;
    private RubyClass symbolClass;
    private RubyClass procClass;
    private RubyClass bindingClass;
    private RubyClass methodClass;
    private RubyClass unboundMethodClass;
    private RubyClass matchDataClass;
    private RubyClass regexpClass;
    private RubyClass timeClass;
    private RubyClass bignumClass;
    private RubyClass dirClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass ioClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass continuationClass;
    private RubyClass structClass;
    private RubyClass tmsStruct;
    private RubyClass passwdStruct;
    private RubyClass groupStruct;
    private RubyClass procStatusClass;
    private RubyClass exceptionClass;
    private RubyClass runtimeError;
    private RubyClass ioError;
    private RubyClass scriptError;
    private RubyClass nameError;
    private RubyClass nameErrorMessage;
    private RubyClass noMethodError;
    private RubyClass signalException;
    private RubyClass rangeError;
    private RubyClass dummyClass;
    private RubyClass systemExit;
    private RubyClass localJumpError;
    private RubyClass nativeException;
    private RubyClass systemCallError;
    private RubyClass fatal;
    private RubyClass interrupt;
    private RubyClass typeError;
    private RubyClass argumentError;
    private RubyClass indexError;
    private RubyClass stopIteration;
    private RubyClass syntaxError;
    private RubyClass standardError;
    private RubyClass loadError;
    private RubyClass notImplementedError;
    private RubyClass securityError;
    private RubyClass noMemoryError;
    private RubyClass regexpError;
    private RubyClass eofError;
    private RubyClass threadError;
    private RubyClass concurrencyError;
    private RubyClass systemStackError;
    private RubyClass zeroDivisionError;
    private RubyClass floatDomainError;
    private RubyClass mathDomainError;
    private RubyClass encodingError;
    private RubyClass encodingCompatibilityError;
    private RubyClass converterNotFoundError;
    private RubyClass undefinedConversionError;
    private RubyClass invalidByteSequenceError;
    private RubyClass randomClass;
    private RubyModule kernelModule;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule mathModule;
    private RubyModule marshalModule;
    private RubyModule etcModule;
    private RubyModule fileTestModule;
    private RubyModule gcModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyModule errnoModule;
    private DynamicMethod privateMethodMissing;
    private DynamicMethod protectedMethodMissing;
    private DynamicMethod variableMethodMissing;
    private DynamicMethod superMethodMissing;
    private DynamicMethod normalMethodMissing;
    private DynamicMethod defaultMethodMissing;
    private GlobalVariable recordSeparatorVar;
    private String currentDirectory;
    private int currentLine = 0;
    private IRubyObject argsFile;
    private long startTime = System.currentTimeMillis();
    private final RubyInstanceConfig config;
    private final boolean is1_9;
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;
    private JavaSupport javaSupport;
    private JRubyClassLoader jrubyClassLoader;
    private BeanManager beanManager;
    private ParserStats parserStats;
    private final JITCompiler jitCompiler;
    private static volatile boolean securityRestricted;
    private final Parser parser = new Parser(this);
    private LoadService loadService;
    private Encoding defaultInternalEncoding;
    private Encoding defaultExternalEncoding;
    private EncodingService encodingService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private final RubyWarnings warnings = new RubyWarnings(this);
    private final Stack<RubyProc> atExitBlocks = new Stack();
    private Profile profile;
    private KCode kcode = KCode.NONE;
    private final AtomicInteger symbolLastId = new AtomicInteger(128);
    private final AtomicInteger moduleLastId = new AtomicInteger(0);
    private final Set<RubyModule> allModules = new WeakHashSet<RubyModule>();
    private Object respondToMethod;
    private final Map<String, DateTimeZone> timeZoneCache = new HashMap<String, DateTimeZone>();
    private Map<Finalizable, Object> finalizers;
    private Map<Finalizable, Object> internalFinalizers;
    private final Object finalizersMutex = new Object();
    private final Object internalFinalizersMutex = new Object();
    private ExecutorService executor;
    private final Object hierarchyLock = new Object();
    private final AtomicLong dynamicMethodSerial = new AtomicLong(0L);

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config) {
        Ruby ruby2 = new Ruby(config);
        ruby2.init();
        Ruby.setGlobalRuntimeFirstTimeOnly(ruby2);
        return ruby2;
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setInput(in);
        config.setOutput(out);
        config.setError(err);
        return Ruby.newInstance(config);
    }

    public static boolean isGlobalRuntimeReady() {
        return globalRuntime != null;
    }

    private static synchronized void setGlobalRuntimeFirstTimeOnly(Ruby runtime2) {
        if (globalRuntime == null) {
            globalRuntime = runtime2;
        }
    }

    public static synchronized Ruby getGlobalRuntime() {
        if (globalRuntime == null) {
            Ruby.newInstance();
        }
        return globalRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAsGlobalRuntime() {
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            globalRuntime = null;
            Ruby.setGlobalRuntimeFirstTimeOnly(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Ruby(RubyInstanceConfig config) {
        this.config = config;
        this.is1_9 = config.getCompatVersion() == CompatVersion.RUBY1_9;
        this.threadService = new ThreadService(this);
        if (config.isSamplingEnabled()) {
            SimpleSampler.registerThreadContext(this.threadService.getCurrentContext());
        }
        this.in = config.getInput();
        this.out = config.getOutput();
        this.err = config.getError();
        this.objectSpaceEnabled = config.isObjectSpaceEnabled();
        this.profile = config.getProfile();
        this.currentDirectory = config.getCurrentDirectory();
        this.kcode = config.getKCode();
        this.beanManager = BeanManagerFactory.create(this, config.isManagementEnabled());
        this.jitCompiler = new JITCompiler(this);
        this.parserStats = new ParserStats(this);
        this.beanManager.register(new Config(this));
        this.beanManager.register(this.parserStats);
        this.beanManager.register(new ClassCache(this));
    }

    public IRubyObject evalScriptlet(String script) {
        ThreadContext context = this.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        ManyVarsDynamicScope newScope = new ManyVarsDynamicScope(new EvalStaticScope(currentScope.getStaticScope()), currentScope);
        return this.evalScriptlet(script, newScope);
    }

    public IRubyObject evalScriptlet(String script, DynamicScope scope) {
        ThreadContext context = this.getCurrentContext();
        Node node = this.parseEval(script, "<script>", scope, 0);
        try {
            context.preEvalScriptlet(scope);
            IRubyObject iRubyObject = node.interpret(this, context, context.getFrameSelf(), Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            throw this.newLocalJumpError(RubyLocalJumpError.Reason.RETURN, (IRubyObject)rj.getValue(), "unexpected return");
        }
        catch (JumpException.BreakJump bj) {
            throw this.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw this.newLocalJumpError(RubyLocalJumpError.Reason.REDO, (IRubyObject)rj.getValue(), "unexpected redo");
        }
        finally {
            context.postEvalScriptlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeScript(String script, String filename2) {
        byte[] bytes2 = script.getBytes();
        Node node = this.parseInline(new ByteArrayInputStream(bytes2), filename2, null);
        ThreadContext context = this.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(node.getPosition());
            IRubyObject iRubyObject = this.runNormally(node);
            return iRubyObject;
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromMain(InputStream inputStream, String filename2) {
        ValueAccessor d = new ValueAccessor(this.newString(filename2));
        this.getGlobalVariables().define("$PROGRAM_NAME", d);
        this.getGlobalVariables().define("$0", d);
        for (Map.Entry entry : this.config.getOptionGlobals().entrySet()) {
            Object value2 = entry.getValue();
            RubyObject varvalue = value2 != null ? this.newString(value2.toString()) : this.getTrue();
            this.getGlobalVariables().set("$" + entry.getKey().toString(), varvalue);
        }
        if (filename2.endsWith(".class")) {
            Script script = CompiledScriptLoader.loadScriptFromFile(this, inputStream, filename2);
            if (script == null) {
                throw new MainExitException(1, "error: .class file specified is not a compiled JRuby script");
            }
            script.setFilename(filename2);
            this.runScript(script);
            return;
        }
        Node scriptNode = this.parseFromMain(inputStream, filename2);
        try {
            inputStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        ThreadContext context = this.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(scriptNode.getPosition());
            if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                this.runWithGetsLoop(scriptNode, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit());
            } else {
                this.runNormally(scriptNode);
            }
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    public Node parseFromMain(InputStream inputStream, String filename2) {
        if (this.config.isInlineScript()) {
            return this.parseInline(inputStream, filename2, this.getCurrentContext().getCurrentScope());
        }
        return this.parseFile(inputStream, filename2, this.getCurrentContext().getCurrentScope());
    }

    @Deprecated
    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split2, boolean unused2) {
        return this.runWithGetsLoop(scriptNode, printing, processLineEnds, split2);
    }

    /*
     * Exception decompiling
     */
    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public IRubyObject runNormally(Node scriptNode, boolean unused2) {
        return this.runNormally(scriptNode);
    }

    public IRubyObject runNormally(Node scriptNode) {
        Script script = null;
        boolean compile2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        boolean forceCompile = this.getInstanceConfig().getCompileMode().shouldPrecompileAll();
        if (compile2) {
            script = this.tryCompile(scriptNode, null, new JRubyClassLoader(this.getJRubyClassLoader()), this.config.isShowBytecode());
            if (forceCompile && script == null) {
                return this.getNil();
            }
        }
        if (script != null) {
            if (this.config.isShowBytecode()) {
                return this.nilObject;
            }
            return this.runScript(script);
        }
        if (this.config.isShowBytecode()) {
            System.err.print("error: bytecode printing only works with JVM bytecode");
        }
        return this.runInterpreter(scriptNode);
    }

    public Script tryCompile(Node node) {
        return this.tryCompile(node, null, new JRubyClassLoader(this.getJRubyClassLoader()), false);
    }

    public Script tryCompile(Node node, ASTInspector inspector) {
        return this.tryCompile(node, null, new JRubyClassLoader(this.getJRubyClassLoader()), inspector, false);
    }

    private Script tryCompile(Node node, String cachedClassName, JRubyClassLoader classLoader, boolean dump2) {
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(node);
        return this.tryCompile(node, cachedClassName, classLoader, inspector, dump2);
    }

    private Script tryCompile(Node node, String cachedClassName, JRubyClassLoader classLoader, ASTInspector inspector, boolean dump2) {
        Script script = null;
        try {
            String filename2 = node.getPosition().getFile();
            String classname = JavaNameMangler.mangledFilenameForStartupClasspath(filename2);
            StandardASMCompiler asmCompiler = null;
            asmCompiler = RubyInstanceConfig.JIT_CODE_CACHE != null && cachedClassName != null ? new StandardASMCompiler(cachedClassName.replace('.', '/'), filename2) : new StandardASMCompiler(classname, filename2);
            ASTCompiler compiler = this.config.newCompiler();
            if (dump2) {
                compiler.compileRoot(node, asmCompiler, inspector, false, false);
                asmCompiler.dumpClass(System.out);
            } else {
                compiler.compileRoot(node, asmCompiler, inspector, true, false);
            }
            if (RubyInstanceConfig.JIT_CODE_CACHE != null && cachedClassName != null) {
                String pathName = cachedClassName.replace('.', '/');
                JITCompiler.saveToCodeCache(this, asmCompiler.getClassByteArray(), "ruby/jit", new File(RubyInstanceConfig.JIT_CODE_CACHE, pathName + ".class"));
            }
            script = (Script)asmCompiler.loadClass(classLoader).newInstance();
            if (this.config.isJitLogging()) {
                System.err.println("compiled: " + node.getPosition().getFile());
            }
        }
        catch (NotCompilableException nce) {
            if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
                System.err.println("warning: not compileable: " + nce.getMessage());
                nce.printStackTrace();
            } else {
                System.err.println("warning: could not compile; pass -d or -J-Djruby.jit.logging.verbose=true for more details");
            }
        }
        catch (ClassNotFoundException e) {
            if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
                System.err.println("warning: not compileable: " + e.getMessage());
                e.printStackTrace();
            } else {
                System.err.println("warning: could not compile; pass -d or -J-Djruby.jit.logging.verbose=true for more details");
            }
        }
        catch (InstantiationException e) {
            if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
                System.err.println("warning: not compilable: " + e.getMessage());
                e.printStackTrace();
            } else {
                System.err.println("warning: could not compile; pass -d or -J-Djruby.jit.logging.verbose=true for more details");
            }
        }
        catch (IllegalAccessException e) {
            if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
                System.err.println("warning: not compilable: " + e.getMessage());
                e.printStackTrace();
            } else {
                System.err.println("warning: could not compile; pass -d or -J-Djruby.jit.logging.verbose=true for more details");
            }
        }
        catch (Throwable t) {
            if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
                System.err.println("warning: could not compile: " + node.getPosition().getFile() + " because of: \"" + t.getMessage() + "\"");
                t.printStackTrace();
            }
            System.err.println("warning: could not compile; pass -d or -J-Djruby.jit.logging.verbose=true for more details");
        }
        return script;
    }

    public IRubyObject runScript(Script script) {
        ThreadContext context = this.getCurrentContext();
        try {
            return script.load(context, context.getFrameSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runScriptBody(Script script) {
        ThreadContext context = this.getCurrentContext();
        try {
            return script.__file__(context, context.getFrameSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runInterpreter(Node scriptNode) {
        ThreadContext context = this.getCurrentContext();
        assert (scriptNode != null) : "scriptNode is not null";
        try {
            return scriptNode.interpret(this, context, this.getTopSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runInterpreterBody(Node scriptNode) {
        ThreadContext context = this.getCurrentContext();
        assert (scriptNode != null) : "scriptNode is not null";
        assert (scriptNode instanceof RootNode);
        try {
            return ((RootNode)scriptNode).interpret(this, context, this.getTopSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public JITCompiler getJITCompiler() {
        return this.jitCompiler;
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance();
    }

    @Deprecated
    public static Ruby getCurrentInstance() {
        return null;
    }

    @Deprecated
    public static void setCurrentInstance(Ruby runtime2) {
    }

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(RubyModule module) {
        Set<RubyModule> set = this.allModules;
        synchronized (set) {
            this.allModules.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eachModule(Function1<Object, IRubyObject> func) {
        Set<RubyModule> set = this.allModules;
        synchronized (set) {
            for (RubyModule module : this.allModules) {
                func.apply(module);
            }
        }
    }

    public RubyModule getModule(String name2) {
        return (RubyModule)this.objectClass.getConstantAt(name2);
    }

    public RubyModule fastGetModule(String internedName) {
        return (RubyModule)this.objectClass.fastGetConstantAt(internedName);
    }

    public RubyClass getClass(String name2) {
        return this.objectClass.getClass(name2);
    }

    public RubyClass fastGetClass(String internedName) {
        return this.objectClass.fastGetClass(internedName);
    }

    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass);
    }

    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator, CallSite[] callSites) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass, callSites);
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent) {
        return this.defineClassUnder(name2, superClass, allocator, parent, null);
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent, CallSite[] callSites) {
        boolean parentIsObject;
        IRubyObject classObj = parent.getConstantAt(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw this.newTypeError(name2 + " is not a class");
            }
            RubyClass klazz = (RubyClass)classObj;
            if (klazz.getSuperClass().getRealClass() != superClass) {
                throw this.newNameError(name2 + " is already defined", name2);
            }
            if (klazz.getAllocator() != allocator) {
                klazz.setAllocator(allocator);
            }
            return klazz;
        }
        boolean bl = parentIsObject = parent == this.objectClass;
        if (superClass == null) {
            String className = parentIsObject ? name2 : parent.getName() + "::" + name2;
            this.warnings.warn(IRubyWarnings.ID.NO_SUPER_CLASS, "no super class for `" + className + "', Object assumed", className);
            superClass = this.objectClass;
        }
        return RubyClass.newClass(this, superClass, name2, allocator, parent, !parentIsObject, callSites);
    }

    public RubyModule defineModule(String name2) {
        return this.defineModuleUnder(name2, this.objectClass);
    }

    public RubyModule defineModuleUnder(String name2, RubyModule parent) {
        boolean parentIsObject;
        IRubyObject moduleObj = parent.getConstantAt(name2);
        boolean bl = parentIsObject = parent == this.objectClass;
        if (moduleObj != null) {
            if (moduleObj.isModule()) {
                return (RubyModule)moduleObj;
            }
            if (parentIsObject) {
                throw this.newTypeError(moduleObj.getMetaClass().getName() + " is not a module");
            }
            throw this.newTypeError(parent.getName() + "::" + moduleObj.getMetaClass().getName() + " is not a module");
        }
        return RubyModule.newModule(this, name2, parent, !parentIsObject);
    }

    public RubyModule getOrCreateModule(String name2) {
        IRubyObject module = this.objectClass.getConstantAt(name2);
        if (module == null) {
            module = this.defineModule(name2);
        } else {
            if (this.getSafeLevel() >= 4) {
                throw this.newSecurityError("Extending module prohibited.");
            }
            if (!module.isModule()) {
                throw this.newTypeError(name2 + " is not a Module");
            }
        }
        return (RubyModule)module;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode2) {
        this.kcode = kcode2;
    }

    public void secure(int level2) {
        if (level2 <= this.safeLevel) {
            throw this.newSecurityError("Insecure operation '" + this.getCurrentContext().getFrameName() + "' at level " + this.safeLevel);
        }
    }

    public void checkSafeString(IRubyObject object) {
        if (this.getSafeLevel() > 0 && object.isTaint()) {
            ThreadContext tc = this.getCurrentContext();
            if (tc.getFrameName() != null) {
                throw this.newSecurityError("Insecure operation - " + tc.getFrameName());
            }
            throw this.newSecurityError("Insecure operation: -r");
        }
        this.secure(4);
        if (!(object instanceof RubyString)) {
            throw this.newTypeError("wrong argument type " + object.getMetaClass().getName() + " (expected String)");
        }
    }

    public void defineGlobalConstant(String name2, IRubyObject value2) {
        this.objectClass.defineConstant(name2, value2);
    }

    public boolean isClassDefined(String name2) {
        return this.getModule(name2) != null;
    }

    private void init() {
        ThreadContext tc = this.getCurrentContext();
        this.safeLevel = this.config.getSafeLevel();
        this.loadService = this.config.createLoadService(this);
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), RubyInstanceConfig.nativeEnabled);
        this.javaSupport = new JavaSupport(this);
        if (RubyInstanceConfig.POOLING_ENABLED) {
            this.executor = new ThreadPoolExecutor(RubyInstanceConfig.POOL_MIN, RubyInstanceConfig.POOL_MAX, (long)RubyInstanceConfig.POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
        }
        this.initRoot();
        tc.prepareTopLevel(this.objectClass, this.topSelf);
        this.bootstrap();
        this.dummyClass = new RubyClass(this, this.classClass);
        this.dummyClass.freeze(tc);
        RubyGlobal.createGlobals(tc, this);
        this.getLoadService().init(this.config.loadPaths());
        this.initBuiltins();
        for (String scriptName : this.config.requiredLibraries()) {
            this.loadService.smartLoad(scriptName);
        }
    }

    private void bootstrap() {
        this.initCore();
        this.initExceptions();
    }

    private void initRoot() {
        boolean oneNine = this.is1_9();
        if (oneNine) {
            this.basicObjectClass = RubyClass.createBootstrapClass(this, "BasicObject", null, RubyBasicObject.OBJECT_ALLOCATOR);
            this.objectClass = RubyClass.createBootstrapClass(this, "Object", this.basicObjectClass, RubyObject.OBJECT_ALLOCATOR);
        } else {
            this.objectClass = RubyClass.createBootstrapClass(this, "Object", null, RubyObject.OBJECT_ALLOCATOR);
        }
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        if (oneNine) {
            this.basicObjectClass.setMetaClass(this.classClass);
        }
        this.objectClass.setMetaClass(this.classClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        if (oneNine) {
            RubyClass rubyClass = this.basicObjectClass.makeMetaClass(this.classClass);
        }
        RubyClass metaClass = this.objectClass.makeMetaClass(this.classClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        metaClass = this.classClass.makeMetaClass(metaClass);
        if (oneNine) {
            RubyBasicObject.createBasicObjectClass(this, this.basicObjectClass);
        }
        RubyObject.createObjectClass(this, this.objectClass);
        RubyModule.createModuleClass(this, this.moduleClass);
        RubyClass.createClassClass(this, this.classClass);
        if (oneNine) {
            this.objectClass.setConstant("BasicObject", this.basicObjectClass);
        }
        this.objectClass.setConstant("Object", this.objectClass);
        this.objectClass.setConstant("Class", this.classClass);
        this.objectClass.setConstant("Module", this.moduleClass);
        RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        this.topSelf = TopSelfFactory.createTopSelf(this);
    }

    private void initCore() {
        RubyNil.createNilClass(this);
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        for (int i = 0; i < 128; ++i) {
            this.nilPrefilledArray[i] = this.nilObject;
        }
        this.singleNilArray = new IRubyObject[]{this.nilObject};
        this.falseObject = new RubyBoolean(this, false);
        this.trueObject = new RubyBoolean(this, true);
        if (this.profile.allowClass("Data")) {
            this.defineClass("Data", this.objectClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        }
        RubyComparable.createComparable(this);
        RubyEnumerable.createEnumerableModule(this);
        RubyString.createStringClass(this);
        if (this.is1_9()) {
            RubyEncoding.createEncodingClass(this);
            RubyConverter.createConverterClass(this);
            this.encodingService = new EncodingService(this);
            RubyRandom.createRandomClass(this);
        }
        RubySymbol.createSymbolClass(this);
        if (this.profile.allowClass("ThreadGroup")) {
            RubyThreadGroup.createThreadGroupClass(this);
        }
        if (this.profile.allowClass("Thread")) {
            RubyThread.createThreadClass(this);
        }
        if (this.profile.allowClass("Exception")) {
            RubyException.createExceptionClass(this);
        }
        if (!this.is1_9() && this.profile.allowModule("Precision")) {
            RubyPrecision.createPrecisionModule(this);
        }
        if (this.profile.allowClass("Numeric")) {
            RubyNumeric.createNumericClass(this);
        }
        if (this.profile.allowClass("Integer")) {
            RubyInteger.createIntegerClass(this);
        }
        if (this.profile.allowClass("Fixnum")) {
            RubyFixnum.createFixnumClass(this);
        }
        if (this.is1_9()) {
            if (this.profile.allowClass("Complex")) {
                RubyComplex.createComplexClass(this);
            }
            if (this.profile.allowClass("Rational")) {
                RubyRational.createRationalClass(this);
            }
        }
        if (this.profile.allowClass("Hash")) {
            RubyHash.createHashClass(this);
        }
        if (this.profile.allowClass("Array")) {
            RubyArray.createArrayClass(this);
        }
        if (this.profile.allowClass("Float")) {
            RubyFloat.createFloatClass(this);
        }
        if (this.profile.allowClass("Bignum")) {
            RubyBignum.createBignumClass(this);
        }
        this.ioClass = RubyIO.createIOClass(this);
        if (this.profile.allowClass("Struct")) {
            RubyStruct.createStructClass(this);
        }
        if (this.profile.allowClass("Tms")) {
            this.tmsStruct = RubyStruct.newInstance(this.structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")}, Block.NULL_BLOCK);
        }
        if (this.profile.allowClass("Binding")) {
            RubyBinding.createBindingClass(this);
        }
        if (this.profile.allowModule("Math")) {
            RubyMath.createMathModule(this);
        }
        if (this.profile.allowClass("Regexp")) {
            RubyRegexp.createRegexpClass(this);
        }
        if (this.profile.allowClass("Range")) {
            RubyRange.createRangeClass(this);
        }
        if (this.profile.allowModule("ObjectSpace")) {
            RubyObjectSpace.createObjectSpaceModule(this);
        }
        if (this.profile.allowModule("GC")) {
            RubyGC.createGCModule(this);
        }
        if (this.profile.allowClass("Proc")) {
            RubyProc.createProcClass(this);
        }
        if (this.profile.allowClass("Method")) {
            RubyMethod.createMethodClass(this);
        }
        if (this.profile.allowClass("MatchData")) {
            RubyMatchData.createMatchDataClass(this);
        }
        if (this.profile.allowModule("Marshal")) {
            RubyMarshal.createMarshalModule(this);
        }
        if (this.profile.allowClass("Dir")) {
            RubyDir.createDirClass(this);
        }
        if (this.profile.allowModule("FileTest")) {
            RubyFileTest.createFileTestModule(this);
        }
        if (this.profile.allowClass("File")) {
            RubyFile.createFileClass(this);
        }
        if (this.profile.allowClass("File::Stat")) {
            RubyFileStat.createFileStatClass(this);
        }
        if (this.profile.allowModule("Process")) {
            RubyProcess.createProcessModule(this);
        }
        if (this.profile.allowClass("Time")) {
            RubyTime.createTimeClass(this);
        }
        if (this.profile.allowClass("UnboundMethod")) {
            RubyUnboundMethod.defineUnboundMethodClass(this);
        }
        if (this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Continuation")) {
            RubyContinuation.createContinuation(this);
        }
    }

    public IRubyObject[] getNilPrefilledArray() {
        return this.nilPrefilledArray;
    }

    private void initExceptions() {
        this.standardError = this.defineClassIfAllowed("StandardError", this.exceptionClass);
        this.runtimeError = this.defineClassIfAllowed("RuntimeError", this.standardError);
        this.ioError = this.defineClassIfAllowed("IOError", this.standardError);
        this.scriptError = this.defineClassIfAllowed("ScriptError", this.exceptionClass);
        this.rangeError = this.defineClassIfAllowed("RangeError", this.standardError);
        this.signalException = this.defineClassIfAllowed("SignalException", this.exceptionClass);
        if (this.profile.allowClass("NameError")) {
            this.nameError = RubyNameError.createNameErrorClass(this, this.standardError);
            this.nameErrorMessage = RubyNameError.createNameErrorMessageClass(this, this.nameError);
        }
        if (this.profile.allowClass("NoMethodError")) {
            this.noMethodError = RubyNoMethodError.createNoMethodErrorClass(this, this.nameError);
        }
        if (this.profile.allowClass("SystemExit")) {
            this.systemExit = RubySystemExit.createSystemExitClass(this, this.exceptionClass);
        }
        if (this.profile.allowClass("LocalJumpError")) {
            this.localJumpError = RubyLocalJumpError.createLocalJumpErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("NativeException")) {
            this.nativeException = NativeException.createClass(this, this.runtimeError);
        }
        if (this.profile.allowClass("SystemCallError")) {
            this.systemCallError = RubySystemCallError.createSystemCallErrorClass(this, this.standardError);
        }
        this.fatal = this.defineClassIfAllowed("Fatal", this.exceptionClass);
        this.interrupt = this.defineClassIfAllowed("Interrupt", this.signalException);
        this.typeError = this.defineClassIfAllowed("TypeError", this.standardError);
        this.argumentError = this.defineClassIfAllowed("ArgumentError", this.standardError);
        this.indexError = this.defineClassIfAllowed("IndexError", this.standardError);
        this.stopIteration = this.defineClassIfAllowed("StopIteration", this.indexError);
        this.syntaxError = this.defineClassIfAllowed("SyntaxError", this.scriptError);
        this.loadError = this.defineClassIfAllowed("LoadError", this.scriptError);
        this.notImplementedError = this.defineClassIfAllowed("NotImplementedError", this.scriptError);
        this.securityError = this.defineClassIfAllowed("SecurityError", this.standardError);
        this.noMemoryError = this.defineClassIfAllowed("NoMemoryError", this.exceptionClass);
        this.regexpError = this.defineClassIfAllowed("RegexpError", this.standardError);
        this.eofError = this.defineClassIfAllowed("EOFError", this.ioError);
        this.threadError = this.defineClassIfAllowed("ThreadError", this.standardError);
        this.concurrencyError = this.defineClassIfAllowed("ConcurrencyError", this.threadError);
        this.systemStackError = this.defineClassIfAllowed("SystemStackError", this.standardError);
        this.zeroDivisionError = this.defineClassIfAllowed("ZeroDivisionError", this.standardError);
        this.floatDomainError = this.defineClassIfAllowed("FloatDomainError", this.rangeError);
        if (this.is1_9()) {
            if (this.profile.allowClass("EncodingError")) {
                this.encodingError = this.defineClass("EncodingError", this.standardError, this.standardError.getAllocator());
                this.encodingCompatibilityError = this.defineClassUnder("CompatibilityError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
                this.invalidByteSequenceError = this.defineClassUnder("InvalidByteSequenceError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
                this.undefinedConversionError = this.defineClassUnder("UndefinedConversionError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
                this.converterNotFoundError = this.defineClassUnder("ConverterNotFoundError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
            }
            this.mathDomainError = this.defineClassUnder("DomainError", this.argumentError, this.argumentError.getAllocator(), this.mathModule);
            this.recursiveKey = this.newSymbol("__recursive_key__");
        }
        this.initErrno();
    }

    private RubyClass defineClassIfAllowed(String name2, RubyClass superClass) {
        if (superClass != null && this.profile.allowClass(name2)) {
            return this.defineClass(name2, superClass, superClass.getAllocator());
        }
        return null;
    }

    public RubyClass getErrno(int n) {
        return this.errnos.get(n);
    }

    private void initErrno() {
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
            try {
                this.createSysErr(Errno.EAGAIN.value(), Errno.EAGAIN.name());
                for (Errno e : Errno.values()) {
                    Errno c = e;
                    if (!Character.isUpperCase(c.name().charAt(0))) continue;
                    this.createSysErr(c.value(), c.name());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createSysErr(int i, String name2) {
        if (this.profile.allowClass(name2)) {
            if (this.errnos.get(i) == null) {
                RubyClass errno2 = this.getErrno().defineClassUnder(name2, this.systemCallError, this.systemCallError.getAllocator());
                this.errnos.put(i, errno2);
                errno2.defineConstant("Errno", this.newFixnum(i));
            } else {
                this.getErrno().setConstant(name2, this.errnos.get(i));
            }
        }
    }

    private void initBuiltins() {
        String[] builtins;
        this.addLazyBuiltin("java.rb", "java", "org.jruby.javasupport.Java");
        this.addLazyBuiltin("jruby.rb", "jruby", "org.jruby.libraries.JRubyLibrary");
        this.addLazyBuiltin("jruby/ext.rb", "jruby/ext", "org.jruby.RubyJRuby$ExtLibrary");
        this.addLazyBuiltin("jruby/util.rb", "jruby/util", "org.jruby.RubyJRuby$UtilLibrary");
        this.addLazyBuiltin("jruby/core_ext.rb", "jruby/core_ext", "org.jruby.RubyJRuby$CoreExtLibrary");
        this.addLazyBuiltin("jruby/type.rb", "jruby/type", "org.jruby.RubyJRuby$TypeLibrary");
        this.addLazyBuiltin("jruby/synchronized.rb", "jruby/synchronized", "org.jruby.RubyJRuby$SynchronizedLibrary");
        this.addLazyBuiltin("iconv.jar", "iconv", "org.jruby.libraries.IConvLibrary");
        this.addLazyBuiltin("nkf.jar", "nkf", "org.jruby.libraries.NKFLibrary");
        this.addLazyBuiltin("stringio.jar", "stringio", "org.jruby.libraries.StringIOLibrary");
        this.addLazyBuiltin("strscan.jar", "strscan", "org.jruby.libraries.StringScannerLibrary");
        this.addLazyBuiltin("zlib.jar", "zlib", "org.jruby.libraries.ZlibLibrary");
        this.addLazyBuiltin("enumerator.jar", "enumerator", "org.jruby.libraries.EnumeratorLibrary");
        this.addLazyBuiltin("readline.jar", "readline", "org.jruby.ext.Readline$Service");
        this.addLazyBuiltin("thread.jar", "thread", "org.jruby.libraries.ThreadLibrary");
        this.addLazyBuiltin("thread.rb", "thread", "org.jruby.libraries.ThreadLibrary");
        this.addLazyBuiltin("digest.jar", "digest", "org.jruby.libraries.DigestLibrary");
        this.addLazyBuiltin("digest.rb", "digest", "org.jruby.libraries.DigestLibrary");
        this.addLazyBuiltin("digest/md5.jar", "digest/md5", "org.jruby.libraries.DigestLibrary$MD5");
        this.addLazyBuiltin("digest/rmd160.jar", "digest/rmd160", "org.jruby.libraries.DigestLibrary$RMD160");
        this.addLazyBuiltin("digest/sha1.jar", "digest/sha1", "org.jruby.libraries.DigestLibrary$SHA1");
        this.addLazyBuiltin("digest/sha2.jar", "digest/sha2", "org.jruby.libraries.DigestLibrary$SHA2");
        this.addLazyBuiltin("bigdecimal.jar", "bigdecimal", "org.jruby.libraries.BigDecimalLibrary");
        this.addLazyBuiltin("io/wait.jar", "io/wait", "org.jruby.libraries.IOWaitLibrary");
        this.addLazyBuiltin("etc.jar", "etc", "org.jruby.libraries.EtcLibrary");
        this.addLazyBuiltin("weakref.rb", "weakref", "org.jruby.ext.WeakRef$WeakRefLibrary");
        this.addLazyBuiltin("delegate_internal.jar", "delegate_internal", "org.jruby.ext.DelegateLibrary");
        this.addLazyBuiltin("timeout.rb", "timeout", "org.jruby.ext.Timeout");
        this.addLazyBuiltin("socket.jar", "socket", "org.jruby.ext.socket.RubySocket$Service");
        this.addLazyBuiltin("rbconfig.rb", "rbconfig", "org.jruby.libraries.RbConfigLibrary");
        this.addLazyBuiltin("jruby/serialization.rb", "serialization", "org.jruby.libraries.JRubySerializationLibrary");
        this.addLazyBuiltin("ffi-internal.jar", "ffi-internal", "org.jruby.ext.ffi.Factory$Service");
        this.addLazyBuiltin("tempfile.rb", "tempfile", "org.jruby.libraries.TempfileLibrary");
        this.addLazyBuiltin("fcntl.rb", "fcntl", "org.jruby.libraries.FcntlLibrary");
        if (this.is1_9()) {
            this.addLazyBuiltin("mathn/complex.jar", "mathn/complex", "org.jruby.ext.mathn.Complex");
            this.addLazyBuiltin("mathn/rational.jar", "mathn/rational", "org.jruby.ext.mathn.Rational");
        }
        if (RubyInstanceConfig.NATIVE_NET_PROTOCOL) {
            this.addLazyBuiltin("net/protocol.rb", "net/protocol", "org.jruby.libraries.NetProtocolBufferedIOLibrary");
        }
        if (this.is1_9()) {
            LoadService.reflectedLoad(this, "fiber", "org.jruby.libraries.FiberLibrary", this.getJRubyClassLoader(), false);
        }
        this.addBuiltinIfAllowed("openssl.jar", new Library(){

            public void load(Ruby runtime2, boolean wrap2) throws IOException {
                runtime2.getLoadService().require("jruby/openssl/stub");
            }
        });
        for (String library2 : builtins = new String[]{"yaml", "yaml/yecht", "yaml/baseemitter", "yaml/basenode", "yaml/compat", "yaml/constants", "yaml/dbm", "yaml/emitter", "yaml/encoding", "yaml/error", "yaml/rubytypes", "yaml/store", "yaml/stream", "yaml/stringio", "yaml/tag", "yaml/types", "yaml/yamlnode", "yaml/ypath", "jsignal_internal", "generator_internal"}) {
            this.addBuiltinIfAllowed(library2 + ".rb", new BuiltinScript(library2));
        }
        RubyKernel.autoload(this.topSelf, this.newSymbol("Java"), this.newString("java"));
        if (this.is1_9()) {
            this.defineModule("Gem");
            this.loadFile("builtin/prelude.rb", this.getJRubyClassLoader().getResourceAsStream("builtin/prelude.rb"), false);
            this.loadFile("builtin/gem_prelude.rb", this.getJRubyClassLoader().getResourceAsStream("builtin/gem_prelude.rb"), false);
        }
        this.getLoadService().require("builtin/core_ext/symbol");
        this.getLoadService().require("enumerator");
    }

    private void addLazyBuiltin(String name2, String shortName, String className) {
        this.addBuiltinIfAllowed(name2, new LateLoadingLibrary(shortName, className, Ruby.getClassLoader()));
    }

    private void addBuiltinIfAllowed(String name2, Library lib) {
        if (this.profile.allowBuiltin(name2)) {
            this.loadService.addBuiltinLibrary(name2, lib);
        }
    }

    public Object getRespondToMethod() {
        return this.respondToMethod;
    }

    public void setRespondToMethod(Object rtm) {
        this.respondToMethod = rtm;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentLine(int line) {
        this.currentLine = line;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setArgsFile(IRubyObject argsFile) {
        this.argsFile = argsFile;
    }

    public IRubyObject getArgsFile() {
        return this.argsFile;
    }

    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule etcModule) {
        this.etcModule = etcModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getBasicObject() {
        return this.basicObjectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    void setKernel(RubyModule kernelModule) {
        this.kernelModule = kernelModule;
    }

    public DynamicMethod getPrivateMethodMissing() {
        return this.privateMethodMissing;
    }

    public void setPrivateMethodMissing(DynamicMethod method2) {
        this.privateMethodMissing = method2;
    }

    public DynamicMethod getProtectedMethodMissing() {
        return this.protectedMethodMissing;
    }

    public void setProtectedMethodMissing(DynamicMethod method2) {
        this.protectedMethodMissing = method2;
    }

    public DynamicMethod getVariableMethodMissing() {
        return this.variableMethodMissing;
    }

    public void setVariableMethodMissing(DynamicMethod method2) {
        this.variableMethodMissing = method2;
    }

    public DynamicMethod getSuperMethodMissing() {
        return this.superMethodMissing;
    }

    public void setSuperMethodMissing(DynamicMethod method2) {
        this.superMethodMissing = method2;
    }

    public DynamicMethod getNormalMethodMissing() {
        return this.normalMethodMissing;
    }

    public void setNormalMethodMissing(DynamicMethod method2) {
        this.normalMethodMissing = method2;
    }

    public DynamicMethod getDefaultMethodMissing() {
        return this.defaultMethodMissing;
    }

    public void setDefaultMethodMissing(DynamicMethod method2) {
        this.defaultMethodMissing = method2;
    }

    public RubyClass getDummy() {
        return this.dummyClass;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    void setComparable(RubyModule comparableModule) {
        this.comparableModule = comparableModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    void setNumeric(RubyClass numericClass) {
        this.numericClass = numericClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    void setFloat(RubyClass floatClass) {
        this.floatClass = floatClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    void setInteger(RubyClass integerClass) {
        this.integerClass = integerClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    void setFixnum(RubyClass fixnumClass) {
        this.fixnumClass = fixnumClass;
    }

    public RubyClass getComplex() {
        return this.complexClass;
    }

    void setComplex(RubyClass complexClass) {
        this.complexClass = complexClass;
    }

    public RubyClass getRational() {
        return this.rationalClass;
    }

    void setRational(RubyClass rationalClass) {
        this.rationalClass = rationalClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    void setEnumerable(RubyModule enumerableModule) {
        this.enumerableModule = enumerableModule;
    }

    public RubyClass getEnumerator() {
        return this.enumeratorClass;
    }

    void setEnumerator(RubyClass enumeratorClass) {
        this.enumeratorClass = enumeratorClass;
    }

    public RubyClass getYielder() {
        return this.yielderClass;
    }

    void setYielder(RubyClass yielderClass) {
        this.yielderClass = yielderClass;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    void setString(RubyClass stringClass) {
        this.stringClass = stringClass;
    }

    public RubyClass getEncoding() {
        return this.encodingClass;
    }

    void setEncoding(RubyClass encodingClass) {
        this.encodingClass = encodingClass;
    }

    public RubyClass getConverter() {
        return this.converterClass;
    }

    void setConverter(RubyClass converterClass) {
        this.converterClass = converterClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    void setSymbol(RubyClass symbolClass) {
        this.symbolClass = symbolClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    void setArray(RubyClass arrayClass) {
        this.arrayClass = arrayClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    void setHash(RubyClass hashClass) {
        this.hashClass = hashClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    void setRange(RubyClass rangeClass) {
        this.rangeClass = rangeClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public IRubyObject[] getSingleNilArray() {
        return this.singleNilArray;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    void setNilClass(RubyClass nilClass) {
        this.nilClass = nilClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    void setTrueClass(RubyClass trueClass) {
        this.trueClass = trueClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    void setFalseClass(RubyClass falseClass) {
        this.falseClass = falseClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    void setProc(RubyClass procClass) {
        this.procClass = procClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    void setBinding(RubyClass bindingClass) {
        this.bindingClass = bindingClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    void setMethod(RubyClass methodClass) {
        this.methodClass = methodClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    void setUnboundMethod(RubyClass unboundMethodClass) {
        this.unboundMethodClass = unboundMethodClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    void setMatchData(RubyClass matchDataClass) {
        this.matchDataClass = matchDataClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    void setRegexp(RubyClass regexpClass) {
        this.regexpClass = regexpClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    void setTime(RubyClass timeClass) {
        this.timeClass = timeClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    void setMath(RubyModule mathModule) {
        this.mathModule = mathModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    void setMarshal(RubyModule marshalModule) {
        this.marshalModule = marshalModule;
    }

    public RubyClass getBignum() {
        return this.bignumClass;
    }

    void setBignum(RubyClass bignumClass) {
        this.bignumClass = bignumClass;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    void setDir(RubyClass dirClass) {
        this.dirClass = dirClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    void setFile(RubyClass fileClass) {
        this.fileClass = fileClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    void setFileStat(RubyClass fileStatClass) {
        this.fileStatClass = fileStatClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    void setFileTest(RubyModule fileTestModule) {
        this.fileTestModule = fileTestModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    void setIO(RubyClass ioClass) {
        this.ioClass = ioClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    void setThread(RubyClass threadClass) {
        this.threadClass = threadClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    void setThreadGroup(RubyClass threadGroupClass) {
        this.threadGroupClass = threadGroupClass;
    }

    public RubyThreadGroup getDefaultThreadGroup() {
        return this.defaultThreadGroup;
    }

    void setDefaultThreadGroup(RubyThreadGroup defaultThreadGroup) {
        this.defaultThreadGroup = defaultThreadGroup;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    void setContinuation(RubyClass continuationClass) {
        this.continuationClass = continuationClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    void setStructClass(RubyClass structClass) {
        this.structClass = structClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass tmsStruct) {
        this.tmsStruct = tmsStruct;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    void setPasswdStruct(RubyClass passwdStruct) {
        this.passwdStruct = passwdStruct;
    }

    public IRubyObject getGroupStruct() {
        return this.groupStruct;
    }

    void setGroupStruct(RubyClass groupStruct) {
        this.groupStruct = groupStruct;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    void setGC(RubyModule gcModule) {
        this.gcModule = gcModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    void setObjectSpaceModule(RubyModule objectSpaceModule) {
        this.objectSpaceModule = objectSpaceModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    void setProcess(RubyModule processModule) {
        this.processModule = processModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass procStatusClass) {
        this.procStatusClass = procStatusClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule procUIDModule) {
        this.procUIDModule = procUIDModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule procGIDModule) {
        this.procGIDModule = procGIDModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule procSysModule) {
        this.procSysModule = procSysModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule precisionModule) {
        this.precisionModule = precisionModule;
    }

    public RubyModule getErrno() {
        return this.errnoModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    void setException(RubyClass exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNameErrorMessage() {
        return this.nameErrorMessage;
    }

    public RubyClass getNoMethodError() {
        return this.noMethodError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getLocalJumpError() {
        return this.localJumpError;
    }

    public RubyClass getNativeException() {
        return this.nativeException;
    }

    public RubyClass getSystemCallError() {
        return this.systemCallError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getStopIteration() {
        return this.stopIteration;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getNoMemoryError() {
        return this.noMemoryError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }

    public RubyClass getThreadError() {
        return this.threadError;
    }

    public RubyClass getConcurrencyError() {
        return this.concurrencyError;
    }

    public RubyClass getSystemStackError() {
        return this.systemStackError;
    }

    public RubyClass getZeroDivisionError() {
        return this.zeroDivisionError;
    }

    public RubyClass getFloatDomainError() {
        return this.floatDomainError;
    }

    public RubyClass getMathDomainError() {
        return this.mathDomainError;
    }

    public RubyClass getEncodingError() {
        return this.encodingError;
    }

    public RubyClass getEncodingCompatibilityError() {
        return this.encodingCompatibilityError;
    }

    public RubyClass getConverterNotFoundError() {
        return this.converterNotFoundError;
    }

    public RubyClass getUndefinedConversionError() {
        return this.undefinedConversionError;
    }

    public RubyClass getInvalidByteSequenceError() {
        return this.invalidByteSequenceError;
    }

    public RubyClass getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(RubyClass randomClass) {
        this.randomClass = randomClass;
    }

    public RubyHash getCharsetMap() {
        if (this.charsetMap == null) {
            this.charsetMap = new RubyHash(this);
        }
        return this.charsetMap;
    }

    public IRubyObject getVerbose() {
        return this.verboseValue;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean warningsEnabled() {
        return this.warningsEnabled;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose.isTrue();
        this.verboseValue = verbose;
        this.warningsEnabled = !verbose.isNil();
    }

    public IRubyObject getDebug() {
        return this.debug ? this.trueObject : this.falseObject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug.isTrue();
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Ruby.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public synchronized JRubyClassLoader getJRubyClassLoader() {
        if (!Ruby.isSecurityRestricted() && this.jrubyClassLoader == null) {
            this.jrubyClassLoader = new JRubyClassLoader(this.config.getLoader());
        }
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            public IRubyObject getValue() {
                return variable.get();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        });
    }

    public void defineReadonlyVariable(String name2, IRubyObject value2) {
        this.globalVariables.defineReadonly(name2, new ValueAccessor(value2));
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope, int lineNumber) {
        if (this.parserStats != null) {
            this.parserStats.addLoadParse();
        }
        return this.parser.parse(file2, in, scope, new ParserConfiguration(this.getKCode(), lineNumber, false, false, true, this.config));
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope) {
        return this.parseFile(in, file2, scope, 0);
    }

    public Node parseInline(InputStream in, String file2, DynamicScope scope) {
        if (this.parserStats != null) {
            this.parserStats.addEvalParse();
        }
        return this.parser.parse(file2, in, scope, new ParserConfiguration(this.getKCode(), 0, false, true, false, this.config));
    }

    public Node parseEval(String content, String file2, DynamicScope scope, int lineNumber) {
        byte[] bytes2 = content.getBytes();
        if (this.parserStats != null) {
            this.parserStats.addEvalParse();
        }
        return this.parser.parse(file2, bytes2, scope, new ParserConfiguration(this.getKCode(), lineNumber, false, false, true, this.config));
    }

    @Deprecated
    public Node parse(String content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        byte[] bytes2 = content.getBytes();
        return this.parser.parse(file2, bytes2, scope, new ParserConfiguration(this.getKCode(), lineNumber, extraPositionInformation, false, true, this.config));
    }

    public Node parseEval(ByteList content, String file2, DynamicScope scope, int lineNumber) {
        if (this.parserStats != null) {
            this.parserStats.addEvalParse();
        }
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this.getKCode(), lineNumber, false, false, true, this.config));
    }

    public Node parse(ByteList content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        if (this.parserStats != null) {
            this.parserStats.addJRubyModuleParse();
        }
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this.getKCode(), lineNumber, extraPositionInformation, false, true, this.config));
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public Encoding getDefaultInternalEncoding() {
        return this.defaultInternalEncoding;
    }

    public void setDefaultInternalEncoding(Encoding defaultInternalEncoding) {
        this.defaultInternalEncoding = defaultInternalEncoding;
    }

    public Encoding getDefaultExternalEncoding() {
        return this.defaultExternalEncoding;
    }

    public void setDefaultExternalEncoding(Encoding defaultExternalEncoding) {
        this.defaultExternalEncoding = defaultExternalEncoding;
    }

    public EncodingService getEncodingService() {
        return this.encodingService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String path2) {
        RubyModule c = this.getObject();
        if (path2.length() == 0 || path2.charAt(0) == '#') {
            throw this.newTypeError("can't retrieve anonymous class " + path2);
        }
        int pbeg = 0;
        int p2 = 0;
        int l = path2.length();
        while (p2 < l) {
            IRubyObject cc;
            while (p2 < l && path2.charAt(p2) != ':') {
                ++p2;
            }
            String str = path2.substring(pbeg, p2);
            if (p2 < l && path2.charAt(p2) == ':') {
                if (p2 + 1 < l && path2.charAt(p2 + 1) != ':') {
                    throw this.newTypeError("undefined class/module " + path2.substring(pbeg, p2));
                }
                pbeg = p2 += 2;
            }
            if (!((cc = c.getConstant(str)) instanceof RubyModule)) {
                throw this.newTypeError("" + path2 + " does not refer to class/module");
            }
            c = (RubyModule)cc;
        }
        return c;
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        if (RubyException.TRACE_TYPE == 5) {
            this.printRubiniusTrace(excp);
            return;
        }
        ThreadContext context = this.getCurrentContext();
        IRubyObject backtrace2 = excp.callMethod(context, "backtrace");
        PrintStream errorStream = this.getErrorStream();
        if (backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null) {
                errorStream.print(context.getFile() + ":" + context.getLine());
            } else {
                errorStream.print(context.getLine());
            }
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            this.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first();
            if (mesg.isNil()) {
                this.printErrorPos(context, errorStream);
            } else {
                errorStream.print(mesg);
            }
        }
        RubyClass type2 = excp.getMetaClass();
        String info = excp.toString();
        if (type2 == this.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path2 = type2.getName();
            if (info.length() == 0) {
                errorStream.print(": " + path2 + '\n');
            } else {
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(": " + info);
                if (path2 != null) {
                    errorStream.print(" (" + path2 + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        excp.printBacktrace(errorStream);
    }

    private void printRubiniusTrace(RubyException exception2) {
        ThreadContext.RubyStackTraceElement[] frames = exception2.getBacktraceFrames();
        ArrayList<String> firstParts = new ArrayList<String>();
        int longestFirstPart = 0;
        for (ThreadContext.RubyStackTraceElement frame : frames) {
            String firstPart = frame.getClassName() + "#" + frame.getMethodName();
            if (firstPart.length() > longestFirstPart) {
                longestFirstPart = firstPart.length();
            }
            firstParts.add(firstPart);
        }
        int center2 = longestFirstPart + 2 + 1;
        StringBuffer buffer = new StringBuffer();
        buffer.append("An exception has occurred:\n").append("    ");
        if (exception2.getMetaClass() == this.getRuntimeError() && exception2.message(this.getCurrentContext()).toString().length() == 0) {
            buffer.append("No current exception (RuntimeError)");
        } else {
            buffer.append(exception2.message(this.getCurrentContext()).toString());
        }
        buffer.append('\n').append('\n').append("Backtrace:\n");
        int i = 0;
        for (ThreadContext.RubyStackTraceElement frame : frames) {
            String firstPart = (String)firstParts.get(i);
            String secondPart = frame.getFileName() + ":" + frame.getLineNumber();
            buffer.append("  ");
            for (int j = 0; j < center2 - firstPart.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(firstPart);
            buffer.append(" at ");
            buffer.append(secondPart);
            buffer.append('\n');
            ++i;
        }
        PrintStream errorStream = this.getErrorStream();
        errorStream.print(buffer.toString());
    }

    private void printErrorPos(ThreadContext context, PrintStream errorStream) {
        if (context.getFile() != null) {
            if (context.getFrameName() != null) {
                errorStream.print(context.getFile() + ":" + context.getLine());
                errorStream.print(":in '" + context.getFrameName() + '\'');
            } else if (context.getLine() != 0) {
                errorStream.print(context.getFile() + ":" + context.getLine());
            } else {
                errorStream.print(context.getFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String scriptName, InputStream in, boolean wrap2) {
        IRubyObject self = wrap2 ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        String file2 = context.getFile();
        try {
            this.secure(4);
            context.setFile(scriptName);
            context.preNodeEval(this.objectClass, self, scriptName);
            this.parseFile(in, scriptName, null).interpret(this, context, self, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
            context.setFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndLoadFile(String filename2, InputStream in, boolean wrap2) {
        IRubyObject self = wrap2 ? TopSelfFactory.createTopSelf(this) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        String file2 = context.getFile();
        InputStream readStream = in;
        try {
            this.secure(4);
            context.setFile(filename2);
            context.preNodeEval(this.objectClass, self, filename2);
            Script script = null;
            String className = null;
            try {
                int num;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((num = in.read(buffer)) > -1) {
                    baos.write(buffer, 0, num);
                }
                buffer = baos.toByteArray();
                String hash2 = JITCompiler.getHashForBytes(buffer);
                className = "ruby.jit.FILE_" + hash2;
                try {
                    Class<?> contents = this.jrubyClassLoader.loadClass(className);
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        System.err.println("found jitted code for " + filename2 + " at class: " + className);
                    }
                    script = (Script)contents.newInstance();
                    readStream = new ByteArrayInputStream(buffer);
                }
                catch (ClassNotFoundException cnfe) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        System.err.println("no jitted code in classloader for file " + filename2 + " at class: " + className);
                    }
                }
                catch (InstantiationException ie) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        System.err.println("jitted code could not be instantiated for file " + filename2 + " at class: " + className);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        System.err.println("jitted code could not be instantiated for file " + filename2 + " at class: " + className);
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (script == null) {
                Node scriptNode = this.parseFile(readStream, filename2, null);
                script = this.tryCompile(scriptNode, className, new JRubyClassLoader(this.jrubyClassLoader), false);
            }
            if (script == null) {
                System.err.println("Error, could not compile; pass -J-Djruby.jit.logging.verbose=true for more details");
            }
            this.runScript(script);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
            context.setFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(Script script) {
        IRubyObject self = this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            this.secure(4);
            context.preNodeEval(this.objectClass, self);
            script.load(context, self, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
        }
    }

    public void addEventHook(EventHook hook) {
        if (!RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.getWarnings().warn("tracing (e.g. set_trace_func) will not capture all events without --debug flag");
        }
        this.eventHooks.add(hook);
        this.hasEventHooks = true;
    }

    public void removeEventHook(EventHook hook) {
        this.eventHooks.remove(hook);
        this.hasEventHooks = !this.eventHooks.isEmpty();
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.removeEventHook(this.callTraceFuncHook);
        if (traceFunction == null) {
            return;
        }
        this.callTraceFuncHook.setTraceFunc(traceFunction);
        this.addEventHook(this.callTraceFuncHook);
    }

    public void callEventHooks(ThreadContext context, RubyEvent event, String file2, int line, String name2, IRubyObject type2) {
        if (context.isEventHooksEnabled()) {
            for (EventHook eventHook : this.eventHooks) {
                if (!eventHook.isInterestedInEvent(event)) continue;
                eventHook.event(context, event, file2, line, name2, type2);
            }
        }
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public CallbackFactory callbackFactory(Class<?> type2) {
        return CallbackFactory.createFactory(this, type2);
    }

    public IRubyObject pushExitBlock(RubyProc proc2) {
        this.atExitBlocks.push(proc2);
        return proc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers == null) {
                this.internalFinalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.internalFinalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.finalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                this.internalFinalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers != null) {
                this.finalizers.remove(finalizer);
            }
        }
    }

    public void tearDown() {
        this.tearDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(boolean systemExit) {
        Finalizable f;
        Iterator<Finalizable> finalIter;
        Object object;
        int status2 = 0;
        while (!this.atExitBlocks.empty()) {
            RubyProc proc2 = this.atExitBlocks.pop();
            try {
                proc2.call(this.getCurrentContext(), IRubyObject.NULL_ARRAY);
            }
            catch (RaiseException rj) {
                RubyException raisedException = rj.getException();
                if (!this.getSystemExit().isInstance(raisedException)) {
                    status2 = 1;
                    this.printError(raisedException);
                    continue;
                }
                IRubyObject statusObj = raisedException.callMethod(this.getCurrentContext(), "status");
                if (statusObj == null || statusObj.isNil()) continue;
                status2 = RubyNumeric.fix2int(statusObj);
            }
        }
        if (this.finalizers != null) {
            object = this.finalizersMutex;
            synchronized (object) {
                finalIter = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        f.finalize();
                    }
                    finalIter.remove();
                }
            }
        }
        object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                finalIter = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        f.finalize();
                    }
                    finalIter.remove();
                }
            }
        }
        this.getThreadService().disposeCurrentThread();
        this.getBeanManager().unregisterCompiler();
        this.getBeanManager().unregisterConfig();
        this.getBeanManager().unregisterParserStats();
        this.getBeanManager().unregisterClassCache();
        this.getBeanManager().unregisterMethodCache();
        if (systemExit && status2 != 0) {
            throw this.newSystemExit(status2);
        }
    }

    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject ... objects) {
        return RubyArray.newArray(this, objects);
    }

    public RubyArray newArrayNoCopy(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    public RubyArray newArray(List<IRubyObject> list2) {
        return RubyArray.newArray(this, list2);
    }

    public RubyArray newArray(int size2) {
        return RubyArray.newArray(this, size2);
    }

    public RubyBoolean newBoolean(boolean value2) {
        return value2 ? this.trueObject : this.falseObject;
    }

    public RubyFileStat newFileStat(String filename2, boolean lstat2) {
        return RubyFileStat.newFileStat(this, filename2, lstat2);
    }

    public RubyFileStat newFileStat(FileDescriptor descriptor) {
        return RubyFileStat.newFileStat(this, descriptor);
    }

    public RubyFixnum newFixnum(long value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(int value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(Constant value2) {
        return RubyFixnum.newFixnum(this, value2.value());
    }

    public RubyFloat newFloat(double value2) {
        return RubyFloat.newFloat(this, value2);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyProc newProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc2 = RubyProc.newProc(this, type2);
        proc2.callInit(IRubyObject.NULL_ARRAY, block);
        return proc2;
    }

    public RubyProc newBlockPassProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc2 = RubyProc.newProc(this, type2);
        proc2.initialize(this.getCurrentContext(), block);
        return proc2;
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this, this.getCurrentContext().currentBinding());
    }

    public RubyBinding newBinding(Binding binding2) {
        return RubyBinding.newBinding(this, binding2);
    }

    public RubyString newString() {
        return RubyString.newString(this, new ByteList());
    }

    public RubyString newString(String string2) {
        return RubyString.newString(this, string2);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    @Deprecated
    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol fastNewSymbol(String internedName) {
        return this.symbolTable.fastGetSymbol(internedName);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message2) {
        return this.newRaiseException(this.getRuntimeError(), message2);
    }

    public RaiseException newArgumentError(String message2) {
        return this.newRaiseException(this.getArgumentError(), message2);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newRaiseException(this.getArgumentError(), "wrong # of arguments(" + got + " for " + expected + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEISCONNError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EISCONN"), "Socket is already connected");
    }

    public RaiseException newErrnoEINPROGRESSError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EINPROGRESS"), "Operation now in progress");
    }

    public RaiseException newErrnoENOPROTOOPTError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOPROTOOPT"), "Protocol not available");
    }

    public RaiseException newErrnoEPIPEError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNABORTEDError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ECONNABORTED"), "An established connection was aborted by the software in your host machine");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoECONNRESETError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ECONNRESET"), "Connection reset by peer");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEADDRINUSEError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EADDRINUSE"), message2);
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.getErrno().fastGetClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EACCES"), message2);
    }

    public RaiseException newErrnoEAGAINError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EAGAIN"), message2);
    }

    public RaiseException newErrnoEISDirError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EISDIR"), message2);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newErrnoEISDirError("Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EBADF"), message2);
    }

    public RaiseException newErrnoEINPROGRESSError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EINPROGRESS"), message2);
    }

    public RaiseException newErrnoEISCONNError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EISCONN"), message2);
    }

    public RaiseException newErrnoEINVALError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EINVAL"), message2);
    }

    public RaiseException newErrnoENOTDIRError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOTDIR"), message2);
    }

    public RaiseException newErrnoENOTSOCKError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOTSOCK"), message2);
    }

    public RaiseException newErrnoENOTCONNError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOTCONN"), message2);
    }

    public RaiseException newErrnoENOTCONNError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOTCONN"), "Socket is not connected");
    }

    public RaiseException newErrnoENOENTError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("ENOENT"), message2);
    }

    public RaiseException newErrnoESPIPEError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("ESPIPE"), message2);
    }

    public RaiseException newErrnoEEXISTError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EEXIST"), message2);
    }

    public RaiseException newErrnoEDOMError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EDOM"), "Domain error - " + message2);
    }

    public RaiseException newErrnoECHILDError() {
        return this.newRaiseException(this.getErrno().fastGetClass("ECHILD"), "No child processes");
    }

    public RaiseException newErrnoEADDRNOTAVAILError(String message2) {
        return this.newRaiseException(this.getErrno().fastGetClass("EADDRNOTAVAIL"), message2);
    }

    public RaiseException newIndexError(String message2) {
        return this.newRaiseException(this.getIndexError(), message2);
    }

    public RaiseException newSecurityError(String message2) {
        return this.newRaiseException(this.getSecurityError(), message2);
    }

    public RaiseException newSystemCallError(String message2) {
        return this.newRaiseException(this.getSystemCallError(), message2);
    }

    public RaiseException newErrnoFromLastPOSIXErrno() {
        return this.newRaiseException(this.getErrno(this.getPosix().errno()), null);
    }

    public RaiseException newErrnoFromInt(int errno2, String message2) {
        RubyClass errnoClass = this.getErrno(errno2);
        if (errnoClass != null) {
            return this.newRaiseException(errnoClass, message2);
        }
        return this.newSystemCallError("Unknown Error (" + errno2 + ") - " + message2);
    }

    public RaiseException newTypeError(String message2) {
        return this.newRaiseException(this.getTypeError(), message2);
    }

    public RaiseException newThreadError(String message2) {
        return this.newRaiseException(this.getThreadError(), message2);
    }

    public RaiseException newConcurrencyError(String message2) {
        return this.newRaiseException(this.getConcurrencyError(), message2);
    }

    public RaiseException newSyntaxError(String message2) {
        return this.newRaiseException(this.getSyntaxError(), message2);
    }

    public RaiseException newRegexpError(String message2) {
        return this.newRaiseException(this.getRegexpError(), message2);
    }

    public RaiseException newRangeError(String message2) {
        return this.newRaiseException(this.getRangeError(), message2);
    }

    public RaiseException newNotImplementedError(String message2) {
        return this.newRaiseException(this.getNotImplementedError(), message2);
    }

    public RaiseException newInvalidEncoding(String message2) {
        return this.newRaiseException(this.fastGetClass("Iconv").fastGetClass("InvalidEncoding"), message2);
    }

    public RaiseException newIllegalSequence(String message2) {
        return this.newRaiseException(this.fastGetClass("Iconv").fastGetClass("IllegalSequence"), message2);
    }

    public RaiseException newNoMethodError(String message2, String name2, IRubyObject args2) {
        return new RaiseException(new RubyNoMethodError(this, this.getNoMethodError(), message2, name2, args2), true);
    }

    public RaiseException newNameError(String message2, String name2) {
        return this.newNameError(message2, name2, null);
    }

    public RaiseException newNameError(String message2, String name2, Throwable origException) {
        return this.newNameError(message2, name2, origException, true);
    }

    public RaiseException newNameError(String message2, String name2, Throwable origException, boolean printWhenVerbose) {
        if (printWhenVerbose && origException != null && this.isVerbose()) {
            origException.printStackTrace(this.getErrorStream());
        }
        return new RaiseException(new RubyNameError(this, this.getNameError(), message2, name2), false);
    }

    public RaiseException newLocalJumpError(RubyLocalJumpError.Reason reason2, IRubyObject exitValue, String message2) {
        return new RaiseException(new RubyLocalJumpError(this, this.getLocalJumpError(), message2, reason2, exitValue), true);
    }

    public RaiseException newLocalJumpErrorNoBlock() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, this.getNil(), "no block given");
    }

    public RaiseException newRedoLocalJumpError() {
        return new RaiseException(new RubyLocalJumpError(this, this.getLocalJumpError(), "unexpected redo", RubyLocalJumpError.Reason.REDO, this.getNil()), true);
    }

    public RaiseException newLoadError(String message2) {
        return this.newRaiseException(this.getLoadError(), message2);
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newRaiseException(this.is1_9() ? this.getRuntimeError() : this.getTypeError(), "can't modify frozen " + objectType);
    }

    public RaiseException newSystemStackError(String message2) {
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemStackError(String message2, StackOverflowError soe) {
        if (this.getDebug().isTrue()) {
            soe.printStackTrace(this.getInstanceConfig().getError());
        }
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemExit(int status2) {
        return new RaiseException(RubySystemExit.newInstance(this, status2));
    }

    public RaiseException newIOError(String message2) {
        return this.newRaiseException(this.getIOError(), message2);
    }

    public RaiseException newStandardError(String message2) {
        return this.newRaiseException(this.getStandardError(), message2);
    }

    public RaiseException newIOErrorFromException(IOException ioe) {
        if (ioe.getMessage() != null) {
            if (ioe.getMessage().equals("Broken pipe")) {
                throw this.newErrnoEPIPEError();
            }
            if (ioe.getMessage().equals("Connection reset by peer")) {
                throw this.newErrnoECONNRESETError();
            }
            return this.newRaiseException(this.getIOError(), ioe.getMessage());
        }
        return this.newRaiseException(this.getIOError(), "IO Error");
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newRaiseException(this.getTypeError(), "wrong argument type " + receivedObject.getMetaClass().getRealClass() + " (expected " + expectedType + ")");
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getEOFError(), "End of file reached");
    }

    public RaiseException newEOFError(String message2) {
        return this.newRaiseException(this.getEOFError(), message2);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getZeroDivisionError(), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message2) {
        return this.newRaiseException(this.getFloatDomainError(), message2);
    }

    public RaiseException newMathDomainError(String message2) {
        return this.newRaiseException(this.getMathDomainError(), "Numerical argument is out of domain - \"" + message2 + "\"");
    }

    public RaiseException newEncodingError(String message2) {
        return this.newRaiseException(this.getEncodingError(), message2);
    }

    public RaiseException newEncodingCompatibilityError(String message2) {
        return this.newRaiseException(this.getEncodingCompatibilityError(), message2);
    }

    public RaiseException newConverterNotFoundError(String message2) {
        return this.newRaiseException(this.getConverterNotFoundError(), message2);
    }

    public RaiseException newUndefinedConversionError(String message2) {
        return this.newRaiseException(this.getUndefinedConversionError(), message2);
    }

    public RaiseException newInvalidByteSequenceError(String message2) {
        return this.newRaiseException(this.getInvalidByteSequenceError(), message2);
    }

    private RaiseException newRaiseException(RubyClass exceptionClass, String message2) {
        RaiseException re = new RaiseException(this, exceptionClass, message2, true);
        return re;
    }

    public RubyObject.Data newData(RubyClass objectClass, Object sval) {
        return new RubyObject.Data(this, objectClass, sval);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setStackTraces(int stackTraces) {
        this.stackTraces = stackTraces;
    }

    public int getStackTraces() {
        return this.stackTraces;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public Random getRandom() {
        return this.random;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public Map<Integer, WeakDescriptorReference> getDescriptors() {
        return this.descriptors;
    }

    private void cleanDescriptors() {
        Reference<ChannelDescriptor> reference2;
        while ((reference2 = this.descriptorQueue.poll()) != null) {
            int fileno2 = ((WeakDescriptorReference)reference2).getFileno();
            this.descriptors.remove(fileno2);
        }
    }

    public void registerDescriptor(ChannelDescriptor descriptor, boolean isRetained) {
        this.cleanDescriptors();
        Integer filenoKey = descriptor.getFileno();
        this.descriptors.put(filenoKey, new WeakDescriptorReference(descriptor, this.descriptorQueue));
        if (isRetained) {
            this.retainedDescriptors.put(filenoKey, descriptor);
        }
    }

    public void registerDescriptor(ChannelDescriptor descriptor) {
        this.registerDescriptor(descriptor, false);
    }

    public void unregisterDescriptor(int aFileno) {
        this.cleanDescriptors();
        Integer aFilenoKey = aFileno;
        this.descriptors.remove(aFilenoKey);
        this.retainedDescriptors.remove(aFilenoKey);
    }

    public ChannelDescriptor getDescriptorByFileno(int aFileno) {
        this.cleanDescriptors();
        Reference reference2 = this.descriptors.get(aFileno);
        if (reference2 == null) {
            return null;
        }
        return (ChannelDescriptor)reference2.get();
    }

    public long incrementRandomSeedSequence() {
        return this.randomSeedSequence++;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable2) {
        this.globalAbortOnExceptionEnabled = enable2;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b) {
        this.doNotReverseLookupEnabled = b;
    }

    public void registerInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val == null) {
            val = new IdentityHashMap<Object, Object>();
            this.inspect.set(val);
        }
        val.put(obj, null);
    }

    public boolean isInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        return val == null ? false : val.containsKey(obj);
    }

    public void unregisterInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val != null) {
            val.remove(obj);
        }
    }

    private IRubyObject recursiveListAccess() {
        Map<String, RubyHash> hash2 = this.recursive.get();
        String sym = this.getCurrentContext().getFrameName();
        IRubyObject list2 = this.getNil();
        if (hash2 == null) {
            hash2 = new HashMap<String, RubyHash>();
            this.recursive.set(hash2);
        } else {
            list2 = hash2.get(sym);
        }
        if (list2 == null || list2.isNil()) {
            list2 = RubyHash.newHash(this);
            list2.setUntrusted(true);
            hash2.put(sym, (RubyHash)list2);
        }
        return list2;
    }

    private void recursivePush(IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj == null) {
            ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, this.getTrue());
        } else {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, paired_obj);
            } else {
                if (!(pair_list instanceof RubyHash)) {
                    IRubyObject other_paired_obj = pair_list;
                    pair_list = RubyHash.newHash(this);
                    pair_list.setUntrusted(true);
                    ((RubyHash)pair_list).op_aset(this.getCurrentContext(), other_paired_obj, this.getTrue());
                    ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, pair_list);
                }
                ((RubyHash)pair_list).op_aset(this.getCurrentContext(), paired_obj, this.getTrue());
            }
        }
    }

    private void recursivePop(IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj != null) {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                throw this.newTypeError("invalid inspect_tbl pair_list for " + this.getCurrentContext().getFrameName());
            }
            if (pair_list instanceof RubyHash) {
                ((RubyHash)pair_list).delete(this.getCurrentContext(), paired_obj, Block.NULL_BLOCK);
                if (!((RubyHash)pair_list).isEmpty()) {
                    return;
                }
            }
        }
        ((RubyHash)list2).delete(this.getCurrentContext(), obj, Block.NULL_BLOCK);
    }

    private boolean recursiveCheck(IRubyObject list2, IRubyObject obj_id, IRubyObject paired_obj_id) {
        IRubyObject paired_result;
        IRubyObject pair_list = ((RubyHash)list2).fastARef(obj_id);
        if (pair_list == null) {
            return false;
        }
        return paired_obj_id == null || !(!(pair_list instanceof RubyHash) ? pair_list != paired_obj_id : (paired_result = ((RubyHash)pair_list).fastARef(paired_obj_id)) == null || paired_result.isNil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject execRecursiveI(ExecRecursiveParams p2) {
        IRubyObject result = null;
        this.recursivePush(p2.list, p2.objid, p2.pairid);
        try {
            result = p2.func.call(p2.obj, false);
        }
        finally {
            this.recursivePop(p2.list, p2.objid, p2.pairid);
        }
        return result;
    }

    private IRubyObject execRecursiveInternal(RecursiveFunction func, IRubyObject obj, IRubyObject pairid, boolean outer) {
        boolean outermost;
        ExecRecursiveParams p2 = new ExecRecursiveParams();
        p2.list = this.recursiveListAccess();
        p2.objid = obj.id();
        boolean bl = outermost = outer && !this.recursiveCheck(p2.list, this.recursiveKey, null);
        if (this.recursiveCheck(p2.list, p2.objid, pairid)) {
            if (outer && !outermost) {
                throw new RecursiveError(p2.list);
            }
            return func.call(obj, true);
        }
        IRubyObject result = null;
        p2.func = func;
        p2.obj = obj;
        p2.pairid = pairid;
        if (outermost) {
            this.recursivePush(p2.list, this.recursiveKey, null);
            try {
                result = this.execRecursiveI(p2);
            }
            catch (RecursiveError e) {
                if (e.tag != p2.list) {
                    throw e;
                }
                result = p2.list;
            }
            this.recursivePop(p2.list, this.recursiveKey, null);
            if (result == p2.list) {
                result = func.call(obj, true);
            }
        } else {
            result = this.execRecursiveI(p2);
        }
        return result;
    }

    public IRubyObject execRecursive(RecursiveFunction func, IRubyObject obj) {
        return this.execRecursiveInternal(func, obj, null, false);
    }

    public IRubyObject execRecursiveOuter(RecursiveFunction func, IRubyObject obj) {
        return this.execRecursiveInternal(func, obj, null, true);
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    void setObjectSpaceEnabled(boolean objectSpaceEnabled) {
        this.objectSpaceEnabled = objectSpaceEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        return this.config.getJRubyHome();
    }

    public void setJRubyHome(String home2) {
        this.config.setJRubyHome(home2);
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    public boolean is1_9() {
        return this.is1_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalState() {
        Ruby ruby2 = this;
        synchronized (ruby2) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incGlobalState() {
        Ruby ruby2 = this;
        synchronized (ruby2) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean restricted) {
        securityRestricted = restricted;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public void setRecordSeparatorVar(GlobalVariable recordSeparatorVar) {
        this.recordSeparatorVar = recordSeparatorVar;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    public Set<Script> getJittedMethods() {
        return this.jittedMethods;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Map<String, DateTimeZone> getTimezoneCache() {
        return this.timeZoneCache;
    }

    public int getConstantGeneration() {
        return this.constantGeneration;
    }

    public synchronized void incrementConstantGeneration() {
        ++this.constantGeneration;
    }

    public <E extends Enum<E>> void loadConstantSet(RubyModule module, Class<E> enumClass) {
        for (Enum e : EnumSet.allOf(enumClass)) {
            Constant c = (Constant)((Object)e);
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.fastSetConstant(c.name(), this.newFixnum(c.value()));
        }
    }

    public void loadConstantSet(RubyModule module, String constantSetName) {
        for (Constant c : ConstantSet.getConstantSet(constantSetName)) {
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.fastSetConstant(c.name(), this.newFixnum(c.value()));
        }
    }

    public long getNextDynamicMethodSerial() {
        return this.dynamicMethodSerial.getAndIncrement();
    }

    public Object getHierarchyLock() {
        return this.hierarchyLock;
    }

    static {
        securityRestricted = false;
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflection")) {
            securityRestricted = true;
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkCreateClassLoader();
                }
                catch (SecurityException se) {
                    securityRestricted = true;
                }
            }
        }
    }

    private static class ExecRecursiveParams {
        public RecursiveFunction func;
        public IRubyObject list;
        public IRubyObject obj;
        public IRubyObject objid;
        public IRubyObject pairid;
    }

    private static class RecursiveError
    extends Error
    implements Unrescuable {
        public final Object tag;

        public RecursiveError(Object tag) {
            this.tag = tag;
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface RecursiveFunction {
        public IRubyObject call(IRubyObject var1, boolean var2);
    }

    private class WeakDescriptorReference
    extends WeakReference {
        private int fileno;

        public WeakDescriptorReference(ChannelDescriptor descriptor, ReferenceQueue queue) {
            super(descriptor, queue);
            this.fileno = descriptor.getFileno();
        }

        public int getFileno() {
            return this.fileno;
        }
    }

    public class CallTraceFuncHook
    extends EventHook {
        private RubyProc traceFunc;

        public void setTraceFunc(RubyProc traceFunc) {
            this.traceFunc = traceFunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (!context.isWithinTrace()) {
                if (file2 == null) {
                    file2 = "(ruby)";
                }
                if (type2 == null) {
                    type2 = Ruby.this.getFalse();
                }
                RubyBinding binding2 = RubyBinding.newBinding(Ruby.this, context.currentBinding());
                context.preTrace();
                try {
                    this.traceFunc.call(context, new IRubyObject[]{Ruby.this.newString(eventName), Ruby.this.newString(file2), Ruby.this.newFixnum(line), name2 != null ? Ruby.this.newSymbol(name2) : Ruby.this.getNil(), binding2, type2});
                }
                finally {
                    context.postTrace();
                }
            }
        }

        public boolean isInterestedInEvent(RubyEvent event) {
            return true;
        }
    }
}

