/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyThread;
import org.jruby.runtime.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyThreadMap {
    private static final Object NULL_KEY = new Object();
    private final Map<RubyThreadWeakReference<Object>, RubyThread> map = new Hashtable<RubyThreadWeakReference<Object>, RubyThread>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Map<RubyThread, ThreadContext> mapToClean;

    public RubyThreadMap(Map<RubyThread, ThreadContext> mapToClean) {
        this.mapToClean = mapToClean;
    }

    private void cleanup() {
        RubyThreadWeakReference ref;
        while ((ref = (RubyThreadWeakReference)this.queue.poll()) != null) {
            this.map.remove(ref);
            this.mapToClean.remove(ref.getThread());
        }
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    public Set<Map.Entry<RubyThreadWeakReference<Object>, RubyThread>> entrySet() {
        return this.map.entrySet();
    }

    public RubyThread get(Object key2) {
        this.cleanup();
        key2 = this.nullKey(key2);
        return this.map.get(key2);
    }

    public RubyThread put(Object key2, RubyThread value2) {
        this.cleanup();
        key2 = this.nullKey(key2);
        return this.map.put(new RubyThreadWeakReference<Object>(key2, value2), value2);
    }

    public RubyThread remove(Object key2) {
        this.cleanup();
        key2 = this.nullKey(key2);
        RubyThread t = this.map.remove(key2);
        return t;
    }

    private Object nullKey(Object key2) {
        return key2 == null ? NULL_KEY : key2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RubyThreadWeakReference<T>
    extends WeakReference<T> {
        private final RubyThread thread;
        public int hashCode;

        public RubyThreadWeakReference(T referrent, RubyThread thread) {
            super(referrent);
            this.hashCode = referrent.hashCode();
            this.thread = thread;
        }

        public RubyThreadWeakReference(T referrent, ReferenceQueue<? super T> queue, RubyThread thread) {
            super(referrent, queue);
            this.hashCode = referrent.hashCode();
            this.thread = thread;
        }

        public RubyThread getThread() {
            return this.thread;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            Object myKey = this.get();
            if (other instanceof RubyThreadWeakReference) {
                Object otherKey = ((RubyThreadWeakReference)other).get();
                return myKey == otherKey;
            }
            if (other instanceof Thread) {
                return myKey == other;
            }
            return false;
        }
    }
}

