/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class AbstractVariable
implements BiVariable {
    protected IRubyObject origin = null;
    protected String name;
    protected Object javaObject = null;
    protected Class javaType = null;
    protected IRubyObject irubyObject = null;

    protected AbstractVariable(Ruby runtime2, String name2, Object ... values) {
        this.name = name2;
        this.updateJavaObject(runtime2, values[0]);
        if (values.length > 1) {
            this.javaType = (Class)values[1];
        } else if (this.javaObject != null) {
            this.javaType = values[0].getClass();
        }
    }

    protected void updateJavaObject(Ruby runtime2, Object javaObject) {
        this.javaObject = javaObject;
        this.javaType = javaObject == null ? null : javaObject.getClass();
        this.irubyObject = JavaEmbedUtils.javaToRuby(runtime2, javaObject);
    }

    protected AbstractVariable(IRubyObject origin, String name2, IRubyObject rubyObject) {
        this.origin = origin;
        this.name = name2;
        this.updateRubyObject(rubyObject);
    }

    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.irubyObject = rubyObject;
    }

    public IRubyObject getOrigin() {
        return this.origin;
    }

    public void setOrigin(IRubyObject origin) {
        this.origin = origin;
    }

    public String getName() {
        return this.name;
    }

    public Object getJavaObject() {
        if (this.irubyObject == null) {
            return this.javaObject;
        }
        Ruby rt = this.irubyObject.getRuntime();
        if (this.javaType != null) {
            this.javaObject = this.javaType.cast(JavaEmbedUtils.rubyToJava(rt, this.irubyObject, this.javaType));
        } else {
            this.javaObject = JavaEmbedUtils.rubyToJava(this.irubyObject);
            if (this.javaObject != null) {
                this.javaType = this.javaObject.getClass();
            }
        }
        return this.javaObject;
    }

    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateJavaObject(runtime2, javaObject);
    }

    public IRubyObject getRubyObject() {
        return this.irubyObject;
    }

    public void setRubyObject(IRubyObject rubyObject) {
        this.updateRubyObject(rubyObject);
    }

    protected RubyModule getRubyClass(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        return rubyClass;
    }

    protected static boolean isValidName(String pattern, Object name2) {
        if (!(name2 instanceof String)) {
            return false;
        }
        return ((String)name2).matches(pattern);
    }
}

