/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.FutureThread;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BlockingIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject
implements ExecutionContext {
    private ThreadLike threadImpl;
    private RubyFixnum priority;
    private transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    private boolean abortOnException;
    private IRubyObject finalResult;
    private RaiseException exitingException;
    private RubyThreadGroup threadGroup;
    private final ThreadService threadService;
    private IRubyObject errorInfo;
    private static final boolean DEBUG = false;
    private volatile ThreadService.Event mail;
    private volatile Status status = Status.RUN;
    private volatile Selector currentSelector;
    private volatile Object currentWaitObject;
    private volatile Selector selector;
    private volatile BlockingIO.Condition blockingIO = null;

    protected RubyThread(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.threadService = runtime2.getThreadService();
        this.finalResult = runtime2.getNil();
        this.errorInfo = runtime2.getNil();
    }

    public synchronized void receiveMail(ThreadService.Event event) {
        if (this.status == Status.ABORTING) {
            return;
        }
        this.mail = event;
        switch (event.type) {
            case KILL: {
                this.status = Status.ABORTING;
            }
        }
        this.notify();
        this.interrupt();
    }

    public synchronized void checkMail(ThreadContext context) {
        ThreadService.Event myEvent = this.mail;
        this.mail = null;
        if (myEvent != null) {
            switch (myEvent.type) {
                case RAISE: {
                    this.receivedAnException(context, myEvent.exception);
                }
                case KILL: {
                    RubyThread.throwThreadKill();
                }
            }
        }
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void dispose() {
        this.threadGroup.remove(this);
    }

    public static RubyClass createThreadClass(Ruby runtime2) {
        RubyClass threadClass = runtime2.defineClass("Thread", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setThread(threadClass);
        threadClass.index = 29;
        threadClass.setReifiedClass(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime2, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime2.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    @JRubyMethod(name={"start"}, rest=true, frame=true, meta=true)
    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, false, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        return RubyThread.adoptThread(recv2, t, Block.NULL_BLOCK);
    }

    private static RubyThread adoptThread(IRubyObject recv2, Thread t, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)recv2);
        rubyThread.threadImpl = new NativeThread(rubyThread, t);
        ThreadContext context = runtime2.getThreadService().registerNewThread(rubyThread);
        context.preAdoptThread();
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        if (!block.isGiven()) {
            throw runtime2.newThreadError("must be called with a block");
        }
        try {
            RubyRunnable runnable = new RubyRunnable(this, args2, context.getFrames(0), block);
            if (RubyInstanceConfig.POOLING_ENABLED) {
                FutureThread futureThread = new FutureThread(this, runnable);
                this.threadImpl = futureThread;
                this.addToCorrectThreadGroup(context);
                this.threadImpl.start();
                runtime2.getThreadService().associateThread(futureThread.getFuture(), this);
            } else {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                this.threadImpl = new NativeThread(this, thread);
                this.addToCorrectThreadGroup(context);
                this.threadImpl.start();
                runtime2.getThreadService().associateThread(thread, this);
            }
            Thread.yield();
            return this;
        }
        catch (SecurityException ex) {
            throw runtime2.newThreadError(ex.getMessage());
        }
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        RubyThread rubyThread = new RubyThread(recv2.getRuntime(), (RubyClass)recv2);
        if (callInit) {
            rubyThread.callInit(args2, block);
        } else {
            rubyThread.initialize(recv2.getRuntime().getCurrentContext(), args2, block);
        }
        return rubyThread;
    }

    public synchronized void cleanTerminate(IRubyObject result) {
        this.finalResult = result;
    }

    public synchronized void beDead() {
        this.status = Status.DEAD;
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context) {
        if (this.mail != null) {
            this.checkMail(context);
        }
    }

    private static void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return runtime2.isGlobalAbortOnExceptionEnabled() ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject recv2, IRubyObject value2) {
        recv2.getRuntime().setGlobalAbortOnExceptionEnabled(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"current"}, meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(name={"main"}, meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(name={"pass"}, meta=true)
    public static IRubyObject pass(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        ThreadService ts = runtime2.getThreadService();
        boolean critical2 = ts.getCritical();
        ts.setCritical(false);
        Thread.yield();
        ts.setCritical(critical2);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static RubyArray list(IRubyObject recv2) {
        IRubyObject[] activeThreads = recv2.getRuntime().getThreadService().getActiveRubyThreads();
        return recv2.getRuntime().newArrayNoCopy(activeThreads);
    }

    private void addToCorrectThreadGroup(ThreadContext context) {
        IRubyObject group2 = context.getThread().group();
        if (!group2.isNil()) {
            ((RubyThreadGroup)group2).addDirectly(this);
        } else {
            context.getRuntime().getDefaultThreadGroup().addDirectly(this);
        }
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        if (originalKey instanceof RubyString) {
            return this.getRuntime().newSymbol(originalKey.asJavaString());
        }
        if (originalKey instanceof RubyFixnum) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "Do not use Fixnums as Symbols", new Object[0]);
            throw this.getRuntime().newArgumentError(originalKey + " is not a symbol");
        }
        throw this.getRuntime().newTypeError(originalKey + " is not a symbol");
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    @Override
    public final Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isAlive() {
        return this.threadImpl.isAlive() && this.status != Status.ABORTING;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(IRubyObject key2) {
        IRubyObject value2 = this.getThreadLocals().get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        key2 = this.getSymbolKey(key2);
        this.getThreadLocals().put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"abort_on_exception"})
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return this.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"join"}, optional=1, backtrace=true)
    public IRubyObject join(IRubyObject[] args2) {
        block16: {
            long timeoutMillis = Long.MAX_VALUE;
            if (args2.length > 0) {
                if (args2.length > 1) {
                    throw this.getRuntime().newArgumentError(args2.length, 1);
                }
                timeoutMillis = (long)(1000.0 * args2[0].convertToFloat().getValue());
                if (timeoutMillis <= 0L) {
                    if (this.threadImpl.isAlive()) {
                        return this.getRuntime().getNil();
                    }
                    return this;
                }
            }
            if (this.isCurrent()) {
                throw this.getRuntime().newThreadError("thread tried to join itself");
            }
            try {
                if (this.threadService.getCritical()) {
                    RubyThread rubyThread = this;
                    synchronized (rubyThread) {
                        this.notify();
                    }
                }
                RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
                long timeToWait = Math.min(timeoutMillis, 200L);
                long start2 = System.currentTimeMillis();
                do {
                    currentThread.pollThreadEvents();
                    this.threadImpl.join(timeToWait);
                } while (this.threadImpl.isAlive() && System.currentTimeMillis() - start2 <= timeoutMillis);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                assert (false) : ie;
            }
            catch (ExecutionException ie) {
                ie.printStackTrace();
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)ie);
            }
        }
        if (this.exitingException != null) {
            throw this.exitingException;
        }
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"value"}, frame=true)
    public IRubyObject value() {
        this.join(new IRubyObject[0]);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod(name={"group"})
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public synchronized IRubyObject inspect() {
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(System.identityHashCode(this)));
        part.append(this.status.toString().toLowerCase());
        part.append(">");
        return this.getRuntime().newString(part.toString());
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key2) {
        key2 = this.getSymbolKey(key2);
        return this.getRuntime().newBoolean(this.getThreadLocals().containsKey(key2));
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        IRubyObject[] keys2 = new IRubyObject[this.getThreadLocals().size()];
        return RubyArray.newArrayNoCopy(this.getRuntime(), this.getThreadLocals().keySet().toArray(keys2));
    }

    @JRubyMethod(name={"critical="}, required=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject critical_set(IRubyObject receiver2, IRubyObject value2) {
        receiver2.getRuntime().getThreadService().setCritical(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"critical"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject critical(IRubyObject receiver2) {
        return receiver2.getRuntime().newBoolean(receiver2.getRuntime().getThreadService().getCritical());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"stop"}, meta=true)
    public static IRubyObject stop(ThreadContext context, IRubyObject receiver2) {
        RubyThread rubyThread;
        RubyThread rubyThread2 = rubyThread = context.getThread();
        synchronized (rubyThread2) {
            rubyThread.checkMail(context);
            try {
                receiver2.getRuntime().getThreadService().setCritical(false);
                rubyThread.status = Status.SLEEP;
                rubyThread.wait();
            }
            catch (InterruptedException ie) {
                rubyThread.checkMail(context);
                rubyThread.status = Status.RUN;
            }
        }
        return receiver2.getRuntime().getNil();
    }

    @JRubyMethod(name={"kill"}, required=1, frame=true, meta=true)
    public static IRubyObject kill(IRubyObject receiver2, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver2.getRuntime().newTypeError(rubyThread, receiver2.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(name={"exit"}, frame=true, meta=true)
    public static IRubyObject s_exit(IRubyObject receiver2, Block block) {
        RubyThread rubyThread;
        RubyThread rubyThread2 = rubyThread = receiver2.getRuntime().getThreadService().getCurrentContext().getThread();
        synchronized (rubyThread2) {
            rubyThread.status = Status.ABORTING;
            rubyThread.mail = null;
            receiver2.getRuntime().getThreadService().setCritical(false);
            throw new ThreadKill();
        }
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.status == Status.SLEEP || this.status == Status.DEAD);
    }

    @JRubyMethod(name={"wakeup"})
    public synchronized RubyThread wakeup() {
        if (!this.threadImpl.isAlive() && this.status == Status.DEAD) {
            throw this.getRuntime().newThreadError("killed thread");
        }
        this.status = Status.RUN;
        this.notifyAll();
        return this;
    }

    @JRubyMethod(name={"priority"})
    public RubyFixnum priority() {
        return this.priority;
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < 1) {
            iPriority = 1;
        } else if (iPriority > 10) {
            iPriority = 10;
        }
        this.priority = RubyFixnum.newFixnum(this.getRuntime(), iPriority);
        if (this.threadImpl.isAlive()) {
            this.threadImpl.setPriority(iPriority);
        }
        return this.priority;
    }

    @JRubyMethod(name={"raise"}, optional=3, frame=true)
    public IRubyObject raise(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        if (this == context.getThread()) {
            return RubyKernel.raise(context, runtime2.getKernel(), args2, block);
        }
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        IRubyObject exception2 = this.prepareRaiseException(runtime2, args2, block);
        runtime2.getThreadService().deliverEvent(new ThreadService.Event(currentThread, this, ThreadService.Event.Type.RAISE, exception2));
        return this;
    }

    public void internalRaise(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        IRubyObject exception2 = this.prepareRaiseException(runtime2, args2, Block.NULL_BLOCK);
        this.receiveMail(new ThreadService.Event(this, this, ThreadService.Event.Type.RAISE, exception2));
    }

    private IRubyObject prepareRaiseException(Ruby runtime2, IRubyObject[] args2, Block block) {
        IRubyObject exception2;
        if (args2.length == 0) {
            IRubyObject lastException = this.errorInfo;
            if (lastException.isNil()) {
                return new RaiseException(runtime2, runtime2.getRuntimeError(), "", false).getException();
            }
            return lastException;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (args2.length == 1) {
            if (args2[0] instanceof RubyString) {
                return runtime2.getRuntimeError().newInstance(context, args2, block);
            }
            if (!args2[0].respondsTo("exception")) {
                return runtime2.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception");
        } else {
            if (!args2[0].respondsTo("exception")) {
                return runtime2.newTypeError("exception class/object expected").getException();
            }
            exception2 = args2[0].callMethod(context, "exception", args2[1]);
        }
        if (!runtime2.getException().isInstance(exception2)) {
            return runtime2.newTypeError("exception object expected").getException();
        }
        if (args2.length == 3) {
            ((RubyException)exception2).set_backtrace(args2[2]);
        }
        return exception2;
    }

    @JRubyMethod(name={"run"})
    public synchronized IRubyObject run() {
        return this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        boolean result = true;
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            this.pollThreadEvents();
            try {
                this.status = Status.SLEEP;
                this.wait(millis);
                result = this.status != Status.RUN;
            }
            catch (Throwable throwable) {
                result = this.status != Status.RUN;
                this.pollThreadEvents();
                this.status = Status.RUN;
                throw throwable;
            }
            this.pollThreadEvents();
            this.status = Status.RUN;
        }
        return result;
    }

    @JRubyMethod(name={"status"})
    public synchronized IRubyObject status() {
        if (this.threadImpl.isAlive()) {
            return this.getRuntime().newString(this.status.toString().toLowerCase());
        }
        if (this.exitingException != null) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().getFalse();
    }

    public void enterSleep() {
        this.status = Status.SLEEP;
    }

    public void exitSleep() {
        this.status = Status.RUN;
    }

    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        RubyThread currentThread = this.getRuntime().getCurrentContext().getThread();
        if (currentThread == this) {
            RubyThread.throwThreadKill();
        }
        currentThread.pollThreadEvents();
        this.getRuntime().getThreadService().deliverEvent(new ThreadService.Event(currentThread, this, ThreadService.Event.Type.KILL));
        return this;
    }

    @JRubyMethod(name={"kill!", "exit!", "terminate!"})
    public IRubyObject kill_bang() {
        throw this.getRuntime().newNotImplementedError("Thread#kill!, exit!, and terminate! are not safe and not supported");
    }

    @JRubyMethod(name={"safe_level"})
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject backtrace(ThreadContext context) {
        return context.createCallerBacktrace(context.getRuntime(), 0);
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        assert (this.isCurrent());
        RubyException rubyException = exception2.getException();
        Ruby runtime2 = rubyException.getRuntime();
        if (runtime2.getSystemExit().isInstance(rubyException)) {
            this.threadService.getMainThread().raise(new IRubyObject[]{rubyException}, Block.NULL_BLOCK);
        } else {
            if (this.abortOnException(runtime2)) {
                runtime2.printError(rubyException);
                RubySystemExit systemExit = RubySystemExit.newInstance(runtime2, 1);
                systemExit.message = rubyException.message;
                systemExit.set_backtrace(rubyException.backtrace());
                this.threadService.getMainThread().raise(new IRubyObject[]{systemExit}, Block.NULL_BLOCK);
                return;
            }
            if (runtime2.getDebug().isTrue()) {
                runtime2.printError(exception2.getException());
            }
        }
        this.exitingException = exception2;
    }

    private boolean abortOnException(Ruby runtime2) {
        return runtime2.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver2) {
        return receiver2.getRuntime().getThreadService().getMainThread();
    }

    @Deprecated
    public boolean selectForAccept(RubyIO io2) {
        return this.select(io2, 16);
    }

    private synchronized Selector getSelector(SelectableChannel channel) throws IOException {
        if (this.selector == null) {
            this.selector = Selector.open();
        }
        return this.selector;
    }

    public boolean select(RubyIO io2, int ops) {
        return this.select(io2.getChannel(), io2, ops);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Channel channel, RubyIO io2, int ops) {
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean bl;
            SelectionKey key2;
            boolean oldBlocking;
            block20: {
                boolean bl2;
                block19: {
                    oldBlocking = selectable.isBlocking();
                    key2 = null;
                    try {
                        Set<SelectionKey> keySet;
                        selectable.configureBlocking(false);
                        if (io2 != null) {
                            io2.addBlockingThread(this);
                        }
                        this.currentSelector = this.getSelector(selectable);
                        key2 = selectable.register(this.currentSelector, ops);
                        this.beforeBlockingCall();
                        int result = this.currentSelector.select();
                        this.pollThreadEvents();
                        if (result == 1 && (keySet = this.currentSelector.selectedKeys()).iterator().next() == key2) {
                            bl2 = true;
                            break block19;
                        }
                        bl = false;
                        break block20;
                    }
                    catch (IOException ioe) {
                        throw this.getRuntime().newRuntimeError("Error with selector: " + ioe);
                    }
                }
                return bl2;
            }
            return bl;
            finally {
                try {
                    if (key2 != null) {
                        key2.cancel();
                        this.currentSelector.selectNow();
                    }
                    this.afterBlockingCall();
                    this.currentSelector = null;
                    if (io2 != null) {
                        io2.removeBlockingThread(this);
                    }
                    selectable.configureBlocking(oldBlocking);
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object;
        BlockingIO.Condition iowait;
        Selector selector = this.currentSelector;
        if (selector != null) {
            selector.wakeup();
        }
        if ((iowait = this.blockingIO) != null) {
            iowait.cancel();
        }
        if ((object = this.currentWaitObject) != null) {
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
        }
    }

    public boolean waitForIO(ThreadContext context, RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        try {
            io2.addBlockingThread(this);
            this.blockingIO = BlockingIO.newCondition(channel, ops);
            boolean ready2 = this.blockingIO.await();
            this.pollThreadEvents();
            boolean bl = ready2;
            return bl;
        }
        catch (IOException ioe) {
            throw context.getRuntime().newRuntimeError("Error with selector: " + ioe);
        }
        catch (InterruptedException ex) {
            throw context.getRuntime().newRuntimeError("Interrupted");
        }
        finally {
            this.blockingIO = null;
            io2.removeBlockingThread(this);
        }
    }

    public void beforeBlockingCall() {
        this.enterSleep();
    }

    public void afterBlockingCall() {
        this.exitSleep();
    }

    private void receivedAnException(ThreadContext context, IRubyObject exception2) {
        RubyModule kernelModule = this.getRuntime().getKernel();
        kernelModule.callMethod(context, "raise", exception2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wait_timeout(IRubyObject o, Double timeout2) throws InterruptedException {
        if (timeout2 != null) {
            long end_ns;
            long delay_ns = (long)(timeout2 * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                try {
                    this.currentWaitObject = o;
                    this.status = Status.SLEEP;
                    o.wait(delay_ms, delay_ns_remainder);
                }
                finally {
                    this.pollThreadEvents();
                    this.status = Status.RUN;
                    this.currentWaitObject = null;
                }
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        try {
            this.currentWaitObject = o;
            this.status = Status.SLEEP;
            o.wait();
        }
        finally {
            this.pollThreadEvents();
            this.status = Status.RUN;
            this.currentWaitObject = null;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyThread other = (RubyThread)obj;
        return this.threadImpl == other.threadImpl || this.threadImpl != null && this.threadImpl.equals(other.threadImpl);
    }

    @Override
    public int hashCode() {
        int hash2 = 3;
        hash2 = 97 * hash2 + (this.threadImpl != null ? this.threadImpl.hashCode() : 0);
        return hash2;
    }

    @Override
    public String toString() {
        return this.threadImpl.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        RUN,
        SLEEP,
        ABORTING,
        DEAD;

    }
}

