/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.jcodings.Encoding;
import org.joni.ast.Node;
import org.joni.constants.StringType;

public final class StringNode
extends Node
implements StringType {
    private static final int NODE_STR_MARGIN = 16;
    private static final int NODE_STR_BUF_SIZE = 24;
    public byte[] bytes;
    public int p;
    public int end;
    int flag;

    public StringNode() {
        this.bytes = new byte[24];
    }

    public StringNode(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.p = n;
        this.end = n2;
        this.setShared();
    }

    public StringNode(byte by) {
        this();
        this.bytes[this.end++] = by;
    }

    public void ensure(int n) {
        int n2 = this.end - this.p + n;
        if (n2 >= this.bytes.length) {
            byte[] byArray = new byte[n2 + 16];
            System.arraycopy(this.bytes, this.p, byArray, 0, this.end - this.p);
            this.bytes = byArray;
        }
    }

    private void modifyEnsure(int n) {
        int n2 = this.end - this.p + n;
        if (this.isShared()) {
            byte[] byArray = new byte[n2 + 16];
            System.arraycopy(this.bytes, this.p, byArray, 0, this.end - this.p);
            this.bytes = byArray;
            this.end -= this.p;
            this.p = 0;
            this.clearShared();
        } else if (n2 >= this.bytes.length) {
            byte[] byArray = new byte[n2 + 16];
            System.arraycopy(this.bytes, this.p, byArray, 0, this.end - this.p);
            this.bytes = byArray;
        }
    }

    public int getType() {
        return 0;
    }

    public String getName() {
        return "String";
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n  bytes: ");
        for (int i = this.p; i < this.end; ++i) {
            if ((this.bytes[i] & 0xFF) >= 32 && (this.bytes[i] & 0xFF) < 127) {
                stringBuilder.append((char)this.bytes[i]);
                continue;
            }
            stringBuilder.append(String.format(" 0x%02x", this.bytes[i]));
        }
        return stringBuilder.toString();
    }

    public int length() {
        return this.end - this.p;
    }

    public int length(Encoding encoding2) {
        return encoding2.strLength(this.bytes, this.p, this.end);
    }

    public StringNode splitLastChar(Encoding encoding2) {
        int n;
        StringNode stringNode = null;
        if (this.end > this.p && (n = encoding2.prevCharHead(this.bytes, this.p, this.end, this.end)) != -1 && n > this.p) {
            stringNode = new StringNode(this.bytes, n, this.end);
            if (this.isRaw()) {
                stringNode.setRaw();
            }
            this.end = n;
        }
        return stringNode;
    }

    public boolean canBeSplit(Encoding encoding2) {
        if (this.end > this.p) {
            return encoding2.length(this.bytes, this.p, this.end) < this.end - this.p;
        }
        return false;
    }

    public void set(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.p = n;
        this.end = n2;
        this.setShared();
    }

    public void cat(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        this.modifyEnsure(n3);
        System.arraycopy(byArray, n, this.bytes, this.end, n3);
        this.end += n3;
    }

    public void cat(byte by) {
        this.modifyEnsure(1);
        this.bytes[this.end++] = by;
    }

    public void clear() {
        if (this.bytes.length > 24) {
            this.bytes = new byte[24];
        }
        this.flag = 0;
        this.end = 0;
        this.p = 0;
    }

    public void setRaw() {
        this.flag |= 1;
    }

    public void clearRaw() {
        this.flag &= 0xFFFFFFFE;
    }

    public boolean isRaw() {
        return (this.flag & 1) != 0;
    }

    public void setAmbig() {
        this.flag |= 2;
    }

    public void clearAmbig() {
        this.flag &= 0xFFFFFFFD;
    }

    public boolean isAmbig() {
        return (this.flag & 2) != 0;
    }

    public void setDontGetOptInfo() {
        this.flag |= 4;
    }

    public void clearDontGetOptInfo() {
        this.flag &= 0xFFFFFFFB;
    }

    public boolean isDontGetOptInfo() {
        return (this.flag & 4) != 0;
    }

    public void setShared() {
        this.flag |= 8;
    }

    public void clearShared() {
        this.flag &= 0xFFFFFFF7;
    }

    public boolean isShared() {
        return (this.flag & 8) != 0;
    }
}

